// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESPONSE_TYPE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESPONSE_TYPE_H_

#include <optional>

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/enumeration_base.h"  // IWYU pragma: export

namespace blink {

class ExceptionState;

class CORE_EXPORT V8ResponseType final : public bindings::EnumerationBase {
  
  public:
enum class Enum : enum_int_t {
kBasic, kCors, kDefault, kError, kOpaque, kOpaqueredirect
};
static constexpr size_t kEnumSize = 6;

static V8ResponseType Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state);
static std::optional<V8ResponseType> Create(const String& value);

explicit constexpr  V8ResponseType(Enum value) : bindings::EnumerationBase(static_cast<enum_int_t>(value), string_table_[static_cast<enum_int_t>(value)]) {
  
}
constexpr  V8ResponseType(const V8ResponseType&) = default;
constexpr  V8ResponseType(V8ResponseType&&) = default;
 ~V8ResponseType() = default;

V8ResponseType& operator=(const V8ResponseType&) = default;
V8ResponseType& operator=(V8ResponseType&&) = default;

Enum AsEnum() const {
  return static_cast<Enum>(GetEnumValue());
}


  
  private:
static const char* const string_table_[];

constexpr  V8ResponseType() = default;


  
};

inline bool operator==(const V8ResponseType& lhs, V8ResponseType::Enum rhs) {
  return lhs.AsEnum() == rhs;
}

inline bool operator==(V8ResponseType::Enum lhs, const V8ResponseType& rhs) {
  return lhs == rhs.AsEnum();
}


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_RESPONSE_TYPE_H_
