// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_FRAME_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_FRAME_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT ProfilerFrame : public bindings::DictionaryBase {
  
  public:
static ProfilerFrame* Create() {
  return MakeGarbageCollected<ProfilerFrame>();
}
static ProfilerFrame* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ProfilerFrame>(isolate);
}
static ProfilerFrame* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ProfilerFrame();
explicit  ProfilerFrame(v8::Isolate* isolate);

bool hasColumn() const {
  return has_column_;
}
uint64_t column() const {
  DCHECK(hasColumn());
return member_column_;
}
uint64_t getColumnOr(uint64_t fallback_value) const {
  if (!hasColumn()) {
  return fallback_value;
}
return member_column_;
}
void setColumn(uint64_t value) {
  member_column_ = value;
has_column_ = true;
}

bool hasLine() const {
  return has_line_;
}
uint64_t line() const {
  DCHECK(hasLine());
return member_line_;
}
uint64_t getLineOr(uint64_t fallback_value) const {
  if (!hasLine()) {
  return fallback_value;
}
return member_line_;
}
void setLine(uint64_t value) {
  member_line_ = value;
has_line_ = true;
}

bool hasName() const {
  return true;
}
const String& name() const {
  return member_name_;
}
void setName(const String& value);
void setName(String&& value);

bool hasResourceId() const {
  return has_resource_id_;
}
uint64_t resourceId() const {
  DCHECK(hasResourceId());
return member_resource_id_;
}
uint64_t getResourceIdOr(uint64_t fallback_value) const {
  if (!hasResourceId()) {
  return fallback_value;
}
return member_resource_id_;
}
void setResourceId(uint64_t value) {
  member_resource_id_ = value;
has_resource_id_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_column_ = false;
bool has_line_ = false;
bool has_resource_id_ = false;

uint64_t member_column_;
uint64_t member_line_;
String member_name_;
uint64_t member_resource_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PROFILER_FRAME_H_
