// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POST_MESSAGE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POST_MESSAGE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_structured_serialize_options.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PostMessageOptions : public StructuredSerializeOptions {
  
  public:
static PostMessageOptions* Create() {
  return MakeGarbageCollected<PostMessageOptions>();
}
static PostMessageOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PostMessageOptions>(isolate);
}
static PostMessageOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PostMessageOptions();
explicit  PostMessageOptions(v8::Isolate* isolate);

bool hasIncludeUserActivation() const {
  return true;
}
bool includeUserActivation() const {
  return member_include_user_activation_;
}
void setIncludeUserActivation(bool value) {
  member_include_user_activation_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = StructuredSerializeOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_include_user_activation_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_POST_MESSAGE_OPTIONS_H_
