// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_OBSERVER_CALLBACK_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_OBSERVER_CALLBACK_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT PerformanceObserverCallbackOptions : public bindings::DictionaryBase {
  
  public:
static PerformanceObserverCallbackOptions* Create() {
  return MakeGarbageCollected<PerformanceObserverCallbackOptions>();
}
static PerformanceObserverCallbackOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PerformanceObserverCallbackOptions>(isolate);
}
static PerformanceObserverCallbackOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PerformanceObserverCallbackOptions();
explicit  PerformanceObserverCallbackOptions(v8::Isolate* isolate);

bool hasDroppedEntriesCount() const {
  return has_dropped_entries_count_;
}
uint64_t droppedEntriesCount() const {
  DCHECK(hasDroppedEntriesCount());
return member_dropped_entries_count_;
}
uint64_t getDroppedEntriesCountOr(uint64_t fallback_value) const {
  if (!hasDroppedEntriesCount()) {
  return fallback_value;
}
return member_dropped_entries_count_;
}
void setDroppedEntriesCount(uint64_t value) {
  member_dropped_entries_count_ = value;
has_dropped_entries_count_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dropped_entries_count_ = false;

uint64_t member_dropped_entries_count_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_OBSERVER_CALLBACK_OPTIONS_H_
