// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_MEASURE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_MEASURE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionDoubleOrString;

class CORE_EXPORT PerformanceMeasureOptions : public bindings::InputDictionaryBase {
  
  public:
static PerformanceMeasureOptions* Create() {
  return MakeGarbageCollected<PerformanceMeasureOptions>();
}
static PerformanceMeasureOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PerformanceMeasureOptions>(isolate);
}
static PerformanceMeasureOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PerformanceMeasureOptions();
explicit  PerformanceMeasureOptions(v8::Isolate* isolate);

bool hasDetail() const {
  return !member_detail_.IsEmpty();
}
const ScriptValue& detail() const {
  DCHECK(hasDetail());
return member_detail_;
}
ScriptValue getDetailOr(const ScriptValue& fallback_value) const {
  if (!hasDetail()) {
  return fallback_value;
}
return member_detail_;
}
void setDetail(const ScriptValue& value) {
  member_detail_ = value;
}

bool hasDuration() const {
  return has_duration_;
}
double duration() const {
  DCHECK(hasDuration());
return member_duration_;
}
double getDurationOr(double fallback_value) const {
  if (!hasDuration()) {
  return fallback_value;
}
return member_duration_;
}
void setDuration(double value) {
  member_duration_ = value;
has_duration_ = true;
}

bool hasEnd() const {
  return has_end_;
}
V8UnionDoubleOrString* end() const {
  DCHECK(hasEnd());
return member_end_.Get();
}
V8UnionDoubleOrString* getEndOr(V8UnionDoubleOrString* fallback_value) const {
  if (!hasEnd()) {
  return fallback_value;
}
return member_end_.Get();
}
void setEnd(V8UnionDoubleOrString* value) {
  member_end_ = value;
has_end_ = true;
DCHECK(member_end_);
}

bool hasStart() const {
  return has_start_;
}
V8UnionDoubleOrString* start() const {
  DCHECK(hasStart());
return member_start_.Get();
}
V8UnionDoubleOrString* getStartOr(V8UnionDoubleOrString* fallback_value) const {
  if (!hasStart()) {
  return fallback_value;
}
return member_start_.Get();
}
void setStart(V8UnionDoubleOrString* value) {
  member_start_ = value;
has_start_ = true;
DCHECK(member_start_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_duration_ = false;
bool has_end_ = false;
bool has_start_ = false;

ScriptValue member_detail_;
double member_duration_;
Member<V8UnionDoubleOrString> member_end_;
Member<V8UnionDoubleOrString> member_start_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_PERFORMANCE_MEASURE_OPTIONS_H_
