// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NODE_FILTER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NODE_FILTER_H_

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/callback_interface_base.h"
#include "third_party/blink/renderer/platform/bindings/v8_value_or_script_wrappable_adapter.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Node;
struct WrapperTypeInfo;

class CORE_EXPORT V8NodeFilter final : public CallbackInterfaceBase {
  
  public:
// Constants
class Constant final {
  STATIC_ONLY(Constant);

  public:
static constexpr uint16_t kFilterAccept = 1;
static constexpr uint16_t kFilterReject = 2;
static constexpr uint16_t kFilterSkip = 3;
static constexpr uint32_t kShowAll = 0xFFFFFFFF;
static constexpr uint32_t kShowElement = 0x1;
static constexpr uint32_t kShowAttribute = 0x2;
static constexpr uint32_t kShowText = 0x4;
static constexpr uint32_t kShowCdataSection = 0x8;
static constexpr uint32_t kShowEntityReference = 0x10;
static constexpr uint32_t kShowEntity = 0x20;
static constexpr uint32_t kShowProcessingInstruction = 0x40;
static constexpr uint32_t kShowComment = 0x80;
static constexpr uint32_t kShowDocument = 0x100;
static constexpr uint32_t kShowDocumentType = 0x200;
static constexpr uint32_t kShowDocumentFragment = 0x400;
static constexpr uint32_t kShowNotation = 0x800;

  
  
  
};

// Migration adapters
static constexpr uint16_t FILTER_ACCEPT = 1;
static constexpr uint16_t FILTER_REJECT = 2;
static constexpr uint16_t FILTER_SKIP = 3;
static constexpr uint32_t SHOW_ALL = 0xFFFFFFFF;
static constexpr uint32_t SHOW_ELEMENT = 0x1;
static constexpr uint32_t SHOW_ATTRIBUTE = 0x2;
static constexpr uint32_t SHOW_TEXT = 0x4;
static constexpr uint32_t SHOW_CDATA_SECTION = 0x8;
static constexpr uint32_t SHOW_ENTITY_REFERENCE = 0x10;
static constexpr uint32_t SHOW_ENTITY = 0x20;
static constexpr uint32_t SHOW_PROCESSING_INSTRUCTION = 0x40;
static constexpr uint32_t SHOW_COMMENT = 0x80;
static constexpr uint32_t SHOW_DOCUMENT = 0x100;
static constexpr uint32_t SHOW_DOCUMENT_TYPE = 0x200;
static constexpr uint32_t SHOW_DOCUMENT_FRAGMENT = 0x400;
static constexpr uint32_t SHOW_NOTATION = 0x800;

static constexpr const WrapperTypeInfo* GetWrapperTypeInfo() {
  return &wrapper_type_info_;
}
  static_assert(static_cast<v8::CppHeapPointerTag>(1446) <
                 blink::kLastScriptWrappableTag,
                 "There are more ScriptWrappable types than available type tags."
                 "You have to increase the kLastScirptWrappableTag in wrapper_type_info.h");
  static constexpr v8::CppHeapPointerTag kThisTag =
      static_cast<v8::CppHeapPointerTag>(1446);
  static constexpr v8::CppHeapPointerTag kMaxSubclassTag =
      static_cast<v8::CppHeapPointerTag>(1446);
  static constexpr v8::CppHeapPointerTagRange kTagRange =
      v8::CppHeapPointerTagRange(kThisTag, kMaxSubclassTag);


static void InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template);
static void InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template);

static V8NodeFilter* Create(v8::Local<v8::Object> callback_object) {
  return MakeGarbageCollected<V8NodeFilter>(callback_object);
}

explicit  V8NodeFilter(v8::Local<v8::Object> callback_object) : CallbackInterfaceBase(callback_object, kSingleOperation) {
  
}
 ~V8NodeFilter() override = default;

// NameClient overrides:
const char* GetHumanReadableName() const override;

// Performs "call a user object's operation".
// https://webidl.spec.whatwg.org/#call-a-user-objects-operation
[[nodiscard]] v8::Maybe<uint16_t> acceptNode(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Node* arg1_node);




  
  private:
static const WrapperTypeInfo wrapper_type_info_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_NODE_FILTER_H_
