// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_node_filter.h"

#include <tuple>

#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/dom/node.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8NodeFilter::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8NodeFilter::InstallInterfaceTemplate,
    nullptr,
    "NodeFilter",
    nullptr,
    V8NodeFilter::kThisTag,
    V8NodeFilter::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeNoPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif


void V8NodeFilter::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8NodeFilter::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
bindings::SetupIDLCallbackInterfaceTemplate(isolate, wrapper_type_info, interface_function_template);



v8::Local<v8::ObjectTemplate> instance_template;
v8::Local<v8::ObjectTemplate> prototype_template;
InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8NodeFilter::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;



{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"FILTER_ACCEPT", V8NodeFilter::Constant::kFilterAccept},
{"FILTER_REJECT", V8NodeFilter::Constant::kFilterReject},
{"FILTER_SKIP", V8NodeFilter::Constant::kFilterSkip},
{"SHOW_ALL", V8NodeFilter::Constant::kShowAll},
{"SHOW_ELEMENT", V8NodeFilter::Constant::kShowElement},
{"SHOW_ATTRIBUTE", V8NodeFilter::Constant::kShowAttribute},
{"SHOW_TEXT", V8NodeFilter::Constant::kShowText},
{"SHOW_CDATA_SECTION", V8NodeFilter::Constant::kShowCdataSection},
{"SHOW_ENTITY_REFERENCE", V8NodeFilter::Constant::kShowEntityReference},
{"SHOW_ENTITY", V8NodeFilter::Constant::kShowEntity},
{"SHOW_PROCESSING_INSTRUCTION", V8NodeFilter::Constant::kShowProcessingInstruction},
{"SHOW_COMMENT", V8NodeFilter::Constant::kShowComment},
{"SHOW_DOCUMENT", V8NodeFilter::Constant::kShowDocument},
{"SHOW_DOCUMENT_TYPE", V8NodeFilter::Constant::kShowDocumentType},
{"SHOW_DOCUMENT_FRAGMENT", V8NodeFilter::Constant::kShowDocumentFragment},
{"SHOW_NOTATION", V8NodeFilter::Constant::kShowNotation},
};
v8::Local<v8::Signature> signature;
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}





}



const char* V8NodeFilter::GetHumanReadableName() const {
  return "V8NodeFilter";
}

v8::Maybe<uint16_t> V8NodeFilter::acceptNode(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Node* arg1_node) {
  const char* const class_like_name = "NodeFilter";
const char* const property_name = "acceptNode";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<uint16_t>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<uint16_t>();
}

bindings::CallbackInvokeHelper<CallbackInterfaceBase> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<uint16_t>();
}
return helper.Result<IDLUnsignedShort, uint16_t>();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_node;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_node = ToV8Traits<Node>::ToV8(arg1_node->GetExecutionContext() && arg1_node->GetExecutionContext() != ToExecutionContext(script_state) ? ToScriptState(arg1_node->GetExecutionContext(), script_state->World()) : script_state, arg1_node);
argv[0] = v8_arg1_node;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<uint16_t>();
}
return helper.Result<IDLUnsignedShort, uint16_t>();
}




}  // namespace blink
