// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_layout_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/css/cssom/style_property_map_read_only.h"
#include "third_party/blink/renderer/core/layout/custom/custom_layout_child.h"
#include "third_party/blink/renderer/core/layout/custom/custom_layout_constraints.h"
#include "third_party/blink/renderer/core/layout/custom/custom_layout_edges.h"

namespace blink {





const char* V8LayoutCallback::GetHumanReadableName() const {
  return "V8LayoutCallback";
}

v8::Maybe<ScriptValue> V8LayoutCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const HeapVector<Member<CustomLayoutChild>>& arg1_children, CustomLayoutEdges* arg2_edges, CustomLayoutConstraints* arg3_constraints, StylePropertyMapReadOnly* arg4_style_map) {
  const char* const class_like_name = "LayoutCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptValue>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptValue>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}
v8::Local<v8::Value> argv_arr[4];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_children;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_children = ToV8Traits<IDLSequence<CustomLayoutChild>>::ToV8(script_state, arg1_children);
argv[0] = v8_arg1_children;
v8::Local<v8::Value> v8_arg2_edges;
v8_arg2_edges = ToV8Traits<CustomLayoutEdges>::ToV8(script_state, arg2_edges);
argv[1] = v8_arg2_edges;
v8::Local<v8::Value> v8_arg3_constraints;
v8_arg3_constraints = ToV8Traits<CustomLayoutConstraints>::ToV8(script_state, arg3_constraints);
argv[2] = v8_arg3_constraints;
v8::Local<v8::Value> v8_arg4_style_map;
v8_arg4_style_map = ToV8Traits<StylePropertyMapReadOnly>::ToV8(script_state, arg4_style_map);
argv[3] = v8_arg4_style_map;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}

v8::Maybe<ScriptValue> V8LayoutCallback::Construct(const HeapVector<Member<CustomLayoutChild>>& arg1_children, CustomLayoutEdges* arg2_edges, CustomLayoutConstraints* arg3_constraints, StylePropertyMapReadOnly* arg4_style_map) {
  const char* const class_like_name = "LayoutCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptValue>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptValue>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kNo> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}
v8::Local<v8::Value> argv_arr[4];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_children;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_children = ToV8Traits<IDLSequence<CustomLayoutChild>>::ToV8(script_state, arg1_children);
argv[0] = v8_arg1_children;
v8::Local<v8::Value> v8_arg2_edges;
v8_arg2_edges = ToV8Traits<CustomLayoutEdges>::ToV8(script_state, arg2_edges);
argv[1] = v8_arg2_edges;
v8::Local<v8::Value> v8_arg3_constraints;
v8_arg3_constraints = ToV8Traits<CustomLayoutConstraints>::ToV8(script_state, arg3_constraints);
argv[2] = v8_arg3_constraints;
v8::Local<v8::Value> v8_arg4_style_map;
v8_arg4_style_map = ToV8Traits<StylePropertyMapReadOnly>::ToV8(script_state, arg4_style_map);
argv[3] = v8_arg4_style_map;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptValue>();
}
return helper.Result<IDLAny, ScriptValue>();
}




}  // namespace blink
