// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTERNAL_DICTIONARY_DERIVED_DERIVED_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTERNAL_DICTIONARY_DERIVED_DERIVED_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_internal_dictionary_derived.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class  InternalDictionaryDerivedDerived : public InternalDictionaryDerived {
  
  public:
static InternalDictionaryDerivedDerived* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<InternalDictionaryDerivedDerived>(isolate);
}
static InternalDictionaryDerivedDerived* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  InternalDictionaryDerivedDerived(v8::Isolate* isolate);

bool hasDerivedDerivedStringMember() const {
  return has_derived_derived_string_member_;
}
const String& derivedDerivedStringMember() const {
  DCHECK(hasDerivedDerivedStringMember());
return member_derived_derived_string_member_;
}
String getDerivedDerivedStringMemberOr(const String& fallback_value) const;
String getDerivedDerivedStringMemberOr(String&& fallback_value) const;
void setDerivedDerivedStringMember(const String& value);
void setDerivedDerivedStringMember(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = InternalDictionaryDerived::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_derived_derived_string_member_ = false;

String member_derived_derived_string_member_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INTERNAL_DICTIONARY_DERIVED_DERIVED_H_
