// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INPUT_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INPUT_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_ui_event_init.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class DataTransfer;
class ExceptionState;
class StaticRange;

class CORE_EXPORT InputEventInit : public UIEventInit {
  
  public:
static InputEventInit* Create() {
  return MakeGarbageCollected<InputEventInit>();
}
static InputEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<InputEventInit>(isolate);
}
static InputEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  InputEventInit();
explicit  InputEventInit(v8::Isolate* isolate);

bool hasData() const {
  return has_data_;
}
const String& data() const {
  DCHECK(hasData());
return member_data_;
}
String getDataOr(const String& fallback_value) const;
String getDataOr(String&& fallback_value) const;
void setData(const String& value);
void setData(String&& value);

bool hasDataTransfer() const {
  return has_data_transfer_;
}
DataTransfer* dataTransfer() const {
  DCHECK(hasDataTransfer());
return member_data_transfer_.Get();
}
DataTransfer* getDataTransferOr(DataTransfer* fallback_value) const {
  if (!hasDataTransfer()) {
  return fallback_value;
}
return member_data_transfer_.Get();
}
void setDataTransfer(DataTransfer* value) {
  member_data_transfer_ = value;
has_data_transfer_ = true;
}

bool hasInputType() const {
  return true;
}
const String& inputType() const {
  return member_input_type_;
}
void setInputType(const String& value);
void setInputType(String&& value);

bool hasIsComposing() const {
  return true;
}
bool isComposing() const {
  return member_is_composing_;
}
void setIsComposing(bool value) {
  member_is_composing_ = value;
}

bool hasTargetRanges() const {
  return true;
}
const HeapVector<Member<StaticRange>>& targetRanges() const {
  return member_target_ranges_;
}
void setTargetRanges(const HeapVector<Member<StaticRange>>& value);
void setTargetRanges(HeapVector<Member<StaticRange>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = UIEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_ = false;
bool has_data_transfer_ = false;

String member_data_;
Member<DataTransfer> member_data_transfer_;
String member_input_type_{""};
bool member_is_composing_{false};
HeapVector<Member<StaticRange>> member_target_ranges_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_INPUT_EVENT_INIT_H_
