// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_HIGHLIGHT_HIT_RESULT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_HIGHLIGHT_HIT_RESULT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AbstractRange;
class ExceptionState;
class Highlight;

class CORE_EXPORT HighlightHitResult : public bindings::DictionaryBase {
  
  public:
static HighlightHitResult* Create() {
  return MakeGarbageCollected<HighlightHitResult>();
}
static HighlightHitResult* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<HighlightHitResult>(isolate);
}
static HighlightHitResult* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  HighlightHitResult();
explicit  HighlightHitResult(v8::Isolate* isolate);

bool hasHighlight() const {
  return has_highlight_;
}
Highlight* highlight() const {
  DCHECK(hasHighlight());
return member_highlight_.Get();
}
Highlight* getHighlightOr(Highlight* fallback_value) const {
  if (!hasHighlight()) {
  return fallback_value;
}
return member_highlight_.Get();
}
void setHighlight(Highlight* value) {
  member_highlight_ = value;
has_highlight_ = true;
DCHECK(member_highlight_);
}

bool hasRanges() const {
  return has_ranges_;
}
const HeapVector<Member<AbstractRange>>& ranges() const {
  DCHECK(hasRanges());
return member_ranges_;
}
HeapVector<Member<AbstractRange>> getRangesOr(const HeapVector<Member<AbstractRange>>& fallback_value) const;
HeapVector<Member<AbstractRange>> getRangesOr(HeapVector<Member<AbstractRange>>&& fallback_value) const;
void setRanges(const HeapVector<Member<AbstractRange>>& value);
void setRanges(HeapVector<Member<AbstractRange>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_highlight_ = false;
bool has_ranges_ = false;

Member<Highlight> member_highlight_;
HeapVector<Member<AbstractRange>> member_ranges_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_HIGHLIGHT_HIT_RESULT_H_
