// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_TRIGGER_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_TRIGGER_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class EventTarget;
class ExceptionState;

class CORE_EXPORT EventTriggerOptions : public bindings::InputDictionaryBase {
  
  public:
static EventTriggerOptions* Create() {
  return MakeGarbageCollected<EventTriggerOptions>();
}
static EventTriggerOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<EventTriggerOptions>(isolate);
}
static EventTriggerOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  EventTriggerOptions();
explicit  EventTriggerOptions(v8::Isolate* isolate);

bool hasEventTarget() const {
  return has_event_target_;
}
EventTarget* eventTarget() const {
  DCHECK(hasEventTarget());
return member_event_target_.Get();
}
EventTarget* getEventTargetOr(EventTarget* fallback_value) const {
  if (!hasEventTarget()) {
  return fallback_value;
}
return member_event_target_.Get();
}
void setEventTarget(EventTarget* value) {
  member_event_target_ = value;
has_event_target_ = true;
DCHECK(member_event_target_);
}

bool hasEventType() const {
  return has_event_type_;
}
const String& eventType() const {
  DCHECK(hasEventType());
return member_event_type_;
}
String getEventTypeOr(const String& fallback_value) const;
String getEventTypeOr(String&& fallback_value) const;
void setEventType(const String& value);
void setEventType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_event_target_ = false;
bool has_event_type_ = false;

Member<EventTarget> member_event_target_;
String member_event_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_TRIGGER_OPTIONS_H_
