// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_HANDLER_NON_NULL_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_HANDLER_NON_NULL_H_

#include "third_party/blink/renderer/bindings/core/v8/script_value.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/callback_function_base.h"
#include "third_party/blink/renderer/platform/bindings/v8_value_or_script_wrappable_adapter.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"

namespace blink {



class CORE_EXPORT V8EventHandlerNonNull final : public CallbackFunctionBase {
  
  public:
static V8EventHandlerNonNull* Create(v8::Local<v8::Object> callback_object) {
  return MakeGarbageCollected<V8EventHandlerNonNull>(callback_object);
}

explicit  V8EventHandlerNonNull(v8::Local<v8::Object> callback_object) : CallbackFunctionBase(callback_object) {
  
}
 ~V8EventHandlerNonNull() override = default;

// NameClient overrides:
const char* GetHumanReadableName() const override;

// Performs "invoke".
// https://webidl.spec.whatwg.org/#invoke-a-callback-function
[[nodiscard]] v8::Maybe<ScriptValue> Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const HeapVector<ScriptValue>& arg1_args);

// Performs "construct".
// https://webidl.spec.whatwg.org/#construct-a-callback-function
[[nodiscard]] v8::Maybe<ScriptValue> Construct(const HeapVector<ScriptValue>& arg1_args);


// Returns true if the callback is runnable, otherwise returns false and
// throws an exception.
enum class IgnorePause {
  kDontIgnore,
  kIgnore,
};
bool IsRunnableOrThrowException(IgnorePause ignore_pause);

// Performs "invoke".
// https://webidl.spec.whatwg.org/#invoke-a-callback-function
[[nodiscard]] v8::Maybe<ScriptValue> InvokeWithoutRunnabilityCheck(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, const HeapVector<ScriptValue>& arg1_args);


  
  
  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_EVENT_HANDLER_NON_NULL_H_
