// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_MATRIX_2D_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_MATRIX_2D_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT DOMMatrix2DInit : public bindings::InputDictionaryBase {
  
  public:
static DOMMatrix2DInit* Create() {
  return MakeGarbageCollected<DOMMatrix2DInit>();
}
static DOMMatrix2DInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<DOMMatrix2DInit>(isolate);
}
static DOMMatrix2DInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  DOMMatrix2DInit();
explicit  DOMMatrix2DInit(v8::Isolate* isolate);

bool hasA() const {
  return has_a_;
}
double a() const {
  DCHECK(hasA());
return member_a_;
}
double getAOr(double fallback_value) const {
  if (!hasA()) {
  return fallback_value;
}
return member_a_;
}
void setA(double value) {
  member_a_ = value;
has_a_ = true;
}

bool hasB() const {
  return has_b_;
}
double b() const {
  DCHECK(hasB());
return member_b_;
}
double getBOr(double fallback_value) const {
  if (!hasB()) {
  return fallback_value;
}
return member_b_;
}
void setB(double value) {
  member_b_ = value;
has_b_ = true;
}

bool hasC() const {
  return has_c_;
}
double c() const {
  DCHECK(hasC());
return member_c_;
}
double getCOr(double fallback_value) const {
  if (!hasC()) {
  return fallback_value;
}
return member_c_;
}
void setC(double value) {
  member_c_ = value;
has_c_ = true;
}

bool hasD() const {
  return has_d_;
}
double d() const {
  DCHECK(hasD());
return member_d_;
}
double getDOr(double fallback_value) const {
  if (!hasD()) {
  return fallback_value;
}
return member_d_;
}
void setD(double value) {
  member_d_ = value;
has_d_ = true;
}

bool hasE() const {
  return has_e_;
}
double e() const {
  DCHECK(hasE());
return member_e_;
}
double getEOr(double fallback_value) const {
  if (!hasE()) {
  return fallback_value;
}
return member_e_;
}
void setE(double value) {
  member_e_ = value;
has_e_ = true;
}

bool hasF() const {
  return has_f_;
}
double f() const {
  DCHECK(hasF());
return member_f_;
}
double getFOr(double fallback_value) const {
  if (!hasF()) {
  return fallback_value;
}
return member_f_;
}
void setF(double value) {
  member_f_ = value;
has_f_ = true;
}

bool hasM11() const {
  return has_m_11_;
}
double m11() const {
  DCHECK(hasM11());
return member_m_11_;
}
double getM11Or(double fallback_value) const {
  if (!hasM11()) {
  return fallback_value;
}
return member_m_11_;
}
void setM11(double value) {
  member_m_11_ = value;
has_m_11_ = true;
}

bool hasM12() const {
  return has_m_12_;
}
double m12() const {
  DCHECK(hasM12());
return member_m_12_;
}
double getM12Or(double fallback_value) const {
  if (!hasM12()) {
  return fallback_value;
}
return member_m_12_;
}
void setM12(double value) {
  member_m_12_ = value;
has_m_12_ = true;
}

bool hasM21() const {
  return has_m_21_;
}
double m21() const {
  DCHECK(hasM21());
return member_m_21_;
}
double getM21Or(double fallback_value) const {
  if (!hasM21()) {
  return fallback_value;
}
return member_m_21_;
}
void setM21(double value) {
  member_m_21_ = value;
has_m_21_ = true;
}

bool hasM22() const {
  return has_m_22_;
}
double m22() const {
  DCHECK(hasM22());
return member_m_22_;
}
double getM22Or(double fallback_value) const {
  if (!hasM22()) {
  return fallback_value;
}
return member_m_22_;
}
void setM22(double value) {
  member_m_22_ = value;
has_m_22_ = true;
}

bool hasM41() const {
  return has_m_41_;
}
double m41() const {
  DCHECK(hasM41());
return member_m_41_;
}
double getM41Or(double fallback_value) const {
  if (!hasM41()) {
  return fallback_value;
}
return member_m_41_;
}
void setM41(double value) {
  member_m_41_ = value;
has_m_41_ = true;
}

bool hasM42() const {
  return has_m_42_;
}
double m42() const {
  DCHECK(hasM42());
return member_m_42_;
}
double getM42Or(double fallback_value) const {
  if (!hasM42()) {
  return fallback_value;
}
return member_m_42_;
}
void setM42(double value) {
  member_m_42_ = value;
has_m_42_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 12;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_a_ = false;
bool has_b_ = false;
bool has_c_ = false;
bool has_d_ = false;
bool has_e_ = false;
bool has_f_ = false;
bool has_m_11_ = false;
bool has_m_12_ = false;
bool has_m_21_ = false;
bool has_m_22_ = false;
bool has_m_41_ = false;
bool has_m_42_ = false;

double member_a_;
double member_b_;
double member_c_;
double member_d_;
double member_e_;
double member_f_;
double member_m_11_;
double member_m_12_;
double member_m_21_;
double member_m_22_;
double member_m_41_;
double member_m_42_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_DOM_MATRIX_2D_INIT_H_
