// third_party/blink/public/mojom/worker/shared_worker_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/worker/shared_worker_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var content_security_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/content_security_policy.mojom', '../../../../../services/network/public/mojom/content_security_policy.mojom.js');
  }
  var fetch_client_settings_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom', '../loader/fetch_client_settings_object.mojom.js');
  }
  var worker_options$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/worker_options.mojom', 'worker_options.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var SharedWorkerSameSiteCookies = {};
  SharedWorkerSameSiteCookies.kAll = 0;
  SharedWorkerSameSiteCookies.kNone = 1;
  SharedWorkerSameSiteCookies.MIN_VALUE = 0;
  SharedWorkerSameSiteCookies.MAX_VALUE = 1;

  SharedWorkerSameSiteCookies.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SharedWorkerSameSiteCookies.toKnownEnumValue = function(value) {
    return value;
  };

  SharedWorkerSameSiteCookies.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SharedWorkerInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedWorkerInfo.prototype.initDefaults_ = function() {
    this.url = null;
    this.options = null;
    this.contentSecurityPolicies = null;
    this.outsideFetchClientSettingsObject = null;
    this.sameSiteCookies = SharedWorkerSameSiteCookies.kNone;
    this.extendedLifetime = false;
  };
  SharedWorkerInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedWorkerInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerInfo.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerInfo.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, worker_options$.WorkerOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerInfo.contentSecurityPolicies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(content_security_policy$.ContentSecurityPolicy), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerInfo.outsideFetchClientSettingsObject
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, fetch_client_settings_object$.FetchClientSettingsObject, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerInfo.sameSiteCookies
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, SharedWorkerSameSiteCookies);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SharedWorkerInfo.encodedSize = codec.kStructHeaderSize + 40;

  SharedWorkerInfo.decode = function(decoder) {
    var packed;
    var val = new SharedWorkerInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.options =
        decoder.decodeStructPointer(worker_options$.WorkerOptions);
    val.contentSecurityPolicies =
        decoder.decodeArrayPointer(new codec.PointerTo(content_security_policy$.ContentSecurityPolicy));
    val.outsideFetchClientSettingsObject =
        decoder.decodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject);
    val.sameSiteCookies =
        decoder.decodeStruct(new codec.Enum(SharedWorkerSameSiteCookies));
    packed = decoder.readUint8();
    val.extendedLifetime = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedWorkerInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedWorkerInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(worker_options$.WorkerOptions, val.options);
    encoder.encodeArrayPointer(new codec.PointerTo(content_security_policy$.ContentSecurityPolicy), val.contentSecurityPolicies);
    encoder.encodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject, val.outsideFetchClientSettingsObject);
    encoder.encodeStruct(codec.Int32, val.sameSiteCookies);
    packed = 0;
    packed |= (val.extendedLifetime & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.SharedWorkerSameSiteCookies = SharedWorkerSameSiteCookies;
  exports.SharedWorkerInfo = SharedWorkerInfo;
})();