// third_party/blink/public/mojom/worker/shared_worker_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/worker_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::SharedWorkerSameSiteCookies, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SharedWorkerInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedWorkerInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedWorkerInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in SharedWorkerInfo struct");

      decltype(Traits::options(input)) in_options = Traits::options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->options)::BaseType> options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::WorkerOptionsDataView, send_validation>(
        in_options,
        options_fragment);

      fragment->options.Set(
          options_fragment.is_null() ? nullptr : options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in SharedWorkerInfo struct");

      decltype(Traits::content_security_policies(input)) in_content_security_policies = Traits::content_security_policies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_security_policies)::BaseType>
          content_security_policies_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>, send_validation>(
        in_content_security_policies,
        content_security_policies_fragment,
        &content_security_policies_validate_params);

      fragment->content_security_policies.Set(
          content_security_policies_fragment.is_null() ? nullptr : content_security_policies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_security_policies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_security_policies in SharedWorkerInfo struct");

      decltype(Traits::outside_fetch_client_settings_object(input)) in_outside_fetch_client_settings_object = Traits::outside_fetch_client_settings_object(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->outside_fetch_client_settings_object)::BaseType> outside_fetch_client_settings_object_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::FetchClientSettingsObjectDataView, send_validation>(
        in_outside_fetch_client_settings_object,
        outside_fetch_client_settings_object_fragment);

      fragment->outside_fetch_client_settings_object.Set(
          outside_fetch_client_settings_object_fragment.is_null() ? nullptr : outside_fetch_client_settings_object_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->outside_fetch_client_settings_object.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outside_fetch_client_settings_object in SharedWorkerInfo struct");

      
      mojo::internal::Serialize<::blink::mojom::SharedWorkerSameSiteCookies>(
        Traits::same_site_cookies(input),
        &fragment->same_site_cookies);

      fragment->extended_lifetime = Traits::extended_lifetime(input);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_SEND_VALIDATION_H_