// third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/source_location.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT SharedWorkerExceptionDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedWorkerExceptionDetails, T>::value>;
  using DataView = SharedWorkerExceptionDetailsDataView;
  using Data_ = internal::SharedWorkerExceptionDetails_Data;

  template <typename... Args>
  static SharedWorkerExceptionDetailsPtr New(Args&&... args) {
    return SharedWorkerExceptionDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedWorkerExceptionDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SharedWorkerExceptionDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedWorkerExceptionDetails>::Convert(*this);
  }


  SharedWorkerExceptionDetails();

  SharedWorkerExceptionDetails(
      const std::string& error_message,
      ::network::mojom::SourceLocationPtr source_location,
      SharedWorkerErrorType error_type);

SharedWorkerExceptionDetails(const SharedWorkerExceptionDetails&) = delete;
SharedWorkerExceptionDetails& operator=(const SharedWorkerExceptionDetails&) = delete;

  ~SharedWorkerExceptionDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedWorkerExceptionDetailsPtr>
  SharedWorkerExceptionDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerExceptionDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerExceptionDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedWorkerExceptionDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedWorkerExceptionDetails_UnserializedMessageContext<
            UserType, SharedWorkerExceptionDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedWorkerExceptionDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedWorkerExceptionDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedWorkerExceptionDetails_UnserializedMessageContext<
            UserType, SharedWorkerExceptionDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedWorkerExceptionDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string error_message;
  
  ::network::mojom::SourceLocationPtr source_location;
  
  SharedWorkerErrorType error_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedWorkerExceptionDetailsPtr SharedWorkerExceptionDetails::Clone() const {
  return New(
      mojo::Clone(error_message),
      mojo::Clone(source_location),
      mojo::Clone(error_type)
  );
}

template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>*>
bool SharedWorkerExceptionDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_message, other_struct.error_message))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  if (!mojo::Equals(this->error_type, other_struct.error_type))
    return false;
  return true;
}

template <typename T, SharedWorkerExceptionDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_message < rhs.error_message)
    return true;
  if (rhs.error_message < lhs.error_message)
    return false;
  if (lhs.source_location < rhs.source_location)
    return true;
  if (rhs.source_location < lhs.source_location)
    return false;
  if (lhs.error_type < rhs.error_type)
    return true;
  if (rhs.error_type < lhs.error_type)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedWorkerExceptionDetails::DataView,
                                         ::blink::mojom::SharedWorkerExceptionDetailsPtr> {
  static bool IsNull(const ::blink::mojom::SharedWorkerExceptionDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedWorkerExceptionDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SharedWorkerExceptionDetails::error_message)& error_message(
      const ::blink::mojom::SharedWorkerExceptionDetailsPtr& input) {
    return input->error_message;
  }

  static const decltype(::blink::mojom::SharedWorkerExceptionDetails::source_location)& source_location(
      const ::blink::mojom::SharedWorkerExceptionDetailsPtr& input) {
    return input->source_location;
  }

  static decltype(::blink::mojom::SharedWorkerExceptionDetails::error_type) error_type(
      const ::blink::mojom::SharedWorkerExceptionDetailsPtr& input) {
    return input->error_type;
  }

  static bool Read(::blink::mojom::SharedWorkerExceptionDetails::DataView input, ::blink::mojom::SharedWorkerExceptionDetailsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_EXCEPTION_DETAILS_MOJOM_H_