// third_party/blink/public/mojom/worker/shared_worker_connector.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CONNECTOR_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CONNECTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/shared_worker_connector.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-forward.h"
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom.h"
#include "third_party/blink/public/mojom/worker/shared_worker_client.mojom-forward.h"
#include "third_party/blink/public/mojom/worker/shared_worker_creation_context_type.mojom-forward.h"
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class SharedWorkerConnectorProxy;

template <typename ImplRefTraits>
class SharedWorkerConnectorStub;

class SharedWorkerConnectorRequestValidator;


class BLINK_COMMON_EXPORT SharedWorkerConnector
    : public SharedWorkerConnectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SharedWorkerConnector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedWorkerConnectorInterfaceBase;
  using Proxy_ = SharedWorkerConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedWorkerConnectorStub<ImplRefTraits>;

  using RequestValidator_ = SharedWorkerConnectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedWorkerConnector() = default;

  virtual void Connect(::blink::mojom::SharedWorkerInfoPtr info, ::mojo::PendingRemote<::blink::mojom::SharedWorkerClient> client, ::blink::mojom::SharedWorkerCreationContextType creation_context_type, ::blink::MessagePortDescriptor message_port, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, int64_t client_ukm_source_id) = 0;
};



class BLINK_COMMON_EXPORT SharedWorkerConnectorProxy
    : public SharedWorkerConnector {
 public:
  using InterfaceType = SharedWorkerConnector;

  explicit SharedWorkerConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Connect(::blink::mojom::SharedWorkerInfoPtr info, ::mojo::PendingRemote<::blink::mojom::SharedWorkerClient> client, ::blink::mojom::SharedWorkerCreationContextType creation_context_type, ::blink::MessagePortDescriptor message_port, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, int64_t client_ukm_source_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SharedWorkerConnectorStubDispatch {
 public:
  static bool Accept(SharedWorkerConnector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedWorkerConnector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedWorkerConnector>>
class SharedWorkerConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedWorkerConnectorStub() = default;
  ~SharedWorkerConnectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedWorkerConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedWorkerConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SharedWorkerConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_CONNECTOR_MOJOM_H_