// third_party/blink/public/mojom/worker/shared_worker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  MessagePortDescriptor as blink_mojom_MessagePortDescriptor,
  MessagePortDescriptorSpec as blink_mojom_MessagePortDescriptorSpec
} from '../messaging/message_port_descriptor.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedWorkerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedWorker', scope);
  }
}

/** @interface */
export class SharedWorkerInterface {
  
  /**
   * @param { !number } connectionId
   * @param { !blink_mojom_MessagePortDescriptor } messagePort
   */

  connect(connectionId, messagePort) {}
  
  /**
   */

  terminate() {}
}

/**
 * @implements { SharedWorkerInterface }
 */
export class SharedWorkerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } connectionId
   * @param { !blink_mojom_MessagePortDescriptor } messagePort
   */

  connect(
      connectionId,
      messagePort) {
    this.proxy.sendMessage(
        0,
        SharedWorker_Connect_ParamsSpec.$,
        null,
        [
          connectionId,
          messagePort
        ],
        false);
  }

  
  /**
   */

  terminate() {
    this.proxy.sendMessage(
        1,
        SharedWorker_Terminate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedWorkerReceiver {
  /**
   * @param {!SharedWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedWorker_Connect_ParamsSpec.$,
        null,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedWorker_Terminate_ParamsSpec.$,
        null,
        impl.terminate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedWorker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedWorkerRemote}
   */
  static getRemote() {
    let remote = new SharedWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedWorkerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedWorker_Connect_ParamsSpec.$,
        null,
        this.connect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.terminate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedWorker_Terminate_ParamsSpec.$,
        null,
        this.terminate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorker_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorker_Terminate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedWorker_Connect_ParamsSpec.$,
    'SharedWorker_Connect_Params',
    [
      mojo.internal.StructField(
        'connectionId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'messagePort', 8,
        0,
        blink_mojom_MessagePortDescriptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedWorker_Connect_Params {
  constructor() {
    /** @type { !number } */
    this.connectionId;
    /** @type { !blink_mojom_MessagePortDescriptor } */
    this.messagePort;
  }
}



mojo.internal.Struct(
    SharedWorker_Terminate_ParamsSpec.$,
    'SharedWorker_Terminate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SharedWorker_Terminate_Params {
  constructor() {
  }
}

