// third_party/blink/public/mojom/window_features/window_features.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/window_features/window_features.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function WindowFeatures(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WindowFeatures.prototype.initDefaults_ = function() {
    this.bounds = null;
    this.hasX = false;
    this.hasY = false;
    this.hasWidth = false;
    this.hasHeight = false;
    this.isPopup = false;
    this.isPartitionedPopin = false;
  };
  WindowFeatures.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WindowFeatures.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WindowFeatures.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  WindowFeatures.encodedSize = codec.kStructHeaderSize + 16;

  WindowFeatures.decode = function(decoder) {
    var packed;
    var val = new WindowFeatures();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bounds =
        decoder.decodeStructPointer(geometry$.Rect);
    packed = decoder.readUint8();
    val.hasX = (packed >> 0) & 1 ? true : false;
    val.hasY = (packed >> 1) & 1 ? true : false;
    val.hasWidth = (packed >> 2) & 1 ? true : false;
    val.hasHeight = (packed >> 3) & 1 ? true : false;
    val.isPopup = (packed >> 4) & 1 ? true : false;
    val.isPartitionedPopin = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WindowFeatures.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WindowFeatures.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.bounds);
    packed = 0;
    packed |= (val.hasX & 1) << 0
    packed |= (val.hasY & 1) << 1
    packed |= (val.hasWidth & 1) << 2
    packed |= (val.hasHeight & 1) << 3
    packed |= (val.isPopup & 1) << 4
    packed |= (val.isPartitionedPopin & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.WindowFeatures = WindowFeatures;
})();