// third_party/blink/public/mojom/widget/platform_widget.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_PLATFORM_WIDGET_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_PLATFORM_WIDGET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/widget/platform_widget.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/render_frame_metadata.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"
#include "ui/base/cursor/mojom/cursor.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-forward.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"
#include "third_party/blink/public/mojom/widget/record_content_to_visible_time_request.mojom-forward.h"
#include "ui/base/ime/mojom/text_input_state.mojom-forward.h"
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-forward.h"
#include "ui/base/mojom/menu_source_type.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WidgetCompositorProxy;

template <typename ImplRefTraits>
class WidgetCompositorStub;

class WidgetCompositorRequestValidator;
class WidgetCompositorResponseValidator;


class BLINK_COMMON_EXPORT WidgetCompositor
    : public WidgetCompositorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WidgetCompositor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WidgetCompositorInterfaceBase;
  using Proxy_ = WidgetCompositorProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetCompositorStub<ImplRefTraits>;

  using RequestValidator_ = WidgetCompositorRequestValidator;
  using ResponseValidator_ = WidgetCompositorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kVisualStateRequestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct VisualStateRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WidgetCompositor() = default;

  using VisualStateRequestCallback = base::OnceCallback<void()>;
  using VisualStateRequestMojoCallback = base::OnceCallback<void()>;

  virtual void VisualStateRequest(VisualStateRequestCallback callback) = 0;
};

class WidgetHostProxy;

template <typename ImplRefTraits>
class WidgetHostStub;

class WidgetHostRequestValidator;


class BLINK_COMMON_EXPORT WidgetHost
    : public WidgetHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WidgetHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WidgetHostInterfaceBase;
  using Proxy_ = WidgetHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetHostStub<ImplRefTraits>;

  using RequestValidator_ = WidgetHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCursorMinVersion = 0,
    kUpdateTooltipUnderCursorMinVersion = 0,
    kUpdateTooltipFromKeyboardMinVersion = 0,
    kClearKeyboardTriggeredTooltipMinVersion = 0,
    kTextInputStateChangedMinVersion = 0,
    kSelectionBoundsChangedMinVersion = 0,
    kCreateFrameSinkMinVersion = 0,
    kRegisterRenderFrameMetadataObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCursor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTooltipUnderCursor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTooltipFromKeyboard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearKeyboardTriggeredTooltip_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextInputStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SelectionBoundsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterRenderFrameMetadataObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WidgetHost() = default;

  virtual void SetCursor(const ::ui::Cursor& cursor) = 0;

  virtual void UpdateTooltipUnderCursor(const ::std::u16string& tooltip_text, ::base::i18n::TextDirection text_direction_hint) = 0;

  virtual void UpdateTooltipFromKeyboard(const ::std::u16string& tooltip_text, ::base::i18n::TextDirection text_direction_hint, const ::gfx::Rect& bounds) = 0;

  virtual void ClearKeyboardTriggeredTooltip() = 0;

  virtual void TextInputStateChanged(::ui::mojom::TextInputStatePtr state) = 0;

  virtual void SelectionBoundsChanged(const ::gfx::Rect& anchor_rect, ::base::i18n::TextDirection anchor_dir, const ::gfx::Rect& focus_rect, ::base::i18n::TextDirection focus_dir, const ::gfx::Rect& bounding_box_rect, bool is_anchor_first) = 0;

  virtual void CreateFrameSink(::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client, ::mojo::PendingRemote<RenderInputRouterClient> render_input_router_client) = 0;

  virtual void RegisterRenderFrameMetadataObserver(::mojo::PendingReceiver<::cc::mojom::RenderFrameMetadataObserverClient> render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::RenderFrameMetadataObserver> render_frame_metadata_observer) = 0;
};

class WidgetProxy;

template <typename ImplRefTraits>
class WidgetStub;

class WidgetRequestValidator;
class WidgetResponseValidator;


class BLINK_COMMON_EXPORT Widget
    : public WidgetInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.Widget";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WidgetInterfaceBase;
  using Proxy_ = WidgetProxy;

  template <typename ImplRefTraits>
  using Stub_ = WidgetStub<ImplRefTraits>;

  using RequestValidator_ = WidgetRequestValidator;
  using ResponseValidator_ = WidgetResponseValidator;
  enum MethodMinVersions : uint32_t {
    kForceRedrawMinVersion = 0,
    kUpdateVisualPropertiesMinVersion = 0,
    kUpdateScreenRectsMinVersion = 0,
    kWasHiddenMinVersion = 0,
    kWasShownMinVersion = 0,
    kRequestSuccessfulPresentationTimeForNextFrameMinVersion = 0,
    kCancelSuccessfulPresentationTimeRequestMinVersion = 0,
    kSetupBrowserRenderInputRouterConnectionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ForceRedraw_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateVisualProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateScreenRects_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WasHidden_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WasShown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSuccessfulPresentationTimeForNextFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelSuccessfulPresentationTimeRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetupBrowserRenderInputRouterConnections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Widget() = default;

  using ForceRedrawCallback = base::OnceCallback<void()>;
  using ForceRedrawMojoCallback = base::OnceCallback<void()>;

  virtual void ForceRedraw(ForceRedrawCallback callback) = 0;

  virtual void UpdateVisualProperties(const ::blink::VisualProperties& visual_properties) = 0;

  using UpdateScreenRectsCallback = base::OnceCallback<void()>;
  using UpdateScreenRectsMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateScreenRects(const ::gfx::Rect& widget_screen_rect, const ::gfx::Rect& window_screen_rect, UpdateScreenRectsCallback callback) = 0;

  virtual void WasHidden() = 0;

  virtual void WasShown(bool was_evicted, ::blink::mojom::RecordContentToVisibleTimeRequestPtr record_tab_switch_time_request) = 0;

  virtual void RequestSuccessfulPresentationTimeForNextFrame(::blink::mojom::RecordContentToVisibleTimeRequestPtr visible_time_request) = 0;

  virtual void CancelSuccessfulPresentationTimeRequest() = 0;

  virtual void SetupBrowserRenderInputRouterConnections(::mojo::PendingReceiver<RenderInputRouterClient> browser_client) = 0;
};

class RenderInputRouterClientProxy;

template <typename ImplRefTraits>
class RenderInputRouterClientStub;

class RenderInputRouterClientRequestValidator;


class BLINK_COMMON_EXPORT RenderInputRouterClient
    : public RenderInputRouterClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RenderInputRouterClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RenderInputRouterClientInterfaceBase;
  using Proxy_ = RenderInputRouterClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderInputRouterClientStub<ImplRefTraits>;

  using RequestValidator_ = RenderInputRouterClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetWidgetInputHandlerMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kBindInputTargetClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetWidgetInputHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindInputTargetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RenderInputRouterClient() = default;

  virtual void GetWidgetInputHandler(::mojo::PendingReceiver<::blink::mojom::WidgetInputHandler> request, ::mojo::PendingRemote<::blink::mojom::WidgetInputHandlerHost> host, bool from_viz) = 0;

  virtual void ShowContextMenu(::ui::mojom::MenuSourceType source_type, const ::gfx::Point& location) = 0;

  virtual void BindInputTargetClient(::mojo::PendingReceiver<::viz::mojom::InputTargetClient> host) = 0;
};



class BLINK_COMMON_EXPORT WidgetCompositorProxy
    : public WidgetCompositor {
 public:
  using InterfaceType = WidgetCompositor;

  explicit WidgetCompositorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void VisualStateRequest(VisualStateRequestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WidgetHostProxy
    : public WidgetHost {
 public:
  using InterfaceType = WidgetHost;

  explicit WidgetHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCursor(const ::ui::Cursor& cursor) final;
  
  void UpdateTooltipUnderCursor(const ::std::u16string& tooltip_text, ::base::i18n::TextDirection text_direction_hint) final;
  
  void UpdateTooltipFromKeyboard(const ::std::u16string& tooltip_text, ::base::i18n::TextDirection text_direction_hint, const ::gfx::Rect& bounds) final;
  
  void ClearKeyboardTriggeredTooltip() final;
  
  void TextInputStateChanged(::ui::mojom::TextInputStatePtr state) final;
  
  void SelectionBoundsChanged(const ::gfx::Rect& anchor_rect, ::base::i18n::TextDirection anchor_dir, const ::gfx::Rect& focus_rect, ::base::i18n::TextDirection focus_dir, const ::gfx::Rect& bounding_box_rect, bool is_anchor_first) final;
  
  void CreateFrameSink(::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client, ::mojo::PendingRemote<RenderInputRouterClient> render_input_router_client) final;
  
  void RegisterRenderFrameMetadataObserver(::mojo::PendingReceiver<::cc::mojom::RenderFrameMetadataObserverClient> render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::RenderFrameMetadataObserver> render_frame_metadata_observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WidgetProxy
    : public Widget {
 public:
  using InterfaceType = Widget;

  explicit WidgetProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ForceRedraw(ForceRedrawCallback callback) final;
  
  void UpdateVisualProperties(const ::blink::VisualProperties& visual_properties) final;
  
  void UpdateScreenRects(const ::gfx::Rect& widget_screen_rect, const ::gfx::Rect& window_screen_rect, UpdateScreenRectsCallback callback) final;
  
  void WasHidden() final;
  
  void WasShown(bool was_evicted, ::blink::mojom::RecordContentToVisibleTimeRequestPtr record_tab_switch_time_request) final;
  
  void RequestSuccessfulPresentationTimeForNextFrame(::blink::mojom::RecordContentToVisibleTimeRequestPtr visible_time_request) final;
  
  void CancelSuccessfulPresentationTimeRequest() final;
  
  void SetupBrowserRenderInputRouterConnections(::mojo::PendingReceiver<RenderInputRouterClient> browser_client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RenderInputRouterClientProxy
    : public RenderInputRouterClient {
 public:
  using InterfaceType = RenderInputRouterClient;

  explicit RenderInputRouterClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetWidgetInputHandler(::mojo::PendingReceiver<::blink::mojom::WidgetInputHandler> request, ::mojo::PendingRemote<::blink::mojom::WidgetInputHandlerHost> host, bool from_viz) final;
  
  void ShowContextMenu(::ui::mojom::MenuSourceType source_type, const ::gfx::Point& location) final;
  
  void BindInputTargetClient(::mojo::PendingReceiver<::viz::mojom::InputTargetClient> host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WidgetCompositorStubDispatch {
 public:
  static bool Accept(WidgetCompositor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WidgetCompositor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WidgetCompositor>>
class WidgetCompositorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetCompositorStub() = default;
  ~WidgetCompositorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetCompositorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetCompositorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WidgetHostStubDispatch {
 public:
  static bool Accept(WidgetHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WidgetHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WidgetHost>>
class WidgetHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetHostStub() = default;
  ~WidgetHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WidgetStubDispatch {
 public:
  static bool Accept(Widget* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Widget* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Widget>>
class WidgetStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WidgetStub() = default;
  ~WidgetStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WidgetStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RenderInputRouterClientStubDispatch {
 public:
  static bool Accept(RenderInputRouterClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderInputRouterClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderInputRouterClient>>
class RenderInputRouterClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderInputRouterClientStub() = default;
  ~RenderInputRouterClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderInputRouterClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderInputRouterClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WidgetCompositorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WidgetHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WidgetRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RenderInputRouterClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WidgetCompositorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WidgetResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_PLATFORM_WIDGET_MOJOM_H_