// third_party/blink/public/mojom/webshare/webshare.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webshare/webshare.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webshare/webshare.mojom-params-data.h"
#include "third_party/blink/public/mojom/webshare/webshare.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webshare/webshare.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/webshare/webshare.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SharedFile::SharedFile()
    : name(),
      blob() {}

SharedFile::SharedFile(
    const ::base::SafeBaseName& name_in,
    const ::scoped_refptr<::blink::BlobDataHandle>& blob_in)
    : name(std::move(name_in)),
      blob(std::move(blob_in)) {}

SharedFile::~SharedFile() = default;

void SharedFile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::SafeBaseName&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob"), this->blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ShareService::IPCStableHashFunction ShareService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ShareService>(message.name())) {
    case messages::ShareService::kShare: {
      return &ShareService::Share_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ShareService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ShareService>(message.name())) {
      case messages::ShareService::kShare:
            return "Receive blink::mojom::ShareService::Share";
    }
  } else {
    switch (static_cast<messages::ShareService>(message.name())) {
      case messages::ShareService::kShare:
            return "Receive reply blink::mojom::ShareService::Share";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ShareService::Share_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdda8167f;  // IPCStableHash for blink::mojom::ShareService::Share
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ShareService_Share_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ShareService_Share_ForwardToCallback(
      ShareService::ShareCallback callback
      ) : callback_(std::move(callback)) {
  }

  ShareService_Share_ForwardToCallback(const ShareService_Share_ForwardToCallback&) = delete;
  ShareService_Share_ForwardToCallback& operator=(const ShareService_Share_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ShareService::ShareCallback callback_;
};

ShareServiceProxy::ShareServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ShareServiceProxy::Share(
    const ::blink::String& in_title, const ::blink::String& in_text, const ::blink::KURL& in_url, ::blink::Vector<SharedFilePtr> in_files, ShareCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ShareService::Share", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type ::blink::Vector<SharedFilePtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShareService::kShare), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ShareService_Share_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in ShareService.Share request");
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ShareService.Share request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ShareService.Share request");
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SharedFileDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in ShareService.Share request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShareService::Name_);
  message.set_method_name("Share");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ShareService_Share_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ShareService_Share_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ShareService::ShareCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ShareService_Share_ProxyToResponder> proxy(
        new ShareService_Share_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ShareService_Share_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ShareService_Share_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ShareService_Share_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ShareService::ShareCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ShareError in_error);
};

bool ShareService_Share_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ShareService_Share_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ShareService_Share_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ShareService.0
  bool success = true;
  ::blink::mojom::blink::ShareError p_error{};
  ShareService_Share_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ShareService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void ShareService_Share_ProxyToResponder::Run(
    ::blink::mojom::blink::ShareError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ShareService::Share", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::blink::ShareError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ShareService::kShare), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ShareService_Share_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ShareError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ShareService::Name_);
  message.set_method_name("Share");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ShareServiceStubDispatch::Accept(
    ShareService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ShareService>(message->header()->name)) {
    case messages::ShareService::kShare: {
      break;
    }
  }
  return false;
}

// static
bool ShareServiceStubDispatch::AcceptWithResponder(
    ShareService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ShareService>(message->header()->name)) {
    case messages::ShareService::kShare: {
      internal::ShareService_Share_Params_Data* params =
          reinterpret_cast<
              internal::ShareService_Share_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ShareService.0
      bool success = true;
      ::blink::String p_title{};
      ::blink::String p_text{};
      ::blink::KURL p_url{};
      ::blink::Vector<SharedFilePtr> p_files{};
      ShareService_Share_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ShareService::Name_, 0, false);
        return false;
      }
      auto callback =
          ShareService_Share_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Share(        
        std::move(p_title), 
        std::move(p_text), 
        std::move(p_url), 
        std::move(p_files), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kShareServiceValidationInfo[] = {
    { &internal::ShareService_Share_Params_Data::Validate,
     &internal::ShareService_Share_ResponseParams_Data::Validate},
};

bool ShareServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ShareService::Name_,
    kShareServiceValidationInfo);
}

bool ShareServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ShareService::Name_,
    kShareServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SharedFile::DataView, ::blink::mojom::blink::SharedFilePtr>::Read(
    ::blink::mojom::blink::SharedFile::DataView input,
    ::blink::mojom::blink::SharedFilePtr* output) {
  bool success = true;
  ::blink::mojom::blink::SharedFilePtr result(::blink::mojom::blink::SharedFile::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadBlob(&result->blob))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ShareServiceInterceptorForTesting::Share(const ::blink::String& title, const ::blink::String& text, const ::blink::KURL& url, ::blink::Vector<SharedFilePtr> files, ShareCallback callback) {
  GetForwardingInterface()->Share(
    std::move(title)
    , 
    std::move(text)
    , 
    std::move(url)
    , 
    std::move(files)
    , std::move(callback));
}
ShareServiceAsyncWaiter::ShareServiceAsyncWaiter(
    ShareService* proxy) : proxy_(proxy) {}

ShareServiceAsyncWaiter::~ShareServiceAsyncWaiter() = default;


void ShareServiceAsyncWaiter::Share(
    const ::blink::String& title, const ::blink::String& text, const ::blink::KURL& url, ::blink::Vector<SharedFilePtr> files, ::blink::mojom::blink::ShareError* out_error) {
  base::RunLoop loop;
  proxy_->Share(
      std::move(title),
      std::move(text),
      std::move(url),
      std::move(files),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ShareError* out_error
,
             ::blink::mojom::blink::ShareError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::blink::mojom::blink::ShareError ShareServiceAsyncWaiter::Share(
    const ::blink::String& title, const ::blink::String& text, const ::blink::KURL& url, ::blink::Vector<SharedFilePtr> files) {
  ::blink::mojom::blink::ShareError async_wait_result;
  Share(std::move(title),std::move(text),std::move(url),std::move(files),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif