// third_party/blink/public/mojom/webpreferences/web_preferences.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/webpreferences/web_preferences.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var skcolor$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor.mojom', '../../../../../skia/public/mojom/skcolor.mojom.js');
  }
  var preferred_color_scheme$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/css/preferred_color_scheme.mojom', '../css/preferred_color_scheme.mojom.js');
  }
  var preferred_contrast$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/css/preferred_contrast.mojom', '../css/preferred_contrast.mojom.js');
  }
  var v8_cache_options$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/v8_cache_options.mojom', '../v8_cache_options.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var PointerType = {};
  PointerType.kPointerNone = 1;
  PointerType.kPointerFirstType = 1;
  PointerType.kPointerCoarseType = 2;
  PointerType.kPointerFineType = 4;
  PointerType.MIN_VALUE = 1;
  PointerType.MAX_VALUE = 4;

  PointerType.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
    case 4:
      return true;
    }
    return false;
  };

  PointerType.toKnownEnumValue = function(value) {
    return value;
  };

  PointerType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HoverType = {};
  HoverType.kHoverNone = 1;
  HoverType.kHoverFirstType = 1;
  HoverType.kHoverHoverType = 2;
  HoverType.MIN_VALUE = 1;
  HoverType.MAX_VALUE = 2;

  HoverType.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  HoverType.toKnownEnumValue = function(value) {
    return value;
  };

  HoverType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var OutputDeviceUpdateAbilityType = {};
  OutputDeviceUpdateAbilityType.kSlowType = 0;
  OutputDeviceUpdateAbilityType.kFastType = 1;
  OutputDeviceUpdateAbilityType.MIN_VALUE = 0;
  OutputDeviceUpdateAbilityType.MAX_VALUE = 1;

  OutputDeviceUpdateAbilityType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  OutputDeviceUpdateAbilityType.toKnownEnumValue = function(value) {
    return value;
  };

  OutputDeviceUpdateAbilityType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EditingBehavior = {};
  EditingBehavior.kEditingMacBehavior = 0;
  EditingBehavior.kEditingWindowsBehavior = 1;
  EditingBehavior.kEditingUnixBehavior = 2;
  EditingBehavior.kEditingAndroidBehavior = 3;
  EditingBehavior.kEditingChromeOSBehavior = 4;
  EditingBehavior.MIN_VALUE = 0;
  EditingBehavior.MAX_VALUE = 4;

  EditingBehavior.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  EditingBehavior.toKnownEnumValue = function(value) {
    return value;
  };

  EditingBehavior.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ImageAnimationPolicy = {};
  ImageAnimationPolicy.kImageAnimationPolicyAllowed = 0;
  ImageAnimationPolicy.kImageAnimationPolicyAnimateOnce = 1;
  ImageAnimationPolicy.kImageAnimationPolicyNoAnimation = 2;
  ImageAnimationPolicy.MIN_VALUE = 0;
  ImageAnimationPolicy.MAX_VALUE = 2;

  ImageAnimationPolicy.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ImageAnimationPolicy.toKnownEnumValue = function(value) {
    return value;
  };

  ImageAnimationPolicy.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ViewportStyle = {};
  ViewportStyle.kDefault = 0;
  ViewportStyle.kMobile = 1;
  ViewportStyle.kTelevision = 2;
  ViewportStyle.kLast = 2;
  ViewportStyle.MIN_VALUE = 0;
  ViewportStyle.MAX_VALUE = 2;

  ViewportStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ViewportStyle.toKnownEnumValue = function(value) {
    return value;
  };

  ViewportStyle.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AutoplayPolicy = {};
  AutoplayPolicy.kNoUserGestureRequired = 0;
  AutoplayPolicy.kUserGestureRequired = 1;
  AutoplayPolicy.kDocumentUserActivationRequired = 2;
  AutoplayPolicy.MIN_VALUE = 0;
  AutoplayPolicy.MAX_VALUE = 2;

  AutoplayPolicy.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AutoplayPolicy.toKnownEnumValue = function(value) {
    return value;
  };

  AutoplayPolicy.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var EffectiveConnectionType = {};
  EffectiveConnectionType.kEffectiveConnectionUnknownType = 0;
  EffectiveConnectionType.kEffectiveConnectionOfflineType = 1;
  EffectiveConnectionType.kEffectiveConnectionSlow2GType = 2;
  EffectiveConnectionType.kEffectiveConnection2GType = 3;
  EffectiveConnectionType.kEffectiveConnection3GType = 4;
  EffectiveConnectionType.kEffectiveConnection4GType = 5;
  EffectiveConnectionType.kEffectiveConnectionTypeLast = 6;
  EffectiveConnectionType.MIN_VALUE = 0;
  EffectiveConnectionType.MAX_VALUE = 6;

  EffectiveConnectionType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  EffectiveConnectionType.toKnownEnumValue = function(value) {
    return value;
  };

  EffectiveConnectionType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function WebPreferences(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPreferences.prototype.initDefaults_ = function() {
    this.standardFontFamilyMap = null;
    this.fixedFontFamilyMap = null;
    this.serifFontFamilyMap = null;
    this.sansSerifFontFamilyMap = null;
    this.cursiveFontFamilyMap = null;
    this.fantasyFontFamilyMap = null;
    this.mathFontFamilyMap = null;
    this.defaultFontSize = 0;
    this.defaultFixedFontSize = 0;
    this.minimumFontSize = 0;
    this.minimumLogicalFontSize = 0;
    this.defaultEncoding = null;
    this.alwaysShowContextMenuOnTouch = false;
    this.contextMenuOnMouseUp = false;
    this.javascriptEnabled = false;
    this.webSecurityEnabled = false;
    this.loadsImagesAutomatically = false;
    this.imagesEnabled = false;
    this.pluginsEnabled = false;
    this.domPasteEnabled = false;
    this.shrinksStandaloneImagesToFit = false;
    this.textAreasAreResizable = false;
    this.allowScriptsToCloseWindows = false;
    this.remoteFontsEnabled = false;
    this.javascriptCanAccessClipboard = false;
    this.dnsPrefetchingEnabled = false;
    this.dataSaverEnabled = false;
    this.localStorageEnabled = false;
    this.tabsToLinks = false;
    this.disableIpcFloodingProtection = false;
    this.hyperlinkAuditingEnabled = false;
    this.allowUniversalAccessFromFileUrls = false;
    this.allowFileAccessFromFileUrls = false;
    this.webgl1Enabled = false;
    this.webgl2Enabled = false;
    this.privilegedWebglExtensionsEnabled = false;
    this.webglErrorsToConsoleEnabled = false;
    this.hideScrollbars = false;
    this.prefersDefaultScrollbarStyles = false;
    this.accelerated2dCanvasEnabled = false;
    this.canvas2dLayersEnabled = false;
    this.antialiased2dCanvasDisabled = false;
    this.antialiasedClips2dCanvasEnabled = false;
    this.acceleratedFiltersEnabled = false;
    this.deferredFiltersEnabled = false;
    this.containerCullingEnabled = false;
    this.allowRunningInsecureContent = false;
    this.disableReadingFromCanvas = false;
    this.strictMixedContentChecking = false;
    this.strictPowerfulFeatureRestrictions = false;
    this.allowGeolocationOnInsecureOrigins = false;
    this.strictlyBlockBlockableMixedContent = false;
    this.blockMixedPluginContent = false;
    this.passwordEchoEnabled = false;
    this.shouldClearDocumentBackground = false;
    this.enableScrollAnimator = false;
    this.prefersReducedMotion = false;
    this.prefersReducedTransparency = false;
    this.invertedColors = false;
    this.touchEventFeatureDetectionEnabled = false;
    this.dontSendKeyEventsToJavascript = false;
    this.barrelButtonForDragEnabled = false;
    this.syncXhrInDocumentsEnabled = false;
    this.targetBlankImpliesNoOpenerEnabledWillBeRemoved = false;
    this.ignorePermissionForDeviceChangedEvent = false;
    this.supportsMultipleWindows = false;
    this.viewportEnabled = false;
    this.viewportMetaEnabled = false;
    this.autoZoomFocusedEditableToLegibleScale = false;
    this.shrinksViewportContentsToFit = false;
    this.smoothScrollForFindEnabled = false;
    this.mainFrameResizesAreOrientationChanges = false;
    this.initializeAtMinimumPageScale = false;
    this.smartInsertDeleteEnabled = false;
    this.spatialNavigationEnabled = false;
    this.recordWholeDocument = false;
    this.pointerEventsMaxTouchPoints = 0;
    this.availablePointerTypes = 0;
    this.primaryPointerType = 0;
    this.outputDeviceUpdateAbilityType = 0;
    this.availableHoverTypes = 0;
    this.primaryHoverType = 0;
    this.numberOfCpuCores = 0;
    this.editingBehavior = 0;
    this.viewportStyle = 0;
    this.v8CacheOptions = 0;
    this.stylusHandwritingEnabled = false;
    this.cookieEnabled = false;
    this.acceleratedVideoDecodeEnabled = false;
    this.userGestureRequiredForPresentation = false;
    this.textTracksEnabled = false;
    this.immersiveModeEnabled = false;
    this.doubleTapToZoomEnabled = false;
    this.fullscreenSupported = false;
    this.textAutosizingEnabled = false;
    this.forceDarkModeEnabled = false;
    this.hideDownloadUi = false;
    this.presentationReceiver = false;
    this.mediaControlsEnabled = false;
    this.doNotUpdateSelectionOnMutatingSelectionRange = false;
    this.requireTransientActivationForGetDisplayMedia = false;
    this.requireTransientActivationForShowFileOrDirectoryPicker = false;
    this.requireTransientActivationAndUserConfirmationForSubappsApi = false;
    this.inForcedColors = false;
    this.isForcedColorsDisabled = false;
    this.pictureInPictureEnabled = false;
    this.translateServiceAvailable = false;
    this.lazyLoadEnabled = false;
    this.allowMixedContentUpgrades = false;
    this.alwaysShowFocus = false;
    this.touchDragDropEnabled = false;
    this.touchDragendContextMenu = false;
    this.webxrImmersiveArAllowed = false;
    this.rendererWideNamedFrameLookup = false;
    this.strictMimeTypeCheckForWorkerScriptsEnabled = true;
    this.modalContextMenu = true;
    this.paymentRequestEnabled = false;
    this.contentBasedFingerprintingProtectionEnabled = false;
    this.animationPolicy = 0;
    this.textTrackBackgroundColor = null;
    this.textTrackTextColor = null;
    this.textTrackTextSize = null;
    this.textTrackTextShadow = null;
    this.textTrackFontFamily = null;
    this.textTrackFontStyle = null;
    this.textTrackFontVariant = null;
    this.textTrackWindowColor = null;
    this.textTrackWindowRadius = null;
    this.textTrackMarginPercentage = 0;
    this.defaultMinimumPageScaleFactor = 0;
    this.webAppScope = null;
    this.defaultMaximumPageScaleFactor = 0;
    this.autoplayPolicy = 0;
    this.rootScrollbarThemeColor = null;
    this.preferredRootScrollbarColorScheme = 0;
    this.preferredColorScheme = 0;
    this.preferredContrast = 0;
    this.lowPriorityIframesThreshold = 0;
    this.networkQualityEstimatorWebHoldback = 0;
    this.aiPromptApiEnabled = false;
    this.shouldDisableExternalPopups = false;
  };
  WebPreferences.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPreferences.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 272}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.standardFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.fixedFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.serifFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.sansSerifFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 24, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.cursiveFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 32, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.fantasyFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.mathFontFamilyMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 48, false, codec.String, new codec.PointerTo(string16$.String16), false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate WebPreferences.defaultEncoding
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 72, false)
    if (err !== validator.validationError.NONE)
        return err;




















































    // validate WebPreferences.primaryPointerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 96, PointerType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.outputDeviceUpdateAbilityType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, OutputDeviceUpdateAbilityType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPreferences.primaryHoverType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 108, HoverType);
    if (err !== validator.validationError.NONE)
        return err;








    // validate WebPreferences.editingBehavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 116, EditingBehavior);
    if (err !== validator.validationError.NONE)
        return err;







    // validate WebPreferences.viewportStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 120, ViewportStyle);
    if (err !== validator.validationError.NONE)
        return err;







    // validate WebPreferences.v8CacheOptions
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 124, v8_cache_options$.V8CacheOptions);
    if (err !== validator.validationError.NONE)
        return err;






    // validate WebPreferences.animationPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 132, ImageAnimationPolicy);
    if (err !== validator.validationError.NONE)
        return err;




    // validate WebPreferences.textTrackBackgroundColor
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 136, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackTextColor
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 144, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackTextSize
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 152, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackTextShadow
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 160, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackFontFamily
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 168, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackFontStyle
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 176, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackFontVariant
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 184, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackWindowColor
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 192, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.textTrackWindowRadius
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 200, false)
    if (err !== validator.validationError.NONE)
        return err;







    // validate WebPreferences.webAppScope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 216, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;









    // validate WebPreferences.autoplayPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 228, AutoplayPolicy);
    if (err !== validator.validationError.NONE)
        return err;







    // validate WebPreferences.rootScrollbarThemeColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 232, skcolor$.SkColor, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.preferredRootScrollbarColorScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 240, preferred_color_scheme$.PreferredColorScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.preferredColorScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 244, preferred_color_scheme$.PreferredColorScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.preferredContrast
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 248, preferred_contrast$.PreferredContrast);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPreferences.lowPriorityIframesThreshold
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 252, EffectiveConnectionType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate WebPreferences.networkQualityEstimatorWebHoldback
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 256, EffectiveConnectionType);
    if (err !== validator.validationError.NONE)
        return err;














    return validator.validationError.NONE;
  };

  WebPreferences.encodedSize = codec.kStructHeaderSize + 264;

  WebPreferences.decode = function(decoder) {
    var packed;
    var val = new WebPreferences();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.standardFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.fixedFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.serifFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.sansSerifFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.cursiveFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.fantasyFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.mathFontFamilyMap =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(string16$.String16));
    val.defaultFontSize =
        decoder.decodeStruct(codec.Int32);
    val.defaultFixedFontSize =
        decoder.decodeStruct(codec.Int32);
    val.minimumFontSize =
        decoder.decodeStruct(codec.Int32);
    val.minimumLogicalFontSize =
        decoder.decodeStruct(codec.Int32);
    val.defaultEncoding =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.alwaysShowContextMenuOnTouch = (packed >> 0) & 1 ? true : false;
    val.contextMenuOnMouseUp = (packed >> 1) & 1 ? true : false;
    val.javascriptEnabled = (packed >> 2) & 1 ? true : false;
    val.webSecurityEnabled = (packed >> 3) & 1 ? true : false;
    val.loadsImagesAutomatically = (packed >> 4) & 1 ? true : false;
    val.imagesEnabled = (packed >> 5) & 1 ? true : false;
    val.pluginsEnabled = (packed >> 6) & 1 ? true : false;
    val.domPasteEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.shrinksStandaloneImagesToFit = (packed >> 0) & 1 ? true : false;
    val.textAreasAreResizable = (packed >> 1) & 1 ? true : false;
    val.allowScriptsToCloseWindows = (packed >> 2) & 1 ? true : false;
    val.remoteFontsEnabled = (packed >> 3) & 1 ? true : false;
    val.javascriptCanAccessClipboard = (packed >> 4) & 1 ? true : false;
    val.dnsPrefetchingEnabled = (packed >> 5) & 1 ? true : false;
    val.dataSaverEnabled = (packed >> 6) & 1 ? true : false;
    val.localStorageEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.tabsToLinks = (packed >> 0) & 1 ? true : false;
    val.disableIpcFloodingProtection = (packed >> 1) & 1 ? true : false;
    val.hyperlinkAuditingEnabled = (packed >> 2) & 1 ? true : false;
    val.allowUniversalAccessFromFileUrls = (packed >> 3) & 1 ? true : false;
    val.allowFileAccessFromFileUrls = (packed >> 4) & 1 ? true : false;
    val.webgl1Enabled = (packed >> 5) & 1 ? true : false;
    val.webgl2Enabled = (packed >> 6) & 1 ? true : false;
    val.privilegedWebglExtensionsEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.webglErrorsToConsoleEnabled = (packed >> 0) & 1 ? true : false;
    val.hideScrollbars = (packed >> 1) & 1 ? true : false;
    val.prefersDefaultScrollbarStyles = (packed >> 2) & 1 ? true : false;
    val.accelerated2dCanvasEnabled = (packed >> 3) & 1 ? true : false;
    val.canvas2dLayersEnabled = (packed >> 4) & 1 ? true : false;
    val.antialiased2dCanvasDisabled = (packed >> 5) & 1 ? true : false;
    val.antialiasedClips2dCanvasEnabled = (packed >> 6) & 1 ? true : false;
    val.acceleratedFiltersEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.deferredFiltersEnabled = (packed >> 0) & 1 ? true : false;
    val.containerCullingEnabled = (packed >> 1) & 1 ? true : false;
    val.allowRunningInsecureContent = (packed >> 2) & 1 ? true : false;
    val.disableReadingFromCanvas = (packed >> 3) & 1 ? true : false;
    val.strictMixedContentChecking = (packed >> 4) & 1 ? true : false;
    val.strictPowerfulFeatureRestrictions = (packed >> 5) & 1 ? true : false;
    val.allowGeolocationOnInsecureOrigins = (packed >> 6) & 1 ? true : false;
    val.strictlyBlockBlockableMixedContent = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.blockMixedPluginContent = (packed >> 0) & 1 ? true : false;
    val.passwordEchoEnabled = (packed >> 1) & 1 ? true : false;
    val.shouldClearDocumentBackground = (packed >> 2) & 1 ? true : false;
    val.enableScrollAnimator = (packed >> 3) & 1 ? true : false;
    val.prefersReducedMotion = (packed >> 4) & 1 ? true : false;
    val.prefersReducedTransparency = (packed >> 5) & 1 ? true : false;
    val.invertedColors = (packed >> 6) & 1 ? true : false;
    val.touchEventFeatureDetectionEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.dontSendKeyEventsToJavascript = (packed >> 0) & 1 ? true : false;
    val.barrelButtonForDragEnabled = (packed >> 1) & 1 ? true : false;
    val.syncXhrInDocumentsEnabled = (packed >> 2) & 1 ? true : false;
    val.targetBlankImpliesNoOpenerEnabledWillBeRemoved = (packed >> 3) & 1 ? true : false;
    val.ignorePermissionForDeviceChangedEvent = (packed >> 4) & 1 ? true : false;
    val.supportsMultipleWindows = (packed >> 5) & 1 ? true : false;
    val.viewportEnabled = (packed >> 6) & 1 ? true : false;
    val.viewportMetaEnabled = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.autoZoomFocusedEditableToLegibleScale = (packed >> 0) & 1 ? true : false;
    val.shrinksViewportContentsToFit = (packed >> 1) & 1 ? true : false;
    val.smoothScrollForFindEnabled = (packed >> 2) & 1 ? true : false;
    val.mainFrameResizesAreOrientationChanges = (packed >> 3) & 1 ? true : false;
    val.initializeAtMinimumPageScale = (packed >> 4) & 1 ? true : false;
    val.smartInsertDeleteEnabled = (packed >> 5) & 1 ? true : false;
    val.spatialNavigationEnabled = (packed >> 6) & 1 ? true : false;
    val.recordWholeDocument = (packed >> 7) & 1 ? true : false;
    val.pointerEventsMaxTouchPoints =
        decoder.decodeStruct(codec.Int32);
    val.availablePointerTypes =
        decoder.decodeStruct(codec.Int32);
    val.primaryPointerType =
        decoder.decodeStruct(new codec.Enum(PointerType));
    val.outputDeviceUpdateAbilityType =
        decoder.decodeStruct(new codec.Enum(OutputDeviceUpdateAbilityType));
    val.availableHoverTypes =
        decoder.decodeStruct(codec.Int32);
    val.primaryHoverType =
        decoder.decodeStruct(new codec.Enum(HoverType));
    val.numberOfCpuCores =
        decoder.decodeStruct(codec.Int32);
    val.editingBehavior =
        decoder.decodeStruct(new codec.Enum(EditingBehavior));
    val.viewportStyle =
        decoder.decodeStruct(new codec.Enum(ViewportStyle));
    val.v8CacheOptions =
        decoder.decodeStruct(new codec.Enum(v8_cache_options$.V8CacheOptions));
    packed = decoder.readUint8();
    val.stylusHandwritingEnabled = (packed >> 0) & 1 ? true : false;
    val.cookieEnabled = (packed >> 1) & 1 ? true : false;
    val.acceleratedVideoDecodeEnabled = (packed >> 2) & 1 ? true : false;
    val.userGestureRequiredForPresentation = (packed >> 3) & 1 ? true : false;
    val.textTracksEnabled = (packed >> 4) & 1 ? true : false;
    val.immersiveModeEnabled = (packed >> 5) & 1 ? true : false;
    val.doubleTapToZoomEnabled = (packed >> 6) & 1 ? true : false;
    val.fullscreenSupported = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.textAutosizingEnabled = (packed >> 0) & 1 ? true : false;
    val.forceDarkModeEnabled = (packed >> 1) & 1 ? true : false;
    val.hideDownloadUi = (packed >> 2) & 1 ? true : false;
    val.presentationReceiver = (packed >> 3) & 1 ? true : false;
    val.mediaControlsEnabled = (packed >> 4) & 1 ? true : false;
    val.doNotUpdateSelectionOnMutatingSelectionRange = (packed >> 5) & 1 ? true : false;
    val.requireTransientActivationForGetDisplayMedia = (packed >> 6) & 1 ? true : false;
    val.requireTransientActivationForShowFileOrDirectoryPicker = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.requireTransientActivationAndUserConfirmationForSubappsApi = (packed >> 0) & 1 ? true : false;
    val.inForcedColors = (packed >> 1) & 1 ? true : false;
    val.isForcedColorsDisabled = (packed >> 2) & 1 ? true : false;
    val.pictureInPictureEnabled = (packed >> 3) & 1 ? true : false;
    val.translateServiceAvailable = (packed >> 4) & 1 ? true : false;
    val.lazyLoadEnabled = (packed >> 5) & 1 ? true : false;
    val.allowMixedContentUpgrades = (packed >> 6) & 1 ? true : false;
    val.alwaysShowFocus = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.touchDragDropEnabled = (packed >> 0) & 1 ? true : false;
    val.touchDragendContextMenu = (packed >> 1) & 1 ? true : false;
    val.webxrImmersiveArAllowed = (packed >> 2) & 1 ? true : false;
    val.rendererWideNamedFrameLookup = (packed >> 3) & 1 ? true : false;
    val.strictMimeTypeCheckForWorkerScriptsEnabled = (packed >> 4) & 1 ? true : false;
    val.modalContextMenu = (packed >> 5) & 1 ? true : false;
    val.paymentRequestEnabled = (packed >> 6) & 1 ? true : false;
    val.contentBasedFingerprintingProtectionEnabled = (packed >> 7) & 1 ? true : false;
    val.animationPolicy =
        decoder.decodeStruct(new codec.Enum(ImageAnimationPolicy));
    val.textTrackBackgroundColor =
        decoder.decodeStruct(codec.String);
    val.textTrackTextColor =
        decoder.decodeStruct(codec.String);
    val.textTrackTextSize =
        decoder.decodeStruct(codec.String);
    val.textTrackTextShadow =
        decoder.decodeStruct(codec.String);
    val.textTrackFontFamily =
        decoder.decodeStruct(codec.String);
    val.textTrackFontStyle =
        decoder.decodeStruct(codec.String);
    val.textTrackFontVariant =
        decoder.decodeStruct(codec.String);
    val.textTrackWindowColor =
        decoder.decodeStruct(codec.String);
    val.textTrackWindowRadius =
        decoder.decodeStruct(codec.String);
    val.textTrackMarginPercentage =
        decoder.decodeStruct(codec.Float);
    val.defaultMinimumPageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.webAppScope =
        decoder.decodeStructPointer(url$.Url);
    val.defaultMaximumPageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.autoplayPolicy =
        decoder.decodeStruct(new codec.Enum(AutoplayPolicy));
    val.rootScrollbarThemeColor =
        decoder.decodeStructPointer(skcolor$.SkColor);
    val.preferredRootScrollbarColorScheme =
        decoder.decodeStruct(new codec.Enum(preferred_color_scheme$.PreferredColorScheme));
    val.preferredColorScheme =
        decoder.decodeStruct(new codec.Enum(preferred_color_scheme$.PreferredColorScheme));
    val.preferredContrast =
        decoder.decodeStruct(new codec.Enum(preferred_contrast$.PreferredContrast));
    val.lowPriorityIframesThreshold =
        decoder.decodeStruct(new codec.Enum(EffectiveConnectionType));
    val.networkQualityEstimatorWebHoldback =
        decoder.decodeStruct(new codec.Enum(EffectiveConnectionType));
    packed = decoder.readUint8();
    val.aiPromptApiEnabled = (packed >> 0) & 1 ? true : false;
    val.shouldDisableExternalPopups = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebPreferences.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPreferences.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.standardFontFamilyMap);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.fixedFontFamilyMap);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.serifFontFamilyMap);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.sansSerifFontFamilyMap);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.cursiveFontFamilyMap);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.fantasyFontFamilyMap);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(string16$.String16), val.mathFontFamilyMap);
    encoder.encodeStruct(codec.Int32, val.defaultFontSize);
    encoder.encodeStruct(codec.Int32, val.defaultFixedFontSize);
    encoder.encodeStruct(codec.Int32, val.minimumFontSize);
    encoder.encodeStruct(codec.Int32, val.minimumLogicalFontSize);
    encoder.encodeStruct(codec.String, val.defaultEncoding);
    packed = 0;
    packed |= (val.alwaysShowContextMenuOnTouch & 1) << 0
    packed |= (val.contextMenuOnMouseUp & 1) << 1
    packed |= (val.javascriptEnabled & 1) << 2
    packed |= (val.webSecurityEnabled & 1) << 3
    packed |= (val.loadsImagesAutomatically & 1) << 4
    packed |= (val.imagesEnabled & 1) << 5
    packed |= (val.pluginsEnabled & 1) << 6
    packed |= (val.domPasteEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.shrinksStandaloneImagesToFit & 1) << 0
    packed |= (val.textAreasAreResizable & 1) << 1
    packed |= (val.allowScriptsToCloseWindows & 1) << 2
    packed |= (val.remoteFontsEnabled & 1) << 3
    packed |= (val.javascriptCanAccessClipboard & 1) << 4
    packed |= (val.dnsPrefetchingEnabled & 1) << 5
    packed |= (val.dataSaverEnabled & 1) << 6
    packed |= (val.localStorageEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.tabsToLinks & 1) << 0
    packed |= (val.disableIpcFloodingProtection & 1) << 1
    packed |= (val.hyperlinkAuditingEnabled & 1) << 2
    packed |= (val.allowUniversalAccessFromFileUrls & 1) << 3
    packed |= (val.allowFileAccessFromFileUrls & 1) << 4
    packed |= (val.webgl1Enabled & 1) << 5
    packed |= (val.webgl2Enabled & 1) << 6
    packed |= (val.privilegedWebglExtensionsEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.webglErrorsToConsoleEnabled & 1) << 0
    packed |= (val.hideScrollbars & 1) << 1
    packed |= (val.prefersDefaultScrollbarStyles & 1) << 2
    packed |= (val.accelerated2dCanvasEnabled & 1) << 3
    packed |= (val.canvas2dLayersEnabled & 1) << 4
    packed |= (val.antialiased2dCanvasDisabled & 1) << 5
    packed |= (val.antialiasedClips2dCanvasEnabled & 1) << 6
    packed |= (val.acceleratedFiltersEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.deferredFiltersEnabled & 1) << 0
    packed |= (val.containerCullingEnabled & 1) << 1
    packed |= (val.allowRunningInsecureContent & 1) << 2
    packed |= (val.disableReadingFromCanvas & 1) << 3
    packed |= (val.strictMixedContentChecking & 1) << 4
    packed |= (val.strictPowerfulFeatureRestrictions & 1) << 5
    packed |= (val.allowGeolocationOnInsecureOrigins & 1) << 6
    packed |= (val.strictlyBlockBlockableMixedContent & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.blockMixedPluginContent & 1) << 0
    packed |= (val.passwordEchoEnabled & 1) << 1
    packed |= (val.shouldClearDocumentBackground & 1) << 2
    packed |= (val.enableScrollAnimator & 1) << 3
    packed |= (val.prefersReducedMotion & 1) << 4
    packed |= (val.prefersReducedTransparency & 1) << 5
    packed |= (val.invertedColors & 1) << 6
    packed |= (val.touchEventFeatureDetectionEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.dontSendKeyEventsToJavascript & 1) << 0
    packed |= (val.barrelButtonForDragEnabled & 1) << 1
    packed |= (val.syncXhrInDocumentsEnabled & 1) << 2
    packed |= (val.targetBlankImpliesNoOpenerEnabledWillBeRemoved & 1) << 3
    packed |= (val.ignorePermissionForDeviceChangedEvent & 1) << 4
    packed |= (val.supportsMultipleWindows & 1) << 5
    packed |= (val.viewportEnabled & 1) << 6
    packed |= (val.viewportMetaEnabled & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.autoZoomFocusedEditableToLegibleScale & 1) << 0
    packed |= (val.shrinksViewportContentsToFit & 1) << 1
    packed |= (val.smoothScrollForFindEnabled & 1) << 2
    packed |= (val.mainFrameResizesAreOrientationChanges & 1) << 3
    packed |= (val.initializeAtMinimumPageScale & 1) << 4
    packed |= (val.smartInsertDeleteEnabled & 1) << 5
    packed |= (val.spatialNavigationEnabled & 1) << 6
    packed |= (val.recordWholeDocument & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int32, val.pointerEventsMaxTouchPoints);
    encoder.encodeStruct(codec.Int32, val.availablePointerTypes);
    encoder.encodeStruct(codec.Int32, val.primaryPointerType);
    encoder.encodeStruct(codec.Int32, val.outputDeviceUpdateAbilityType);
    encoder.encodeStruct(codec.Int32, val.availableHoverTypes);
    encoder.encodeStruct(codec.Int32, val.primaryHoverType);
    encoder.encodeStruct(codec.Int32, val.numberOfCpuCores);
    encoder.encodeStruct(codec.Int32, val.editingBehavior);
    encoder.encodeStruct(codec.Int32, val.viewportStyle);
    encoder.encodeStruct(codec.Int32, val.v8CacheOptions);
    packed = 0;
    packed |= (val.stylusHandwritingEnabled & 1) << 0
    packed |= (val.cookieEnabled & 1) << 1
    packed |= (val.acceleratedVideoDecodeEnabled & 1) << 2
    packed |= (val.userGestureRequiredForPresentation & 1) << 3
    packed |= (val.textTracksEnabled & 1) << 4
    packed |= (val.immersiveModeEnabled & 1) << 5
    packed |= (val.doubleTapToZoomEnabled & 1) << 6
    packed |= (val.fullscreenSupported & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.textAutosizingEnabled & 1) << 0
    packed |= (val.forceDarkModeEnabled & 1) << 1
    packed |= (val.hideDownloadUi & 1) << 2
    packed |= (val.presentationReceiver & 1) << 3
    packed |= (val.mediaControlsEnabled & 1) << 4
    packed |= (val.doNotUpdateSelectionOnMutatingSelectionRange & 1) << 5
    packed |= (val.requireTransientActivationForGetDisplayMedia & 1) << 6
    packed |= (val.requireTransientActivationForShowFileOrDirectoryPicker & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.requireTransientActivationAndUserConfirmationForSubappsApi & 1) << 0
    packed |= (val.inForcedColors & 1) << 1
    packed |= (val.isForcedColorsDisabled & 1) << 2
    packed |= (val.pictureInPictureEnabled & 1) << 3
    packed |= (val.translateServiceAvailable & 1) << 4
    packed |= (val.lazyLoadEnabled & 1) << 5
    packed |= (val.allowMixedContentUpgrades & 1) << 6
    packed |= (val.alwaysShowFocus & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.touchDragDropEnabled & 1) << 0
    packed |= (val.touchDragendContextMenu & 1) << 1
    packed |= (val.webxrImmersiveArAllowed & 1) << 2
    packed |= (val.rendererWideNamedFrameLookup & 1) << 3
    packed |= (val.strictMimeTypeCheckForWorkerScriptsEnabled & 1) << 4
    packed |= (val.modalContextMenu & 1) << 5
    packed |= (val.paymentRequestEnabled & 1) << 6
    packed |= (val.contentBasedFingerprintingProtectionEnabled & 1) << 7
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int32, val.animationPolicy);
    encoder.encodeStruct(codec.String, val.textTrackBackgroundColor);
    encoder.encodeStruct(codec.String, val.textTrackTextColor);
    encoder.encodeStruct(codec.String, val.textTrackTextSize);
    encoder.encodeStruct(codec.String, val.textTrackTextShadow);
    encoder.encodeStruct(codec.String, val.textTrackFontFamily);
    encoder.encodeStruct(codec.String, val.textTrackFontStyle);
    encoder.encodeStruct(codec.String, val.textTrackFontVariant);
    encoder.encodeStruct(codec.String, val.textTrackWindowColor);
    encoder.encodeStruct(codec.String, val.textTrackWindowRadius);
    encoder.encodeStruct(codec.Float, val.textTrackMarginPercentage);
    encoder.encodeStruct(codec.Float, val.defaultMinimumPageScaleFactor);
    encoder.encodeStructPointer(url$.Url, val.webAppScope);
    encoder.encodeStruct(codec.Float, val.defaultMaximumPageScaleFactor);
    encoder.encodeStruct(codec.Int32, val.autoplayPolicy);
    encoder.encodeStructPointer(skcolor$.SkColor, val.rootScrollbarThemeColor);
    encoder.encodeStruct(codec.Int32, val.preferredRootScrollbarColorScheme);
    encoder.encodeStruct(codec.Int32, val.preferredColorScheme);
    encoder.encodeStruct(codec.Int32, val.preferredContrast);
    encoder.encodeStruct(codec.Int32, val.lowPriorityIframesThreshold);
    encoder.encodeStruct(codec.Int32, val.networkQualityEstimatorWebHoldback);
    packed = 0;
    packed |= (val.aiPromptApiEnabled & 1) << 0
    packed |= (val.shouldDisableExternalPopups & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.PointerType = PointerType;
  exports.HoverType = HoverType;
  exports.OutputDeviceUpdateAbilityType = OutputDeviceUpdateAbilityType;
  exports.EditingBehavior = EditingBehavior;
  exports.ImageAnimationPolicy = ImageAnimationPolicy;
  exports.ViewportStyle = ViewportStyle;
  exports.AutoplayPolicy = AutoplayPolicy;
  exports.EffectiveConnectionType = EffectiveConnectionType;
  exports.WebPreferences = WebPreferences;
})();