// third_party/blink/public/mojom/webid/digital_identity_request.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Value as mojoBase_mojom_Value,
  ValueSpec as mojoBase_mojom_ValueSpec
} from '../../../../../mojo/public/mojom/base/values.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RequestDigitalIdentityStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RequestDigitalIdentityStatus = {
  
  kSuccess: 0,
  kError: 1,
  kErrorTooManyRequests: 2,
  kErrorCanceled: 3,
  kErrorNoRequests: 4,
  kErrorNoTransientUserActivation: 5,
  kErrorInvalidJson: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DigitalIdentityRequestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DigitalIdentityRequest', scope);
  }
}

/** @interface */
export class DigitalIdentityRequestInterface {
  
  /**
   * @param { !Array<!DigitalCredentialGetRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase_mojom_Value,
   *  }>}
   */

  get(digitalCredentialRequests) {}
  
  /**
   * @param { !Array<!DigitalCredentialCreateRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase_mojom_Value,
   *  }>}
   */

  create(digitalCredentialRequests) {}
  
  /**
   */

  abort() {}
}

/**
 * @implements { DigitalIdentityRequestInterface }
 */
export class DigitalIdentityRequestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DigitalIdentityRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DigitalIdentityRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DigitalIdentityRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!DigitalCredentialGetRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase_mojom_Value,
   *  }>}
   */

  get(
      digitalCredentialRequests) {
    return this.proxy.sendMessage(
        0,
        DigitalIdentityRequest_Get_ParamsSpec.$,
        DigitalIdentityRequest_Get_ResponseParamsSpec.$,
        [
          digitalCredentialRequests
        ],
        false);
  }

  
  /**
   * @param { !Array<!DigitalCredentialCreateRequest> } digitalCredentialRequests
   * @return {!Promise<{
        status: !RequestDigitalIdentityStatus,
        protocol: ?string,
        token: ?mojoBase_mojom_Value,
   *  }>}
   */

  create(
      digitalCredentialRequests) {
    return this.proxy.sendMessage(
        1,
        DigitalIdentityRequest_Create_ParamsSpec.$,
        DigitalIdentityRequest_Create_ResponseParamsSpec.$,
        [
          digitalCredentialRequests
        ],
        false);
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        2,
        DigitalIdentityRequest_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DigitalIdentityRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DigitalIdentityRequestReceiver {
  /**
   * @param {!DigitalIdentityRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DigitalIdentityRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DigitalIdentityRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DigitalIdentityRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DigitalIdentityRequest_Get_ParamsSpec.$,
        DigitalIdentityRequest_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DigitalIdentityRequest_Create_ParamsSpec.$,
        DigitalIdentityRequest_Create_ResponseParamsSpec.$,
        impl.create.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DigitalIdentityRequest_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DigitalIdentityRequest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DigitalIdentityRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DigitalIdentityRequestRemote}
   */
  static getRemote() {
    let remote = new DigitalIdentityRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DigitalIdentityRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DigitalIdentityRequestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DigitalIdentityRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DigitalIdentityRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DigitalIdentityRequest_Get_ParamsSpec.$,
        DigitalIdentityRequest_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.create =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DigitalIdentityRequest_Create_ParamsSpec.$,
        DigitalIdentityRequest_Create_ResponseParamsSpec.$,
        this.create.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DigitalIdentityRequest_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalCredentialGetRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalCredentialCreateRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalIdentityRequest_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalIdentityRequest_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalIdentityRequest_Create_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalIdentityRequest_Create_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalIdentityRequest_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DigitalCredentialGetRequestSpec.$,
    'DigitalCredentialGetRequest',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DigitalCredentialGetRequest {
  constructor() {
    /** @type { !string } */
    this.protocol;
    /** @type { !mojoBase_mojom_Value } */
    this.data;
  }
}



mojo.internal.Struct(
    DigitalCredentialCreateRequestSpec.$,
    'DigitalCredentialCreateRequest',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DigitalCredentialCreateRequest {
  constructor() {
    /** @type { !string } */
    this.protocol;
    /** @type { !mojoBase_mojom_Value } */
    this.data;
  }
}



mojo.internal.Struct(
    DigitalIdentityRequest_Get_ParamsSpec.$,
    'DigitalIdentityRequest_Get_Params',
    [
      mojo.internal.StructField(
        'digitalCredentialRequests', 0,
        0,
        mojo.internal.Array(DigitalCredentialGetRequestSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DigitalIdentityRequest_Get_Params {
  constructor() {
    /** @type { !Array<!DigitalCredentialGetRequest> } */
    this.digitalCredentialRequests;
  }
}



mojo.internal.Struct(
    DigitalIdentityRequest_Get_ResponseParamsSpec.$,
    'DigitalIdentityRequest_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        RequestDigitalIdentityStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocol', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 16,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DigitalIdentityRequest_Get_ResponseParams {
  constructor() {
    /** @type { !RequestDigitalIdentityStatus } */
    this.status;
    /** @type { (string|undefined) } */
    this.protocol;
    /** @type { (mojoBase_mojom_Value|undefined) } */
    this.token;
  }
}



mojo.internal.Struct(
    DigitalIdentityRequest_Create_ParamsSpec.$,
    'DigitalIdentityRequest_Create_Params',
    [
      mojo.internal.StructField(
        'digitalCredentialRequests', 0,
        0,
        mojo.internal.Array(DigitalCredentialCreateRequestSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DigitalIdentityRequest_Create_Params {
  constructor() {
    /** @type { !Array<!DigitalCredentialCreateRequest> } */
    this.digitalCredentialRequests;
  }
}



mojo.internal.Struct(
    DigitalIdentityRequest_Create_ResponseParamsSpec.$,
    'DigitalIdentityRequest_Create_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        RequestDigitalIdentityStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocol', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 16,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DigitalIdentityRequest_Create_ResponseParams {
  constructor() {
    /** @type { !RequestDigitalIdentityStatus } */
    this.status;
    /** @type { (string|undefined) } */
    this.protocol;
    /** @type { (mojoBase_mojom_Value|undefined) } */
    this.token;
  }
}



mojo.internal.Struct(
    DigitalIdentityRequest_Abort_ParamsSpec.$,
    'DigitalIdentityRequest_Abort_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DigitalIdentityRequest_Abort_Params {
  constructor() {
  }
}

