// third_party/blink/public/mojom/webauthn/authenticator.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::AuthenticatorStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AuthenticatorStatus> {};

template <>
struct hash<::blink::mojom::AuthenticatorTransport>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AuthenticatorTransport> {};

template <>
struct hash<::blink::mojom::Hint>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Hint> {};

template <>
struct hash<::blink::mojom::UserVerificationRequirement>
    : public mojo::internal::EnumHashImpl<::blink::mojom::UserVerificationRequirement> {};

template <>
struct hash<::blink::mojom::Mediation>
    : public mojo::internal::EnumHashImpl<::blink::mojom::Mediation> {};

template <>
struct hash<::blink::mojom::ResidentKeyRequirement>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ResidentKeyRequirement> {};

template <>
struct hash<::blink::mojom::AuthenticatorAttachment>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AuthenticatorAttachment> {};

template <>
struct hash<::blink::mojom::ProtectionPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ProtectionPolicy> {};

template <>
struct hash<::blink::mojom::LargeBlobSupport>
    : public mojo::internal::EnumHashImpl<::blink::mojom::LargeBlobSupport> {};

template <>
struct hash<::blink::mojom::AttestationConveyancePreference>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AttestationConveyancePreference> {};

template <>
struct hash<::blink::mojom::PublicKeyCredentialType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PublicKeyCredentialType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticatorStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AuthenticatorStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AuthenticatorStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticatorTransport, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AuthenticatorTransport, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AuthenticatorTransport>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Hint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Hint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Hint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UserVerificationRequirement, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::UserVerificationRequirement, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::UserVerificationRequirement>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::Mediation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::Mediation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::Mediation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResidentKeyRequirement, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ResidentKeyRequirement, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ResidentKeyRequirement>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticatorAttachment, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AuthenticatorAttachment, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AuthenticatorAttachment>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ProtectionPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ProtectionPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ProtectionPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LargeBlobSupport, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::LargeBlobSupport, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::LargeBlobSupport>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AttestationConveyancePreference, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AttestationConveyancePreference, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AttestationConveyancePreference>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PublicKeyCredentialType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PublicKeyCredentialType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CommonCredentialInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CommonCredentialInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CommonCredentialInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in CommonCredentialInfo struct");

    decltype(Traits::raw_id(input)) in_raw_id = Traits::raw_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_id)::BaseType>
        raw_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& raw_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_raw_id,
      raw_id_fragment,
      &raw_id_validate_params);

    fragment->raw_id.Set(
        raw_id_fragment.is_null() ? nullptr : raw_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_id in CommonCredentialInfo struct");

    decltype(Traits::client_data_json(input)) in_client_data_json = Traits::client_data_json(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_data_json)::BaseType>
        client_data_json_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_data_json_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_client_data_json,
      client_data_json_fragment,
      &client_data_json_validate_params);

    fragment->client_data_json.Set(
        client_data_json_fragment.is_null() ? nullptr : client_data_json_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_data_json.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_data_json in CommonCredentialInfo struct");

    decltype(Traits::authenticator_data(input)) in_authenticator_data = Traits::authenticator_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->authenticator_data)::BaseType>
        authenticator_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& authenticator_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_authenticator_data,
      authenticator_data_fragment,
      &authenticator_data_validate_params);

    fragment->authenticator_data.Set(
        authenticator_data_fragment.is_null() ? nullptr : authenticator_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->authenticator_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null authenticator_data in CommonCredentialInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::CommonCredentialInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CommonCredentialInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SupplementalPubKeysResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SupplementalPubKeysResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SupplementalPubKeysResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::signatures(input)) in_signatures = Traits::signatures(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signatures)::BaseType>
        signatures_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signatures_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_signatures,
      signatures_fragment,
      &signatures_validate_params);

    fragment->signatures.Set(
        signatures_fragment.is_null() ? nullptr : signatures_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signatures.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signatures in SupplementalPubKeysResponse struct");
  }

  static bool Deserialize(::blink::mojom::internal::SupplementalPubKeysResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SupplementalPubKeysResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuthenticationExtensionsPaymentResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::browser_bound_signature(input)) in_browser_bound_signature = Traits::browser_bound_signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browser_bound_signature)::BaseType>
        browser_bound_signature_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& browser_bound_signature_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_browser_bound_signature,
      browser_bound_signature_fragment,
      &browser_bound_signature_validate_params);

    fragment->browser_bound_signature.Set(
        browser_bound_signature_fragment.is_null() ? nullptr : browser_bound_signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->browser_bound_signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null browser_bound_signature in AuthenticationExtensionsPaymentResponse struct");
  }

  static bool Deserialize(::blink::mojom::internal::AuthenticationExtensionsPaymentResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuthenticationExtensionsPaymentResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MakeCredentialAuthenticatorResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MakeCredentialAuthenticatorResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MakeCredentialAuthenticatorResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::info(input)) in_info = Traits::info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->info)::BaseType> info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CommonCredentialInfoDataView>(
      in_info,
      info_fragment);

    fragment->info.Set(
        info_fragment.is_null() ? nullptr : info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MakeCredentialAuthenticatorResponse struct");

    
    mojo::internal::Serialize<::blink::mojom::AuthenticatorAttachment>(
      Traits::authenticator_attachment(input),
      &fragment->authenticator_attachment);

    decltype(Traits::attestation_object(input)) in_attestation_object = Traits::attestation_object(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attestation_object)::BaseType>
        attestation_object_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attestation_object_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_attestation_object,
      attestation_object_fragment,
      &attestation_object_validate_params);

    fragment->attestation_object.Set(
        attestation_object_fragment.is_null() ? nullptr : attestation_object_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attestation_object.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attestation_object in MakeCredentialAuthenticatorResponse struct");

    decltype(Traits::transports(input)) in_transports = Traits::transports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transports)::BaseType>
        transports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transports_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuthenticatorTransport_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AuthenticatorTransport>>(
      in_transports,
      transports_fragment,
      &transports_validate_params);

    fragment->transports.Set(
        transports_fragment.is_null() ? nullptr : transports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transports in MakeCredentialAuthenticatorResponse struct");

    fragment->echo_hmac_create_secret = Traits::echo_hmac_create_secret(input);

    fragment->hmac_create_secret = Traits::hmac_create_secret(input);

    fragment->echo_prf = Traits::echo_prf(input);

    fragment->prf = Traits::prf(input);

    decltype(Traits::prf_results(input)) in_prf_results = Traits::prf_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_results)::BaseType> prf_results_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PRFValuesDataView>(
      in_prf_results,
      prf_results_fragment);

    fragment->prf_results.Set(
        prf_results_fragment.is_null() ? nullptr : prf_results_fragment.data());

    fragment->echo_cred_blob = Traits::echo_cred_blob(input);

    fragment->cred_blob = Traits::cred_blob(input);

    decltype(Traits::public_key_der(input)) in_public_key_der = Traits::public_key_der(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key_der)::BaseType>
        public_key_der_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& public_key_der_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_public_key_der,
      public_key_der_fragment,
      &public_key_der_validate_params);

    fragment->public_key_der.Set(
        public_key_der_fragment.is_null() ? nullptr : public_key_der_fragment.data());

    fragment->public_key_algo = Traits::public_key_algo(input);

    fragment->echo_cred_props = Traits::echo_cred_props(input);

    fragment->has_cred_props_rk = Traits::has_cred_props_rk(input);

    fragment->cred_props_rk = Traits::cred_props_rk(input);

    fragment->echo_large_blob = Traits::echo_large_blob(input);

    fragment->supports_large_blob = Traits::supports_large_blob(input);

    decltype(Traits::supplemental_pub_keys(input)) in_supplemental_pub_keys = Traits::supplemental_pub_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supplemental_pub_keys)::BaseType> supplemental_pub_keys_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SupplementalPubKeysResponseDataView>(
      in_supplemental_pub_keys,
      supplemental_pub_keys_fragment);

    fragment->supplemental_pub_keys.Set(
        supplemental_pub_keys_fragment.is_null() ? nullptr : supplemental_pub_keys_fragment.data());

    decltype(Traits::payment(input)) in_payment = Traits::payment(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment)::BaseType> payment_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView>(
      in_payment,
      payment_fragment);

    fragment->payment.Set(
        payment_fragment.is_null() ? nullptr : payment_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::MakeCredentialAuthenticatorResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MakeCredentialAuthenticatorResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetAssertionAuthenticatorResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetAssertionAuthenticatorResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GetAssertionAuthenticatorResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::info(input)) in_info = Traits::info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->info)::BaseType> info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CommonCredentialInfoDataView>(
      in_info,
      info_fragment);

    fragment->info.Set(
        info_fragment.is_null() ? nullptr : info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in GetAssertionAuthenticatorResponse struct");

    
    mojo::internal::Serialize<::blink::mojom::AuthenticatorAttachment>(
      Traits::authenticator_attachment(input),
      &fragment->authenticator_attachment);

    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType>
        signature_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_signature,
      signature_fragment,
      &signature_validate_params);

    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in GetAssertionAuthenticatorResponse struct");

    decltype(Traits::user_handle(input)) in_user_handle = Traits::user_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_handle)::BaseType>
        user_handle_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_handle_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_handle,
      user_handle_fragment,
      &user_handle_validate_params);

    fragment->user_handle.Set(
        user_handle_fragment.is_null() ? nullptr : user_handle_fragment.data());

    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType> extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsClientOutputsDataView>(
      in_extensions,
      extensions_fragment);

    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extensions in GetAssertionAuthenticatorResponse struct");
  }

  static bool Deserialize(::blink::mojom::internal::GetAssertionAuthenticatorResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetAssertionAuthenticatorResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticationExtensionsClientOutputsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuthenticationExtensionsClientOutputsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuthenticationExtensionsClientOutputs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->echo_appid_extension = Traits::echo_appid_extension(input);

    fragment->appid_extension = Traits::appid_extension(input);

    fragment->echo_prf = Traits::echo_prf(input);

    decltype(Traits::prf_results(input)) in_prf_results = Traits::prf_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_results)::BaseType> prf_results_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PRFValuesDataView>(
      in_prf_results,
      prf_results_fragment);

    fragment->prf_results.Set(
        prf_results_fragment.is_null() ? nullptr : prf_results_fragment.data());

    fragment->prf_not_evaluated = Traits::prf_not_evaluated(input);

    fragment->echo_large_blob = Traits::echo_large_blob(input);

    decltype(Traits::large_blob(input)) in_large_blob = Traits::large_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->large_blob)::BaseType>
        large_blob_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& large_blob_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_large_blob,
      large_blob_fragment,
      &large_blob_validate_params);

    fragment->large_blob.Set(
        large_blob_fragment.is_null() ? nullptr : large_blob_fragment.data());

    fragment->echo_large_blob_written = Traits::echo_large_blob_written(input);

    fragment->large_blob_written = Traits::large_blob_written(input);

    decltype(Traits::get_cred_blob(input)) in_get_cred_blob = Traits::get_cred_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->get_cred_blob)::BaseType>
        get_cred_blob_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& get_cred_blob_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_get_cred_blob,
      get_cred_blob_fragment,
      &get_cred_blob_validate_params);

    fragment->get_cred_blob.Set(
        get_cred_blob_fragment.is_null() ? nullptr : get_cred_blob_fragment.data());

    decltype(Traits::supplemental_pub_keys(input)) in_supplemental_pub_keys = Traits::supplemental_pub_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supplemental_pub_keys)::BaseType> supplemental_pub_keys_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SupplementalPubKeysResponseDataView>(
      in_supplemental_pub_keys,
      supplemental_pub_keys_fragment);

    fragment->supplemental_pub_keys.Set(
        supplemental_pub_keys_fragment.is_null() ? nullptr : supplemental_pub_keys_fragment.data());

    decltype(Traits::payment(input)) in_payment = Traits::payment(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment)::BaseType> payment_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsPaymentResponseDataView>(
      in_payment,
      payment_fragment);

    fragment->payment.Set(
        payment_fragment.is_null() ? nullptr : payment_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AuthenticationExtensionsClientOutputs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuthenticationExtensionsClientOutputsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialRpEntityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialRpEntityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialRpEntity_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PublicKeyCredentialRpEntity struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PublicKeyCredentialRpEntity struct");
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialRpEntity_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialRpEntityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialUserEntityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialUserEntityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialUserEntity_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType>
        id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_id,
      id_fragment,
      &id_validate_params);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PublicKeyCredentialUserEntity struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in PublicKeyCredentialUserEntity struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in PublicKeyCredentialUserEntity struct");
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialUserEntity_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialUserEntityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialType>(
      Traits::type(input),
      &fragment->type);

    fragment->algorithm_identifier = Traits::algorithm_identifier(input);
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CableAuthenticationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CableAuthenticationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CableAuthentication_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->version = Traits::version(input);

    decltype(Traits::client_eid(input)) in_client_eid = Traits::client_eid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_eid)::BaseType>
        client_eid_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_eid_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_client_eid,
      client_eid_fragment,
      &client_eid_validate_params);

    fragment->client_eid.Set(
        client_eid_fragment.is_null() ? nullptr : client_eid_fragment.data());

    decltype(Traits::authenticator_eid(input)) in_authenticator_eid = Traits::authenticator_eid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->authenticator_eid)::BaseType>
        authenticator_eid_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& authenticator_eid_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_authenticator_eid,
      authenticator_eid_fragment,
      &authenticator_eid_validate_params);

    fragment->authenticator_eid.Set(
        authenticator_eid_fragment.is_null() ? nullptr : authenticator_eid_fragment.data());

    decltype(Traits::session_pre_key(input)) in_session_pre_key = Traits::session_pre_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_pre_key)::BaseType>
        session_pre_key_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& session_pre_key_validate_params =
        mojo::internal::GetArrayValidator<32, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_session_pre_key,
      session_pre_key_fragment,
      &session_pre_key_validate_params);

    fragment->session_pre_key.Set(
        session_pre_key_fragment.is_null() ? nullptr : session_pre_key_fragment.data());

    decltype(Traits::server_link_data(input)) in_server_link_data = Traits::server_link_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_link_data)::BaseType>
        server_link_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& server_link_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_server_link_data,
      server_link_data_fragment,
      &server_link_data_validate_params);

    fragment->server_link_data.Set(
        server_link_data_fragment.is_null() ? nullptr : server_link_data_fragment.data());

    decltype(Traits::experiments(input)) in_experiments = Traits::experiments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->experiments)::BaseType>
        experiments_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& experiments_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_experiments,
      experiments_fragment,
      &experiments_validate_params);

    fragment->experiments.Set(
        experiments_fragment.is_null() ? nullptr : experiments_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::CableAuthentication_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CableAuthenticationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PRFValuesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PRFValuesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PRFValues_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType>
        id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_id,
      id_fragment,
      &id_validate_params);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    decltype(Traits::first(input)) in_first = Traits::first(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->first)::BaseType>
        first_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& first_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_first,
      first_fragment,
      &first_validate_params);

    fragment->first.Set(
        first_fragment.is_null() ? nullptr : first_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->first.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null first in PRFValues struct");

    decltype(Traits::second(input)) in_second = Traits::second(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->second)::BaseType>
        second_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& second_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_second,
      second_fragment,
      &second_validate_params);

    fragment->second.Set(
        second_fragment.is_null() ? nullptr : second_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PRFValues_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PRFValuesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PaymentOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PaymentOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PaymentOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::total(input)) in_total = Traits::total(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total)::BaseType> total_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
      in_total,
      total_fragment);

    fragment->total.Set(
        total_fragment.is_null() ? nullptr : total_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->total.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null total in PaymentOptions struct");

    decltype(Traits::instrument(input)) in_instrument = Traits::instrument(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instrument)::BaseType> instrument_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PaymentCredentialInstrumentDataView>(
      in_instrument,
      instrument_fragment);

    fragment->instrument.Set(
        instrument_fragment.is_null() ? nullptr : instrument_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instrument.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instrument in PaymentOptions struct");

    decltype(Traits::payee_name(input)) in_payee_name = Traits::payee_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payee_name)::BaseType> payee_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_payee_name,
      payee_name_fragment);

    fragment->payee_name.Set(
        payee_name_fragment.is_null() ? nullptr : payee_name_fragment.data());

    decltype(Traits::payee_origin(input)) in_payee_origin = Traits::payee_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payee_origin)::BaseType> payee_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_payee_origin,
      payee_origin_fragment);

    fragment->payee_origin.Set(
        payee_origin_fragment.is_null() ? nullptr : payee_origin_fragment.data());

    decltype(Traits::payment_entities_logos(input)) in_payment_entities_logos = Traits::payment_entities_logos(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_entities_logos)::BaseType>
        payment_entities_logos_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& payment_entities_logos_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ShownPaymentEntityLogoDataView>>(
      in_payment_entities_logos,
      payment_entities_logos_fragment,
      &payment_entities_logos_validate_params);

    fragment->payment_entities_logos.Set(
        payment_entities_logos_fragment.is_null() ? nullptr : payment_entities_logos_fragment.data());

    decltype(Traits::browser_bound_public_key(input)) in_browser_bound_public_key = Traits::browser_bound_public_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browser_bound_public_key)::BaseType>
        browser_bound_public_key_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& browser_bound_public_key_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_browser_bound_public_key,
      browser_bound_public_key_fragment,
      &browser_bound_public_key_validate_params);

    fragment->browser_bound_public_key.Set(
        browser_bound_public_key_fragment.is_null() ? nullptr : browser_bound_public_key_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PaymentOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PaymentOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PaymentCredentialInstrumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PaymentCredentialInstrumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PaymentCredentialInstrument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in PaymentCredentialInstrument struct");

    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_icon,
      icon_fragment);

    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon in PaymentCredentialInstrument struct");

    fragment->iconMustBeShown = Traits::iconMustBeShown(input);

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType> details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_details,
      details_fragment);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PaymentCredentialInstrument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PaymentCredentialInstrumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ShownPaymentEntityLogoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ShownPaymentEntityLogoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ShownPaymentEntityLogo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ShownPaymentEntityLogo struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in ShownPaymentEntityLogo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ShownPaymentEntityLogo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ShownPaymentEntityLogoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RemoteDesktopClientOverrideDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RemoteDesktopClientOverrideDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RemoteDesktopClientOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in RemoteDesktopClientOverride struct");

    fragment->same_origin_with_ancestors = Traits::same_origin_with_ancestors(input);
  }

  static bool Deserialize(::blink::mojom::internal::RemoteDesktopClientOverride_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RemoteDesktopClientOverrideDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SupplementalPubKeysRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SupplementalPubKeysRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SupplementalPubKeysRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->device_scope_requested = Traits::device_scope_requested(input);

    fragment->provider_scope_requested = Traits::provider_scope_requested(input);

    
    mojo::internal::Serialize<::blink::mojom::AttestationConveyancePreference>(
      Traits::attestation(input),
      &fragment->attestation);

    decltype(Traits::attestation_formats(input)) in_attestation_formats = Traits::attestation_formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attestation_formats)::BaseType>
        attestation_formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attestation_formats_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_attestation_formats,
      attestation_formats_fragment,
      &attestation_formats_validate_params);

    fragment->attestation_formats.Set(
        attestation_formats_fragment.is_null() ? nullptr : attestation_formats_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attestation_formats.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attestation_formats in SupplementalPubKeysRequest struct");
  }

  static bool Deserialize(::blink::mojom::internal::SupplementalPubKeysRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SupplementalPubKeysRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialRequestOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialRequestOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialRequestOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::challenge(input)) in_challenge = Traits::challenge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenge)::BaseType>
        challenge_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_challenge,
      challenge_fragment,
      &challenge_validate_params);

    fragment->challenge.Set(
        challenge_fragment.is_null() ? nullptr : challenge_fragment.data());

    decltype(Traits::challenge_url(input)) in_challenge_url = Traits::challenge_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenge_url)::BaseType> challenge_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_challenge_url,
      challenge_url_fragment);

    fragment->challenge_url.Set(
        challenge_url_fragment.is_null() ? nullptr : challenge_url_fragment.data());

    decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout)::BaseType> timeout_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout,
      timeout_fragment);

    fragment->timeout.Set(
        timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

    decltype(Traits::relying_party_id(input)) in_relying_party_id = Traits::relying_party_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relying_party_id)::BaseType> relying_party_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_relying_party_id,
      relying_party_id_fragment);

    fragment->relying_party_id.Set(
        relying_party_id_fragment.is_null() ? nullptr : relying_party_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relying_party_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relying_party_id in PublicKeyCredentialRequestOptions struct");

    decltype(Traits::allow_credentials(input)) in_allow_credentials = Traits::allow_credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allow_credentials)::BaseType>
        allow_credentials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allow_credentials_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialDescriptorDataView>>(
      in_allow_credentials,
      allow_credentials_fragment,
      &allow_credentials_validate_params);

    fragment->allow_credentials.Set(
        allow_credentials_fragment.is_null() ? nullptr : allow_credentials_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allow_credentials.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allow_credentials in PublicKeyCredentialRequestOptions struct");

    decltype(Traits::hints(input)) in_hints = Traits::hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hints)::BaseType>
        hints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hints_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::Hint_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::Hint>>(
      in_hints,
      hints_fragment,
      &hints_validate_params);

    fragment->hints.Set(
        hints_fragment.is_null() ? nullptr : hints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hints in PublicKeyCredentialRequestOptions struct");

    
    mojo::internal::Serialize<::blink::mojom::UserVerificationRequirement>(
      Traits::user_verification(input),
      &fragment->user_verification);

    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType> extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AuthenticationExtensionsClientInputsDataView>(
      in_extensions,
      extensions_fragment);

    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extensions in PublicKeyCredentialRequestOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialRequestOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialRequestOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticationExtensionsClientInputsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuthenticationExtensionsClientInputsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuthenticationExtensionsClientInputs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::appid(input)) in_appid = Traits::appid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->appid)::BaseType> appid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_appid,
      appid_fragment);

    fragment->appid.Set(
        appid_fragment.is_null() ? nullptr : appid_fragment.data());

    decltype(Traits::cable_authentication_data(input)) in_cable_authentication_data = Traits::cable_authentication_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cable_authentication_data)::BaseType>
        cable_authentication_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cable_authentication_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CableAuthenticationDataView>>(
      in_cable_authentication_data,
      cable_authentication_data_fragment,
      &cable_authentication_data_validate_params);

    fragment->cable_authentication_data.Set(
        cable_authentication_data_fragment.is_null() ? nullptr : cable_authentication_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cable_authentication_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cable_authentication_data in AuthenticationExtensionsClientInputs struct");

    fragment->prf = Traits::prf(input);

    decltype(Traits::prf_inputs(input)) in_prf_inputs = Traits::prf_inputs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_inputs)::BaseType>
        prf_inputs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& prf_inputs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PRFValuesDataView>>(
      in_prf_inputs,
      prf_inputs_fragment,
      &prf_inputs_validate_params);

    fragment->prf_inputs.Set(
        prf_inputs_fragment.is_null() ? nullptr : prf_inputs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prf_inputs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prf_inputs in AuthenticationExtensionsClientInputs struct");

    fragment->large_blob_read = Traits::large_blob_read(input);

    decltype(Traits::large_blob_write(input)) in_large_blob_write = Traits::large_blob_write(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->large_blob_write)::BaseType>
        large_blob_write_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& large_blob_write_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_large_blob_write,
      large_blob_write_fragment,
      &large_blob_write_validate_params);

    fragment->large_blob_write.Set(
        large_blob_write_fragment.is_null() ? nullptr : large_blob_write_fragment.data());

    fragment->get_cred_blob = Traits::get_cred_blob(input);

    decltype(Traits::remote_desktop_client_override(input)) in_remote_desktop_client_override = Traits::remote_desktop_client_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_desktop_client_override)::BaseType> remote_desktop_client_override_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::RemoteDesktopClientOverrideDataView>(
      in_remote_desktop_client_override,
      remote_desktop_client_override_fragment);

    fragment->remote_desktop_client_override.Set(
        remote_desktop_client_override_fragment.is_null() ? nullptr : remote_desktop_client_override_fragment.data());

    decltype(Traits::supplemental_pub_keys(input)) in_supplemental_pub_keys = Traits::supplemental_pub_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supplemental_pub_keys)::BaseType> supplemental_pub_keys_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SupplementalPubKeysRequestDataView>(
      in_supplemental_pub_keys,
      supplemental_pub_keys_fragment);

    fragment->supplemental_pub_keys.Set(
        supplemental_pub_keys_fragment.is_null() ? nullptr : supplemental_pub_keys_fragment.data());

    decltype(Traits::payment_browser_bound_key_parameters(input)) in_payment_browser_bound_key_parameters = Traits::payment_browser_bound_key_parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_browser_bound_key_parameters)::BaseType>
        payment_browser_bound_key_parameters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& payment_browser_bound_key_parameters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
      in_payment_browser_bound_key_parameters,
      payment_browser_bound_key_parameters_fragment,
      &payment_browser_bound_key_parameters_validate_params);

    fragment->payment_browser_bound_key_parameters.Set(
        payment_browser_bound_key_parameters_fragment.is_null() ? nullptr : payment_browser_bound_key_parameters_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AuthenticationExtensionsClientInputs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuthenticationExtensionsClientInputsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetCredentialOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetCredentialOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GetCredentialOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::Mediation>(
      Traits::mediation(input),
      &fragment->mediation);

    decltype(Traits::public_key(input)) in_public_key = Traits::public_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key)::BaseType> public_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialRequestOptionsDataView>(
      in_public_key,
      public_key_fragment);

    fragment->public_key.Set(
        public_key_fragment.is_null() ? nullptr : public_key_fragment.data());

    fragment->password = Traits::password(input);
  }

  static bool Deserialize(::blink::mojom::internal::GetCredentialOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetCredentialOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AuthenticatorSelectionCriteriaDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AuthenticatorSelectionCriteriaDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AuthenticatorSelectionCriteria_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::AuthenticatorAttachment>(
      Traits::authenticator_attachment(input),
      &fragment->authenticator_attachment);

    
    mojo::internal::Serialize<::blink::mojom::ResidentKeyRequirement>(
      Traits::resident_key(input),
      &fragment->resident_key);

    
    mojo::internal::Serialize<::blink::mojom::UserVerificationRequirement>(
      Traits::user_verification(input),
      &fragment->user_verification);
  }

  static bool Deserialize(::blink::mojom::internal::AuthenticatorSelectionCriteria_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AuthenticatorSelectionCriteriaDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialCreationOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialCreationOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialCreationOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::relying_party(input)) in_relying_party = Traits::relying_party(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relying_party)::BaseType> relying_party_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialRpEntityDataView>(
      in_relying_party,
      relying_party_fragment);

    fragment->relying_party.Set(
        relying_party_fragment.is_null() ? nullptr : relying_party_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relying_party.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relying_party in PublicKeyCredentialCreationOptions struct");

    decltype(Traits::user(input)) in_user = Traits::user(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user)::BaseType> user_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialUserEntityDataView>(
      in_user,
      user_fragment);

    fragment->user.Set(
        user_fragment.is_null() ? nullptr : user_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user in PublicKeyCredentialCreationOptions struct");

    decltype(Traits::challenge(input)) in_challenge = Traits::challenge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenge)::BaseType>
        challenge_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& challenge_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_challenge,
      challenge_fragment,
      &challenge_validate_params);

    fragment->challenge.Set(
        challenge_fragment.is_null() ? nullptr : challenge_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->challenge.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null challenge in PublicKeyCredentialCreationOptions struct");

    decltype(Traits::public_key_parameters(input)) in_public_key_parameters = Traits::public_key_parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_key_parameters)::BaseType>
        public_key_parameters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& public_key_parameters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
      in_public_key_parameters,
      public_key_parameters_fragment,
      &public_key_parameters_validate_params);

    fragment->public_key_parameters.Set(
        public_key_parameters_fragment.is_null() ? nullptr : public_key_parameters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->public_key_parameters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null public_key_parameters in PublicKeyCredentialCreationOptions struct");

    decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout)::BaseType> timeout_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout,
      timeout_fragment);

    fragment->timeout.Set(
        timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

    decltype(Traits::exclude_credentials(input)) in_exclude_credentials = Traits::exclude_credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclude_credentials)::BaseType>
        exclude_credentials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& exclude_credentials_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialDescriptorDataView>>(
      in_exclude_credentials,
      exclude_credentials_fragment,
      &exclude_credentials_validate_params);

    fragment->exclude_credentials.Set(
        exclude_credentials_fragment.is_null() ? nullptr : exclude_credentials_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->exclude_credentials.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null exclude_credentials in PublicKeyCredentialCreationOptions struct");

    decltype(Traits::authenticator_selection(input)) in_authenticator_selection = Traits::authenticator_selection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->authenticator_selection)::BaseType> authenticator_selection_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AuthenticatorSelectionCriteriaDataView>(
      in_authenticator_selection,
      authenticator_selection_fragment);

    fragment->authenticator_selection.Set(
        authenticator_selection_fragment.is_null() ? nullptr : authenticator_selection_fragment.data());

    decltype(Traits::hints(input)) in_hints = Traits::hints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hints)::BaseType>
        hints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hints_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::Hint_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::Hint>>(
      in_hints,
      hints_fragment,
      &hints_validate_params);

    fragment->hints.Set(
        hints_fragment.is_null() ? nullptr : hints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hints in PublicKeyCredentialCreationOptions struct");

    
    mojo::internal::Serialize<::blink::mojom::AttestationConveyancePreference>(
      Traits::attestation(input),
      &fragment->attestation);

    fragment->hmac_create_secret = Traits::hmac_create_secret(input);

    fragment->prf_enable = Traits::prf_enable(input);

    decltype(Traits::prf_input(input)) in_prf_input = Traits::prf_input(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prf_input)::BaseType> prf_input_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PRFValuesDataView>(
      in_prf_input,
      prf_input_fragment);

    fragment->prf_input.Set(
        prf_input_fragment.is_null() ? nullptr : prf_input_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::ProtectionPolicy>(
      Traits::protection_policy(input),
      &fragment->protection_policy);

    fragment->enforce_protection_policy = Traits::enforce_protection_policy(input);

    decltype(Traits::appid_exclude(input)) in_appid_exclude = Traits::appid_exclude(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->appid_exclude)::BaseType> appid_exclude_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_appid_exclude,
      appid_exclude_fragment);

    fragment->appid_exclude.Set(
        appid_exclude_fragment.is_null() ? nullptr : appid_exclude_fragment.data());

    fragment->cred_props = Traits::cred_props(input);

    
    mojo::internal::Serialize<::blink::mojom::LargeBlobSupport>(
      Traits::large_blob_enable(input),
      &fragment->large_blob_enable);

    fragment->is_payment_credential_creation = Traits::is_payment_credential_creation(input);

    decltype(Traits::cred_blob(input)) in_cred_blob = Traits::cred_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cred_blob)::BaseType>
        cred_blob_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cred_blob_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_cred_blob,
      cred_blob_fragment,
      &cred_blob_validate_params);

    fragment->cred_blob.Set(
        cred_blob_fragment.is_null() ? nullptr : cred_blob_fragment.data());

    fragment->min_pin_length_requested = Traits::min_pin_length_requested(input);

    decltype(Traits::remote_desktop_client_override(input)) in_remote_desktop_client_override = Traits::remote_desktop_client_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_desktop_client_override)::BaseType> remote_desktop_client_override_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::RemoteDesktopClientOverrideDataView>(
      in_remote_desktop_client_override,
      remote_desktop_client_override_fragment);

    fragment->remote_desktop_client_override.Set(
        remote_desktop_client_override_fragment.is_null() ? nullptr : remote_desktop_client_override_fragment.data());

    decltype(Traits::supplemental_pub_keys(input)) in_supplemental_pub_keys = Traits::supplemental_pub_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supplemental_pub_keys)::BaseType> supplemental_pub_keys_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SupplementalPubKeysRequestDataView>(
      in_supplemental_pub_keys,
      supplemental_pub_keys_fragment);

    fragment->supplemental_pub_keys.Set(
        supplemental_pub_keys_fragment.is_null() ? nullptr : supplemental_pub_keys_fragment.data());

    decltype(Traits::payment_browser_bound_key_parameters(input)) in_payment_browser_bound_key_parameters = Traits::payment_browser_bound_key_parameters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payment_browser_bound_key_parameters)::BaseType>
        payment_browser_bound_key_parameters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& payment_browser_bound_key_parameters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PublicKeyCredentialParametersDataView>>(
      in_payment_browser_bound_key_parameters,
      payment_browser_bound_key_parameters_fragment,
      &payment_browser_bound_key_parameters_validate_params);

    fragment->payment_browser_bound_key_parameters.Set(
        payment_browser_bound_key_parameters_fragment.is_null() ? nullptr : payment_browser_bound_key_parameters_fragment.data());

    decltype(Traits::attestation_formats(input)) in_attestation_formats = Traits::attestation_formats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attestation_formats)::BaseType>
        attestation_formats_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attestation_formats_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_attestation_formats,
      attestation_formats_fragment,
      &attestation_formats_validate_params);

    fragment->attestation_formats.Set(
        attestation_formats_fragment.is_null() ? nullptr : attestation_formats_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attestation_formats.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attestation_formats in PublicKeyCredentialCreationOptions struct");

    fragment->is_conditional = Traits::is_conditional(input);
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialCreationOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialCreationOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialDescriptorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialDescriptorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType>
        id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_id,
      id_fragment,
      &id_validate_params);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PublicKeyCredentialDescriptor struct");

    decltype(Traits::transports(input)) in_transports = Traits::transports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transports)::BaseType>
        transports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transports_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuthenticatorTransport_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AuthenticatorTransport>>(
      in_transports,
      transports_fragment,
      &transports_validate_params);

    fragment->transports.Set(
        transports_fragment.is_null() ? nullptr : transports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transports in PublicKeyCredentialDescriptor struct");
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialDescriptor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialDescriptorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebAuthnDOMExceptionDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebAuthnDOMExceptionDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebAuthnDOMExceptionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in WebAuthnDOMExceptionDetails struct");

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in WebAuthnDOMExceptionDetails struct");
  }

  static bool Deserialize(::blink::mojom::internal::WebAuthnDOMExceptionDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebAuthnDOMExceptionDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PublicKeyCredentialReportOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PublicKeyCredentialReportOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PublicKeyCredentialReportOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::relying_party_id(input)) in_relying_party_id = Traits::relying_party_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relying_party_id)::BaseType> relying_party_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_relying_party_id,
      relying_party_id_fragment);

    fragment->relying_party_id.Set(
        relying_party_id_fragment.is_null() ? nullptr : relying_party_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relying_party_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relying_party_id in PublicKeyCredentialReportOptions struct");

    decltype(Traits::unknown_credential_id(input)) in_unknown_credential_id = Traits::unknown_credential_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unknown_credential_id)::BaseType>
        unknown_credential_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& unknown_credential_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_unknown_credential_id,
      unknown_credential_id_fragment,
      &unknown_credential_id_validate_params);

    fragment->unknown_credential_id.Set(
        unknown_credential_id_fragment.is_null() ? nullptr : unknown_credential_id_fragment.data());

    decltype(Traits::all_accepted_credentials(input)) in_all_accepted_credentials = Traits::all_accepted_credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_accepted_credentials)::BaseType> all_accepted_credentials_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AllAcceptedCredentialsOptionsDataView>(
      in_all_accepted_credentials,
      all_accepted_credentials_fragment);

    fragment->all_accepted_credentials.Set(
        all_accepted_credentials_fragment.is_null() ? nullptr : all_accepted_credentials_fragment.data());

    decltype(Traits::current_user_details(input)) in_current_user_details = Traits::current_user_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_user_details)::BaseType> current_user_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CurrentUserDetailsOptionsDataView>(
      in_current_user_details,
      current_user_details_fragment);

    fragment->current_user_details.Set(
        current_user_details_fragment.is_null() ? nullptr : current_user_details_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::PublicKeyCredentialReportOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PublicKeyCredentialReportOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AllAcceptedCredentialsOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AllAcceptedCredentialsOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AllAcceptedCredentialsOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::user_id(input)) in_user_id = Traits::user_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_id)::BaseType>
        user_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_id,
      user_id_fragment,
      &user_id_validate_params);

    fragment->user_id.Set(
        user_id_fragment.is_null() ? nullptr : user_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_id in AllAcceptedCredentialsOptions struct");

    decltype(Traits::all_accepted_credentials_ids(input)) in_all_accepted_credentials_ids = Traits::all_accepted_credentials_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_accepted_credentials_ids)::BaseType>
        all_accepted_credentials_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_accepted_credentials_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_all_accepted_credentials_ids,
      all_accepted_credentials_ids_fragment,
      &all_accepted_credentials_ids_validate_params);

    fragment->all_accepted_credentials_ids.Set(
        all_accepted_credentials_ids_fragment.is_null() ? nullptr : all_accepted_credentials_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->all_accepted_credentials_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null all_accepted_credentials_ids in AllAcceptedCredentialsOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::AllAcceptedCredentialsOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AllAcceptedCredentialsOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CurrentUserDetailsOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CurrentUserDetailsOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CurrentUserDetailsOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::user_id(input)) in_user_id = Traits::user_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_id)::BaseType>
        user_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_user_id,
      user_id_fragment,
      &user_id_validate_params);

    fragment->user_id.Set(
        user_id_fragment.is_null() ? nullptr : user_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_id in CurrentUserDetailsOptions struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in CurrentUserDetailsOptions struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in CurrentUserDetailsOptions struct");
  }

  static bool Deserialize(::blink::mojom::internal::CurrentUserDetailsOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CurrentUserDetailsOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WebAuthnClientCapabilityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebAuthnClientCapabilityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebAuthnClientCapability_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in WebAuthnClientCapability struct");

    fragment->supported = Traits::supported(input);
  }

  static bool Deserialize(::blink::mojom::internal::WebAuthnClientCapability_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WebAuthnClientCapabilityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetAssertionResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetAssertionResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GetAssertionResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      Traits::status(input),
      &fragment->status);

    decltype(Traits::credential(input)) in_credential = Traits::credential(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credential)::BaseType> credential_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
      in_credential,
      credential_fragment);

    fragment->credential.Set(
        credential_fragment.is_null() ? nullptr : credential_fragment.data());

    decltype(Traits::dom_exception_details(input)) in_dom_exception_details = Traits::dom_exception_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dom_exception_details)::BaseType> dom_exception_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
      in_dom_exception_details,
      dom_exception_details_fragment);

    fragment->dom_exception_details.Set(
        dom_exception_details_fragment.is_null() ? nullptr : dom_exception_details_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::GetAssertionResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetAssertionResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetCredentialResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::GetCredentialResponseDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::GetCredentialResponse_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::GetCredentialResponseDataView::Tag::kGetAssertionResponse: {
    decltype(Traits::get_assertion_response(input))
    in_get_assertion_response = Traits::get_assertion_response(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_get_assertion_response)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::GetAssertionResponseDataView>(
  in_get_assertion_response,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null get_assertion_response in GetCredentialResponse union");
    fragment->data.f_get_assertion_response.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::GetCredentialResponseDataView::Tag::kPasswordResponse: {
    decltype(Traits::password_response(input))
    in_password_response = Traits::password_response(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_password_response)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::CredentialInfoDataView>(
  in_password_response,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null password_response in GetCredentialResponse union");
    fragment->data.f_password_response.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::GetCredentialResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetCredentialResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void CommonCredentialInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CommonCredentialInfoDataView::GetRawIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->raw_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CommonCredentialInfoDataView::GetClientDataJsonDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->client_data_json.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CommonCredentialInfoDataView::GetAuthenticatorDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->authenticator_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void SupplementalPubKeysResponseDataView::GetSignaturesDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->signatures.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void AuthenticationExtensionsPaymentResponseDataView::GetBrowserBoundSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->browser_bound_signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void MakeCredentialAuthenticatorResponseDataView::GetInfoDataView(
    CommonCredentialInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = CommonCredentialInfoDataView(pointer, message_);
}
inline void MakeCredentialAuthenticatorResponseDataView::GetAttestationObjectDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->attestation_object.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void MakeCredentialAuthenticatorResponseDataView::GetTransportsDataView(
    mojo::ArrayDataView<AuthenticatorTransport>* output) {
  auto pointer = data_->transports.Get();
  *output = mojo::ArrayDataView<AuthenticatorTransport>(pointer, message_);
}
inline void MakeCredentialAuthenticatorResponseDataView::GetPrfResultsDataView(
    PRFValuesDataView* output) {
  auto pointer = data_->prf_results.Get();
  *output = PRFValuesDataView(pointer, message_);
}
inline void MakeCredentialAuthenticatorResponseDataView::GetPublicKeyDerDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->public_key_der.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void MakeCredentialAuthenticatorResponseDataView::GetSupplementalPubKeysDataView(
    SupplementalPubKeysResponseDataView* output) {
  auto pointer = data_->supplemental_pub_keys.Get();
  *output = SupplementalPubKeysResponseDataView(pointer, message_);
}
inline void MakeCredentialAuthenticatorResponseDataView::GetPaymentDataView(
    AuthenticationExtensionsPaymentResponseDataView* output) {
  auto pointer = data_->payment.Get();
  *output = AuthenticationExtensionsPaymentResponseDataView(pointer, message_);
}


inline void GetAssertionAuthenticatorResponseDataView::GetInfoDataView(
    CommonCredentialInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = CommonCredentialInfoDataView(pointer, message_);
}
inline void GetAssertionAuthenticatorResponseDataView::GetSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void GetAssertionAuthenticatorResponseDataView::GetUserHandleDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_handle.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void GetAssertionAuthenticatorResponseDataView::GetExtensionsDataView(
    AuthenticationExtensionsClientOutputsDataView* output) {
  auto pointer = data_->extensions.Get();
  *output = AuthenticationExtensionsClientOutputsDataView(pointer, message_);
}


inline void AuthenticationExtensionsClientOutputsDataView::GetPrfResultsDataView(
    PRFValuesDataView* output) {
  auto pointer = data_->prf_results.Get();
  *output = PRFValuesDataView(pointer, message_);
}
inline void AuthenticationExtensionsClientOutputsDataView::GetLargeBlobDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->large_blob.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticationExtensionsClientOutputsDataView::GetGetCredBlobDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->get_cred_blob.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticationExtensionsClientOutputsDataView::GetSupplementalPubKeysDataView(
    SupplementalPubKeysResponseDataView* output) {
  auto pointer = data_->supplemental_pub_keys.Get();
  *output = SupplementalPubKeysResponseDataView(pointer, message_);
}
inline void AuthenticationExtensionsClientOutputsDataView::GetPaymentDataView(
    AuthenticationExtensionsPaymentResponseDataView* output) {
  auto pointer = data_->payment.Get();
  *output = AuthenticationExtensionsPaymentResponseDataView(pointer, message_);
}


inline void PublicKeyCredentialRpEntityDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PublicKeyCredentialRpEntityDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PublicKeyCredentialUserEntityDataView::GetIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialUserEntityDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PublicKeyCredentialUserEntityDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void CableAuthenticationDataView::GetClientEidDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->client_eid.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CableAuthenticationDataView::GetAuthenticatorEidDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->authenticator_eid.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CableAuthenticationDataView::GetSessionPreKeyDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->session_pre_key.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CableAuthenticationDataView::GetServerLinkDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->server_link_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CableAuthenticationDataView::GetExperimentsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->experiments.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void PRFValuesDataView::GetIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PRFValuesDataView::GetFirstDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->first.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PRFValuesDataView::GetSecondDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->second.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void PaymentOptionsDataView::GetTotalDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->total.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}
inline void PaymentOptionsDataView::GetInstrumentDataView(
    PaymentCredentialInstrumentDataView* output) {
  auto pointer = data_->instrument.Get();
  *output = PaymentCredentialInstrumentDataView(pointer, message_);
}
inline void PaymentOptionsDataView::GetPayeeNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->payee_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentOptionsDataView::GetPayeeOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->payee_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void PaymentOptionsDataView::GetPaymentEntitiesLogosDataView(
    mojo::ArrayDataView<ShownPaymentEntityLogoDataView>* output) {
  auto pointer = data_->payment_entities_logos.Get();
  *output = mojo::ArrayDataView<ShownPaymentEntityLogoDataView>(pointer, message_);
}
inline void PaymentOptionsDataView::GetBrowserBoundPublicKeyDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->browser_bound_public_key.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void PaymentCredentialInstrumentDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaymentCredentialInstrumentDataView::GetIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PaymentCredentialInstrumentDataView::GetDetailsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->details.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ShownPaymentEntityLogoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ShownPaymentEntityLogoDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RemoteDesktopClientOverrideDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}


inline void SupplementalPubKeysRequestDataView::GetAttestationFormatsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->attestation_formats.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void PublicKeyCredentialRequestOptionsDataView::GetChallengeDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->challenge.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialRequestOptionsDataView::GetChallengeUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->challenge_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PublicKeyCredentialRequestOptionsDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void PublicKeyCredentialRequestOptionsDataView::GetRelyingPartyIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->relying_party_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PublicKeyCredentialRequestOptionsDataView::GetAllowCredentialsDataView(
    mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>* output) {
  auto pointer = data_->allow_credentials.Get();
  *output = mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>(pointer, message_);
}
inline void PublicKeyCredentialRequestOptionsDataView::GetHintsDataView(
    mojo::ArrayDataView<Hint>* output) {
  auto pointer = data_->hints.Get();
  *output = mojo::ArrayDataView<Hint>(pointer, message_);
}
inline void PublicKeyCredentialRequestOptionsDataView::GetExtensionsDataView(
    AuthenticationExtensionsClientInputsDataView* output) {
  auto pointer = data_->extensions.Get();
  *output = AuthenticationExtensionsClientInputsDataView(pointer, message_);
}


inline void AuthenticationExtensionsClientInputsDataView::GetAppidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->appid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AuthenticationExtensionsClientInputsDataView::GetCableAuthenticationDataDataView(
    mojo::ArrayDataView<CableAuthenticationDataView>* output) {
  auto pointer = data_->cable_authentication_data.Get();
  *output = mojo::ArrayDataView<CableAuthenticationDataView>(pointer, message_);
}
inline void AuthenticationExtensionsClientInputsDataView::GetPrfInputsDataView(
    mojo::ArrayDataView<PRFValuesDataView>* output) {
  auto pointer = data_->prf_inputs.Get();
  *output = mojo::ArrayDataView<PRFValuesDataView>(pointer, message_);
}
inline void AuthenticationExtensionsClientInputsDataView::GetLargeBlobWriteDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->large_blob_write.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AuthenticationExtensionsClientInputsDataView::GetRemoteDesktopClientOverrideDataView(
    RemoteDesktopClientOverrideDataView* output) {
  auto pointer = data_->remote_desktop_client_override.Get();
  *output = RemoteDesktopClientOverrideDataView(pointer, message_);
}
inline void AuthenticationExtensionsClientInputsDataView::GetSupplementalPubKeysDataView(
    SupplementalPubKeysRequestDataView* output) {
  auto pointer = data_->supplemental_pub_keys.Get();
  *output = SupplementalPubKeysRequestDataView(pointer, message_);
}
inline void AuthenticationExtensionsClientInputsDataView::GetPaymentBrowserBoundKeyParametersDataView(
    mojo::ArrayDataView<PublicKeyCredentialParametersDataView>* output) {
  auto pointer = data_->payment_browser_bound_key_parameters.Get();
  *output = mojo::ArrayDataView<PublicKeyCredentialParametersDataView>(pointer, message_);
}


inline void GetCredentialOptionsDataView::GetPublicKeyDataView(
    PublicKeyCredentialRequestOptionsDataView* output) {
  auto pointer = data_->public_key.Get();
  *output = PublicKeyCredentialRequestOptionsDataView(pointer, message_);
}




inline void PublicKeyCredentialCreationOptionsDataView::GetRelyingPartyDataView(
    PublicKeyCredentialRpEntityDataView* output) {
  auto pointer = data_->relying_party.Get();
  *output = PublicKeyCredentialRpEntityDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetUserDataView(
    PublicKeyCredentialUserEntityDataView* output) {
  auto pointer = data_->user.Get();
  *output = PublicKeyCredentialUserEntityDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetChallengeDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->challenge.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetPublicKeyParametersDataView(
    mojo::ArrayDataView<PublicKeyCredentialParametersDataView>* output) {
  auto pointer = data_->public_key_parameters.Get();
  *output = mojo::ArrayDataView<PublicKeyCredentialParametersDataView>(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetExcludeCredentialsDataView(
    mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>* output) {
  auto pointer = data_->exclude_credentials.Get();
  *output = mojo::ArrayDataView<PublicKeyCredentialDescriptorDataView>(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetAuthenticatorSelectionDataView(
    AuthenticatorSelectionCriteriaDataView* output) {
  auto pointer = data_->authenticator_selection.Get();
  *output = AuthenticatorSelectionCriteriaDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetHintsDataView(
    mojo::ArrayDataView<Hint>* output) {
  auto pointer = data_->hints.Get();
  *output = mojo::ArrayDataView<Hint>(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetPrfInputDataView(
    PRFValuesDataView* output) {
  auto pointer = data_->prf_input.Get();
  *output = PRFValuesDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetAppidExcludeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->appid_exclude.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetCredBlobDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->cred_blob.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetRemoteDesktopClientOverrideDataView(
    RemoteDesktopClientOverrideDataView* output) {
  auto pointer = data_->remote_desktop_client_override.Get();
  *output = RemoteDesktopClientOverrideDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetSupplementalPubKeysDataView(
    SupplementalPubKeysRequestDataView* output) {
  auto pointer = data_->supplemental_pub_keys.Get();
  *output = SupplementalPubKeysRequestDataView(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetPaymentBrowserBoundKeyParametersDataView(
    mojo::ArrayDataView<PublicKeyCredentialParametersDataView>* output) {
  auto pointer = data_->payment_browser_bound_key_parameters.Get();
  *output = mojo::ArrayDataView<PublicKeyCredentialParametersDataView>(pointer, message_);
}
inline void PublicKeyCredentialCreationOptionsDataView::GetAttestationFormatsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->attestation_formats.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void PublicKeyCredentialDescriptorDataView::GetIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialDescriptorDataView::GetTransportsDataView(
    mojo::ArrayDataView<AuthenticatorTransport>* output) {
  auto pointer = data_->transports.Get();
  *output = mojo::ArrayDataView<AuthenticatorTransport>(pointer, message_);
}


inline void WebAuthnDOMExceptionDetailsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebAuthnDOMExceptionDetailsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PublicKeyCredentialReportOptionsDataView::GetRelyingPartyIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->relying_party_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PublicKeyCredentialReportOptionsDataView::GetUnknownCredentialIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->unknown_credential_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void PublicKeyCredentialReportOptionsDataView::GetAllAcceptedCredentialsDataView(
    AllAcceptedCredentialsOptionsDataView* output) {
  auto pointer = data_->all_accepted_credentials.Get();
  *output = AllAcceptedCredentialsOptionsDataView(pointer, message_);
}
inline void PublicKeyCredentialReportOptionsDataView::GetCurrentUserDetailsDataView(
    CurrentUserDetailsOptionsDataView* output) {
  auto pointer = data_->current_user_details.Get();
  *output = CurrentUserDetailsOptionsDataView(pointer, message_);
}


inline void AllAcceptedCredentialsOptionsDataView::GetUserIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AllAcceptedCredentialsOptionsDataView::GetAllAcceptedCredentialsIdsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->all_accepted_credentials_ids.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}


inline void CurrentUserDetailsOptionsDataView::GetUserIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CurrentUserDetailsOptionsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CurrentUserDetailsOptionsDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebAuthnClientCapabilityDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void GetAssertionResponseDataView::GetCredentialDataView(
    GetAssertionAuthenticatorResponseDataView* output) {
  auto pointer = data_->credential.Get();
  *output = GetAssertionAuthenticatorResponseDataView(pointer, message_);
}
inline void GetAssertionResponseDataView::GetDomExceptionDetailsDataView(
    WebAuthnDOMExceptionDetailsDataView* output) {
  auto pointer = data_->dom_exception_details.Get();
  *output = WebAuthnDOMExceptionDetailsDataView(pointer, message_);
}


inline void GetCredentialResponseDataView::GetGetAssertionResponseDataView(
    GetAssertionResponseDataView* output) const {
  CHECK(is_get_assertion_response());
  *output = GetAssertionResponseDataView(data_->data.f_get_assertion_response.Get(), message_);
}
inline void GetCredentialResponseDataView::GetPasswordResponseDataView(
    ::blink::mojom::CredentialInfoDataView* output) const {
  CHECK(is_password_response());
  *output = ::blink::mojom::CredentialInfoDataView(data_->data.f_password_response.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AuthenticatorStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AuthenticatorStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AuthenticatorTransport> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AuthenticatorTransport value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Hint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Hint value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::UserVerificationRequirement> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::UserVerificationRequirement value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::Mediation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::Mediation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ResidentKeyRequirement> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ResidentKeyRequirement value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AuthenticatorAttachment> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AuthenticatorAttachment value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ProtectionPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ProtectionPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::LargeBlobSupport> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::LargeBlobSupport value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AttestationConveyancePreference> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AttestationConveyancePreference value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PublicKeyCredentialType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PublicKeyCredentialType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_SHARED_H_