// third_party/blink/public/mojom/webaudio/audio_context_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AudioContextManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AudioContextManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.AudioContextManagerInterface }
 */
blink.mojom.AudioContextManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AudioContextManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AudioContextManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AudioContextManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } id
   */

  audioContextAudiblePlaybackStarted(
      id) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  audioContextAudiblePlaybackStopped(
      id) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  audioContextCreated(
      id) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AudioContextManager_AudioContextCreated_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  audioContextClosed(
      id) {
    this.proxy.sendMessage(
        3,
        blink.mojom.AudioContextManager_AudioContextClosed_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioContextManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AudioContextManagerReceiver = class {
  /**
   * @param {!blink.mojom.AudioContextManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AudioContextManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AudioContextManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AudioContextManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
        null,
        impl.audioContextAudiblePlaybackStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
        null,
        impl.audioContextAudiblePlaybackStopped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AudioContextManager_AudioContextCreated_ParamsSpec.$,
        null,
        impl.audioContextCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AudioContextManager_AudioContextClosed_ParamsSpec.$,
        null,
        impl.audioContextClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AudioContextManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AudioContextManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AudioContextManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AudioContextManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioContextManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AudioContextManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AudioContextManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AudioContextManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextAudiblePlaybackStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
        null,
        this.audioContextAudiblePlaybackStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextAudiblePlaybackStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
        null,
        this.audioContextAudiblePlaybackStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AudioContextManager_AudioContextCreated_ParamsSpec.$,
        null,
        this.audioContextCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioContextClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AudioContextManager_AudioContextClosed_ParamsSpec.$,
        null,
        this.audioContextClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AudioContextManager_AudioContextCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AudioContextManager_AudioContextClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStarted_ParamsSpec.$,
    'AudioContextManager_AudioContextAudiblePlaybackStarted_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStarted_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStopped_ParamsSpec.$,
    'AudioContextManager_AudioContextAudiblePlaybackStopped_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AudioContextManager_AudioContextAudiblePlaybackStopped_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.AudioContextManager_AudioContextCreated_ParamsSpec.$,
    'AudioContextManager_AudioContextCreated_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AudioContextManager_AudioContextCreated_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.AudioContextManager_AudioContextClosed_ParamsSpec.$,
    'AudioContextManager_AudioContextClosed_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AudioContextManager_AudioContextClosed_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};

