// third_party/blink/public/mojom/web_install/web_install.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebInstallServiceResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebInstallServiceResult = {
  
  kSuccess: 0,
  kAbortError: 1,
  kDataError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebInstallServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebInstallService', scope);
  }
}

/** @interface */
export class WebInstallServiceInterface {
  
  /**
   * @param { ?InstallOptions } options
   * @return {!Promise<{
        result: !WebInstallServiceResult,
        manifestId: !url_mojom_Url,
   *  }>}
   */

  install(options) {}
}

/**
 * @implements { WebInstallServiceInterface }
 */
export class WebInstallServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebInstallServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebInstallServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebInstallServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?InstallOptions } options
   * @return {!Promise<{
        result: !WebInstallServiceResult,
        manifestId: !url_mojom_Url,
   *  }>}
   */

  install(
      options) {
    return this.proxy.sendMessage(
        0,
        WebInstallService_Install_ParamsSpec.$,
        WebInstallService_Install_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebInstallService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebInstallServiceReceiver {
  /**
   * @param {!WebInstallServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebInstallServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebInstallServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebInstallServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebInstallService_Install_ParamsSpec.$,
        WebInstallService_Install_ResponseParamsSpec.$,
        impl.install.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebInstallService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebInstallService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebInstallServiceRemote}
   */
  static getRemote() {
    let remote = new WebInstallServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebInstallService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebInstallServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebInstallServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebInstallServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.install =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebInstallService_Install_ParamsSpec.$,
        WebInstallService_Install_ResponseParamsSpec.$,
        this.install.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InstallOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebInstallService_Install_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebInstallService_Install_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InstallOptionsSpec.$,
    'InstallOptions',
    [
      mojo.internal.StructField(
        'installUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manifestId', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InstallOptions {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.installUrl;
    /** @type { (url_mojom_Url|undefined) } */
    this.manifestId;
  }
}



mojo.internal.Struct(
    WebInstallService_Install_ParamsSpec.$,
    'WebInstallService_Install_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        InstallOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WebInstallService_Install_Params {
  constructor() {
    /** @type { (InstallOptions|undefined) } */
    this.options;
  }
}



mojo.internal.Struct(
    WebInstallService_Install_ResponseParamsSpec.$,
    'WebInstallService_Install_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        WebInstallServiceResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manifestId', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WebInstallService_Install_ResponseParams {
  constructor() {
    /** @type { !WebInstallServiceResult } */
    this.result;
    /** @type { !url_mojom_Url } */
    this.manifestId;
  }
}

