// third_party/blink/public/mojom/web_install/web_install.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/web_install/web_install.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/web_install/web_install.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* WebInstallServiceResultToStringHelper(WebInstallServiceResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebInstallServiceResult::kSuccess:
      return "kSuccess";
    case WebInstallServiceResult::kAbortError:
      return "kAbortError";
    case WebInstallServiceResult::kDataError:
      return "kDataError";
    default:
      return nullptr;
  }
}

std::string WebInstallServiceResultToString(WebInstallServiceResult value) {
  const char *str = WebInstallServiceResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebInstallServiceResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebInstallServiceResult value) {
  return os << WebInstallServiceResultToString(value);
}

namespace internal {


// static
bool InstallOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InstallOptions_Data* object =
      static_cast<const InstallOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->install_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->install_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->manifest_id, validation_context))
    return false;

  return true;
}

InstallOptions_Data::InstallOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebInstallService_Install_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebInstallService_Install_Params_Data* object =
      static_cast<const WebInstallService_Install_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebInstallService_Install_Params_Data::WebInstallService_Install_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebInstallService_Install_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebInstallService_Install_ResponseParams_Data* object =
      static_cast<const WebInstallService_Install_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::WebInstallServiceResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->manifest_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->manifest_id, validation_context))
    return false;

  return true;
}

WebInstallService_Install_ResponseParams_Data::WebInstallService_Install_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::WebInstallServiceResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::WebInstallServiceResult value) {
  return std::move(context).WriteString(::blink::mojom::WebInstallServiceResultToString(value));
}

} // namespace perfetto