// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared-internal.h"
#include "services/network/public/mojom/no_vary_search.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::SpeculationAction>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SpeculationAction> {};

template <>
struct hash<::blink::mojom::SpeculationTargetHint>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SpeculationTargetHint> {};

template <>
struct hash<::blink::mojom::SpeculationEagerness>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SpeculationEagerness> {};

template <>
struct hash<::blink::mojom::SpeculationInjectionType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SpeculationInjectionType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeculationAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SpeculationAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SpeculationAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeculationTargetHint, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SpeculationTargetHint, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SpeculationTargetHint>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeculationEagerness, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SpeculationEagerness, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SpeculationEagerness>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeculationInjectionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SpeculationInjectionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SpeculationInjectionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpeculationCandidateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpeculationCandidateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpeculationCandidate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SpeculationCandidate struct");

    
    mojo::internal::Serialize<::blink::mojom::SpeculationAction>(
      Traits::action(input),
      &fragment->action);

    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
      in_referrer,
      referrer_fragment);

    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->referrer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer in SpeculationCandidate struct");

    fragment->requires_anonymous_client_ip_when_cross_origin = Traits::requires_anonymous_client_ip_when_cross_origin(input);

    
    mojo::internal::Serialize<::blink::mojom::SpeculationTargetHint>(
      Traits::target_browsing_context_name_hint(input),
      &fragment->target_browsing_context_name_hint);

    
    mojo::internal::Serialize<::blink::mojom::SpeculationEagerness>(
      Traits::eagerness(input),
      &fragment->eagerness);

    decltype(Traits::no_vary_search_hint(input)) in_no_vary_search_hint = Traits::no_vary_search_hint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->no_vary_search_hint)::BaseType> no_vary_search_hint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::NoVarySearchDataView>(
      in_no_vary_search_hint,
      no_vary_search_hint_fragment);

    fragment->no_vary_search_hint.Set(
        no_vary_search_hint_fragment.is_null() ? nullptr : no_vary_search_hint_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::SpeculationInjectionType>(
      Traits::injection_type(input),
      &fragment->injection_type);

    decltype(Traits::tags(input)) in_tags = Traits::tags(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tags)::BaseType>
        tags_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tags_validate_params =
        mojo::internal::GetArrayValidator<0, true, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_tags,
      tags_fragment,
      &tags_validate_params);

    fragment->tags.Set(
        tags_fragment.is_null() ? nullptr : tags_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tags.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tags in SpeculationCandidate struct");
  }

  static bool Deserialize(::blink::mojom::internal::SpeculationCandidate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpeculationCandidateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SpeculationCandidateDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SpeculationCandidateDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void SpeculationCandidateDataView::GetNoVarySearchHintDataView(
    ::network::mojom::NoVarySearchDataView* output) {
  auto pointer = data_->no_vary_search_hint.Get();
  *output = ::network::mojom::NoVarySearchDataView(pointer, message_);
}
inline void SpeculationCandidateDataView::GetTagsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->tags.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SpeculationAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SpeculationAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SpeculationTargetHint> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SpeculationTargetHint value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SpeculationEagerness> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SpeculationEagerness value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SpeculationInjectionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SpeculationInjectionType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_SHARED_H_