// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SharedStorageWorkletPermissionsPolicyState::SharedStorageWorkletPermissionsPolicyState()
    : private_aggregation_allowed(),
      join_ad_interest_group_allowed(),
      run_ad_auction_allowed() {}

SharedStorageWorkletPermissionsPolicyState::SharedStorageWorkletPermissionsPolicyState(
    bool private_aggregation_allowed_in,
    bool join_ad_interest_group_allowed_in,
    bool run_ad_auction_allowed_in)
    : private_aggregation_allowed(std::move(private_aggregation_allowed_in)),
      join_ad_interest_group_allowed(std::move(join_ad_interest_group_allowed_in)),
      run_ad_auction_allowed(std::move(run_ad_auction_allowed_in)) {}

SharedStorageWorkletPermissionsPolicyState::~SharedStorageWorkletPermissionsPolicyState() = default;
size_t SharedStorageWorkletPermissionsPolicyState::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->private_aggregation_allowed);
  seed = mojo::internal::WTFHash(seed, this->join_ad_interest_group_allowed);
  seed = mojo::internal::WTFHash(seed, this->run_ad_auction_allowed);
  return seed;
}

void SharedStorageWorkletPermissionsPolicyState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "private_aggregation_allowed"), this->private_aggregation_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "join_ad_interest_group_allowed"), this->join_ad_interest_group_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "run_ad_auction_allowed"), this->run_ad_auction_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageWorkletPermissionsPolicyState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedStorageKeyAndOrValue::SharedStorageKeyAndOrValue()
    : key(),
      value() {}

SharedStorageKeyAndOrValue::SharedStorageKeyAndOrValue(
    const ::blink::String& key_in,
    const ::blink::String& value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

SharedStorageKeyAndOrValue::~SharedStorageKeyAndOrValue() = default;

void SharedStorageKeyAndOrValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedStorageKeyAndOrValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrivateAggregationOperationDetails::PrivateAggregationOperationDetails()
    : pa_host(),
      filtering_id_max_bytes() {}

PrivateAggregationOperationDetails::PrivateAggregationOperationDetails(
    ::mojo::PendingRemote<::blink::mojom::blink::PrivateAggregationHost> pa_host_in,
    uint32_t filtering_id_max_bytes_in)
    : pa_host(std::move(pa_host_in)),
      filtering_id_max_bytes(std::move(filtering_id_max_bytes_in)) {}

PrivateAggregationOperationDetails::~PrivateAggregationOperationDetails() = default;

void PrivateAggregationOperationDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pa_host"), this->pa_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::blink::PrivateAggregationHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filtering_id_max_bytes"), this->filtering_id_max_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrivateAggregationOperationDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetInterestGroupsResultPtr
GetInterestGroupsResult::NewErrorMessage(
    const ::blink::String& value) {
  return GetInterestGroupsResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorMessage)>,
      std::move(value));
}

GetInterestGroupsResultPtr
GetInterestGroupsResult::NewGroups(
    ::blink::Vector<::blink::mojom::blink::StorageInterestGroupPtr> value) {
  return GetInterestGroupsResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGroups)>,
      std::move(value));
}

GetInterestGroupsResult::GetInterestGroupsResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
    const ::blink::String& value)
    : tag_(Tag::kErrorMessage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorMessage)>,
            std::move(value)) {}

GetInterestGroupsResult::GetInterestGroupsResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kGroups)>,
    ::blink::Vector<::blink::mojom::blink::StorageInterestGroupPtr> value)
    : tag_(Tag::kGroups),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGroups)>,
            std::move(value)) {}
GetInterestGroupsResult::~GetInterestGroupsResult() {
  DestroyActive();
}

void GetInterestGroupsResult::set_error_message(const ::blink::String& error_message) {
  if (tag_ == Tag::kErrorMessage) {
    data_.error_message = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorMessage;
    new (&data_.error_message) ::blink::String(
        std::move(error_message));
  }
}

void GetInterestGroupsResult::set_groups(::blink::Vector<::blink::mojom::blink::StorageInterestGroupPtr> groups) {
  if (tag_ == Tag::kGroups) {
    data_.groups = std::move(groups);
  } else {
    DestroyActive();
    tag_ = Tag::kGroups;
    new (&data_.groups) ::blink::Vector<::blink::mojom::blink::StorageInterestGroupPtr>(
        std::move(groups));
  }
}


GetInterestGroupsResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
    const ::blink::String& value)
    : error_message(std::move(value)) {}

GetInterestGroupsResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGroups)>,
    ::blink::Vector<::blink::mojom::blink::StorageInterestGroupPtr> value)
    : groups(std::move(value)) {}

void GetInterestGroupsResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorMessage:
      std::destroy_at(&data_.error_message);
      break;
    case Tag::kGroups:
      std::destroy_at(&data_.groups);
      break;
  }
}

bool GetInterestGroupsResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

SharedStorageEntriesListener::IPCStableHashFunction SharedStorageEntriesListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedStorageEntriesListener>(message.name())) {
    case messages::SharedStorageEntriesListener::kDidReadEntries: {
      return &SharedStorageEntriesListener::DidReadEntries_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedStorageEntriesListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedStorageEntriesListener>(message.name())) {
      case messages::SharedStorageEntriesListener::kDidReadEntries:
            return "Receive blink::mojom::SharedStorageEntriesListener::DidReadEntries";
    }
  } else {
    switch (static_cast<messages::SharedStorageEntriesListener>(message.name())) {
      case messages::SharedStorageEntriesListener::kDidReadEntries:
            return "Receive reply blink::mojom::SharedStorageEntriesListener::DidReadEntries";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedStorageEntriesListener::DidReadEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x139f6591;  // IPCStableHash for blink::mojom::SharedStorageEntriesListener::DidReadEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SharedStorageEntriesListenerProxy::SharedStorageEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedStorageEntriesListenerProxy::DidReadEntries(
    bool in_success, const ::blink::String& in_error_message, ::blink::Vector<SharedStorageKeyAndOrValuePtr> in_entries, bool in_has_more_entries, int32_t in_total_queued_to_send) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageEntriesListener::DidReadEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type ::blink::Vector<SharedStorageKeyAndOrValuePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_more_entries"), in_has_more_entries,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_queued_to_send"), in_total_queued_to_send,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageEntriesListener::kDidReadEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageEntriesListener_DidReadEntries_Params_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in SharedStorageEntriesListener.DidReadEntries request");
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SharedStorageKeyAndOrValueDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in SharedStorageEntriesListener.DidReadEntries request");

  params->has_more_entries = in_has_more_entries;

  params->total_queued_to_send = in_total_queued_to_send;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageEntriesListener::Name_);
  message.set_method_name("DidReadEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SharedStorageEntriesListenerStubDispatch::Accept(
    SharedStorageEntriesListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedStorageEntriesListener>(message->header()->name)) {
    case messages::SharedStorageEntriesListener::kDidReadEntries: {
      DCHECK(message->is_serialized());
      internal::SharedStorageEntriesListener_DidReadEntries_Params_Data* params =
          reinterpret_cast<internal::SharedStorageEntriesListener_DidReadEntries_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedStorageEntriesListener.0
      bool success = true;
      bool p_success{};
      ::blink::String p_error_message{};
      ::blink::Vector<SharedStorageKeyAndOrValuePtr> p_entries{};
      bool p_has_more_entries{};
      int32_t p_total_queued_to_send{};
      SharedStorageEntriesListener_DidReadEntries_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (success)
        p_has_more_entries = input_data_view.has_more_entries();
      if (success)
        p_total_queued_to_send = input_data_view.total_queued_to_send();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageEntriesListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReadEntries(        
        std::move(p_success), 
        std::move(p_error_message), 
        std::move(p_entries), 
        std::move(p_has_more_entries), 
        std::move(p_total_queued_to_send));
      return true;
    }
  }
  return false;
}

// static
bool SharedStorageEntriesListenerStubDispatch::AcceptWithResponder(
    SharedStorageEntriesListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedStorageEntriesListener>(message->header()->name)) {
    case messages::SharedStorageEntriesListener::kDidReadEntries: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedStorageEntriesListenerValidationInfo[] = {
    { &internal::SharedStorageEntriesListener_DidReadEntries_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedStorageEntriesListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedStorageEntriesListener::Name_,
    kSharedStorageEntriesListenerValidationInfo);
}

// The declaration includes the definition on other builds.

SharedStorageWorkletServiceClient::IPCStableHashFunction SharedStorageWorkletServiceClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedStorageWorkletServiceClient>(message.name())) {
    case messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate: {
      return &SharedStorageWorkletServiceClient::SharedStorageUpdate_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate: {
      return &SharedStorageWorkletServiceClient::SharedStorageBatchUpdate_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageGet: {
      return &SharedStorageWorkletServiceClient::SharedStorageGet_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageKeys: {
      return &SharedStorageWorkletServiceClient::SharedStorageKeys_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageEntries: {
      return &SharedStorageWorkletServiceClient::SharedStorageEntries_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageLength: {
      return &SharedStorageWorkletServiceClient::SharedStorageLength_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget: {
      return &SharedStorageWorkletServiceClient::SharedStorageRemainingBudget_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kGetInterestGroups: {
      return &SharedStorageWorkletServiceClient::GetInterestGroups_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kDidAddMessageToConsole: {
      return &SharedStorageWorkletServiceClient::DidAddMessageToConsole_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletServiceClient::kRecordUseCounters: {
      return &SharedStorageWorkletServiceClient::RecordUseCounters_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedStorageWorkletServiceClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedStorageWorkletServiceClient>(message.name())) {
      case messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageUpdate";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageBatchUpdate";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageGet:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageGet";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageKeys:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageKeys";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageEntries:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageEntries";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageLength:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageLength";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::SharedStorageRemainingBudget";
      case messages::SharedStorageWorkletServiceClient::kGetInterestGroups:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::GetInterestGroups";
      case messages::SharedStorageWorkletServiceClient::kDidAddMessageToConsole:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::DidAddMessageToConsole";
      case messages::SharedStorageWorkletServiceClient::kRecordUseCounters:
            return "Receive blink::mojom::SharedStorageWorkletServiceClient::RecordUseCounters";
    }
  } else {
    switch (static_cast<messages::SharedStorageWorkletServiceClient>(message.name())) {
      case messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageUpdate";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageBatchUpdate";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageGet:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageGet";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageKeys:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageKeys";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageEntries:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageEntries";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageLength:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageLength";
      case messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageRemainingBudget";
      case messages::SharedStorageWorkletServiceClient::kGetInterestGroups:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::GetInterestGroups";
      case messages::SharedStorageWorkletServiceClient::kDidAddMessageToConsole:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::DidAddMessageToConsole";
      case messages::SharedStorageWorkletServiceClient::kRecordUseCounters:
            return "Receive reply blink::mojom::SharedStorageWorkletServiceClient::RecordUseCounters";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedStorageWorkletServiceClient::SharedStorageUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6e251d2;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::SharedStorageBatchUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80752490;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageBatchUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::SharedStorageGet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13173f4d;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageGet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::SharedStorageKeys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd28ccc7f;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageKeys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::SharedStorageEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87a17093;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::SharedStorageLength_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4da3f4b9;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageLength
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::SharedStorageRemainingBudget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3cb70843;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::SharedStorageRemainingBudget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::GetInterestGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xabd1277e;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::GetInterestGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::DidAddMessageToConsole_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x231c05b5;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::DidAddMessageToConsole
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletServiceClient::RecordUseCounters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7376020;  // IPCStableHash for blink::mojom::SharedStorageWorkletServiceClient::RecordUseCounters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback(
      SharedStorageWorkletServiceClient::SharedStorageUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback(const SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback&) = delete;
  SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback& operator=(const SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletServiceClient::SharedStorageUpdateCallback callback_;
};

class SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback(
      SharedStorageWorkletServiceClient::SharedStorageBatchUpdateCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback(const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback&) = delete;
  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback& operator=(const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletServiceClient::SharedStorageBatchUpdateCallback callback_;
};

class SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback(
      SharedStorageWorkletServiceClient::SharedStorageGetCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback(const SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback&) = delete;
  SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback& operator=(const SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletServiceClient::SharedStorageGetCallback callback_;
};

class SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback(
      SharedStorageWorkletServiceClient::SharedStorageLengthCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback(const SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback&) = delete;
  SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback& operator=(const SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletServiceClient::SharedStorageLengthCallback callback_;
};

class SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback(
      SharedStorageWorkletServiceClient::SharedStorageRemainingBudgetCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback(const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback&) = delete;
  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback& operator=(const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletServiceClient::SharedStorageRemainingBudgetCallback callback_;
};

class SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback(
      SharedStorageWorkletServiceClient::GetInterestGroupsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback(const SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback&) = delete;
  SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback& operator=(const SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletServiceClient::GetInterestGroupsCallback callback_;
};

SharedStorageWorkletServiceClientProxy::SharedStorageWorkletServiceClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedStorageWorkletServiceClientProxy::SharedStorageUpdate(
    ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr in_method_with_options, SharedStorageUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method_with_options"), in_method_with_options,
                        "<value of type ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->method_with_options)::BaseType> method_with_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SharedStorageModifierMethodWithOptionsDataView>(
    in_method_with_options,
    method_with_options_fragment);

  params->method_with_options.Set(
      method_with_options_fragment.is_null() ? nullptr : method_with_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->method_with_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null method_with_options in SharedStorageWorkletServiceClient.SharedStorageUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceClientProxy::SharedStorageBatchUpdate(
    ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> in_methods_with_options, const std::optional<::blink::String>& in_with_lock, SharedStorageBatchUpdateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageBatchUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("methods_with_options"), in_methods_with_options,
                        "<value of type ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("with_lock"), in_with_lock,
                        "<value of type const std::optional<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->methods_with_options)::BaseType> methods_with_options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView>(
    in_methods_with_options,
    methods_with_options_fragment);

  params->methods_with_options.Set(
      methods_with_options_fragment.is_null() ? nullptr : methods_with_options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->methods_with_options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null methods_with_options in SharedStorageWorkletServiceClient.SharedStorageBatchUpdate request");
  mojo::internal::MessageFragment<
      typename decltype(params->with_lock)::BaseType> with_lock_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::LockNameDataView>(
    in_with_lock,
    with_lock_fragment);

  params->with_lock.Set(
      with_lock_fragment.is_null() ? nullptr : with_lock_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageBatchUpdate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceClientProxy::SharedStorageGet(
    const ::blink::String& in_key, SharedStorageGetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageGet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in SharedStorageWorkletServiceClient.SharedStorageGet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageGet");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceClientProxy::SharedStorageKeys(
    ::mojo::PendingRemote<SharedStorageEntriesListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageKeys", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<SharedStorageEntriesListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SharedStorageEntriesListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in SharedStorageWorkletServiceClient.SharedStorageKeys request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageKeys");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedStorageWorkletServiceClientProxy::SharedStorageEntries(
    ::mojo::PendingRemote<SharedStorageEntriesListener> in_listener, bool in_values_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<SharedStorageEntriesListener>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values_only"), in_values_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::SharedStorageEntriesListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in SharedStorageWorkletServiceClient.SharedStorageEntries request");

  params->values_only = in_values_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageEntries");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedStorageWorkletServiceClientProxy::SharedStorageLength(
    SharedStorageLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageLength");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceClientProxy::SharedStorageRemainingBudget(
    SharedStorageRemainingBudgetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::SharedStorageRemainingBudget");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageRemainingBudget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceClientProxy::GetInterestGroups(
    GetInterestGroupsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::GetInterestGroups");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kGetInterestGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("GetInterestGroups");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceClientProxy::DidAddMessageToConsole(
    ::blink::mojom::blink::ConsoleMessageLevel in_log_level, const ::blink::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::DidAddMessageToConsole", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_level"), in_log_level,
                        "<value of type ::blink::mojom::blink::ConsoleMessageLevel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kDidAddMessageToConsole), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
    in_log_level,
    &params->log_level);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in SharedStorageWorkletServiceClient.DidAddMessageToConsole request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("DidAddMessageToConsole");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedStorageWorkletServiceClientProxy::RecordUseCounters(
    const ::blink::Vector<::blink::mojom::blink::WebFeature>& in_features) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletServiceClient::RecordUseCounters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type const ::blink::Vector<::blink::mojom::blink::WebFeature>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kRecordUseCounters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
    in_features,
    features_fragment,
    &features_validate_params);

  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->features.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null features in SharedStorageWorkletServiceClient.RecordUseCounters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("RecordUseCounters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletServiceClient::SharedStorageUpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder> proxy(
        new SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletServiceClient::SharedStorageUpdateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_error_message);
};

bool SharedStorageWorkletServiceClient_SharedStorageUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletServiceClient.0
  bool success = true;
  ::blink::String p_error_message{};
  SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletServiceClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_message));
  }
  return true;
}

void SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder::Run(
    const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageUpdate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageUpdate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletServiceClient::SharedStorageBatchUpdateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder> proxy(
        new SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletServiceClient::SharedStorageBatchUpdateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_error_message);
};

bool SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletServiceClient.1
  bool success = true;
  ::blink::String p_error_message{};
  SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletServiceClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_message));
  }
  return true;
}

void SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder::Run(
    const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageBatchUpdate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageBatchUpdate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletServiceClient::SharedStorageGetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder> proxy(
        new SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletServiceClient::SharedStorageGetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::SharedStorageGetStatus in_status, const ::blink::String& in_error_message, const ::blink::String& in_value);
};

bool SharedStorageWorkletServiceClient_SharedStorageGet_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletServiceClient.2
  bool success = true;
  ::blink::mojom::blink::SharedStorageGetStatus p_status{};
  ::blink::String p_error_message{};
  ::blink::String p_value{};
  SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletServiceClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_error_message), 
std::move(p_value));
  }
  return true;
}

void SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder::Run(
    ::blink::mojom::blink::SharedStorageGetStatus in_status, const ::blink::String& in_error_message, const ::blink::String& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageGet", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::SharedStorageGetStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::SharedStorageGetStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageGet");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletServiceClient::SharedStorageLengthCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder> proxy(
        new SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletServiceClient::SharedStorageLengthCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::String& in_error_message, uint32_t in_length);
};

bool SharedStorageWorkletServiceClient_SharedStorageLength_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletServiceClient.5
  bool success = true;
  bool p_success{};
  ::blink::String p_error_message{};
  uint32_t p_length{};
  SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (success)
    p_length = input_data_view.length();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletServiceClient::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message), 
std::move(p_length));
  }
  return true;
}

void SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder::Run(
    bool in_success, const ::blink::String& in_error_message, uint32_t in_length) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageLength", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageLength), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageLength");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletServiceClient::SharedStorageRemainingBudgetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder> proxy(
        new SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletServiceClient::SharedStorageRemainingBudgetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::String& in_error_message, double in_bits);
};

bool SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletServiceClient.6
  bool success = true;
  bool p_success{};
  ::blink::String p_error_message{};
  double p_bits{};
  SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (success)
    p_bits = input_data_view.bits();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletServiceClient::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message), 
std::move(p_bits));
  }
  return true;
}

void SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder::Run(
    bool in_success, const ::blink::String& in_error_message, double in_bits) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletServiceClient::SharedStorageRemainingBudget", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bits"), in_bits,
                        "<value of type double>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

  params->bits = in_bits;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("SharedStorageRemainingBudget");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletServiceClient::GetInterestGroupsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder> proxy(
        new SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletServiceClient::GetInterestGroupsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetInterestGroupsResultPtr in_result);
};

bool SharedStorageWorkletServiceClient_GetInterestGroups_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletServiceClient.7
  bool success = true;
  GetInterestGroupsResultPtr p_result{};
  SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletServiceClient::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder::Run(
    GetInterestGroupsResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletServiceClient::GetInterestGroups", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetInterestGroupsResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletServiceClient::kGetInterestGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::GetInterestGroupsResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletServiceClient::Name_);
  message.set_method_name("GetInterestGroups");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedStorageWorkletServiceClientStubDispatch::Accept(
    SharedStorageWorkletServiceClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedStorageWorkletServiceClient>(message->header()->name)) {
    case messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageGet: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageKeys: {
      DCHECK(message->is_serialized());
      internal::SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data* params =
          reinterpret_cast<internal::SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.3
      bool success = true;
      ::mojo::PendingRemote<SharedStorageEntriesListener> p_listener{};
      SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageKeys(        
        std::move(p_listener));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageEntries: {
      DCHECK(message->is_serialized());
      internal::SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data* params =
          reinterpret_cast<internal::SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.4
      bool success = true;
      ::mojo::PendingRemote<SharedStorageEntriesListener> p_listener{};
      bool p_values_only{};
      SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (success)
        p_values_only = input_data_view.values_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageEntries(        
        std::move(p_listener), 
        std::move(p_values_only));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageLength: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kGetInterestGroups: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kDidAddMessageToConsole: {
      DCHECK(message->is_serialized());
      internal::SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data* params =
          reinterpret_cast<internal::SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.8
      bool success = true;
      ::blink::mojom::blink::ConsoleMessageLevel p_log_level{};
      ::blink::String p_message{};
      SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLogLevel(&p_log_level))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAddMessageToConsole(        
        std::move(p_log_level), 
        std::move(p_message));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kRecordUseCounters: {
      DCHECK(message->is_serialized());
      internal::SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data* params =
          reinterpret_cast<internal::SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.9
      bool success = true;
      ::blink::Vector<::blink::mojom::blink::WebFeature> p_features{};
      SharedStorageWorkletServiceClient_RecordUseCounters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordUseCounters(        
        std::move(p_features));
      return true;
    }
  }
  return false;
}

// static
bool SharedStorageWorkletServiceClientStubDispatch::AcceptWithResponder(
    SharedStorageWorkletServiceClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedStorageWorkletServiceClient>(message->header()->name)) {
    case messages::SharedStorageWorkletServiceClient::kSharedStorageUpdate: {
      internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.0
      bool success = true;
      ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr p_method_with_options{};
      SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodWithOptions(&p_method_with_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 0, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletServiceClient_SharedStorageUpdate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageUpdate(        
        std::move(p_method_with_options), std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageBatchUpdate: {
      internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.1
      bool success = true;
      ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> p_methods_with_options{};
      std::optional<::blink::String> p_with_lock{};
      SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMethodsWithOptions(&p_methods_with_options))
        success = false;
      if (success && !input_data_view.ReadWithLock(&p_with_lock))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 1, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageBatchUpdate(        
        std::move(p_methods_with_options), 
        std::move(p_with_lock), std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageGet: {
      internal::SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.2
      bool success = true;
      ::blink::String p_key{};
      SharedStorageWorkletServiceClient_SharedStorageGet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 2, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletServiceClient_SharedStorageGet_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageGet(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageKeys: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageEntries: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageLength: {
      internal::SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.5
      bool success = true;
      SharedStorageWorkletServiceClient_SharedStorageLength_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 5, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletServiceClient_SharedStorageLength_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageLength(std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kSharedStorageRemainingBudget: {
      internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.6
      bool success = true;
      SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 6, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SharedStorageRemainingBudget(std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kGetInterestGroups: {
      internal::SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletServiceClient.7
      bool success = true;
      SharedStorageWorkletServiceClient_GetInterestGroups_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletServiceClient::Name_, 7, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletServiceClient_GetInterestGroups_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterestGroups(std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletServiceClient::kDidAddMessageToConsole: {
      break;
    }
    case messages::SharedStorageWorkletServiceClient::kRecordUseCounters: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedStorageWorkletServiceClientValidationInfo[] = {
    { &internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_Params_Data::Validate,
     &internal::SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params_Data::Validate,
     &internal::SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletServiceClient_SharedStorageGet_Params_Data::Validate,
     &internal::SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletServiceClient_SharedStorageKeys_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedStorageWorkletServiceClient_SharedStorageEntries_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedStorageWorkletServiceClient_SharedStorageLength_Params_Data::Validate,
     &internal::SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params_Data::Validate,
     &internal::SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletServiceClient_GetInterestGroups_Params_Data::Validate,
     &internal::SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedStorageWorkletServiceClient_RecordUseCounters_Params_Data::Validate,
     nullptr /* no response */},
};

bool SharedStorageWorkletServiceClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedStorageWorkletServiceClient::Name_,
    kSharedStorageWorkletServiceClientValidationInfo);
}

bool SharedStorageWorkletServiceClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::SharedStorageWorkletServiceClient::Name_,
    kSharedStorageWorkletServiceClientValidationInfo);
}
// The declaration includes the definition on other builds.

SharedStorageWorkletService::IPCStableHashFunction SharedStorageWorkletService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedStorageWorkletService>(message.name())) {
    case messages::SharedStorageWorkletService::kInitialize: {
      return &SharedStorageWorkletService::Initialize_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletService::kAddModule: {
      return &SharedStorageWorkletService::AddModule_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletService::kRunURLSelectionOperation: {
      return &SharedStorageWorkletService::RunURLSelectionOperation_Sym::IPCStableHash;
    }
    case messages::SharedStorageWorkletService::kRunOperation: {
      return &SharedStorageWorkletService::RunOperation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedStorageWorkletService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedStorageWorkletService>(message.name())) {
      case messages::SharedStorageWorkletService::kInitialize:
            return "Receive blink::mojom::SharedStorageWorkletService::Initialize";
      case messages::SharedStorageWorkletService::kAddModule:
            return "Receive blink::mojom::SharedStorageWorkletService::AddModule";
      case messages::SharedStorageWorkletService::kRunURLSelectionOperation:
            return "Receive blink::mojom::SharedStorageWorkletService::RunURLSelectionOperation";
      case messages::SharedStorageWorkletService::kRunOperation:
            return "Receive blink::mojom::SharedStorageWorkletService::RunOperation";
    }
  } else {
    switch (static_cast<messages::SharedStorageWorkletService>(message.name())) {
      case messages::SharedStorageWorkletService::kInitialize:
            return "Receive reply blink::mojom::SharedStorageWorkletService::Initialize";
      case messages::SharedStorageWorkletService::kAddModule:
            return "Receive reply blink::mojom::SharedStorageWorkletService::AddModule";
      case messages::SharedStorageWorkletService::kRunURLSelectionOperation:
            return "Receive reply blink::mojom::SharedStorageWorkletService::RunURLSelectionOperation";
      case messages::SharedStorageWorkletService::kRunOperation:
            return "Receive reply blink::mojom::SharedStorageWorkletService::RunOperation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedStorageWorkletService::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb5dfb20;  // IPCStableHash for blink::mojom::SharedStorageWorkletService::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletService::AddModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e1b32f1;  // IPCStableHash for blink::mojom::SharedStorageWorkletService::AddModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletService::RunURLSelectionOperation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb314958a;  // IPCStableHash for blink::mojom::SharedStorageWorkletService::RunURLSelectionOperation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedStorageWorkletService::RunOperation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x747fa6b5;  // IPCStableHash for blink::mojom::SharedStorageWorkletService::RunOperation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SharedStorageWorkletService_AddModule_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletService_AddModule_ForwardToCallback(
      SharedStorageWorkletService::AddModuleCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletService_AddModule_ForwardToCallback(const SharedStorageWorkletService_AddModule_ForwardToCallback&) = delete;
  SharedStorageWorkletService_AddModule_ForwardToCallback& operator=(const SharedStorageWorkletService_AddModule_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletService::AddModuleCallback callback_;
};

class SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback(
      SharedStorageWorkletService::RunURLSelectionOperationCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback(const SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback&) = delete;
  SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback& operator=(const SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletService::RunURLSelectionOperationCallback callback_;
};

class SharedStorageWorkletService_RunOperation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SharedStorageWorkletService_RunOperation_ForwardToCallback(
      SharedStorageWorkletService::RunOperationCallback callback
      ) : callback_(std::move(callback)) {
  }

  SharedStorageWorkletService_RunOperation_ForwardToCallback(const SharedStorageWorkletService_RunOperation_ForwardToCallback&) = delete;
  SharedStorageWorkletService_RunOperation_ForwardToCallback& operator=(const SharedStorageWorkletService_RunOperation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SharedStorageWorkletService::RunOperationCallback callback_;
};

SharedStorageWorkletServiceProxy::SharedStorageWorkletServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedStorageWorkletServiceProxy::Initialize(
    ::mojo::PendingAssociatedRemote<SharedStorageWorkletServiceClient> in_client, SharedStorageWorkletPermissionsPolicyStatePtr in_permissions_policy_state, const ::blink::String& in_embedder_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletService::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<SharedStorageWorkletServiceClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("permissions_policy_state"), in_permissions_policy_state,
                        "<value of type SharedStorageWorkletPermissionsPolicyStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder_context"), in_embedder_context,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_Initialize_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::SharedStorageWorkletServiceClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in SharedStorageWorkletService.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->permissions_policy_state)::BaseType> permissions_policy_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SharedStorageWorkletPermissionsPolicyStateDataView>(
    in_permissions_policy_state,
    permissions_policy_state_fragment);

  params->permissions_policy_state.Set(
      permissions_policy_state_fragment.is_null() ? nullptr : permissions_policy_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->permissions_policy_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null permissions_policy_state in SharedStorageWorkletService.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->embedder_context)::BaseType> embedder_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_embedder_context,
    embedder_context_fragment);

  params->embedder_context.Set(
      embedder_context_fragment.is_null() ? nullptr : embedder_context_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedStorageWorkletServiceProxy::AddModule(
    ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> in_url_loader_factory, const ::blink::KURL& in_script_source_url, AddModuleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletService::AddModule", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_loader_factory"), in_url_loader_factory,
                        "<value of type ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_source_url"), in_script_source_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kAddModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_AddModule_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
    in_url_loader_factory,
    &params->url_loader_factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid url_loader_factory in SharedStorageWorkletService.AddModule request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_source_url)::BaseType> script_source_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_script_source_url,
    script_source_url_fragment);

  params->script_source_url.Set(
      script_source_url_fragment.is_null() ? nullptr : script_source_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_source_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_source_url in SharedStorageWorkletService.AddModule request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("AddModule");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletService_AddModule_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceProxy::RunURLSelectionOperation(
    const ::blink::String& in_name, const ::blink::Vector<::blink::KURL>& in_urls, ::blink::BlinkCloneableMessage in_serialized_data, PrivateAggregationOperationDetailsPtr in_pa_operation_details, RunURLSelectionOperationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletService::RunURLSelectionOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const ::blink::Vector<::blink::KURL>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_data"), in_serialized_data,
                        "<value of type ::blink::BlinkCloneableMessage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pa_operation_details"), in_pa_operation_details,
                        "<value of type PrivateAggregationOperationDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kRunURLSelectionOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_RunURLSelectionOperation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in SharedStorageWorkletService.RunURLSelectionOperation request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in SharedStorageWorkletService.RunURLSelectionOperation request");
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_data)::BaseType> serialized_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
    in_serialized_data,
    serialized_data_fragment);

  params->serialized_data.Set(
      serialized_data_fragment.is_null() ? nullptr : serialized_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serialized_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serialized_data in SharedStorageWorkletService.RunURLSelectionOperation request");
  mojo::internal::MessageFragment<
      typename decltype(params->pa_operation_details)::BaseType> pa_operation_details_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PrivateAggregationOperationDetailsDataView>(
    in_pa_operation_details,
    pa_operation_details_fragment);

  params->pa_operation_details.Set(
      pa_operation_details_fragment.is_null() ? nullptr : pa_operation_details_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("RunURLSelectionOperation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SharedStorageWorkletServiceProxy::RunOperation(
    const ::blink::String& in_name, ::blink::BlinkCloneableMessage in_serialized_data, PrivateAggregationOperationDetailsPtr in_pa_operation_details, RunOperationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SharedStorageWorkletService::RunOperation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_data"), in_serialized_data,
                        "<value of type ::blink::BlinkCloneableMessage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pa_operation_details"), in_pa_operation_details,
                        "<value of type PrivateAggregationOperationDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kRunOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_RunOperation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in SharedStorageWorkletService.RunOperation request");
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_data)::BaseType> serialized_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CloneableMessageDataView>(
    in_serialized_data,
    serialized_data_fragment);

  params->serialized_data.Set(
      serialized_data_fragment.is_null() ? nullptr : serialized_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serialized_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serialized_data in SharedStorageWorkletService.RunOperation request");
  mojo::internal::MessageFragment<
      typename decltype(params->pa_operation_details)::BaseType> pa_operation_details_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PrivateAggregationOperationDetailsDataView>(
    in_pa_operation_details,
    pa_operation_details_fragment);

  params->pa_operation_details.Set(
      pa_operation_details_fragment.is_null() ? nullptr : pa_operation_details_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("RunOperation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SharedStorageWorkletService_RunOperation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SharedStorageWorkletService_AddModule_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletService::AddModuleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletService_AddModule_ProxyToResponder> proxy(
        new SharedStorageWorkletService_AddModule_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletService_AddModule_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletService_AddModule_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletService_AddModule_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletService::AddModuleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::String& in_error_message);
};

bool SharedStorageWorkletService_AddModule_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletService_AddModule_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletService_AddModule_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletService.1
  bool success = true;
  bool p_success{};
  ::blink::String p_error_message{};
  SharedStorageWorkletService_AddModule_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message));
  }
  return true;
}

void SharedStorageWorkletService_AddModule_ProxyToResponder::Run(
    bool in_success, const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletService::AddModule", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kAddModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_AddModule_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("AddModule");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletService::RunURLSelectionOperationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder> proxy(
        new SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletService::RunURLSelectionOperationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::String& in_error_message, uint32_t in_index);
};

bool SharedStorageWorkletService_RunURLSelectionOperation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletService.2
  bool success = true;
  bool p_success{};
  ::blink::String p_error_message{};
  uint32_t p_index{};
  SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (success)
    p_index = input_data_view.index();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message), 
std::move(p_index));
  }
  return true;
}

void SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder::Run(
    bool in_success, const ::blink::String& in_error_message, uint32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletService::RunURLSelectionOperation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kRunURLSelectionOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("RunURLSelectionOperation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SharedStorageWorkletService_RunOperation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SharedStorageWorkletService::RunOperationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SharedStorageWorkletService_RunOperation_ProxyToResponder> proxy(
        new SharedStorageWorkletService_RunOperation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SharedStorageWorkletService_RunOperation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SharedStorageWorkletService_RunOperation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SharedStorageWorkletService_RunOperation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SharedStorageWorkletService::RunOperationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::String& in_error_message);
};

bool SharedStorageWorkletService_RunOperation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SharedStorageWorkletService_RunOperation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SharedStorageWorkletService_RunOperation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SharedStorageWorkletService.3
  bool success = true;
  bool p_success{};
  ::blink::String p_error_message{};
  SharedStorageWorkletService_RunOperation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SharedStorageWorkletService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_error_message));
  }
  return true;
}

void SharedStorageWorkletService_RunOperation_ProxyToResponder::Run(
    bool in_success, const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SharedStorageWorkletService::RunOperation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedStorageWorkletService::kRunOperation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SharedStorageWorkletService_RunOperation_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedStorageWorkletService::Name_);
  message.set_method_name("RunOperation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SharedStorageWorkletServiceStubDispatch::Accept(
    SharedStorageWorkletService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedStorageWorkletService>(message->header()->name)) {
    case messages::SharedStorageWorkletService::kInitialize: {
      DCHECK(message->is_serialized());
      internal::SharedStorageWorkletService_Initialize_Params_Data* params =
          reinterpret_cast<internal::SharedStorageWorkletService_Initialize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SharedStorageWorkletService.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<SharedStorageWorkletServiceClient> p_client{};
      SharedStorageWorkletPermissionsPolicyStatePtr p_permissions_policy_state{};
      ::blink::String p_embedder_context{};
      SharedStorageWorkletService_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadPermissionsPolicyState(&p_permissions_policy_state))
        success = false;
      if (success && !input_data_view.ReadEmbedderContext(&p_embedder_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_client), 
        std::move(p_permissions_policy_state), 
        std::move(p_embedder_context));
      return true;
    }
    case messages::SharedStorageWorkletService::kAddModule: {
      break;
    }
    case messages::SharedStorageWorkletService::kRunURLSelectionOperation: {
      break;
    }
    case messages::SharedStorageWorkletService::kRunOperation: {
      break;
    }
  }
  return false;
}

// static
bool SharedStorageWorkletServiceStubDispatch::AcceptWithResponder(
    SharedStorageWorkletService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedStorageWorkletService>(message->header()->name)) {
    case messages::SharedStorageWorkletService::kInitialize: {
      break;
    }
    case messages::SharedStorageWorkletService::kAddModule: {
      internal::SharedStorageWorkletService_AddModule_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletService_AddModule_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletService.1
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> p_url_loader_factory{};
      ::blink::KURL p_script_source_url{};
      SharedStorageWorkletService_AddModule_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success && !input_data_view.ReadScriptSourceUrl(&p_script_source_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletService::Name_, 1, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletService_AddModule_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddModule(        
        std::move(p_url_loader_factory), 
        std::move(p_script_source_url), std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletService::kRunURLSelectionOperation: {
      internal::SharedStorageWorkletService_RunURLSelectionOperation_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletService_RunURLSelectionOperation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletService.2
      bool success = true;
      ::blink::String p_name{};
      ::blink::Vector<::blink::KURL> p_urls{};
      ::blink::BlinkCloneableMessage p_serialized_data{};
      PrivateAggregationOperationDetailsPtr p_pa_operation_details{};
      SharedStorageWorkletService_RunURLSelectionOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (success && !input_data_view.ReadSerializedData(&p_serialized_data))
        success = false;
      if (success && !input_data_view.ReadPaOperationDetails(&p_pa_operation_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletService::Name_, 2, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletService_RunURLSelectionOperation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunURLSelectionOperation(        
        std::move(p_name), 
        std::move(p_urls), 
        std::move(p_serialized_data), 
        std::move(p_pa_operation_details), std::move(callback));
      return true;
    }
    case messages::SharedStorageWorkletService::kRunOperation: {
      internal::SharedStorageWorkletService_RunOperation_Params_Data* params =
          reinterpret_cast<
              internal::SharedStorageWorkletService_RunOperation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SharedStorageWorkletService.3
      bool success = true;
      ::blink::String p_name{};
      ::blink::BlinkCloneableMessage p_serialized_data{};
      PrivateAggregationOperationDetailsPtr p_pa_operation_details{};
      SharedStorageWorkletService_RunOperation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadSerializedData(&p_serialized_data))
        success = false;
      if (success && !input_data_view.ReadPaOperationDetails(&p_pa_operation_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedStorageWorkletService::Name_, 3, false);
        return false;
      }
      auto callback =
          SharedStorageWorkletService_RunOperation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunOperation(        
        std::move(p_name), 
        std::move(p_serialized_data), 
        std::move(p_pa_operation_details), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSharedStorageWorkletServiceValidationInfo[] = {
    { &internal::SharedStorageWorkletService_Initialize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SharedStorageWorkletService_AddModule_Params_Data::Validate,
     &internal::SharedStorageWorkletService_AddModule_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletService_RunURLSelectionOperation_Params_Data::Validate,
     &internal::SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams_Data::Validate},
    { &internal::SharedStorageWorkletService_RunOperation_Params_Data::Validate,
     &internal::SharedStorageWorkletService_RunOperation_ResponseParams_Data::Validate},
};

bool SharedStorageWorkletServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SharedStorageWorkletService::Name_,
    kSharedStorageWorkletServiceValidationInfo);
}

bool SharedStorageWorkletServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::SharedStorageWorkletService::Name_,
    kSharedStorageWorkletServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SharedStorageWorkletPermissionsPolicyState::DataView, ::blink::mojom::blink::SharedStorageWorkletPermissionsPolicyStatePtr>::Read(
    ::blink::mojom::blink::SharedStorageWorkletPermissionsPolicyState::DataView input,
    ::blink::mojom::blink::SharedStorageWorkletPermissionsPolicyStatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::SharedStorageWorkletPermissionsPolicyStatePtr result(::blink::mojom::blink::SharedStorageWorkletPermissionsPolicyState::New());
  
      if (success)
        result->private_aggregation_allowed = input.private_aggregation_allowed();
      if (success)
        result->join_ad_interest_group_allowed = input.join_ad_interest_group_allowed();
      if (success)
        result->run_ad_auction_allowed = input.run_ad_auction_allowed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SharedStorageKeyAndOrValue::DataView, ::blink::mojom::blink::SharedStorageKeyAndOrValuePtr>::Read(
    ::blink::mojom::blink::SharedStorageKeyAndOrValue::DataView input,
    ::blink::mojom::blink::SharedStorageKeyAndOrValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::SharedStorageKeyAndOrValuePtr result(::blink::mojom::blink::SharedStorageKeyAndOrValue::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PrivateAggregationOperationDetails::DataView, ::blink::mojom::blink::PrivateAggregationOperationDetailsPtr>::Read(
    ::blink::mojom::blink::PrivateAggregationOperationDetails::DataView input,
    ::blink::mojom::blink::PrivateAggregationOperationDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PrivateAggregationOperationDetailsPtr result(::blink::mojom::blink::PrivateAggregationOperationDetails::New());
  
      if (success) {
        result->pa_host =
            input.TakePaHost<decltype(result->pa_host)>();
      }
      if (success)
        result->filtering_id_max_bytes = input.filtering_id_max_bytes();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::GetInterestGroupsResult::DataView, ::blink::mojom::blink::GetInterestGroupsResultPtr>::Read(
    ::blink::mojom::blink::GetInterestGroupsResult::DataView input,
    ::blink::mojom::blink::GetInterestGroupsResultPtr* output) {
  using UnionType = ::blink::mojom::blink::GetInterestGroupsResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorMessage: {
      ::blink::String result_error_message{};
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    case Tag::kGroups: {
      ::blink::Vector<::blink::mojom::blink::StorageInterestGroupPtr> result_groups{};
      if (!input.ReadGroups(&result_groups))
        return false;

      *output = UnionType::NewGroups(
          std::move(result_groups));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SharedStorageEntriesListenerInterceptorForTesting::DidReadEntries(bool success, const ::blink::String& error_message, ::blink::Vector<SharedStorageKeyAndOrValuePtr> entries, bool has_more_entries, int32_t total_queued_to_send) {
  GetForwardingInterface()->DidReadEntries(
    std::move(success)
    , 
    std::move(error_message)
    , 
    std::move(entries)
    , 
    std::move(has_more_entries)
    , 
    std::move(total_queued_to_send)
    );
}
SharedStorageEntriesListenerAsyncWaiter::SharedStorageEntriesListenerAsyncWaiter(
    SharedStorageEntriesListener* proxy) : proxy_(proxy) {}

SharedStorageEntriesListenerAsyncWaiter::~SharedStorageEntriesListenerAsyncWaiter() = default;





void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageUpdate(::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options, SharedStorageUpdateCallback callback) {
  GetForwardingInterface()->SharedStorageUpdate(
    std::move(method_with_options)
    , std::move(callback));
}
void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageBatchUpdate(::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::blink::String>& with_lock, SharedStorageBatchUpdateCallback callback) {
  GetForwardingInterface()->SharedStorageBatchUpdate(
    std::move(methods_with_options)
    , 
    std::move(with_lock)
    , std::move(callback));
}
void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageGet(const ::blink::String& key, SharedStorageGetCallback callback) {
  GetForwardingInterface()->SharedStorageGet(
    std::move(key)
    , std::move(callback));
}
void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageKeys(::mojo::PendingRemote<SharedStorageEntriesListener> listener) {
  GetForwardingInterface()->SharedStorageKeys(
    std::move(listener)
    );
}
void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageEntries(::mojo::PendingRemote<SharedStorageEntriesListener> listener, bool values_only) {
  GetForwardingInterface()->SharedStorageEntries(
    std::move(listener)
    , 
    std::move(values_only)
    );
}
void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageLength(SharedStorageLengthCallback callback) {
  GetForwardingInterface()->SharedStorageLength(std::move(callback));
}
void SharedStorageWorkletServiceClientInterceptorForTesting::SharedStorageRemainingBudget(SharedStorageRemainingBudgetCallback callback) {
  GetForwardingInterface()->SharedStorageRemainingBudget(std::move(callback));
}
void SharedStorageWorkletServiceClientInterceptorForTesting::GetInterestGroups(GetInterestGroupsCallback callback) {
  GetForwardingInterface()->GetInterestGroups(std::move(callback));
}
void SharedStorageWorkletServiceClientInterceptorForTesting::DidAddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel log_level, const ::blink::String& message) {
  GetForwardingInterface()->DidAddMessageToConsole(
    std::move(log_level)
    , 
    std::move(message)
    );
}
void SharedStorageWorkletServiceClientInterceptorForTesting::RecordUseCounters(const ::blink::Vector<::blink::mojom::blink::WebFeature>& features) {
  GetForwardingInterface()->RecordUseCounters(
    std::move(features)
    );
}
SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageWorkletServiceClientAsyncWaiter(
    SharedStorageWorkletServiceClient* proxy) : proxy_(proxy) {}

SharedStorageWorkletServiceClientAsyncWaiter::~SharedStorageWorkletServiceClientAsyncWaiter() = default;


void SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageUpdate(
    ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options, ::blink::String* out_error_message) {
  base::RunLoop loop;
  proxy_->SharedStorageUpdate(
      std::move(method_with_options),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_error_message
,
             const ::blink::String& error_message) {*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_error_message));
  loop.Run();
}

::blink::String SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageUpdate(
    ::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr method_with_options) {
  ::blink::String async_wait_result;
  SharedStorageUpdate(std::move(method_with_options),&async_wait_result);
  return async_wait_result;
}

void SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageBatchUpdate(
    ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::blink::String>& with_lock, ::blink::String* out_error_message) {
  base::RunLoop loop;
  proxy_->SharedStorageBatchUpdate(
      std::move(methods_with_options),
      std::move(with_lock),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_error_message
,
             const ::blink::String& error_message) {*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_error_message));
  loop.Run();
}

::blink::String SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageBatchUpdate(
    ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::blink::String>& with_lock) {
  ::blink::String async_wait_result;
  SharedStorageBatchUpdate(std::move(methods_with_options),std::move(with_lock),&async_wait_result);
  return async_wait_result;
}

void SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageGet(
    const ::blink::String& key, ::blink::mojom::blink::SharedStorageGetStatus* out_status, ::blink::String* out_error_message, ::blink::String* out_value) {
  base::RunLoop loop;
  proxy_->SharedStorageGet(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::SharedStorageGetStatus* out_status
,
             ::blink::String* out_error_message
,
             ::blink::String* out_value
,
             ::blink::mojom::blink::SharedStorageGetStatus status,
             const ::blink::String& error_message,
             const ::blink::String& value) {*out_status = std::move(status);*out_error_message = std::move(error_message);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_status,
          out_error_message,
          out_value));
  loop.Run();
}



void SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageLength(
    bool* out_success, ::blink::String* out_error_message, uint32_t* out_length) {
  base::RunLoop loop;
  proxy_->SharedStorageLength(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::String* out_error_message
,
             uint32_t* out_length
,
             bool success,
             const ::blink::String& error_message,
             uint32_t length) {*out_success = std::move(success);*out_error_message = std::move(error_message);*out_length = std::move(length);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message,
          out_length));
  loop.Run();
}



void SharedStorageWorkletServiceClientAsyncWaiter::SharedStorageRemainingBudget(
    bool* out_success, ::blink::String* out_error_message, double* out_bits) {
  base::RunLoop loop;
  proxy_->SharedStorageRemainingBudget(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::String* out_error_message
,
             double* out_bits
,
             bool success,
             const ::blink::String& error_message,
             double bits) {*out_success = std::move(success);*out_error_message = std::move(error_message);*out_bits = std::move(bits);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message,
          out_bits));
  loop.Run();
}



void SharedStorageWorkletServiceClientAsyncWaiter::GetInterestGroups(
    GetInterestGroupsResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetInterestGroups(
      base::BindOnce(
          [](base::RunLoop* loop,
             GetInterestGroupsResultPtr* out_result
,
             GetInterestGroupsResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetInterestGroupsResultPtr SharedStorageWorkletServiceClientAsyncWaiter::GetInterestGroups(
    ) {
  GetInterestGroupsResultPtr async_wait_result;
  GetInterestGroups(&async_wait_result);
  return async_wait_result;
}




void SharedStorageWorkletServiceInterceptorForTesting::Initialize(::mojo::PendingAssociatedRemote<SharedStorageWorkletServiceClient> client, SharedStorageWorkletPermissionsPolicyStatePtr permissions_policy_state, const ::blink::String& embedder_context) {
  GetForwardingInterface()->Initialize(
    std::move(client)
    , 
    std::move(permissions_policy_state)
    , 
    std::move(embedder_context)
    );
}
void SharedStorageWorkletServiceInterceptorForTesting::AddModule(::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> url_loader_factory, const ::blink::KURL& script_source_url, AddModuleCallback callback) {
  GetForwardingInterface()->AddModule(
    std::move(url_loader_factory)
    , 
    std::move(script_source_url)
    , std::move(callback));
}
void SharedStorageWorkletServiceInterceptorForTesting::RunURLSelectionOperation(const ::blink::String& name, const ::blink::Vector<::blink::KURL>& urls, ::blink::BlinkCloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, RunURLSelectionOperationCallback callback) {
  GetForwardingInterface()->RunURLSelectionOperation(
    std::move(name)
    , 
    std::move(urls)
    , 
    std::move(serialized_data)
    , 
    std::move(pa_operation_details)
    , std::move(callback));
}
void SharedStorageWorkletServiceInterceptorForTesting::RunOperation(const ::blink::String& name, ::blink::BlinkCloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, RunOperationCallback callback) {
  GetForwardingInterface()->RunOperation(
    std::move(name)
    , 
    std::move(serialized_data)
    , 
    std::move(pa_operation_details)
    , std::move(callback));
}
SharedStorageWorkletServiceAsyncWaiter::SharedStorageWorkletServiceAsyncWaiter(
    SharedStorageWorkletService* proxy) : proxy_(proxy) {}

SharedStorageWorkletServiceAsyncWaiter::~SharedStorageWorkletServiceAsyncWaiter() = default;


void SharedStorageWorkletServiceAsyncWaiter::AddModule(
    ::mojo::PendingRemote<::network::mojom::blink::URLLoaderFactory> url_loader_factory, const ::blink::KURL& script_source_url, bool* out_success, ::blink::String* out_error_message) {
  base::RunLoop loop;
  proxy_->AddModule(
      std::move(url_loader_factory),
      std::move(script_source_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::String* out_error_message
,
             bool success,
             const ::blink::String& error_message) {*out_success = std::move(success);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message));
  loop.Run();
}



void SharedStorageWorkletServiceAsyncWaiter::RunURLSelectionOperation(
    const ::blink::String& name, const ::blink::Vector<::blink::KURL>& urls, ::blink::BlinkCloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, bool* out_success, ::blink::String* out_error_message, uint32_t* out_index) {
  base::RunLoop loop;
  proxy_->RunURLSelectionOperation(
      std::move(name),
      std::move(urls),
      std::move(serialized_data),
      std::move(pa_operation_details),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::String* out_error_message
,
             uint32_t* out_index
,
             bool success,
             const ::blink::String& error_message,
             uint32_t index) {*out_success = std::move(success);*out_error_message = std::move(error_message);*out_index = std::move(index);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message,
          out_index));
  loop.Run();
}



void SharedStorageWorkletServiceAsyncWaiter::RunOperation(
    const ::blink::String& name, ::blink::BlinkCloneableMessage serialized_data, PrivateAggregationOperationDetailsPtr pa_operation_details, bool* out_success, ::blink::String* out_error_message) {
  base::RunLoop loop;
  proxy_->RunOperation(
      std::move(name),
      std::move(serialized_data),
      std::move(pa_operation_details),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::String* out_error_message
,
             bool success,
             const ::blink::String& error_message) {*out_success = std::move(success);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_success,
          out_error_message));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif