// third_party/blink/public/mojom/service_worker/service_worker_worker_client_registry.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/service_worker_worker_client_registry.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var service_worker_worker_client$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_worker_client.mojom', 'service_worker_worker_client.mojom.js');
  }



  function ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.prototype.initDefaults_ = function() {
    this.client = new service_worker_worker_client$.ServiceWorkerWorkerClientPtr();
  };
  ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(new codec.Interface(service_worker_worker_client$.ServiceWorkerWorkerClientPtr));
    return val;
  };

  ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(service_worker_worker_client$.ServiceWorkerWorkerClientPtr), val.client);
  };
  function ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.prototype.initDefaults_ = function() {
    this.host = new bindings.InterfaceRequest();
  };
  ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.host
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.host =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.host);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name = 0;
  var kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name = 1;

  function ServiceWorkerWorkerClientRegistryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceWorkerWorkerClientRegistry,
                                                   handleOrPtrInfo);
  }

  function ServiceWorkerWorkerClientRegistryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceWorkerWorkerClientRegistry, associatedInterfacePtrInfo);
  }

  ServiceWorkerWorkerClientRegistryAssociatedPtr.prototype =
      Object.create(ServiceWorkerWorkerClientRegistryPtr.prototype);
  ServiceWorkerWorkerClientRegistryAssociatedPtr.prototype.constructor =
      ServiceWorkerWorkerClientRegistryAssociatedPtr;

  function ServiceWorkerWorkerClientRegistryProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceWorkerWorkerClientRegistryPtr.prototype.registerWorkerClient = function() {
    return ServiceWorkerWorkerClientRegistryProxy.prototype.registerWorkerClient
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerWorkerClientRegistryProxy.prototype.registerWorkerClient = function(client) {
    var params_ = new ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params();
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name,
        codec.align(ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceWorkerWorkerClientRegistryPtr.prototype.cloneWorkerClientRegistry = function() {
    return ServiceWorkerWorkerClientRegistryProxy.prototype.cloneWorkerClientRegistry
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceWorkerWorkerClientRegistryProxy.prototype.cloneWorkerClientRegistry = function(host) {
    var params_ = new ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params();
    params_.host = host;
    var builder = new codec.MessageV0Builder(
        kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name,
        codec.align(ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params.encodedSize));
    builder.encodeStruct(ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceWorkerWorkerClientRegistryStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceWorkerWorkerClientRegistryStub.prototype.registerWorkerClient = function(client) {
    return this.delegate_ && this.delegate_.registerWorkerClient && this.delegate_.registerWorkerClient(client);
  }
  ServiceWorkerWorkerClientRegistryStub.prototype.cloneWorkerClientRegistry = function(host) {
    return this.delegate_ && this.delegate_.cloneWorkerClientRegistry && this.delegate_.cloneWorkerClientRegistry(host);
  }

  ServiceWorkerWorkerClientRegistryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name:
      var params = reader.decodeStruct(ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params);
      this.registerWorkerClient(params.client);
      return true;
    case kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name:
      var params = reader.decodeStruct(ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params);
      this.cloneWorkerClientRegistry(params.host);
      return true;
    default:
      return false;
    }
  };

  ServiceWorkerWorkerClientRegistryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateServiceWorkerWorkerClientRegistryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerWorkerClientRegistry_RegisterWorkerClient_Params;
      break;
      case kServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceWorkerWorkerClientRegistry_CloneWorkerClientRegistry_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceWorkerWorkerClientRegistryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ServiceWorkerWorkerClientRegistry = {
    name: 'blink.mojom.ServiceWorkerWorkerClientRegistry',
    kVersion: 0,
    ptrClass: ServiceWorkerWorkerClientRegistryPtr,
    proxyClass: ServiceWorkerWorkerClientRegistryProxy,
    stubClass: ServiceWorkerWorkerClientRegistryStub,
    validateRequest: validateServiceWorkerWorkerClientRegistryRequest,
    validateResponse: null,
  };
  ServiceWorkerWorkerClientRegistryStub.prototype.validator = validateServiceWorkerWorkerClientRegistryRequest;
  ServiceWorkerWorkerClientRegistryProxy.prototype.validator = null;
  exports.ServiceWorkerWorkerClientRegistry = ServiceWorkerWorkerClientRegistry;
  exports.ServiceWorkerWorkerClientRegistryPtr = ServiceWorkerWorkerClientRegistryPtr;
  exports.ServiceWorkerWorkerClientRegistryAssociatedPtr = ServiceWorkerWorkerClientRegistryAssociatedPtr;
})();