// third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var safe_url_pattern$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/safe_url_pattern.mojom', '../safe_url_pattern.mojom.js');
  }


  var ServiceWorkerRouterRunningStatusEnum = {};
  ServiceWorkerRouterRunningStatusEnum.kRunning = 0;
  ServiceWorkerRouterRunningStatusEnum.kNotRunning = 1;
  ServiceWorkerRouterRunningStatusEnum.MIN_VALUE = 0;
  ServiceWorkerRouterRunningStatusEnum.MAX_VALUE = 1;

  ServiceWorkerRouterRunningStatusEnum.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ServiceWorkerRouterRunningStatusEnum.toKnownEnumValue = function(value) {
    return value;
  };

  ServiceWorkerRouterRunningStatusEnum.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ServiceWorkerRouterRunningStatusCondition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterRunningStatusCondition.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  ServiceWorkerRouterRunningStatusCondition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterRunningStatusCondition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterRunningStatusCondition.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ServiceWorkerRouterRunningStatusEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterRunningStatusCondition.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRouterRunningStatusCondition.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterRunningStatusCondition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(ServiceWorkerRouterRunningStatusEnum));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRouterRunningStatusCondition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterRunningStatusCondition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerRouterRequestCondition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterRequestCondition.prototype.initDefaults_ = function() {
    this.method = null;
    this.hasMode = false;
    this.hasDestination = false;
    this.mode = 0;
    this.destination = 0;
  };
  ServiceWorkerRouterRequestCondition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterRequestCondition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterRequestCondition.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRouterRequestCondition.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, fetch_api$.RequestMode);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ServiceWorkerRouterRequestCondition.destination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterRequestCondition.encodedSize = codec.kStructHeaderSize + 24;

  ServiceWorkerRouterRequestCondition.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterRequestCondition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.method =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.hasMode = (packed >> 0) & 1 ? true : false;
    val.hasDestination = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.mode =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestMode));
    val.destination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceWorkerRouterRequestCondition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterRequestCondition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.method);
    packed = 0;
    packed |= (val.hasMode & 1) << 0
    packed |= (val.hasDestination & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStruct(codec.Int32, val.destination);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceWorkerRouterOrCondition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterOrCondition.prototype.initDefaults_ = function() {
    this.conditions = null;
  };
  ServiceWorkerRouterOrCondition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterOrCondition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterOrCondition.conditions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ServiceWorkerRouterCondition), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterOrCondition.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRouterOrCondition.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterOrCondition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.conditions =
        decoder.decodeArrayPointer(new codec.PointerTo(ServiceWorkerRouterCondition));
    return val;
  };

  ServiceWorkerRouterOrCondition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterOrCondition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ServiceWorkerRouterCondition), val.conditions);
  };
  function ServiceWorkerRouterNotCondition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterNotCondition.prototype.initDefaults_ = function() {
    this.condition = null;
  };
  ServiceWorkerRouterNotCondition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterNotCondition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterNotCondition.condition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ServiceWorkerRouterCondition, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterNotCondition.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRouterNotCondition.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterNotCondition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.condition =
        decoder.decodeStructPointer(ServiceWorkerRouterCondition);
    return val;
  };

  ServiceWorkerRouterNotCondition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterNotCondition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ServiceWorkerRouterCondition, val.condition);
  };
  function ServiceWorkerRouterCondition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterCondition.prototype.initDefaults_ = function() {
    this.urlPattern = null;
    this.request = null;
    this.runningStatus = null;
    this.orCondition = null;
    this.notCondition = null;
  };
  ServiceWorkerRouterCondition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterCondition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterCondition.urlPattern
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, safe_url_pattern$.SafeUrlPattern, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterCondition.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ServiceWorkerRouterRequestCondition, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterCondition.runningStatus
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ServiceWorkerRouterRunningStatusCondition, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterCondition.orCondition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ServiceWorkerRouterOrCondition, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterCondition.notCondition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, ServiceWorkerRouterNotCondition, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterCondition.encodedSize = codec.kStructHeaderSize + 40;

  ServiceWorkerRouterCondition.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterCondition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urlPattern =
        decoder.decodeStructPointer(safe_url_pattern$.SafeUrlPattern);
    val.request =
        decoder.decodeStructPointer(ServiceWorkerRouterRequestCondition);
    val.runningStatus =
        decoder.decodeStructPointer(ServiceWorkerRouterRunningStatusCondition);
    val.orCondition =
        decoder.decodeStructPointer(ServiceWorkerRouterOrCondition);
    val.notCondition =
        decoder.decodeStructPointer(ServiceWorkerRouterNotCondition);
    return val;
  };

  ServiceWorkerRouterCondition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterCondition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(safe_url_pattern$.SafeUrlPattern, val.urlPattern);
    encoder.encodeStructPointer(ServiceWorkerRouterRequestCondition, val.request);
    encoder.encodeStructPointer(ServiceWorkerRouterRunningStatusCondition, val.runningStatus);
    encoder.encodeStructPointer(ServiceWorkerRouterOrCondition, val.orCondition);
    encoder.encodeStructPointer(ServiceWorkerRouterNotCondition, val.notCondition);
  };
  function ServiceWorkerRouterNetworkSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterNetworkSource.prototype.initDefaults_ = function() {
  };
  ServiceWorkerRouterNetworkSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterNetworkSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterNetworkSource.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerRouterNetworkSource.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterNetworkSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerRouterNetworkSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterNetworkSource.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerRouterRaceNetworkAndFetchEventSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterRaceNetworkAndFetchEventSource.prototype.initDefaults_ = function() {
  };
  ServiceWorkerRouterRaceNetworkAndFetchEventSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterRaceNetworkAndFetchEventSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterRaceNetworkAndFetchEventSource.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerRouterRaceNetworkAndFetchEventSource.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterRaceNetworkAndFetchEventSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerRouterRaceNetworkAndFetchEventSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterRaceNetworkAndFetchEventSource.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerRouterFetchEventSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterFetchEventSource.prototype.initDefaults_ = function() {
  };
  ServiceWorkerRouterFetchEventSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterFetchEventSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterFetchEventSource.encodedSize = codec.kStructHeaderSize + 0;

  ServiceWorkerRouterFetchEventSource.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterFetchEventSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ServiceWorkerRouterFetchEventSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterFetchEventSource.encodedSize);
    encoder.writeUint32(0);
  };
  function ServiceWorkerRouterCacheSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterCacheSource.prototype.initDefaults_ = function() {
    this.cacheName = null;
  };
  ServiceWorkerRouterCacheSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterCacheSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterCacheSource.cacheName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterCacheSource.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRouterCacheSource.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterCacheSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ServiceWorkerRouterCacheSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterCacheSource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.cacheName);
  };
  function ServiceWorkerRouterRaceNetworkAndCacheSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterRaceNetworkAndCacheSource.prototype.initDefaults_ = function() {
    this.cacheSource = null;
  };
  ServiceWorkerRouterRaceNetworkAndCacheSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterRaceNetworkAndCacheSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterRaceNetworkAndCacheSource.cacheSource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ServiceWorkerRouterCacheSource, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterRaceNetworkAndCacheSource.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRouterRaceNetworkAndCacheSource.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterRaceNetworkAndCacheSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cacheSource =
        decoder.decodeStructPointer(ServiceWorkerRouterCacheSource);
    return val;
  };

  ServiceWorkerRouterRaceNetworkAndCacheSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterRaceNetworkAndCacheSource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ServiceWorkerRouterCacheSource, val.cacheSource);
  };
  function ServiceWorkerRouterRule(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterRule.prototype.initDefaults_ = function() {
    this.condition = null;
    this.sources = null;
  };
  ServiceWorkerRouterRule.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterRule.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterRule.condition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ServiceWorkerRouterCondition, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterRule.sources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, ServiceWorkerRouterSource, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterRule.encodedSize = codec.kStructHeaderSize + 16;

  ServiceWorkerRouterRule.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterRule();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.condition =
        decoder.decodeStructPointer(ServiceWorkerRouterCondition);
    val.sources =
        decoder.decodeArrayPointer(ServiceWorkerRouterSource);
    return val;
  };

  ServiceWorkerRouterRule.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterRule.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ServiceWorkerRouterCondition, val.condition);
    encoder.encodeArrayPointer(ServiceWorkerRouterSource, val.sources);
  };
  function ServiceWorkerRouterRules(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerRouterRules.prototype.initDefaults_ = function() {
    this.rules = null;
  };
  ServiceWorkerRouterRules.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerRouterRules.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerRouterRules.rules
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ServiceWorkerRouterRule), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerRouterRules.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerRouterRules.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerRouterRules();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rules =
        decoder.decodeArrayPointer(new codec.PointerTo(ServiceWorkerRouterRule));
    return val;
  };

  ServiceWorkerRouterRules.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerRouterRules.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ServiceWorkerRouterRule), val.rules);
  };

  function ServiceWorkerRouterSource(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ServiceWorkerRouterSource.Tags = {
    networkSource: 0,
    raceNetworkAndFetchEventSource: 1,
    fetchEventSource: 2,
    cacheSource: 3,
    raceNetworkAndCacheSource: 4,
  };

  ServiceWorkerRouterSource.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ServiceWorkerRouterSource.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "networkSource",
        "raceNetworkAndFetchEventSource",
        "fetchEventSource",
        "cacheSource",
        "raceNetworkAndCacheSource",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ServiceWorkerRouterSource member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ServiceWorkerRouterSource.prototype, "networkSource", {
    get: function() {
      if (this.$tag != ServiceWorkerRouterSource.Tags.networkSource) {
        throw new ReferenceError(
            "ServiceWorkerRouterSource.networkSource is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ServiceWorkerRouterSource.Tags.networkSource;
      this.$data = value;
    }
  });
  Object.defineProperty(ServiceWorkerRouterSource.prototype, "raceNetworkAndFetchEventSource", {
    get: function() {
      if (this.$tag != ServiceWorkerRouterSource.Tags.raceNetworkAndFetchEventSource) {
        throw new ReferenceError(
            "ServiceWorkerRouterSource.raceNetworkAndFetchEventSource is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ServiceWorkerRouterSource.Tags.raceNetworkAndFetchEventSource;
      this.$data = value;
    }
  });
  Object.defineProperty(ServiceWorkerRouterSource.prototype, "fetchEventSource", {
    get: function() {
      if (this.$tag != ServiceWorkerRouterSource.Tags.fetchEventSource) {
        throw new ReferenceError(
            "ServiceWorkerRouterSource.fetchEventSource is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ServiceWorkerRouterSource.Tags.fetchEventSource;
      this.$data = value;
    }
  });
  Object.defineProperty(ServiceWorkerRouterSource.prototype, "cacheSource", {
    get: function() {
      if (this.$tag != ServiceWorkerRouterSource.Tags.cacheSource) {
        throw new ReferenceError(
            "ServiceWorkerRouterSource.cacheSource is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ServiceWorkerRouterSource.Tags.cacheSource;
      this.$data = value;
    }
  });
  Object.defineProperty(ServiceWorkerRouterSource.prototype, "raceNetworkAndCacheSource", {
    get: function() {
      if (this.$tag != ServiceWorkerRouterSource.Tags.raceNetworkAndCacheSource) {
        throw new ReferenceError(
            "ServiceWorkerRouterSource.raceNetworkAndCacheSource is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ServiceWorkerRouterSource.Tags.raceNetworkAndCacheSource;
      this.$data = value;
    }
  });


    ServiceWorkerRouterSource.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ServiceWorkerRouterSource.Tags.networkSource:
          encoder.encodeStructPointer(ServiceWorkerRouterNetworkSource, val.networkSource);
          break;
        case ServiceWorkerRouterSource.Tags.raceNetworkAndFetchEventSource:
          encoder.encodeStructPointer(ServiceWorkerRouterRaceNetworkAndFetchEventSource, val.raceNetworkAndFetchEventSource);
          break;
        case ServiceWorkerRouterSource.Tags.fetchEventSource:
          encoder.encodeStructPointer(ServiceWorkerRouterFetchEventSource, val.fetchEventSource);
          break;
        case ServiceWorkerRouterSource.Tags.cacheSource:
          encoder.encodeStructPointer(ServiceWorkerRouterCacheSource, val.cacheSource);
          break;
        case ServiceWorkerRouterSource.Tags.raceNetworkAndCacheSource:
          encoder.encodeStructPointer(ServiceWorkerRouterRaceNetworkAndCacheSource, val.raceNetworkAndCacheSource);
          break;
      }
      encoder.align();
    };


    ServiceWorkerRouterSource.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ServiceWorkerRouterSource();
      var tag = decoder.readUint32();
      switch (tag) {
        case ServiceWorkerRouterSource.Tags.networkSource:
          result.networkSource = decoder.decodeStructPointer(ServiceWorkerRouterNetworkSource);
          break;
        case ServiceWorkerRouterSource.Tags.raceNetworkAndFetchEventSource:
          result.raceNetworkAndFetchEventSource = decoder.decodeStructPointer(ServiceWorkerRouterRaceNetworkAndFetchEventSource);
          break;
        case ServiceWorkerRouterSource.Tags.fetchEventSource:
          result.fetchEventSource = decoder.decodeStructPointer(ServiceWorkerRouterFetchEventSource);
          break;
        case ServiceWorkerRouterSource.Tags.cacheSource:
          result.cacheSource = decoder.decodeStructPointer(ServiceWorkerRouterCacheSource);
          break;
        case ServiceWorkerRouterSource.Tags.raceNetworkAndCacheSource:
          result.raceNetworkAndCacheSource = decoder.decodeStructPointer(ServiceWorkerRouterRaceNetworkAndCacheSource);
          break;
      }
      decoder.align();

      return result;
    };


    ServiceWorkerRouterSource.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ServiceWorkerRouterSource.Tags.networkSource:
          

    // validate ServiceWorkerRouterSource.networkSource
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerRouterNetworkSource, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ServiceWorkerRouterSource.Tags.raceNetworkAndFetchEventSource:
          

    // validate ServiceWorkerRouterSource.raceNetworkAndFetchEventSource
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerRouterRaceNetworkAndFetchEventSource, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ServiceWorkerRouterSource.Tags.fetchEventSource:
          

    // validate ServiceWorkerRouterSource.fetchEventSource
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerRouterFetchEventSource, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ServiceWorkerRouterSource.Tags.cacheSource:
          

    // validate ServiceWorkerRouterSource.cacheSource
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerRouterCacheSource, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ServiceWorkerRouterSource.Tags.raceNetworkAndCacheSource:
          

    // validate ServiceWorkerRouterSource.raceNetworkAndCacheSource
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerRouterRaceNetworkAndCacheSource, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  ServiceWorkerRouterSource.encodedSize = 16;
  exports.ServiceWorkerRouterRunningStatusEnum = ServiceWorkerRouterRunningStatusEnum;
  exports.ServiceWorkerRouterRunningStatusCondition = ServiceWorkerRouterRunningStatusCondition;
  exports.ServiceWorkerRouterRequestCondition = ServiceWorkerRouterRequestCondition;
  exports.ServiceWorkerRouterOrCondition = ServiceWorkerRouterOrCondition;
  exports.ServiceWorkerRouterNotCondition = ServiceWorkerRouterNotCondition;
  exports.ServiceWorkerRouterCondition = ServiceWorkerRouterCondition;
  exports.ServiceWorkerRouterNetworkSource = ServiceWorkerRouterNetworkSource;
  exports.ServiceWorkerRouterRaceNetworkAndFetchEventSource = ServiceWorkerRouterRaceNetworkAndFetchEventSource;
  exports.ServiceWorkerRouterFetchEventSource = ServiceWorkerRouterFetchEventSource;
  exports.ServiceWorkerRouterCacheSource = ServiceWorkerRouterCacheSource;
  exports.ServiceWorkerRouterRaceNetworkAndCacheSource = ServiceWorkerRouterRaceNetworkAndCacheSource;
  exports.ServiceWorkerRouterRule = ServiceWorkerRouterRule;
  exports.ServiceWorkerRouterRules = ServiceWorkerRouterRules;
  exports.ServiceWorkerRouterSource = ServiceWorkerRouterSource;
})();