// third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ServiceWorkerRouterRunningStatusEnumToStringHelper(ServiceWorkerRouterRunningStatusEnum value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ServiceWorkerRouterRunningStatusEnum::kRunning:
      return "kRunning";
    case ServiceWorkerRouterRunningStatusEnum::kNotRunning:
      return "kNotRunning";
    default:
      return nullptr;
  }
}

std::string ServiceWorkerRouterRunningStatusEnumToString(ServiceWorkerRouterRunningStatusEnum value) {
  const char *str = ServiceWorkerRouterRunningStatusEnumToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ServiceWorkerRouterRunningStatusEnum value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ServiceWorkerRouterRunningStatusEnum value) {
  return os << ServiceWorkerRouterRunningStatusEnumToString(value);
}

namespace internal {
// static
bool ServiceWorkerRouterSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ServiceWorkerRouterSource_Data* object = static_cast<const ServiceWorkerRouterSource_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ServiceWorkerRouterSource_Tag::kNetworkSource: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_network_source, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_network_source, validation_context))
        return false;
      return true;
    }
    case ServiceWorkerRouterSource_Tag::kRaceNetworkAndFetchEventSource: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_race_network_and_fetch_event_source, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_race_network_and_fetch_event_source, validation_context))
        return false;
      return true;
    }
    case ServiceWorkerRouterSource_Tag::kFetchEventSource: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_fetch_event_source, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_fetch_event_source, validation_context))
        return false;
      return true;
    }
    case ServiceWorkerRouterSource_Tag::kCacheSource: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cache_source, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_cache_source, validation_context))
        return false;
      return true;
    }
    case ServiceWorkerRouterSource_Tag::kRaceNetworkAndCacheSource: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_race_network_and_cache_source, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_race_network_and_cache_source, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ServiceWorkerRouterSource");
      return false;
    }
  }
}


// static
bool ServiceWorkerRouterRunningStatusCondition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterRunningStatusCondition_Data* object =
      static_cast<const ServiceWorkerRouterRunningStatusCondition_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerRouterRunningStatusEnum_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ServiceWorkerRouterRunningStatusCondition_Data::ServiceWorkerRouterRunningStatusCondition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterRequestCondition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterRequestCondition_Data* object =
      static_cast<const ServiceWorkerRouterRequestCondition_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;

  return true;
}

ServiceWorkerRouterRequestCondition_Data::ServiceWorkerRouterRequestCondition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterOrCondition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterOrCondition_Data* object =
      static_cast<const ServiceWorkerRouterOrCondition_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conditions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& conditions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->conditions, validation_context,
                                         &conditions_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRouterOrCondition_Data::ServiceWorkerRouterOrCondition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterNotCondition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterNotCondition_Data* object =
      static_cast<const ServiceWorkerRouterNotCondition_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->condition, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->condition, validation_context))
    return false;

  return true;
}

ServiceWorkerRouterNotCondition_Data::ServiceWorkerRouterNotCondition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterCondition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterCondition_Data* object =
      static_cast<const ServiceWorkerRouterCondition_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url_pattern, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->running_status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->or_condition, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->not_condition, validation_context))
    return false;

  return true;
}

ServiceWorkerRouterCondition_Data::ServiceWorkerRouterCondition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterNetworkSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterNetworkSource_Data* object =
      static_cast<const ServiceWorkerRouterNetworkSource_Data*>(data);

  return true;
}

ServiceWorkerRouterNetworkSource_Data::ServiceWorkerRouterNetworkSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterRaceNetworkAndFetchEventSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterRaceNetworkAndFetchEventSource_Data* object =
      static_cast<const ServiceWorkerRouterRaceNetworkAndFetchEventSource_Data*>(data);

  return true;
}

ServiceWorkerRouterRaceNetworkAndFetchEventSource_Data::ServiceWorkerRouterRaceNetworkAndFetchEventSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterFetchEventSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterFetchEventSource_Data* object =
      static_cast<const ServiceWorkerRouterFetchEventSource_Data*>(data);

  return true;
}

ServiceWorkerRouterFetchEventSource_Data::ServiceWorkerRouterFetchEventSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterCacheSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterCacheSource_Data* object =
      static_cast<const ServiceWorkerRouterCacheSource_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& cache_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cache_name, validation_context,
                                         &cache_name_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRouterCacheSource_Data::ServiceWorkerRouterCacheSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterRaceNetworkAndCacheSource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterRaceNetworkAndCacheSource_Data* object =
      static_cast<const ServiceWorkerRouterRaceNetworkAndCacheSource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_source, validation_context))
    return false;

  return true;
}

ServiceWorkerRouterRaceNetworkAndCacheSource_Data::ServiceWorkerRouterRaceNetworkAndCacheSource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterRule_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterRule_Data* object =
      static_cast<const ServiceWorkerRouterRule_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->condition, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->condition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRouterRule_Data::ServiceWorkerRouterRule_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerRouterRules_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterRules_Data* object =
      static_cast<const ServiceWorkerRouterRules_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rules, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& rules_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->rules, validation_context,
                                         &rules_validate_params)) {
    return false;
  }

  return true;
}

ServiceWorkerRouterRules_Data::ServiceWorkerRouterRules_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ServiceWorkerRouterRunningStatusEnum>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ServiceWorkerRouterRunningStatusEnum value) {
  return std::move(context).WriteString(::blink::mojom::ServiceWorkerRouterRunningStatusEnumToString(value));
}

} // namespace perfetto