// third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.Url');






goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHost');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHostReceiver');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHostCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHostInterface');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerInstalledScriptsManagerHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerInstalledScriptsManagerHostInterface = class {
  
  /**
   * @param { !url.mojom.Url } scriptUrl
   */

  requestInstalledScript(scriptUrl) {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerInstalledScriptsManagerHostInterface }
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerInstalledScriptsManagerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerInstalledScriptsManagerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerInstalledScriptsManagerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } scriptUrl
   */

  requestInstalledScript(
      scriptUrl) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
        null,
        [
          scriptUrl
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerHostReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerInstalledScriptsManagerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
        null,
        impl.requestInstalledScript.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerInstalledScriptsManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestInstalledScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
        null,
        this.requestInstalledScript.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManager');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerReceiver');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerInterface');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerRemote');
goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerInstalledScriptsManager.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerInstalledScriptsManagerInterface = class {
  
  /**
   * @param { !blink.mojom.ServiceWorkerScriptInfo } scriptInfo
   */

  transferInstalledScript(scriptInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerInstalledScriptsManagerInterface }
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerScriptInfo } scriptInfo
   */

  transferInstalledScript(
      scriptInfo) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
        null,
        [
          scriptInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerInstalledScriptsManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerInstalledScriptsManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerInstalledScriptsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerInstalledScriptsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
        null,
        impl.transferInstalledScript.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerInstalledScriptsManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerInstalledScriptsManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerInstalledScriptsManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerInstalledScriptsManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerInstalledScriptsManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerInstalledScriptsManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transferInstalledScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
        null,
        this.transferInstalledScript.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorkerInstalledScriptsInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerScriptInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerScriptInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ServiceWorkerInstalledScriptsInfoSpec.$,
    'ServiceWorkerInstalledScriptsInfo',
    [
      mojo.internal.StructField(
        'managerReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'managerHostRemote', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'installedUrls', 16,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerInstalledScriptsInfo');

/** @record */
blink.mojom.ServiceWorkerInstalledScriptsInfo = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerInstalledScriptsManagerPendingReceiver } */
    this.managerReceiver;
    /** @export { !blink.mojom.ServiceWorkerInstalledScriptsManagerHostRemote } */
    this.managerHostRemote;
    /** @export { !Array<!url.mojom.Url> } */
    this.installedUrls;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerScriptInfoSpec.$,
    'ServiceWorkerScriptInfo',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encoding', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'headers', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'body', 24,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bodySize', 32,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metaData', 28,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metaDataSize', 40,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.ServiceWorkerScriptInfo');

/** @record */
blink.mojom.ServiceWorkerScriptInfo = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.scriptUrl;
    /** @export { !string } */
    this.encoding;
    /** @export { !Object<!string, !string> } */
    this.headers;
    /** @export { !MojoHandle } */
    this.body;
    /** @export { !bigint } */
    this.bodySize;
    /** @export { (MojoHandle|undefined) } */
    this.metaData;
    /** @export { !bigint } */
    this.metaDataSize;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsSpec.$,
    'ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params');

/** @record */
blink.mojom.ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.scriptUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsSpec.$,
    'ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params',
    [
      mojo.internal.StructField(
        'scriptInfo', 0,
        0,
        blink.mojom.ServiceWorkerScriptInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params');

/** @record */
blink.mojom.ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerScriptInfo } */
    this.scriptInfo;
  }
};

