// third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_INSTALLED_SCRIPTS_MANAGER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_INSTALLED_SCRIPTS_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class ServiceWorkerInstalledScriptsInfoDataView;

class ServiceWorkerScriptInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerInstalledScriptsInfoDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerInstalledScriptsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerScriptInfoDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerScriptInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class ServiceWorkerInstalledScriptsManagerHostInterfaceBase {};

using ServiceWorkerInstalledScriptsManagerHostPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerInstalledScriptsManagerHostInterfaceBase>;
using ServiceWorkerInstalledScriptsManagerHostRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerInstalledScriptsManagerHostInterfaceBase>;
using ServiceWorkerInstalledScriptsManagerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerInstalledScriptsManagerHostInterfaceBase>;
using ServiceWorkerInstalledScriptsManagerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerInstalledScriptsManagerHostInterfaceBase>;
class ServiceWorkerInstalledScriptsManagerInterfaceBase {};

using ServiceWorkerInstalledScriptsManagerPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerInstalledScriptsManagerInterfaceBase>;
using ServiceWorkerInstalledScriptsManagerRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerInstalledScriptsManagerInterfaceBase>;
using ServiceWorkerInstalledScriptsManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerInstalledScriptsManagerInterfaceBase>;
using ServiceWorkerInstalledScriptsManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerInstalledScriptsManagerInterfaceBase>;


class ServiceWorkerInstalledScriptsInfoDataView {
 public:
  ServiceWorkerInstalledScriptsInfoDataView() = default;

  ServiceWorkerInstalledScriptsInfoDataView(
      internal::ServiceWorkerInstalledScriptsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeManagerReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ServiceWorkerInstalledScriptsManagerInterfaceBase>>(
            &data_->manager_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeManagerHostRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::ServiceWorkerInstalledScriptsManagerHostInterfaceBase>>(
            &data_->manager_host_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetInstalledUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstalledUrls(UserType* output) {
    
    auto* pointer = data_->installed_urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceWorkerInstalledScriptsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceWorkerScriptInfoDataView {
 public:
  ServiceWorkerScriptInfoDataView() = default;

  ServiceWorkerScriptInfoDataView(
      internal::ServiceWorkerScriptInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScriptUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptUrl(UserType* output) {
    
    auto* pointer = data_->script_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncoding(UserType* output) {
    
    auto* pointer = data_->encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeBody() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->body, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint64_t body_size() const {
    return data_->body_size;
  }
  mojo::ScopedDataPipeConsumerHandle TakeMetaData() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->meta_data, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint64_t meta_data_size() const {
    return data_->meta_data_size;
  }
 private:
  internal::ServiceWorkerScriptInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_INSTALLED_SCRIPTS_MANAGER_MOJOM_DATA_VIEW_H_