// third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
ServiceWorkerInstalledScriptsInfo::ServiceWorkerInstalledScriptsInfo()
    : manager_receiver(),
      manager_host_remote(),
      installed_urls() {}

ServiceWorkerInstalledScriptsInfo::ServiceWorkerInstalledScriptsInfo(
    ::mojo::PendingReceiver<ServiceWorkerInstalledScriptsManager> manager_receiver_in,
    ::mojo::PendingRemote<ServiceWorkerInstalledScriptsManagerHost> manager_host_remote_in,
    ::blink::Vector<::blink::KURL> installed_urls_in)
    : manager_receiver(std::move(manager_receiver_in)),
      manager_host_remote(std::move(manager_host_remote_in)),
      installed_urls(std::move(installed_urls_in)) {}

ServiceWorkerInstalledScriptsInfo::~ServiceWorkerInstalledScriptsInfo() = default;

void ServiceWorkerInstalledScriptsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manager_receiver"), this->manager_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<ServiceWorkerInstalledScriptsManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manager_host_remote"), this->manager_host_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<ServiceWorkerInstalledScriptsManagerHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installed_urls"), this->installed_urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerInstalledScriptsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerScriptInfo::ServiceWorkerScriptInfo()
    : script_url(),
      encoding(),
      headers(),
      body(),
      body_size(),
      meta_data(),
      meta_data_size() {}

ServiceWorkerScriptInfo::ServiceWorkerScriptInfo(
    const ::blink::KURL& script_url_in,
    const ::blink::String& encoding_in,
    const ::blink::HashMap<::blink::String, ::blink::String>& headers_in,
    ::mojo::ScopedDataPipeConsumerHandle body_in,
    uint64_t body_size_in,
    ::mojo::ScopedDataPipeConsumerHandle meta_data_in,
    uint64_t meta_data_size_in)
    : script_url(std::move(script_url_in)),
      encoding(std::move(encoding_in)),
      headers(std::move(headers_in)),
      body(std::move(body_in)),
      body_size(std::move(body_size_in)),
      meta_data(std::move(meta_data_in)),
      meta_data_size(std::move(meta_data_size_in)) {}

ServiceWorkerScriptInfo::~ServiceWorkerScriptInfo() = default;

void ServiceWorkerScriptInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoding"), this->encoding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headers"), this->headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::blink::String, ::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body_size"), this->body_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_data"), this->meta_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meta_data_size"), this->meta_data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerScriptInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceWorkerInstalledScriptsManagerHost::IPCStableHashFunction ServiceWorkerInstalledScriptsManagerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerInstalledScriptsManagerHost>(message.name())) {
    case messages::ServiceWorkerInstalledScriptsManagerHost::kRequestInstalledScript: {
      return &ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerInstalledScriptsManagerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerInstalledScriptsManagerHost>(message.name())) {
      case messages::ServiceWorkerInstalledScriptsManagerHost::kRequestInstalledScript:
            return "Receive blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerInstalledScriptsManagerHost>(message.name())) {
      case messages::ServiceWorkerInstalledScriptsManagerHost::kRequestInstalledScript:
            return "Receive reply blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8cffa21;  // IPCStableHash for blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerInstalledScriptsManagerHostProxy::ServiceWorkerInstalledScriptsManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerInstalledScriptsManagerHostProxy::RequestInstalledScript(
    const ::blink::KURL& in_script_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerInstalledScriptsManagerHost::RequestInstalledScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_url"), in_script_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerInstalledScriptsManagerHost::kRequestInstalledScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_url)::BaseType> script_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_script_url,
    script_url_fragment);

  params->script_url.Set(
      script_url_fragment.is_null() ? nullptr : script_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_url in ServiceWorkerInstalledScriptsManagerHost.RequestInstalledScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerInstalledScriptsManagerHost::Name_);
  message.set_method_name("RequestInstalledScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceWorkerInstalledScriptsManagerHostStubDispatch::Accept(
    ServiceWorkerInstalledScriptsManagerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerInstalledScriptsManagerHost>(message->header()->name)) {
    case messages::ServiceWorkerInstalledScriptsManagerHost::kRequestInstalledScript: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerInstalledScriptsManagerHost.0
      bool success = true;
      ::blink::KURL p_script_url{};
      ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptUrl(&p_script_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerInstalledScriptsManagerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestInstalledScript(        
        std::move(p_script_url));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerInstalledScriptsManagerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerInstalledScriptsManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerInstalledScriptsManagerHost>(message->header()->name)) {
    case messages::ServiceWorkerInstalledScriptsManagerHost::kRequestInstalledScript: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerInstalledScriptsManagerHostValidationInfo[] = {
    { &internal::ServiceWorkerInstalledScriptsManagerHost_RequestInstalledScript_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerInstalledScriptsManagerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerInstalledScriptsManagerHost::Name_,
    kServiceWorkerInstalledScriptsManagerHostValidationInfo);
}

// The declaration includes the definition on other builds.

ServiceWorkerInstalledScriptsManager::IPCStableHashFunction ServiceWorkerInstalledScriptsManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerInstalledScriptsManager>(message.name())) {
    case messages::ServiceWorkerInstalledScriptsManager::kTransferInstalledScript: {
      return &ServiceWorkerInstalledScriptsManager::TransferInstalledScript_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerInstalledScriptsManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerInstalledScriptsManager>(message.name())) {
      case messages::ServiceWorkerInstalledScriptsManager::kTransferInstalledScript:
            return "Receive blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerInstalledScriptsManager>(message.name())) {
      case messages::ServiceWorkerInstalledScriptsManager::kTransferInstalledScript:
            return "Receive reply blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerInstalledScriptsManager::TransferInstalledScript_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x684ca8cb;  // IPCStableHash for blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerInstalledScriptsManagerProxy::ServiceWorkerInstalledScriptsManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerInstalledScriptsManagerProxy::TransferInstalledScript(
    ServiceWorkerScriptInfoPtr in_script_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ServiceWorkerInstalledScriptsManager::TransferInstalledScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_info"), in_script_info,
                        "<value of type ServiceWorkerScriptInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerInstalledScriptsManager::kTransferInstalledScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script_info)::BaseType> script_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerScriptInfoDataView>(
    in_script_info,
    script_info_fragment);

  params->script_info.Set(
      script_info_fragment.is_null() ? nullptr : script_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_info in ServiceWorkerInstalledScriptsManager.TransferInstalledScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerInstalledScriptsManager::Name_);
  message.set_method_name("TransferInstalledScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceWorkerInstalledScriptsManagerStubDispatch::Accept(
    ServiceWorkerInstalledScriptsManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerInstalledScriptsManager>(message->header()->name)) {
    case messages::ServiceWorkerInstalledScriptsManager::kTransferInstalledScript: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerInstalledScriptsManager.0
      bool success = true;
      ServiceWorkerScriptInfoPtr p_script_info{};
      ServiceWorkerInstalledScriptsManager_TransferInstalledScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScriptInfo(&p_script_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerInstalledScriptsManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TransferInstalledScript(        
        std::move(p_script_info));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerInstalledScriptsManagerStubDispatch::AcceptWithResponder(
    ServiceWorkerInstalledScriptsManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerInstalledScriptsManager>(message->header()->name)) {
    case messages::ServiceWorkerInstalledScriptsManager::kTransferInstalledScript: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerInstalledScriptsManagerValidationInfo[] = {
    { &internal::ServiceWorkerInstalledScriptsManager_TransferInstalledScript_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerInstalledScriptsManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerInstalledScriptsManager::Name_,
    kServiceWorkerInstalledScriptsManagerValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerInstalledScriptsInfo::DataView, ::blink::mojom::blink::ServiceWorkerInstalledScriptsInfoPtr>::Read(
    ::blink::mojom::blink::ServiceWorkerInstalledScriptsInfo::DataView input,
    ::blink::mojom::blink::ServiceWorkerInstalledScriptsInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerInstalledScriptsInfoPtr result(::blink::mojom::blink::ServiceWorkerInstalledScriptsInfo::New());
  
      if (success) {
        result->manager_receiver =
            input.TakeManagerReceiver<decltype(result->manager_receiver)>();
      }
      if (success) {
        result->manager_host_remote =
            input.TakeManagerHostRemote<decltype(result->manager_host_remote)>();
      }
      if (success && !input.ReadInstalledUrls(&result->installed_urls))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerScriptInfo::DataView, ::blink::mojom::blink::ServiceWorkerScriptInfoPtr>::Read(
    ::blink::mojom::blink::ServiceWorkerScriptInfo::DataView input,
    ::blink::mojom::blink::ServiceWorkerScriptInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerScriptInfoPtr result(::blink::mojom::blink::ServiceWorkerScriptInfo::New());
  
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
      if (success && !input.ReadEncoding(&result->encoding))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success)
        result->body = input.TakeBody();
      if (success)
        result->body_size = input.body_size();
      if (success)
        result->meta_data = input.TakeMetaData();
      if (success)
        result->meta_data_size = input.meta_data_size();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ServiceWorkerInstalledScriptsManagerHostInterceptorForTesting::RequestInstalledScript(const ::blink::KURL& script_url) {
  GetForwardingInterface()->RequestInstalledScript(
    std::move(script_url)
    );
}
ServiceWorkerInstalledScriptsManagerHostAsyncWaiter::ServiceWorkerInstalledScriptsManagerHostAsyncWaiter(
    ServiceWorkerInstalledScriptsManagerHost* proxy) : proxy_(proxy) {}

ServiceWorkerInstalledScriptsManagerHostAsyncWaiter::~ServiceWorkerInstalledScriptsManagerHostAsyncWaiter() = default;





void ServiceWorkerInstalledScriptsManagerInterceptorForTesting::TransferInstalledScript(ServiceWorkerScriptInfoPtr script_info) {
  GetForwardingInterface()->TransferInstalledScript(
    std::move(script_info)
    );
}
ServiceWorkerInstalledScriptsManagerAsyncWaiter::ServiceWorkerInstalledScriptsManagerAsyncWaiter(
    ServiceWorkerInstalledScriptsManager* proxy) : proxy_(proxy) {}

ServiceWorkerInstalledScriptsManagerAsyncWaiter::~ServiceWorkerInstalledScriptsManagerAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif