// third_party/blink/public/mojom/service_worker/service_worker_container.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ServiceWorkerErrorType');
goog.require('blink.mojom.WebFeature');
goog.require('blink.mojom.ControllerServiceWorker');
goog.require('blink.mojom.ControllerServiceWorkerInfo');
goog.require('blink.mojom.FetchClientSettingsObject');
goog.require('mojoBase.mojom.FilePath');
goog.require('blink.mojom.ServiceWorkerObjectInfo');
goog.require('blink.mojom.ServiceWorkerRegistrationObjectInfo');
goog.require('blink.mojom.ServiceWorkerRegistrationOptions');
goog.require('blink.mojom.TransferableMessage');
goog.require('url.mojom.Url');




goog.provide('blink.mojom.ControllerServiceWorkerPurpose');
goog.provide('blink.mojom.ControllerServiceWorkerPurposeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.ControllerServiceWorkerPurposeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.ControllerServiceWorkerPurpose = {
  
  FETCH_SUB_RESOURCE: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



goog.provide('blink.mojom.ServiceWorkerContainerHost');
goog.provide('blink.mojom.ServiceWorkerContainerHostReceiver');
goog.provide('blink.mojom.ServiceWorkerContainerHostCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerContainerHostInterface');
goog.provide('blink.mojom.ServiceWorkerContainerHostRemote');
goog.provide('blink.mojom.ServiceWorkerContainerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerContainerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerContainerHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerContainerHostInterface = class {
  
  /**
   * @param { !url.mojom.Url } scriptUrl
   * @param { !blink.mojom.ServiceWorkerRegistrationOptions } options
   * @param { !blink.mojom.FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink.mojom.ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  register(scriptUrl, options, outsideFetchClientSettingsObject) {}
  
  /**
   * @param { !url.mojom.Url } clientUrl
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink.mojom.ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistration(clientUrl) {}
  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        infos: ?Array<!blink.mojom.ServiceWorkerRegistrationObjectInfo>,
   *  }>}
   */

  getRegistrations() {}
  
  /**
   * @return {!Promise<{
        registration: ?blink.mojom.ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistrationForReady() {}
  
  /**
   * @param { !blink.mojom.ControllerServiceWorkerPendingReceiver } receiver
   * @param { !blink.mojom.ControllerServiceWorkerPurpose } purpose
   */

  ensureControllerServiceWorker(receiver, purpose) {}
  
  /**
   * @param { !blink.mojom.ServiceWorkerContainerHostPendingReceiver } containerHost
   */

  cloneContainerHost(containerHost) {}
  
  /**
   */

  hintToUpdateServiceWorker() {}
  
  /**
   * @param { !Array<!mojoBase.mojom.FilePath> } files
   * @return {!Promise}
   */

  ensureFileAccess(files) {}
  
  /**
   */

  onExecutionReady() {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerContainerHostInterface }
 */
blink.mojom.ServiceWorkerContainerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerContainerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerContainerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerContainerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } scriptUrl
   * @param { !blink.mojom.ServiceWorkerRegistrationOptions } options
   * @param { !blink.mojom.FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink.mojom.ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  register(
      scriptUrl,
      options,
      outsideFetchClientSettingsObject) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerContainerHost_Register_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
        [
          scriptUrl,
          options,
          outsideFetchClientSettingsObject
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } clientUrl
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        registration: ?blink.mojom.ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistration(
      clientUrl) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
        [
          clientUrl
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink.mojom.ServiceWorkerErrorType,
        errorMsg: ?string,
        infos: ?Array<!blink.mojom.ServiceWorkerRegistrationObjectInfo>,
   *  }>}
   */

  getRegistrations() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        registration: ?blink.mojom.ServiceWorkerRegistrationObjectInfo,
   *  }>}
   */

  getRegistrationForReady() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ControllerServiceWorkerPendingReceiver } receiver
   * @param { !blink.mojom.ControllerServiceWorkerPurpose } purpose
   */

  ensureControllerServiceWorker(
      receiver,
      purpose) {
    this.proxy.sendMessage(
        4,
        blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
        null,
        [
          receiver,
          purpose
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerContainerHostPendingReceiver } containerHost
   */

  cloneContainerHost(
      containerHost) {
    this.proxy.sendMessage(
        5,
        blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
        null,
        [
          containerHost
        ],
        false);
  }

  
  /**
   */

  hintToUpdateServiceWorker() {
    this.proxy.sendMessage(
        6,
        blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!mojoBase.mojom.FilePath> } files
   * @return {!Promise}
   */

  ensureFileAccess(
      files) {
    return this.proxy.sendMessage(
        7,
        blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
        [
          files
        ],
        false);
  }

  
  /**
   */

  onExecutionReady() {
    this.proxy.sendMessage(
        8,
        blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerContainerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerContainerHostReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerContainerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerContainerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerContainerHost_Register_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
        impl.getRegistration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
        impl.getRegistrations.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
        impl.getRegistrationForReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
        null,
        impl.ensureControllerServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
        null,
        impl.cloneContainerHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
        null,
        impl.hintToUpdateServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
        impl.ensureFileAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
        null,
        impl.onExecutionReady.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerContainerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerContainerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerContainerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerContainerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerContainerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerContainerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerContainerHost_Register_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
        this.getRegistration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistrations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
        this.getRegistrations.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRegistrationForReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
        this.getRegistrationForReady.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ensureControllerServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
        null,
        this.ensureControllerServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cloneContainerHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
        null,
        this.cloneContainerHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hintToUpdateServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
        null,
        this.hintToUpdateServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ensureFileAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
        blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
        this.ensureFileAccess.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onExecutionReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
        null,
        this.onExecutionReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorkerContainer');
goog.provide('blink.mojom.ServiceWorkerContainerReceiver');
goog.provide('blink.mojom.ServiceWorkerContainerCallbackRouter');
goog.provide('blink.mojom.ServiceWorkerContainerInterface');
goog.provide('blink.mojom.ServiceWorkerContainerRemote');
goog.provide('blink.mojom.ServiceWorkerContainerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerContainerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerContainer.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ServiceWorkerContainerInterface = class {
  
  /**
   * @param { !blink.mojom.ControllerServiceWorkerInfo } controllerInfo
   * @param { !boolean } shouldNotifyControllerchange
   */

  setController(controllerInfo, shouldNotifyControllerchange) {}
  
  /**
   * @param { !blink.mojom.ServiceWorkerObjectInfo } source
   * @param { !blink.mojom.TransferableMessage } message
   */

  postMessageToClient(source, message) {}
  
  /**
   * @param { !blink.mojom.WebFeature } feature
   */

  countFeature(feature) {}
};

/**
 * @export
 * @implements { blink.mojom.ServiceWorkerContainerInterface }
 */
blink.mojom.ServiceWorkerContainerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerContainerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerContainerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerContainerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.ControllerServiceWorkerInfo } controllerInfo
   * @param { !boolean } shouldNotifyControllerchange
   */

  setController(
      controllerInfo,
      shouldNotifyControllerchange) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerContainer_SetController_ParamsSpec.$,
        null,
        [
          controllerInfo,
          shouldNotifyControllerchange
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerObjectInfo } source
   * @param { !blink.mojom.TransferableMessage } message
   */

  postMessageToClient(
      source,
      message) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
        null,
        [
          source,
          message
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebFeature } feature
   */

  countFeature(
      feature) {
    this.proxy.sendMessage(
        2,
        blink.mojom.ServiceWorkerContainer_CountFeature_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerContainer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerContainerReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerContainerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerContainerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerContainer_SetController_ParamsSpec.$,
        null,
        impl.setController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
        null,
        impl.postMessageToClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerContainer_CountFeature_ParamsSpec.$,
        null,
        impl.countFeature.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerContainer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerContainer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerContainerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerContainerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerContainer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerContainerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerContainerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerContainerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerContainer_SetController_ParamsSpec.$,
        null,
        this.setController.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageToClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
        null,
        this.postMessageToClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.countFeature =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ServiceWorkerContainer_CountFeature_ParamsSpec.$,
        null,
        this.countFeature.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorkerContainerInfoForClientSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerInfoForClientSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_Register_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_Register_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_Register_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_Register_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistration_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_GetRegistration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainer_SetController_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainer_SetController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainer_PostMessageToClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainer_PostMessageToClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ServiceWorkerContainer_CountFeature_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerContainer_CountFeature_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerInfoForClientSpec.$,
    'ServiceWorkerContainerInfoForClient',
    [
      mojo.internal.StructField(
        'hostRemote', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.ServiceWorkerContainerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientReceiver', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.ServiceWorkerContainerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerContainerInfoForClient');

/** @record */
blink.mojom.ServiceWorkerContainerInfoForClient = class {
  constructor() {
    /** @export { !Object } */
    this.hostRemote;
    /** @export { !Object } */
    this.clientReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_Register_ParamsSpec.$,
    'ServiceWorkerContainerHost_Register_Params',
    [
      mojo.internal.StructField(
        'scriptUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        blink.mojom.ServiceWorkerRegistrationOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 16,
        0,
        blink.mojom.FetchClientSettingsObjectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_Register_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_Register_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.scriptUrl;
    /** @export { !blink.mojom.ServiceWorkerRegistrationOptions } */
    this.options;
    /** @export { !blink.mojom.FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_Register_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_Register_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registration', 16,
        0,
        blink.mojom.ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_Register_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerContainerHost_Register_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
    /** @export { (blink.mojom.ServiceWorkerRegistrationObjectInfo|undefined) } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_GetRegistration_ParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistration_Params',
    [
      mojo.internal.StructField(
        'clientUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistration_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_GetRegistration_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.clientUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistration_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'registration', 16,
        0,
        blink.mojom.ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerContainerHost_GetRegistration_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
    /** @export { (blink.mojom.ServiceWorkerRegistrationObjectInfo|undefined) } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrations_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrations_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_GetRegistrations_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrations_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.ServiceWorkerErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'infos', 16,
        0,
        mojo.internal.Array(blink.mojom.ServiceWorkerRegistrationObjectInfoSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerContainerHost_GetRegistrations_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerErrorType } */
    this.error;
    /** @export { (string|undefined) } */
    this.errorMsg;
    /** @export { (Array<!blink.mojom.ServiceWorkerRegistrationObjectInfo>|undefined) } */
    this.infos;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrationForReady_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink.mojom.ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerContainerHost_GetRegistrationForReady_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.ServiceWorkerRegistrationObjectInfo|undefined) } */
    this.registration;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_ParamsSpec.$,
    'ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ControllerServiceWorkerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'purpose', 4,
        0,
        blink.mojom.ControllerServiceWorkerPurposeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_EnsureControllerServiceWorker_Params = class {
  constructor() {
    /** @export { !blink.mojom.ControllerServiceWorkerPendingReceiver } */
    this.receiver;
    /** @export { !blink.mojom.ControllerServiceWorkerPurpose } */
    this.purpose;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_ParamsSpec.$,
    'ServiceWorkerContainerHost_CloneContainerHost_Params',
    [
      mojo.internal.StructField(
        'containerHost', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ServiceWorkerContainerHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_CloneContainerHost_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerContainerHostPendingReceiver } */
    this.containerHost;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_ParamsSpec.$,
    'ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_HintToUpdateServiceWorker_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ParamsSpec.$,
    'ServiceWorkerContainerHost_EnsureFileAccess_Params',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.FilePathSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_Params = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.FilePath> } */
    this.files;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParamsSpec.$,
    'ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams');

/** @record */
blink.mojom.ServiceWorkerContainerHost_EnsureFileAccess_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_ParamsSpec.$,
    'ServiceWorkerContainerHost_OnExecutionReady_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_Params');

/** @record */
blink.mojom.ServiceWorkerContainerHost_OnExecutionReady_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainer_SetController_ParamsSpec.$,
    'ServiceWorkerContainer_SetController_Params',
    [
      mojo.internal.StructField(
        'controllerInfo', 0,
        0,
        blink.mojom.ControllerServiceWorkerInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldNotifyControllerchange', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerContainer_SetController_Params');

/** @record */
blink.mojom.ServiceWorkerContainer_SetController_Params = class {
  constructor() {
    /** @export { !blink.mojom.ControllerServiceWorkerInfo } */
    this.controllerInfo;
    /** @export { !boolean } */
    this.shouldNotifyControllerchange;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainer_PostMessageToClient_ParamsSpec.$,
    'ServiceWorkerContainer_PostMessageToClient_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        blink.mojom.TransferableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ServiceWorkerContainer_PostMessageToClient_Params');

/** @record */
blink.mojom.ServiceWorkerContainer_PostMessageToClient_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerObjectInfo } */
    this.source;
    /** @export { !blink.mojom.TransferableMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerContainer_CountFeature_ParamsSpec.$,
    'ServiceWorkerContainer_CountFeature_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink.mojom.WebFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ServiceWorkerContainer_CountFeature_Params');

/** @record */
blink.mojom.ServiceWorkerContainer_CountFeature_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebFeature } */
    this.feature;
  }
};

