// third_party/blink/public/mojom/service_worker/service_worker_client.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT ServiceWorkerClientQueryOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerClientQueryOptions, T>::value>;
  using DataView = ServiceWorkerClientQueryOptionsDataView;
  using Data_ = internal::ServiceWorkerClientQueryOptions_Data;

  template <typename... Args>
  static ServiceWorkerClientQueryOptionsPtr New(Args&&... args) {
    return ServiceWorkerClientQueryOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerClientQueryOptionsPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerClientQueryOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerClientQueryOptions>::Convert(*this);
  }


  ServiceWorkerClientQueryOptions();

  ServiceWorkerClientQueryOptions(
      bool include_uncontrolled,
      ServiceWorkerClientType client_type);


  ~ServiceWorkerClientQueryOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerClientQueryOptionsPtr>
  ServiceWorkerClientQueryOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerClientQueryOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerClientQueryOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerClientQueryOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerClientQueryOptions_UnserializedMessageContext<
            UserType, ServiceWorkerClientQueryOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerClientQueryOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerClientQueryOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerClientQueryOptions_UnserializedMessageContext<
            UserType, ServiceWorkerClientQueryOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerClientQueryOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_uncontrolled;
  
  ServiceWorkerClientType client_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class PLATFORM_EXPORT ServiceWorkerClientInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerClientInfo, T>::value>;
  using DataView = ServiceWorkerClientInfoDataView;
  using Data_ = internal::ServiceWorkerClientInfo_Data;

  template <typename... Args>
  static ServiceWorkerClientInfoPtr New(Args&&... args) {
    return ServiceWorkerClientInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerClientInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerClientInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerClientInfo>::Convert(*this);
  }


  ServiceWorkerClientInfo();

  ServiceWorkerClientInfo(
      const ::blink::KURL& url,
      ::blink::mojom::blink::RequestContextFrameType frame_type,
      const ::blink::String& client_uuid,
      ServiceWorkerClientType client_type,
      bool page_hidden,
      bool is_focused,
      ServiceWorkerClientLifecycleState lifecycle_state,
      ::base::TimeTicks last_focus_time,
      ::base::TimeTicks creation_time);


  ~ServiceWorkerClientInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerClientInfoPtr>
  ServiceWorkerClientInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerClientInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerClientInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerClientInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerClientInfo_UnserializedMessageContext<
            UserType, ServiceWorkerClientInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerClientInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerClientInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerClientInfo_UnserializedMessageContext<
            UserType, ServiceWorkerClientInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerClientInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::mojom::blink::RequestContextFrameType frame_type;
  
  ::blink::String client_uuid;
  
  ServiceWorkerClientType client_type;
  
  bool page_hidden;
  
  bool is_focused;
  
  ServiceWorkerClientLifecycleState lifecycle_state;
  
  ::base::TimeTicks last_focus_time;
  
  ::base::TimeTicks creation_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerClientQueryOptionsPtr ServiceWorkerClientQueryOptions::Clone() const {
  return New(
      mojo::Clone(include_uncontrolled),
      mojo::Clone(client_type)
  );
}

template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>*>
bool ServiceWorkerClientQueryOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_uncontrolled, other_struct.include_uncontrolled))
    return false;
  if (!mojo::Equals(this->client_type, other_struct.client_type))
    return false;
  return true;
}

template <typename T, ServiceWorkerClientQueryOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_uncontrolled < rhs.include_uncontrolled)
    return true;
  if (rhs.include_uncontrolled < lhs.include_uncontrolled)
    return false;
  if (lhs.client_type < rhs.client_type)
    return true;
  if (rhs.client_type < lhs.client_type)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerClientInfoPtr ServiceWorkerClientInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(frame_type),
      mojo::Clone(client_uuid),
      mojo::Clone(client_type),
      mojo::Clone(page_hidden),
      mojo::Clone(is_focused),
      mojo::Clone(lifecycle_state),
      mojo::Clone(last_focus_time),
      mojo::Clone(creation_time)
  );
}

template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>*>
bool ServiceWorkerClientInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->frame_type, other_struct.frame_type))
    return false;
  if (!mojo::Equals(this->client_uuid, other_struct.client_uuid))
    return false;
  if (!mojo::Equals(this->client_type, other_struct.client_type))
    return false;
  if (!mojo::Equals(this->page_hidden, other_struct.page_hidden))
    return false;
  if (!mojo::Equals(this->is_focused, other_struct.is_focused))
    return false;
  if (!mojo::Equals(this->lifecycle_state, other_struct.lifecycle_state))
    return false;
  if (!mojo::Equals(this->last_focus_time, other_struct.last_focus_time))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  return true;
}

template <typename T, ServiceWorkerClientInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.frame_type < rhs.frame_type)
    return true;
  if (rhs.frame_type < lhs.frame_type)
    return false;
  if (lhs.client_uuid < rhs.client_uuid)
    return true;
  if (rhs.client_uuid < lhs.client_uuid)
    return false;
  if (lhs.client_type < rhs.client_type)
    return true;
  if (rhs.client_type < lhs.client_type)
    return false;
  if (lhs.page_hidden < rhs.page_hidden)
    return true;
  if (rhs.page_hidden < lhs.page_hidden)
    return false;
  if (lhs.is_focused < rhs.is_focused)
    return true;
  if (rhs.is_focused < lhs.is_focused)
    return false;
  if (lhs.lifecycle_state < rhs.lifecycle_state)
    return true;
  if (rhs.lifecycle_state < lhs.lifecycle_state)
    return false;
  if (lhs.last_focus_time < rhs.last_focus_time)
    return true;
  if (rhs.last_focus_time < lhs.last_focus_time)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ServiceWorkerClientQueryOptions::DataView,
                                         ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ServiceWorkerClientQueryOptions::include_uncontrolled) include_uncontrolled(
      const ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr& input) {
    return input->include_uncontrolled;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerClientQueryOptions::client_type) client_type(
      const ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr& input) {
    return input->client_type;
  }

  static bool Read(::blink::mojom::blink::ServiceWorkerClientQueryOptions::DataView input, ::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ServiceWorkerClientInfo::DataView,
                                         ::blink::mojom::blink::ServiceWorkerClientInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ServiceWorkerClientInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ServiceWorkerClientInfo::url)& url(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerClientInfo::frame_type) frame_type(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->frame_type;
  }

  static const decltype(::blink::mojom::blink::ServiceWorkerClientInfo::client_uuid)& client_uuid(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->client_uuid;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerClientInfo::client_type) client_type(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->client_type;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerClientInfo::page_hidden) page_hidden(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->page_hidden;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerClientInfo::is_focused) is_focused(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->is_focused;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerClientInfo::lifecycle_state) lifecycle_state(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->lifecycle_state;
  }

  static const decltype(::blink::mojom::blink::ServiceWorkerClientInfo::last_focus_time)& last_focus_time(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->last_focus_time;
  }

  static const decltype(::blink::mojom::blink::ServiceWorkerClientInfo::creation_time)& creation_time(
      const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& input) {
    return input->creation_time;
  }

  static bool Read(::blink::mojom::blink::ServiceWorkerClientInfo::DataView input, ::blink::mojom::blink::ServiceWorkerClientInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CLIENT_MOJOM_BLINK_H_