// third_party/blink/public/mojom/service_worker/service_worker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyBuffer as mojoBase_mojom_ReadOnlyBuffer,
  ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec
} from '../../../../../mojo/public/mojom/base/read_only_buffer.mojom.m.js';

import {
  BigString16 as mojoBase_mojom_BigString16,
  BigString16Spec as mojoBase_mojom_BigString16Spec,
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Value as mojoBase_mojom_Value,
  ValueSpec as mojoBase_mojom_ValueSpec
} from '../../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  CookieChangeInfo as network_mojom_CookieChangeInfo,
  CookieChangeInfoSpec as network_mojom_CookieChangeInfoSpec
} from '../../../../../services/network/public/mojom/cookie_manager.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  AssociatedInterfaceProviderRemote as blink_mojom_AssociatedInterfaceProviderRemote,
  AssociatedInterfaceProviderPendingReceiver as blink_mojom_AssociatedInterfaceProviderPendingReceiver
} from '../associated_interfaces/associated_interfaces.mojom.m.js';

import {
  BackgroundFetchRegistration as blink_mojom_BackgroundFetchRegistration,
  BackgroundFetchRegistrationSpec as blink_mojom_BackgroundFetchRegistrationSpec
} from '../background_fetch/background_fetch.mojom.m.js';

import {
  ConsoleMessageLevel as blink_mojom_ConsoleMessageLevel,
  ConsoleMessageLevelSpec as blink_mojom_ConsoleMessageLevelSpec
} from '../devtools/console_message.mojom.m.js';

import {
  TransferableMessage as blink_mojom_TransferableMessage,
  TransferableMessageSpec as blink_mojom_TransferableMessageSpec
} from '../messaging/transferable_message.mojom.m.js';

import {
  NotificationData as blink_mojom_NotificationData,
  NotificationDataSpec as blink_mojom_NotificationDataSpec
} from '../notifications/notification.mojom.m.js';

import {
  PaymentHandlerResponseCallbackRemote as payments_mojom_PaymentHandlerResponseCallbackRemote,
  PaymentHandlerResponseCallbackPendingReceiver as payments_mojom_PaymentHandlerResponseCallbackPendingReceiver,
  CanMakePaymentEventData as payments_mojom_CanMakePaymentEventData,
  CanMakePaymentEventDataSpec as payments_mojom_CanMakePaymentEventDataSpec,
  PaymentRequestEventData as payments_mojom_PaymentRequestEventData,
  PaymentRequestEventDataSpec as payments_mojom_PaymentRequestEventDataSpec
} from '../payments/payment_app.mojom.m.js';

import {
  PushSubscription as blink_mojom_PushSubscription,
  PushSubscriptionSpec as blink_mojom_PushSubscriptionSpec
} from '../push_messaging/push_messaging.mojom.m.js';

import {
  StorageKey as blink_mojom_StorageKey,
  StorageKeySpec as blink_mojom_StorageKeySpec
} from '../storage_key/storage_key.mojom.m.js';

import {
  DispatchFetchEventParams as blink_mojom_DispatchFetchEventParams,
  DispatchFetchEventParamsSpec as blink_mojom_DispatchFetchEventParamsSpec
} from './dispatch_fetch_event_params.mojom.m.js';

import {
  AncestorFrameType as blink_mojom_AncestorFrameType,
  AncestorFrameTypeSpec as blink_mojom_AncestorFrameTypeSpec
} from './service_worker_ancestor_frame_type.mojom.m.js';

import {
  ServiceWorkerClientInfo as blink_mojom_ServiceWorkerClientInfo,
  ServiceWorkerClientInfoSpec as blink_mojom_ServiceWorkerClientInfoSpec,
  ServiceWorkerClientQueryOptions as blink_mojom_ServiceWorkerClientQueryOptions,
  ServiceWorkerClientQueryOptionsSpec as blink_mojom_ServiceWorkerClientQueryOptionsSpec
} from './service_worker_client.mojom.m.js';

import {
  ServiceWorkerErrorType as blink_mojom_ServiceWorkerErrorType,
  ServiceWorkerErrorTypeSpec as blink_mojom_ServiceWorkerErrorTypeSpec
} from './service_worker_error_type.mojom.m.js';

import {
  ServiceWorkerEventStatus as blink_mojom_ServiceWorkerEventStatus,
  ServiceWorkerEventStatusSpec as blink_mojom_ServiceWorkerEventStatusSpec
} from './service_worker_event_status.mojom.m.js';

import {
  ServiceWorkerFetchResponseCallbackRemote as blink_mojom_ServiceWorkerFetchResponseCallbackRemote,
  ServiceWorkerFetchResponseCallbackPendingReceiver as blink_mojom_ServiceWorkerFetchResponseCallbackPendingReceiver
} from './service_worker_fetch_response_callback.mojom.m.js';

import {
  ServiceWorkerObjectInfo as blink_mojom_ServiceWorkerObjectInfo,
  ServiceWorkerObjectInfoSpec as blink_mojom_ServiceWorkerObjectInfoSpec
} from './service_worker_object.mojom.m.js';

import {
  ServiceWorkerRegistrationObjectInfo as blink_mojom_ServiceWorkerRegistrationObjectInfo,
  ServiceWorkerRegistrationObjectInfoSpec as blink_mojom_ServiceWorkerRegistrationObjectInfoSpec
} from './service_worker_registration.mojom.m.js';

import {
  ServiceWorkerRouterRules as blink_mojom_ServiceWorkerRouterRules,
  ServiceWorkerRouterRulesSpec as blink_mojom_ServiceWorkerRouterRulesSpec
} from './service_worker_router_rule.mojom.m.js';


/**
 * @const { !number }
 */
export const PUSH_EVENT_TIMEOUT_SECONDS = 90;


/**
 * @const { !number }
 */
export const SERVICE_WORKER_DEFAULT_IDLE_DELAY_IN_SECONDS = 30;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FocusErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FocusError = {
  
  CLIENT_NOT_FOUND: 0,
  CLIENT_INACTIVE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FetchHandlerExistenceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FetchHandlerExistence = {
  
  UNKNOWN: 0,
  EXISTS: 1,
  DOES_NOT_EXIST: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorkerHost', scope);
  }
}

/** @interface */
export class ServiceWorkerHostInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   */

  setCachedMetadata(url, data) {}
  
  /**
   * @param { !url_mojom_Url } url
   */

  clearCachedMetadata(url) {}
  
  /**
   * @param { !blink_mojom_ServiceWorkerClientQueryOptions } options
   * @return {!Promise<{
        clients: !Array<!blink_mojom_ServiceWorkerClientInfo>,
   *  }>}
   */

  getClients(options) {}
  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        client: ?blink_mojom_ServiceWorkerClientInfo,
   *  }>}
   */

  getClient(clientUuid) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink_mojom_ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openNewTab(url) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink_mojom_ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openPaymentHandlerWindow(url) {}
  
  /**
   * @param { !string } clientUuid
   * @param { !blink_mojom_TransferableMessage } message
   */

  postMessageToClient(clientUuid, message) {}
  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        result: !FocusResult,
   *  }>}
   */

  focusClient(clientUuid) {}
  
  /**
   * @param { !string } clientUuid
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink_mojom_ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  navigateClient(clientUuid, url) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  skipWaiting() {}
  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  claimClients() {}
  
  /**
   * @param { !blink_mojom_ServiceWorkerRouterRules } rules
   * @return {!Promise<{
        isParseError: !boolean,
   *  }>}
   */

  addRoutes(rules) {}
}

/**
 * @implements { ServiceWorkerHostInterface }
 */
export class ServiceWorkerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_ReadOnlyBuffer } data
   */

  setCachedMetadata(
      url,
      data) {
    this.proxy.sendMessage(
        0,
        ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
        null,
        [
          url,
          data
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   */

  clearCachedMetadata(
      url) {
    this.proxy.sendMessage(
        1,
        ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerClientQueryOptions } options
   * @return {!Promise<{
        clients: !Array<!blink_mojom_ServiceWorkerClientInfo>,
   *  }>}
   */

  getClients(
      options) {
    return this.proxy.sendMessage(
        2,
        ServiceWorkerHost_GetClients_ParamsSpec.$,
        ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        client: ?blink_mojom_ServiceWorkerClientInfo,
   *  }>}
   */

  getClient(
      clientUuid) {
    return this.proxy.sendMessage(
        3,
        ServiceWorkerHost_GetClient_ParamsSpec.$,
        ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
        [
          clientUuid
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink_mojom_ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openNewTab(
      url) {
    return this.proxy.sendMessage(
        4,
        ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
        ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink_mojom_ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  openPaymentHandlerWindow(
      url) {
    return this.proxy.sendMessage(
        5,
        ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
        ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @param { !blink_mojom_TransferableMessage } message
   */

  postMessageToClient(
      clientUuid,
      message) {
    this.proxy.sendMessage(
        6,
        ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
        null,
        [
          clientUuid,
          message
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @return {!Promise<{
        result: !FocusResult,
   *  }>}
   */

  focusClient(
      clientUuid) {
    return this.proxy.sendMessage(
        7,
        ServiceWorkerHost_FocusClient_ParamsSpec.$,
        ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
        [
          clientUuid
        ],
        false);
  }

  
  /**
   * @param { !string } clientUuid
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        success: !boolean,
        client: ?blink_mojom_ServiceWorkerClientInfo,
        errorMsg: ?string,
   *  }>}
   */

  navigateClient(
      clientUuid,
      url) {
    return this.proxy.sendMessage(
        8,
        ServiceWorkerHost_NavigateClient_ParamsSpec.$,
        ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
        [
          clientUuid,
          url
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  skipWaiting() {
    return this.proxy.sendMessage(
        9,
        ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
        ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !blink_mojom_ServiceWorkerErrorType,
        errorMsg: ?string,
   *  }>}
   */

  claimClients() {
    return this.proxy.sendMessage(
        10,
        ServiceWorkerHost_ClaimClients_ParamsSpec.$,
        ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ServiceWorkerRouterRules } rules
   * @return {!Promise<{
        isParseError: !boolean,
   *  }>}
   */

  addRoutes(
      rules) {
    return this.proxy.sendMessage(
        11,
        ServiceWorkerHost_AddRoutes_ParamsSpec.$,
        ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
        [
          rules
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerHostReceiver {
  /**
   * @param {!ServiceWorkerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
        null,
        impl.setCachedMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
        null,
        impl.clearCachedMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerHost_GetClients_ParamsSpec.$,
        ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
        impl.getClients.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerHost_GetClient_ParamsSpec.$,
        ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
        impl.getClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
        ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
        impl.openNewTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
        ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
        impl.openPaymentHandlerWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
        null,
        impl.postMessageToClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ServiceWorkerHost_FocusClient_ParamsSpec.$,
        ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
        impl.focusClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ServiceWorkerHost_NavigateClient_ParamsSpec.$,
        ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
        impl.navigateClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
        ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
        impl.skipWaiting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ServiceWorkerHost_ClaimClients_ParamsSpec.$,
        ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
        impl.claimClients.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ServiceWorkerHost_AddRoutes_ParamsSpec.$,
        ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
        impl.addRoutes.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorkerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerHostRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorkerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCachedMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
        null,
        this.setCachedMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearCachedMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
        null,
        this.clearCachedMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getClients =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorkerHost_GetClients_ParamsSpec.$,
        ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
        this.getClients.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ServiceWorkerHost_GetClient_ParamsSpec.$,
        ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
        this.getClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openNewTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
        ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
        this.openNewTab.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openPaymentHandlerWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
        ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
        this.openPaymentHandlerWindow.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageToClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
        null,
        this.postMessageToClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.focusClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ServiceWorkerHost_FocusClient_ParamsSpec.$,
        ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
        this.focusClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.navigateClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ServiceWorkerHost_NavigateClient_ParamsSpec.$,
        ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
        this.navigateClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.skipWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
        ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
        this.skipWaiting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.claimClients =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ServiceWorkerHost_ClaimClients_ParamsSpec.$,
        ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
        this.claimClients.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addRoutes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ServiceWorkerHost_AddRoutes_ParamsSpec.$,
        ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
        this.addRoutes.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServiceWorkerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ServiceWorker', scope);
  }
}

/** @interface */
export class ServiceWorkerInterface {
  
  /**
   * @param { !Object } serviceWorkerHost
   * @param { !Object } associatedInterfacesToBrowser
   * @param { !Object } associatedInterfacesFromBrowser
   * @param { !blink_mojom_ServiceWorkerRegistrationObjectInfo } registrationInfo
   * @param { !blink_mojom_ServiceWorkerObjectInfo } serviceWorkerInfo
   * @param { !FetchHandlerExistence } fetchHandlerExistence
   * @param { !blink_mojom_AncestorFrameType } ancestorFrameType
   * @param { !blink_mojom_StorageKey } storageKey
   */

  initializeGlobalScope(serviceWorkerHost, associatedInterfacesToBrowser, associatedInterfacesFromBrowser, registrationInfo, serviceWorkerInfo, fetchHandlerExistence, ancestorFrameType, storageKey) {}
  
  /**
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
        fetchCount: !number,
   *  }>}
   */

  dispatchInstallEvent() {}
  
  /**
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchActivateEvent() {}
  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchAbortEvent(registration) {}
  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchClickEvent(registration) {}
  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchFailEvent(registration) {}
  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchSuccessEvent(registration) {}
  
  /**
   * @param { !network_mojom_CookieChangeInfo } change
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCookieChangeEvent(change) {}
  
  /**
   * @param { !blink_mojom_DispatchFetchEventParams } params
   * @param { !blink_mojom_ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForMainResource(params, responseCallback) {}
  
  /**
   * @param { !string } notificationId
   * @param { !blink_mojom_NotificationData } notificationData
   * @param { !number } actionIndex
   * @param { ?mojoBase_mojom_String16 } reply
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationClickEvent(notificationId, notificationData, actionIndex, reply) {}
  
  /**
   * @param { !string } notificationId
   * @param { !blink_mojom_NotificationData } notificationData
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationCloseEvent(notificationId, notificationData) {}
  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushEvent(payload) {}
  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
        requestedUrls: ?Array<!url_mojom_Url>,
   *  }>}
   */

  dispatchPushEventRecordingNetworkRequests(payload) {}
  
  /**
   * @param { ?blink_mojom_PushSubscription } oldSubscription
   * @param { ?blink_mojom_PushSubscription } newSubscription
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushSubscriptionChangeEvent(oldSubscription, newSubscription) {}
  
  /**
   * @param { !string } tag
   * @param { !boolean } lastChance
   * @param { !mojoBase_mojom_TimeDelta } timeout
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchSyncEvent(tag, lastChance, timeout) {}
  
  /**
   * @param { !string } tag
   * @param { !mojoBase_mojom_TimeDelta } timeout
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPeriodicSyncEvent(tag, timeout) {}
  
  /**
   * @param { !payments_mojom_PaymentHandlerResponseCallbackRemote } resultOfAbortPayment
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchAbortPaymentEvent(resultOfAbortPayment) {}
  
  /**
   * @param { !payments_mojom_CanMakePaymentEventData } eventData
   * @param { !payments_mojom_PaymentHandlerResponseCallbackRemote } resultOfCanMakePayment
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCanMakePaymentEvent(eventData, resultOfCanMakePayment) {}
  
  /**
   * @param { !payments_mojom_PaymentRequestEventData } requestData
   * @param { !payments_mojom_PaymentHandlerResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPaymentRequestEvent(requestData, responseCallback) {}
  
  /**
   * @param { !ExtendableMessageEvent } event
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchExtendableMessageEvent(event) {}
  
  /**
   * @param { !string } id
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchContentDeleteEvent(id) {}
  
  /**
   * @return {!Promise}
   */

  ping() {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } delay
   */

  setIdleDelay(delay) {}
  
  /**
   */

  addKeepAlive() {}
  
  /**
   */

  clearKeepAlive() {}
  
  /**
   * @param { !blink_mojom_ConsoleMessageLevel } level
   * @param { !string } message
   */

  addMessageToConsole(level, message) {}
  
  /**
   * @param { !mojoBase_mojom_BigString16 } javascript
   * @param { !boolean } wantsResult
   * @return {!Promise<{
        result: !mojoBase_mojom_Value,
        error: ?string,
   *  }>}
   */

  executeScriptForTest(javascript, wantsResult) {}
}

/**
 * @implements { ServiceWorkerInterface }
 */
export class ServiceWorkerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServiceWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServiceWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServiceWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } serviceWorkerHost
   * @param { !Object } associatedInterfacesToBrowser
   * @param { !Object } associatedInterfacesFromBrowser
   * @param { !blink_mojom_ServiceWorkerRegistrationObjectInfo } registrationInfo
   * @param { !blink_mojom_ServiceWorkerObjectInfo } serviceWorkerInfo
   * @param { !FetchHandlerExistence } fetchHandlerExistence
   * @param { !blink_mojom_AncestorFrameType } ancestorFrameType
   * @param { !blink_mojom_StorageKey } storageKey
   */

  initializeGlobalScope(
      serviceWorkerHost,
      associatedInterfacesToBrowser,
      associatedInterfacesFromBrowser,
      registrationInfo,
      serviceWorkerInfo,
      fetchHandlerExistence,
      ancestorFrameType,
      storageKey) {
    this.proxy.sendMessage(
        0,
        ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
        null,
        [
          serviceWorkerHost,
          associatedInterfacesToBrowser,
          associatedInterfacesFromBrowser,
          registrationInfo,
          serviceWorkerInfo,
          fetchHandlerExistence,
          ancestorFrameType,
          storageKey
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
        fetchCount: !number,
   *  }>}
   */

  dispatchInstallEvent() {
    return this.proxy.sendMessage(
        1,
        ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
        ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchActivateEvent() {
    return this.proxy.sendMessage(
        2,
        ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
        ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchAbortEvent(
      registration) {
    return this.proxy.sendMessage(
        3,
        ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchClickEvent(
      registration) {
    return this.proxy.sendMessage(
        4,
        ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchFailEvent(
      registration) {
    return this.proxy.sendMessage(
        5,
        ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_BackgroundFetchRegistration } registration
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchBackgroundFetchSuccessEvent(
      registration) {
    return this.proxy.sendMessage(
        6,
        ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
        [
          registration
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_CookieChangeInfo } change
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCookieChangeEvent(
      change) {
    return this.proxy.sendMessage(
        7,
        ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
        ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
        [
          change
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_DispatchFetchEventParams } params
   * @param { !blink_mojom_ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForMainResource(
      params,
      responseCallback) {
    return this.proxy.sendMessage(
        8,
        ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
        ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
        [
          params,
          responseCallback
        ],
        false);
  }

  
  /**
   * @param { !string } notificationId
   * @param { !blink_mojom_NotificationData } notificationData
   * @param { !number } actionIndex
   * @param { ?mojoBase_mojom_String16 } reply
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationClickEvent(
      notificationId,
      notificationData,
      actionIndex,
      reply) {
    return this.proxy.sendMessage(
        9,
        ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
        ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
        [
          notificationId,
          notificationData,
          actionIndex,
          reply
        ],
        false);
  }

  
  /**
   * @param { !string } notificationId
   * @param { !blink_mojom_NotificationData } notificationData
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchNotificationCloseEvent(
      notificationId,
      notificationData) {
    return this.proxy.sendMessage(
        10,
        ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
        ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
        [
          notificationId,
          notificationData
        ],
        false);
  }

  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushEvent(
      payload) {
    return this.proxy.sendMessage(
        11,
        ServiceWorker_DispatchPushEvent_ParamsSpec.$,
        ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
        [
          payload
        ],
        false);
  }

  
  /**
   * @param { ?string } payload
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
        requestedUrls: ?Array<!url_mojom_Url>,
   *  }>}
   */

  dispatchPushEventRecordingNetworkRequests(
      payload) {
    return this.proxy.sendMessage(
        12,
        ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
        ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
        [
          payload
        ],
        false);
  }

  
  /**
   * @param { ?blink_mojom_PushSubscription } oldSubscription
   * @param { ?blink_mojom_PushSubscription } newSubscription
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPushSubscriptionChangeEvent(
      oldSubscription,
      newSubscription) {
    return this.proxy.sendMessage(
        13,
        ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
        ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
        [
          oldSubscription,
          newSubscription
        ],
        false);
  }

  
  /**
   * @param { !string } tag
   * @param { !boolean } lastChance
   * @param { !mojoBase_mojom_TimeDelta } timeout
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchSyncEvent(
      tag,
      lastChance,
      timeout) {
    return this.proxy.sendMessage(
        14,
        ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
        ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
        [
          tag,
          lastChance,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !string } tag
   * @param { !mojoBase_mojom_TimeDelta } timeout
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPeriodicSyncEvent(
      tag,
      timeout) {
    return this.proxy.sendMessage(
        15,
        ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
        ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
        [
          tag,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !payments_mojom_PaymentHandlerResponseCallbackRemote } resultOfAbortPayment
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchAbortPaymentEvent(
      resultOfAbortPayment) {
    return this.proxy.sendMessage(
        16,
        ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
        ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
        [
          resultOfAbortPayment
        ],
        false);
  }

  
  /**
   * @param { !payments_mojom_CanMakePaymentEventData } eventData
   * @param { !payments_mojom_PaymentHandlerResponseCallbackRemote } resultOfCanMakePayment
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchCanMakePaymentEvent(
      eventData,
      resultOfCanMakePayment) {
    return this.proxy.sendMessage(
        17,
        ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
        ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
        [
          eventData,
          resultOfCanMakePayment
        ],
        false);
  }

  
  /**
   * @param { !payments_mojom_PaymentRequestEventData } requestData
   * @param { !payments_mojom_PaymentHandlerResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchPaymentRequestEvent(
      requestData,
      responseCallback) {
    return this.proxy.sendMessage(
        18,
        ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
        ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
        [
          requestData,
          responseCallback
        ],
        false);
  }

  
  /**
   * @param { !ExtendableMessageEvent } event
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchExtendableMessageEvent(
      event) {
    return this.proxy.sendMessage(
        19,
        ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
        ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
        [
          event
        ],
        false);
  }

  
  /**
   * @param { !string } id
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchContentDeleteEvent(
      id) {
    return this.proxy.sendMessage(
        20,
        ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
        ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  ping() {
    return this.proxy.sendMessage(
        21,
        ServiceWorker_Ping_ParamsSpec.$,
        ServiceWorker_Ping_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } delay
   */

  setIdleDelay(
      delay) {
    this.proxy.sendMessage(
        22,
        ServiceWorker_SetIdleDelay_ParamsSpec.$,
        null,
        [
          delay
        ],
        false);
  }

  
  /**
   */

  addKeepAlive() {
    this.proxy.sendMessage(
        23,
        ServiceWorker_AddKeepAlive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  clearKeepAlive() {
    this.proxy.sendMessage(
        24,
        ServiceWorker_ClearKeepAlive_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ConsoleMessageLevel } level
   * @param { !string } message
   */

  addMessageToConsole(
      level,
      message) {
    this.proxy.sendMessage(
        25,
        ServiceWorker_AddMessageToConsole_ParamsSpec.$,
        null,
        [
          level,
          message
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_BigString16 } javascript
   * @param { !boolean } wantsResult
   * @return {!Promise<{
        result: !mojoBase_mojom_Value,
        error: ?string,
   *  }>}
   */

  executeScriptForTest(
      javascript,
      wantsResult) {
    return this.proxy.sendMessage(
        26,
        ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
        ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
        [
          javascript,
          wantsResult
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceWorkerReceiver {
  /**
   * @param {!ServiceWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
        null,
        impl.initializeGlobalScope.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
        ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
        impl.dispatchInstallEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
        ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
        impl.dispatchActivateEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchAbortEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchClickEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchFailEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
        impl.dispatchBackgroundFetchSuccessEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
        ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
        impl.dispatchCookieChangeEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
        ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
        impl.dispatchFetchEventForMainResource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
        ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
        impl.dispatchNotificationClickEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
        ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
        impl.dispatchNotificationCloseEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ServiceWorker_DispatchPushEvent_ParamsSpec.$,
        ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
        impl.dispatchPushEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
        ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
        impl.dispatchPushEventRecordingNetworkRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
        ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
        impl.dispatchPushSubscriptionChangeEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
        ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
        impl.dispatchSyncEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
        ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
        impl.dispatchPeriodicSyncEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
        ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
        impl.dispatchAbortPaymentEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
        ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
        impl.dispatchCanMakePaymentEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
        ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
        impl.dispatchPaymentRequestEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
        ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
        impl.dispatchExtendableMessageEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
        ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
        impl.dispatchContentDeleteEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        ServiceWorker_Ping_ParamsSpec.$,
        ServiceWorker_Ping_ResponseParamsSpec.$,
        impl.ping.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        ServiceWorker_SetIdleDelay_ParamsSpec.$,
        null,
        impl.setIdleDelay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        ServiceWorker_AddKeepAlive_ParamsSpec.$,
        null,
        impl.addKeepAlive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        ServiceWorker_ClearKeepAlive_ParamsSpec.$,
        null,
        impl.clearKeepAlive.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        ServiceWorker_AddMessageToConsole_ParamsSpec.$,
        null,
        impl.addMessageToConsole.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
        ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
        impl.executeScriptForTest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ServiceWorker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceWorkerRemote}
   */
  static getRemote() {
    let remote = new ServiceWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ServiceWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceWorkerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeGlobalScope =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
        null,
        this.initializeGlobalScope.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchInstallEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
        ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
        this.dispatchInstallEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchActivateEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
        ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
        this.dispatchActivateEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchAbortEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchAbortEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchClickEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchClickEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchFailEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchFailEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchBackgroundFetchSuccessEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
        ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
        this.dispatchBackgroundFetchSuccessEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchCookieChangeEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
        ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
        this.dispatchCookieChangeEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchFetchEventForMainResource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
        ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
        this.dispatchFetchEventForMainResource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNotificationClickEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
        ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
        this.dispatchNotificationClickEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNotificationCloseEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
        ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
        this.dispatchNotificationCloseEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPushEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ServiceWorker_DispatchPushEvent_ParamsSpec.$,
        ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
        this.dispatchPushEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPushEventRecordingNetworkRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
        ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
        this.dispatchPushEventRecordingNetworkRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPushSubscriptionChangeEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
        ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
        this.dispatchPushSubscriptionChangeEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchSyncEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
        ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
        this.dispatchSyncEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPeriodicSyncEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
        ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
        this.dispatchPeriodicSyncEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchAbortPaymentEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
        ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
        this.dispatchAbortPaymentEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchCanMakePaymentEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
        ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
        this.dispatchCanMakePaymentEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchPaymentRequestEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
        ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
        this.dispatchPaymentRequestEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchExtendableMessageEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
        ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
        this.dispatchExtendableMessageEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchContentDeleteEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
        ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
        this.dispatchContentDeleteEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ping =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        ServiceWorker_Ping_ParamsSpec.$,
        ServiceWorker_Ping_ResponseParamsSpec.$,
        this.ping.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIdleDelay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        ServiceWorker_SetIdleDelay_ParamsSpec.$,
        null,
        this.setIdleDelay.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addKeepAlive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        ServiceWorker_AddKeepAlive_ParamsSpec.$,
        null,
        this.addKeepAlive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearKeepAlive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        ServiceWorker_ClearKeepAlive_ParamsSpec.$,
        null,
        this.clearKeepAlive.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addMessageToConsole =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        ServiceWorker_AddMessageToConsole_ParamsSpec.$,
        null,
        this.addMessageToConsole.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeScriptForTest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
        ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
        this.executeScriptForTest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ExtendableMessageEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_SetCachedMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_ClearCachedMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_GetClients_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_GetClients_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_GetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_GetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenNewTab_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenNewTab_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_PostMessageToClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_FocusClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_FocusClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_NavigateClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_NavigateClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_SkipWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_SkipWaiting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_ClaimClients_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_ClaimClients_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_AddRoutes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerHost_AddRoutes_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_InitializeGlobalScope_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchInstallEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchInstallEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchActivateEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchActivateEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchCookieChangeEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchNotificationClickEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPushEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPushEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchSyncEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchSyncEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchContentDeleteEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_Ping_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_Ping_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_SetIdleDelay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_AddKeepAlive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_ClearKeepAlive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_AddMessageToConsole_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_ExecuteScriptForTest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FocusResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ExtendableMessageEventSpec.$,
    'ExtendableMessageEvent',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink_mojom_TransferableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceOrigin', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceInfoForClient', 16,
        0,
        blink_mojom_ServiceWorkerClientInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceInfoForServiceWorker', 24,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ExtendableMessageEvent {
  constructor() {
    /** @type { !blink_mojom_TransferableMessage } */
    this.message;
    /** @type { !url_mojom_Origin } */
    this.sourceOrigin;
    /** @type { (blink_mojom_ServiceWorkerClientInfo|undefined) } */
    this.sourceInfoForClient;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.sourceInfoForServiceWorker;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_SetCachedMetadata_ParamsSpec.$,
    'ServiceWorkerHost_SetCachedMetadata_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_ReadOnlyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerHost_SetCachedMetadata_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_ReadOnlyBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_ClearCachedMetadata_ParamsSpec.$,
    'ServiceWorkerHost_ClearCachedMetadata_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_ClearCachedMetadata_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_GetClients_ParamsSpec.$,
    'ServiceWorkerHost_GetClients_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink_mojom_ServiceWorkerClientQueryOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_GetClients_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerClientQueryOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_GetClients_ResponseParamsSpec.$,
    'ServiceWorkerHost_GetClients_ResponseParams',
    [
      mojo.internal.StructField(
        'clients', 0,
        0,
        mojo.internal.Array(blink_mojom_ServiceWorkerClientInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_GetClients_ResponseParams {
  constructor() {
    /** @type { !Array<!blink_mojom_ServiceWorkerClientInfo> } */
    this.clients;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_GetClient_ParamsSpec.$,
    'ServiceWorkerHost_GetClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_GetClient_Params {
  constructor() {
    /** @type { !string } */
    this.clientUuid;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_GetClient_ResponseParamsSpec.$,
    'ServiceWorkerHost_GetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        blink_mojom_ServiceWorkerClientInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_GetClient_ResponseParams {
  constructor() {
    /** @type { (blink_mojom_ServiceWorkerClientInfo|undefined) } */
    this.client;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenNewTab_ParamsSpec.$,
    'ServiceWorkerHost_OpenNewTab_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenNewTab_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenNewTab_ResponseParamsSpec.$,
    'ServiceWorkerHost_OpenNewTab_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        blink_mojom_ServiceWorkerClientInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenNewTab_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (blink_mojom_ServiceWorkerClientInfo|undefined) } */
    this.client;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenPaymentHandlerWindow_ParamsSpec.$,
    'ServiceWorkerHost_OpenPaymentHandlerWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenPaymentHandlerWindow_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParamsSpec.$,
    'ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        blink_mojom_ServiceWorkerClientInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerHost_OpenPaymentHandlerWindow_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (blink_mojom_ServiceWorkerClientInfo|undefined) } */
    this.client;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_PostMessageToClient_ParamsSpec.$,
    'ServiceWorkerHost_PostMessageToClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        blink_mojom_TransferableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerHost_PostMessageToClient_Params {
  constructor() {
    /** @type { !string } */
    this.clientUuid;
    /** @type { !blink_mojom_TransferableMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_FocusClient_ParamsSpec.$,
    'ServiceWorkerHost_FocusClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_FocusClient_Params {
  constructor() {
    /** @type { !string } */
    this.clientUuid;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_FocusClient_ResponseParamsSpec.$,
    'ServiceWorkerHost_FocusClient_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        FocusResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerHost_FocusClient_ResponseParams {
  constructor() {
    /** @type { !FocusResult } */
    this.result;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_NavigateClient_ParamsSpec.$,
    'ServiceWorkerHost_NavigateClient_Params',
    [
      mojo.internal.StructField(
        'clientUuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerHost_NavigateClient_Params {
  constructor() {
    /** @type { !string } */
    this.clientUuid;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_NavigateClient_ResponseParamsSpec.$,
    'ServiceWorkerHost_NavigateClient_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        blink_mojom_ServiceWorkerClientInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorkerHost_NavigateClient_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (blink_mojom_ServiceWorkerClientInfo|undefined) } */
    this.client;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_SkipWaiting_ParamsSpec.$,
    'ServiceWorkerHost_SkipWaiting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerHost_SkipWaiting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_SkipWaiting_ResponseParamsSpec.$,
    'ServiceWorkerHost_SkipWaiting_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_SkipWaiting_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_ClaimClients_ParamsSpec.$,
    'ServiceWorkerHost_ClaimClients_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorkerHost_ClaimClients_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_ClaimClients_ResponseParamsSpec.$,
    'ServiceWorkerHost_ClaimClients_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ServiceWorkerErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMsg', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorkerHost_ClaimClients_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerErrorType } */
    this.error;
    /** @type { (string|undefined) } */
    this.errorMsg;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_AddRoutes_ParamsSpec.$,
    'ServiceWorkerHost_AddRoutes_Params',
    [
      mojo.internal.StructField(
        'rules', 0,
        0,
        blink_mojom_ServiceWorkerRouterRulesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_AddRoutes_Params {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerRouterRules } */
    this.rules;
  }
}



mojo.internal.Struct(
    ServiceWorkerHost_AddRoutes_ResponseParamsSpec.$,
    'ServiceWorkerHost_AddRoutes_ResponseParams',
    [
      mojo.internal.StructField(
        'isParseError', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorkerHost_AddRoutes_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isParseError;
  }
}



mojo.internal.Struct(
    ServiceWorker_InitializeGlobalScope_ParamsSpec.$,
    'ServiceWorker_InitializeGlobalScope_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerHost', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(ServiceWorkerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'associatedInterfacesToBrowser', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink_mojom_AssociatedInterfaceProviderRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'associatedInterfacesFromBrowser', 16,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink_mojom_AssociatedInterfaceProviderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'registrationInfo', 24,
        0,
        blink_mojom_ServiceWorkerRegistrationObjectInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerInfo', 32,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchHandlerExistence', 20,
        0,
        FetchHandlerExistenceSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ancestorFrameType', 40,
        0,
        blink_mojom_AncestorFrameTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'storageKey', 48,
        0,
        blink_mojom_StorageKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class ServiceWorker_InitializeGlobalScope_Params {
  constructor() {
    /** @type { !Object } */
    this.serviceWorkerHost;
    /** @type { !Object } */
    this.associatedInterfacesToBrowser;
    /** @type { !Object } */
    this.associatedInterfacesFromBrowser;
    /** @type { !blink_mojom_ServiceWorkerRegistrationObjectInfo } */
    this.registrationInfo;
    /** @type { !blink_mojom_ServiceWorkerObjectInfo } */
    this.serviceWorkerInfo;
    /** @type { !FetchHandlerExistence } */
    this.fetchHandlerExistence;
    /** @type { !blink_mojom_AncestorFrameType } */
    this.ancestorFrameType;
    /** @type { !blink_mojom_StorageKey } */
    this.storageKey;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchInstallEvent_ParamsSpec.$,
    'ServiceWorker_DispatchInstallEvent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorker_DispatchInstallEvent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchInstallEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchInstallEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchCount', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchInstallEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
    /** @type { !number } */
    this.fetchCount;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchActivateEvent_ParamsSpec.$,
    'ServiceWorker_DispatchActivateEvent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorker_DispatchActivateEvent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchActivateEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchActivateEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchActivateEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchAbortEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchAbortEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink_mojom_BackgroundFetchRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchAbortEvent_Params {
  constructor() {
    /** @type { !blink_mojom_BackgroundFetchRegistration } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchAbortEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchClickEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchClickEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink_mojom_BackgroundFetchRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchClickEvent_Params {
  constructor() {
    /** @type { !blink_mojom_BackgroundFetchRegistration } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchClickEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchFailEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchFailEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink_mojom_BackgroundFetchRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchFailEvent_Params {
  constructor() {
    /** @type { !blink_mojom_BackgroundFetchRegistration } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchFailEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchSuccessEvent_ParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        blink_mojom_BackgroundFetchRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchSuccessEvent_Params {
  constructor() {
    /** @type { !blink_mojom_BackgroundFetchRegistration } */
    this.registration;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchBackgroundFetchSuccessEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchCookieChangeEvent_ParamsSpec.$,
    'ServiceWorker_DispatchCookieChangeEvent_Params',
    [
      mojo.internal.StructField(
        'change', 0,
        0,
        network_mojom_CookieChangeInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchCookieChangeEvent_Params {
  constructor() {
    /** @type { !network_mojom_CookieChangeInfo } */
    this.change;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchCookieChangeEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchCookieChangeEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchCookieChangeEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchFetchEventForMainResource_ParamsSpec.$,
    'ServiceWorker_DispatchFetchEventForMainResource_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink_mojom_DispatchFetchEventParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseCallback', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ServiceWorkerFetchResponseCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchFetchEventForMainResource_Params {
  constructor() {
    /** @type { !blink_mojom_DispatchFetchEventParams } */
    this.params;
    /** @type { !blink_mojom_ServiceWorkerFetchResponseCallbackRemote } */
    this.responseCallback;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchFetchEventForMainResource_ResponseParamsSpec.$,
    'ServiceWorker_DispatchFetchEventForMainResource_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchFetchEventForMainResource_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchNotificationClickEvent_ParamsSpec.$,
    'ServiceWorker_DispatchNotificationClickEvent_Params',
    [
      mojo.internal.StructField(
        'notificationId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink_mojom_NotificationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'actionIndex', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reply', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ServiceWorker_DispatchNotificationClickEvent_Params {
  constructor() {
    /** @type { !string } */
    this.notificationId;
    /** @type { !blink_mojom_NotificationData } */
    this.notificationData;
    /** @type { !number } */
    this.actionIndex;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.reply;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchNotificationClickEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchNotificationClickEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchNotificationClickEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchNotificationCloseEvent_ParamsSpec.$,
    'ServiceWorker_DispatchNotificationCloseEvent_Params',
    [
      mojo.internal.StructField(
        'notificationId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'notificationData', 8,
        0,
        blink_mojom_NotificationDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchNotificationCloseEvent_Params {
  constructor() {
    /** @type { !string } */
    this.notificationId;
    /** @type { !blink_mojom_NotificationData } */
    this.notificationData;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchNotificationCloseEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchNotificationCloseEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchNotificationCloseEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPushEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPushEvent_Params',
    [
      mojo.internal.StructField(
        'payload', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPushEvent_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.payload;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPushEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPushEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPushEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPushEventRecordingNetworkRequests_ParamsSpec.$,
    'ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params',
    [
      mojo.internal.StructField(
        'payload', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPushEventRecordingNetworkRequests_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.payload;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestedUrls', 8,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPushEventRecordingNetworkRequests_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
    /** @type { (Array<!url_mojom_Url>|undefined) } */
    this.requestedUrls;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPushSubscriptionChangeEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPushSubscriptionChangeEvent_Params',
    [
      mojo.internal.StructField(
        'oldSubscription', 0,
        0,
        blink_mojom_PushSubscriptionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newSubscription', 8,
        0,
        blink_mojom_PushSubscriptionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPushSubscriptionChangeEvent_Params {
  constructor() {
    /** @type { (blink_mojom_PushSubscription|undefined) } */
    this.oldSubscription;
    /** @type { (blink_mojom_PushSubscription|undefined) } */
    this.newSubscription;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPushSubscriptionChangeEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchSyncEvent_ParamsSpec.$,
    'ServiceWorker_DispatchSyncEvent_Params',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastChance', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorker_DispatchSyncEvent_Params {
  constructor() {
    /** @type { !string } */
    this.tag;
    /** @type { !boolean } */
    this.lastChance;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timeout;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchSyncEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchSyncEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchSyncEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPeriodicSyncEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPeriodicSyncEvent_Params',
    [
      mojo.internal.StructField(
        'tag', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeout', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPeriodicSyncEvent_Params {
  constructor() {
    /** @type { !string } */
    this.tag;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timeout;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPeriodicSyncEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPeriodicSyncEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchAbortPaymentEvent_ParamsSpec.$,
    'ServiceWorker_DispatchAbortPaymentEvent_Params',
    [
      mojo.internal.StructField(
        'resultOfAbortPayment', 0,
        0,
        mojo.internal.InterfaceProxy(payments_mojom_PaymentHandlerResponseCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchAbortPaymentEvent_Params {
  constructor() {
    /** @type { !payments_mojom_PaymentHandlerResponseCallbackRemote } */
    this.resultOfAbortPayment;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchAbortPaymentEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchAbortPaymentEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchAbortPaymentEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchCanMakePaymentEvent_ParamsSpec.$,
    'ServiceWorker_DispatchCanMakePaymentEvent_Params',
    [
      mojo.internal.StructField(
        'eventData', 0,
        0,
        payments_mojom_CanMakePaymentEventDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resultOfCanMakePayment', 8,
        0,
        mojo.internal.InterfaceProxy(payments_mojom_PaymentHandlerResponseCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchCanMakePaymentEvent_Params {
  constructor() {
    /** @type { !payments_mojom_CanMakePaymentEventData } */
    this.eventData;
    /** @type { !payments_mojom_PaymentHandlerResponseCallbackRemote } */
    this.resultOfCanMakePayment;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchCanMakePaymentEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchCanMakePaymentEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPaymentRequestEvent_ParamsSpec.$,
    'ServiceWorker_DispatchPaymentRequestEvent_Params',
    [
      mojo.internal.StructField(
        'requestData', 0,
        0,
        payments_mojom_PaymentRequestEventDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseCallback', 8,
        0,
        mojo.internal.InterfaceProxy(payments_mojom_PaymentHandlerResponseCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPaymentRequestEvent_Params {
  constructor() {
    /** @type { !payments_mojom_PaymentRequestEventData } */
    this.requestData;
    /** @type { !payments_mojom_PaymentHandlerResponseCallbackRemote } */
    this.responseCallback;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchPaymentRequestEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchPaymentRequestEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchPaymentRequestEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchExtendableMessageEvent_ParamsSpec.$,
    'ServiceWorker_DispatchExtendableMessageEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        ExtendableMessageEventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchExtendableMessageEvent_Params {
  constructor() {
    /** @type { !ExtendableMessageEvent } */
    this.event;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchExtendableMessageEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchExtendableMessageEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchExtendableMessageEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchContentDeleteEvent_ParamsSpec.$,
    'ServiceWorker_DispatchContentDeleteEvent_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchContentDeleteEvent_Params {
  constructor() {
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    ServiceWorker_DispatchContentDeleteEvent_ResponseParamsSpec.$,
    'ServiceWorker_DispatchContentDeleteEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_DispatchContentDeleteEvent_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ServiceWorker_Ping_ParamsSpec.$,
    'ServiceWorker_Ping_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorker_Ping_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorker_Ping_ResponseParamsSpec.$,
    'ServiceWorker_Ping_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorker_Ping_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorker_SetIdleDelay_ParamsSpec.$,
    'ServiceWorker_SetIdleDelay_Params',
    [
      mojo.internal.StructField(
        'delay', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceWorker_SetIdleDelay_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.delay;
  }
}



mojo.internal.Struct(
    ServiceWorker_AddKeepAlive_ParamsSpec.$,
    'ServiceWorker_AddKeepAlive_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorker_AddKeepAlive_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorker_ClearKeepAlive_ParamsSpec.$,
    'ServiceWorker_ClearKeepAlive_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ServiceWorker_ClearKeepAlive_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ServiceWorker_AddMessageToConsole_ParamsSpec.$,
    'ServiceWorker_AddMessageToConsole_Params',
    [
      mojo.internal.StructField(
        'level', 0,
        0,
        blink_mojom_ConsoleMessageLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_AddMessageToConsole_Params {
  constructor() {
    /** @type { !blink_mojom_ConsoleMessageLevel } */
    this.level;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    ServiceWorker_ExecuteScriptForTest_ParamsSpec.$,
    'ServiceWorker_ExecuteScriptForTest_Params',
    [
      mojo.internal.StructField(
        'javascript', 0,
        0,
        mojoBase_mojom_BigString16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wantsResult', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ServiceWorker_ExecuteScriptForTest_Params {
  constructor() {
    /** @type { !mojoBase_mojom_BigString16 } */
    this.javascript;
    /** @type { !boolean } */
    this.wantsResult;
  }
}



mojo.internal.Struct(
    ServiceWorker_ExecuteScriptForTest_ResponseParamsSpec.$,
    'ServiceWorker_ExecuteScriptForTest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ServiceWorker_ExecuteScriptForTest_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_Value } */
    this.result;
    /** @type { (string|undefined) } */
    this.error;
  }
}

mojo.internal.Union(
    FocusResultSpec.$, 'FocusResult',
    {
      'client': {
        'ordinal': 0,
        'type': blink_mojom_ServiceWorkerClientInfoSpec.$,
      },
      'errorCode': {
        'ordinal': 1,
        'type': FocusErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   client: (!blink_mojom_ServiceWorkerClientInfo|undefined),
 *   errorCode: (!FocusError|undefined),
 * } }
 */
export const FocusResult = {};
