// third_party/blink/public/mojom/service_worker/service_worker.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "services/network/public/mojom/cookie_manager.mojom-blink-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-blink.h"
#include "third_party/blink/public/mojom/notifications/notification.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/payments/payment_app.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_ancestor_frame_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_client.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_response_callback.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-blink.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ServiceWorkerHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerHostStub;

class ServiceWorkerHostRequestValidator;
class ServiceWorkerHostResponseValidator;


class CORE_EXPORT ServiceWorkerHost
    : public ServiceWorkerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorkerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerHostInterfaceBase;
  using Proxy_ = ServiceWorkerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetCachedMetadataMinVersion = 0,
    kClearCachedMetadataMinVersion = 0,
    kGetClientsMinVersion = 0,
    kGetClientMinVersion = 0,
    kOpenNewTabMinVersion = 0,
    kOpenPaymentHandlerWindowMinVersion = 0,
    kPostMessageToClientMinVersion = 0,
    kFocusClientMinVersion = 0,
    kNavigateClientMinVersion = 0,
    kSkipWaitingMinVersion = 0,
    kClaimClientsMinVersion = 0,
    kAddRoutesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCachedMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearCachedMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetClients_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenNewTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenPaymentHandlerWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PostMessageToClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SkipWaiting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClaimClients_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddRoutes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerHost() = default;

  virtual void SetCachedMetadata(const ::blink::KURL& url, ::base::span<const ::uint8_t> data) = 0;

  virtual void ClearCachedMetadata(const ::blink::KURL& url) = 0;

  using GetClientsCallback = base::OnceCallback<void(::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr>)>;
  using GetClientsMojoCallback = base::OnceCallback<void(::blink::Vector<::blink::mojom::blink::ServiceWorkerClientInfoPtr>)>;

  virtual void GetClients(::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) = 0;

  using GetClientCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerClientInfoPtr)>;
  using GetClientMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerClientInfoPtr)>;

  virtual void GetClient(const ::blink::String& client_uuid, GetClientCallback callback) = 0;

  using OpenNewTabCallback = base::OnceCallback<void(bool, ::blink::mojom::blink::ServiceWorkerClientInfoPtr, const ::blink::String&)>;
  using OpenNewTabMojoCallback = base::OnceCallback<void(bool, ::blink::mojom::blink::ServiceWorkerClientInfoPtr, const ::blink::String&)>;

  virtual void OpenNewTab(const ::blink::KURL& url, OpenNewTabCallback callback) = 0;

  using OpenPaymentHandlerWindowCallback = base::OnceCallback<void(bool, ::blink::mojom::blink::ServiceWorkerClientInfoPtr, const ::blink::String&)>;
  using OpenPaymentHandlerWindowMojoCallback = base::OnceCallback<void(bool, ::blink::mojom::blink::ServiceWorkerClientInfoPtr, const ::blink::String&)>;

  virtual void OpenPaymentHandlerWindow(const ::blink::KURL& url, OpenPaymentHandlerWindowCallback callback) = 0;

  virtual void PostMessageToClient(const ::blink::String& client_uuid, ::blink::BlinkTransferableMessage message) = 0;

  using FocusClientCallback = base::OnceCallback<void(FocusResultPtr)>;
  using FocusClientMojoCallback = base::OnceCallback<void(FocusResultPtr)>;

  virtual void FocusClient(const ::blink::String& client_uuid, FocusClientCallback callback) = 0;

  using NavigateClientCallback = base::OnceCallback<void(bool, ::blink::mojom::blink::ServiceWorkerClientInfoPtr, const ::blink::String&)>;
  using NavigateClientMojoCallback = base::OnceCallback<void(bool, ::blink::mojom::blink::ServiceWorkerClientInfoPtr, const ::blink::String&)>;

  virtual void NavigateClient(const ::blink::String& client_uuid, const ::blink::KURL& url, NavigateClientCallback callback) = 0;

  using SkipWaitingCallback = base::OnceCallback<void(bool)>;
  using SkipWaitingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SkipWaiting(SkipWaitingCallback callback) = 0;

  using ClaimClientsCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&)>;
  using ClaimClientsMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const ::blink::String&)>;

  virtual void ClaimClients(ClaimClientsCallback callback) = 0;

  using AddRoutesCallback = base::OnceCallback<void(bool)>;
  using AddRoutesMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AddRoutes(const ::blink::ServiceWorkerRouterRules& rules, AddRoutesCallback callback) = 0;
};

class ServiceWorkerProxy;

template <typename ImplRefTraits>
class ServiceWorkerStub;

class ServiceWorkerRequestValidator;
class ServiceWorkerResponseValidator;


class CORE_EXPORT ServiceWorker
    : public ServiceWorkerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorker";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerInterfaceBase;
  using Proxy_ = ServiceWorkerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRequestValidator;
  using ResponseValidator_ = ServiceWorkerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kInitializeGlobalScopeMinVersion = 0,
    kDispatchInstallEventMinVersion = 0,
    kDispatchActivateEventMinVersion = 0,
    kDispatchBackgroundFetchAbortEventMinVersion = 0,
    kDispatchBackgroundFetchClickEventMinVersion = 0,
    kDispatchBackgroundFetchFailEventMinVersion = 0,
    kDispatchBackgroundFetchSuccessEventMinVersion = 0,
    kDispatchCookieChangeEventMinVersion = 0,
    kDispatchFetchEventForMainResourceMinVersion = 0,
    kDispatchNotificationClickEventMinVersion = 0,
    kDispatchNotificationCloseEventMinVersion = 0,
    kDispatchPushEventMinVersion = 0,
    kDispatchPushEventRecordingNetworkRequestsMinVersion = 0,
    kDispatchPushSubscriptionChangeEventMinVersion = 0,
    kDispatchSyncEventMinVersion = 0,
    kDispatchPeriodicSyncEventMinVersion = 0,
    kDispatchAbortPaymentEventMinVersion = 0,
    kDispatchCanMakePaymentEventMinVersion = 0,
    kDispatchPaymentRequestEventMinVersion = 0,
    kDispatchExtendableMessageEventMinVersion = 0,
    kDispatchContentDeleteEventMinVersion = 0,
    kPingMinVersion = 0,
    kSetIdleDelayMinVersion = 0,
    kAddKeepAliveMinVersion = 0,
    kClearKeepAliveMinVersion = 0,
    kAddMessageToConsoleMinVersion = 0,
    kExecuteScriptForTestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitializeGlobalScope_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchInstallEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchActivateEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchBackgroundFetchAbortEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchBackgroundFetchClickEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchBackgroundFetchFailEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchBackgroundFetchSuccessEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchCookieChangeEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchFetchEventForMainResource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchNotificationClickEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchNotificationCloseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPushEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPushEventRecordingNetworkRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPushSubscriptionChangeEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchSyncEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPeriodicSyncEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchAbortPaymentEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchCanMakePaymentEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPaymentRequestEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchExtendableMessageEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchContentDeleteEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIdleDelay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddKeepAlive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearKeepAlive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddMessageToConsole_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteScriptForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorker() = default;

  virtual void InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_to_browser, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_from_browser, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::blink::mojom::blink::AncestorFrameType ancestor_frame_type, const ::blink::BlinkStorageKey& storage_key) = 0;

  using DispatchInstallEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus, uint32_t)>;
  using DispatchInstallEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus, uint32_t)>;

  virtual void DispatchInstallEvent(DispatchInstallEventCallback callback) = 0;

  using DispatchActivateEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchActivateEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchActivateEvent(DispatchActivateEventCallback callback) = 0;

  using DispatchBackgroundFetchAbortEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchBackgroundFetchAbortEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchBackgroundFetchAbortEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) = 0;

  using DispatchBackgroundFetchClickEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchBackgroundFetchClickEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchBackgroundFetchClickEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) = 0;

  using DispatchBackgroundFetchFailEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchBackgroundFetchFailEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchBackgroundFetchFailEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) = 0;

  using DispatchBackgroundFetchSuccessEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchBackgroundFetchSuccessEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchBackgroundFetchSuccessEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) = 0;

  using DispatchCookieChangeEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchCookieChangeEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchCookieChangeEvent(::network::mojom::blink::CookieChangeInfoPtr change, DispatchCookieChangeEventCallback callback) = 0;

  using DispatchFetchEventForMainResourceCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchFetchEventForMainResourceMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchFetchEventForMainResource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) = 0;

  using DispatchNotificationClickEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchNotificationClickEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchNotificationClickEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply, DispatchNotificationClickEventCallback callback) = 0;

  using DispatchNotificationCloseEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchNotificationCloseEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchNotificationCloseEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, DispatchNotificationCloseEventCallback callback) = 0;

  using DispatchPushEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchPushEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchPushEvent(const ::blink::String& payload, DispatchPushEventCallback callback) = 0;

  using DispatchPushEventRecordingNetworkRequestsCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus, const std::optional<::blink::Vector<::blink::KURL>>&)>;
  using DispatchPushEventRecordingNetworkRequestsMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus, const std::optional<::blink::Vector<::blink::KURL>>&)>;

  virtual void DispatchPushEventRecordingNetworkRequests(const ::blink::String& payload, DispatchPushEventRecordingNetworkRequestsCallback callback) = 0;

  using DispatchPushSubscriptionChangeEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchPushSubscriptionChangeEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchPushSubscriptionChangeEvent(::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) = 0;

  using DispatchSyncEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchSyncEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchSyncEvent(const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) = 0;

  using DispatchPeriodicSyncEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchPeriodicSyncEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchPeriodicSyncEvent(const ::blink::String& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) = 0;

  using DispatchAbortPaymentEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchAbortPaymentEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) = 0;

  using DispatchCanMakePaymentEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchCanMakePaymentEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchCanMakePaymentEvent(::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) = 0;

  using DispatchPaymentRequestEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchPaymentRequestEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchPaymentRequestEvent(::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) = 0;

  using DispatchExtendableMessageEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchExtendableMessageEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) = 0;

  using DispatchContentDeleteEventCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;
  using DispatchContentDeleteEventMojoCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerEventStatus)>;

  virtual void DispatchContentDeleteEvent(const ::blink::String& id, DispatchContentDeleteEventCallback callback) = 0;

  using PingCallback = base::OnceCallback<void()>;
  using PingMojoCallback = base::OnceCallback<void()>;

  virtual void Ping(PingCallback callback) = 0;

  virtual void SetIdleDelay(::base::TimeDelta delay) = 0;

  virtual void AddKeepAlive() = 0;

  virtual void ClearKeepAlive() = 0;

  virtual void AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message) = 0;

  using ExecuteScriptForTestCallback = base::OnceCallback<void(::base::Value, const ::blink::String&)>;
  using ExecuteScriptForTestMojoCallback = base::OnceCallback<void(::base::Value, const ::blink::String&)>;

  virtual void ExecuteScriptForTest(const ::blink::String& javascript, bool wants_result, ExecuteScriptForTestCallback callback) = 0;
};



class CORE_EXPORT ServiceWorkerHostProxy
    : public ServiceWorkerHost {
 public:
  using InterfaceType = ServiceWorkerHost;

  explicit ServiceWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCachedMetadata(const ::blink::KURL& url, ::base::span<const ::uint8_t> data) final;
  
  void ClearCachedMetadata(const ::blink::KURL& url) final;
  
  void GetClients(::blink::mojom::blink::ServiceWorkerClientQueryOptionsPtr options, GetClientsCallback callback) final;
  
  void GetClient(const ::blink::String& client_uuid, GetClientCallback callback) final;
  
  void OpenNewTab(const ::blink::KURL& url, OpenNewTabCallback callback) final;
  
  void OpenPaymentHandlerWindow(const ::blink::KURL& url, OpenPaymentHandlerWindowCallback callback) final;
  
  void PostMessageToClient(const ::blink::String& client_uuid, ::blink::BlinkTransferableMessage message) final;
  
  void FocusClient(const ::blink::String& client_uuid, FocusClientCallback callback) final;
  
  void NavigateClient(const ::blink::String& client_uuid, const ::blink::KURL& url, NavigateClientCallback callback) final;
  
  void SkipWaiting(SkipWaitingCallback callback) final;
  
  void ClaimClients(ClaimClientsCallback callback) final;
  
  void AddRoutes(const ::blink::ServiceWorkerRouterRules& rules, AddRoutesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT ServiceWorkerProxy
    : public ServiceWorker {
 public:
  using InterfaceType = ServiceWorker;

  explicit ServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitializeGlobalScope(::mojo::PendingAssociatedRemote<ServiceWorkerHost> service_worker_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_to_browser, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::AssociatedInterfaceProvider> associated_interfaces_from_browser, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr registration_info, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr service_worker_info, FetchHandlerExistence fetch_handler_existence, ::blink::mojom::blink::AncestorFrameType ancestor_frame_type, const ::blink::BlinkStorageKey& storage_key) final;
  
  void DispatchInstallEvent(DispatchInstallEventCallback callback) final;
  
  void DispatchActivateEvent(DispatchActivateEventCallback callback) final;
  
  void DispatchBackgroundFetchAbortEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchAbortEventCallback callback) final;
  
  void DispatchBackgroundFetchClickEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchClickEventCallback callback) final;
  
  void DispatchBackgroundFetchFailEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchFailEventCallback callback) final;
  
  void DispatchBackgroundFetchSuccessEvent(::blink::mojom::blink::BackgroundFetchRegistrationPtr registration, DispatchBackgroundFetchSuccessEventCallback callback) final;
  
  void DispatchCookieChangeEvent(::network::mojom::blink::CookieChangeInfoPtr change, DispatchCookieChangeEventCallback callback) final;
  
  void DispatchFetchEventForMainResource(::blink::mojom::blink::DispatchFetchEventParamsPtr params, ::mojo::PendingRemote<::blink::mojom::blink::ServiceWorkerFetchResponseCallback> response_callback, DispatchFetchEventForMainResourceCallback callback) final;
  
  void DispatchNotificationClickEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, int32_t action_index, const ::blink::String& reply, DispatchNotificationClickEventCallback callback) final;
  
  void DispatchNotificationCloseEvent(const ::blink::String& notification_id, ::blink::mojom::blink::NotificationDataPtr notification_data, DispatchNotificationCloseEventCallback callback) final;
  
  void DispatchPushEvent(const ::blink::String& payload, DispatchPushEventCallback callback) final;
  
  void DispatchPushEventRecordingNetworkRequests(const ::blink::String& payload, DispatchPushEventRecordingNetworkRequestsCallback callback) final;
  
  void DispatchPushSubscriptionChangeEvent(::blink::mojom::blink::PushSubscriptionPtr old_subscription, ::blink::mojom::blink::PushSubscriptionPtr new_subscription, DispatchPushSubscriptionChangeEventCallback callback) final;
  
  void DispatchSyncEvent(const ::blink::String& tag, bool last_chance, ::base::TimeDelta timeout, DispatchSyncEventCallback callback) final;
  
  void DispatchPeriodicSyncEvent(const ::blink::String& tag, ::base::TimeDelta timeout, DispatchPeriodicSyncEventCallback callback) final;
  
  void DispatchAbortPaymentEvent(::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_abort_payment, DispatchAbortPaymentEventCallback callback) final;
  
  void DispatchCanMakePaymentEvent(::payments::mojom::blink::CanMakePaymentEventDataPtr event_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> result_of_can_make_payment, DispatchCanMakePaymentEventCallback callback) final;
  
  void DispatchPaymentRequestEvent(::payments::mojom::blink::PaymentRequestEventDataPtr request_data, ::mojo::PendingRemote<::payments::mojom::blink::PaymentHandlerResponseCallback> response_callback, DispatchPaymentRequestEventCallback callback) final;
  
  void DispatchExtendableMessageEvent(ExtendableMessageEventPtr event, DispatchExtendableMessageEventCallback callback) final;
  
  void DispatchContentDeleteEvent(const ::blink::String& id, DispatchContentDeleteEventCallback callback) final;
  
  void Ping(PingCallback callback) final;
  
  void SetIdleDelay(::base::TimeDelta delay) final;
  
  void AddKeepAlive() final;
  
  void ClearKeepAlive() final;
  
  void AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message) final;
  
  void ExecuteScriptForTest(const ::blink::String& javascript, bool wants_result, ExecuteScriptForTestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT ServiceWorkerHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerHost>>
class ServiceWorkerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerHostStub() = default;
  ~ServiceWorkerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ServiceWorkerStubDispatch {
 public:
  static bool Accept(ServiceWorker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorker>>
class ServiceWorkerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerStub() = default;
  ~ServiceWorkerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ServiceWorkerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CORE_EXPORT FocusResult {
 public:
  using DataView = FocusResultDataView;
  using Data_ = internal::FocusResult_Data;
  using Tag = Data_::FocusResult_Tag;

  template <typename... Args>
  static FocusResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |client|.
  static FocusResultPtr NewClient(
      ::blink::mojom::blink::ServiceWorkerClientInfoPtr value);
  // Construct an instance holding |error_code|.
  static FocusResultPtr NewErrorCode(
      FocusError value);

  template <typename U>
  static FocusResultPtr From(const U& u) {
    return mojo::TypeConverter<FocusResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FocusResult>::Convert(*this);
  }
  ~FocusResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FocusResult(const FocusResult& other) = delete;
  FocusResult& operator=(const FocusResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FocusResultPtr>
  FocusResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FocusResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FocusResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_client() const { return tag_ == Tag::kClient; }
  const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& get_client() const {
    CHECK(tag_ == Tag::kClient);
    return data_.client;
  }
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr& get_client() {
    CHECK(tag_ == Tag::kClient);
    return data_.client;
  }
  void set_client(::blink::mojom::blink::ServiceWorkerClientInfoPtr client);

  bool is_error_code() const { return tag_ == Tag::kErrorCode; }
  FocusError get_error_code() const {
    CHECK(tag_ == Tag::kErrorCode);
    return data_.error_code;
  }
  void set_error_code(FocusError error_code);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FocusResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FocusResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kClient)>,
        ::blink::mojom::blink::ServiceWorkerClientInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
        FocusError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::mojom::blink::ServiceWorkerClientInfoPtr client;
    FocusError error_code;
  };

  FocusResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kClient)>,
      ::blink::mojom::blink::ServiceWorkerClientInfoPtr value);
  FocusResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
      FocusError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CORE_EXPORT ExtendableMessageEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtendableMessageEvent, T>::value>;
  using DataView = ExtendableMessageEventDataView;
  using Data_ = internal::ExtendableMessageEvent_Data;

  template <typename... Args>
  static ExtendableMessageEventPtr New(Args&&... args) {
    return ExtendableMessageEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtendableMessageEventPtr From(const U& u) {
    return mojo::TypeConverter<ExtendableMessageEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtendableMessageEvent>::Convert(*this);
  }


  ExtendableMessageEvent();

  ExtendableMessageEvent(
      ::blink::BlinkTransferableMessage message,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin,
      ::blink::mojom::blink::ServiceWorkerClientInfoPtr source_info_for_client,
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr source_info_for_service_worker);

ExtendableMessageEvent(const ExtendableMessageEvent&) = delete;
ExtendableMessageEvent& operator=(const ExtendableMessageEvent&) = delete;

  ~ExtendableMessageEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtendableMessageEventPtr>
  ExtendableMessageEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtendableMessageEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtendableMessageEvent_UnserializedMessageContext<
            UserType, ExtendableMessageEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtendableMessageEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtendableMessageEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtendableMessageEvent_UnserializedMessageContext<
            UserType, ExtendableMessageEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtendableMessageEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::BlinkTransferableMessage message;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> source_origin;
  
  ::blink::mojom::blink::ServiceWorkerClientInfoPtr source_info_for_client;
  
  ::blink::mojom::blink::ServiceWorkerObjectInfoPtr source_info_for_service_worker;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FocusResultPtr FocusResult::Clone() const {
  switch (tag_) {
    case Tag::kClient:
      return NewClient(
          mojo::Clone(data_.client));
    case Tag::kErrorCode:
      return NewErrorCode(
          mojo::Clone(data_.error_code));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FocusResult>::value>::type*>
bool FocusResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kClient:
      return mojo::Equals(data_.client, other.data_.client);
    case Tag::kErrorCode:
      return mojo::Equals(data_.error_code, other.data_.error_code);
  }

  return false;
}
template <typename StructPtrType>
ExtendableMessageEventPtr ExtendableMessageEvent::Clone() const {
  return New(
      mojo::Clone(message),
      mojo::Clone(source_origin),
      mojo::Clone(source_info_for_client),
      mojo::Clone(source_info_for_service_worker)
  );
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>*>
bool ExtendableMessageEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  if (!mojo::Equals(this->source_info_for_client, other_struct.source_info_for_client))
    return false;
  if (!mojo::Equals(this->source_info_for_service_worker, other_struct.source_info_for_service_worker))
    return false;
  return true;
}

template <typename T, ExtendableMessageEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.source_origin < rhs.source_origin)
    return true;
  if (rhs.source_origin < lhs.source_origin)
    return false;
  if (lhs.source_info_for_client < rhs.source_info_for_client)
    return true;
  if (rhs.source_info_for_client < lhs.source_info_for_client)
    return false;
  if (lhs.source_info_for_service_worker < rhs.source_info_for_service_worker)
    return true;
  if (rhs.source_info_for_service_worker < lhs.source_info_for_service_worker)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ExtendableMessageEvent::DataView,
                                         ::blink::mojom::blink::ExtendableMessageEventPtr> {
  static bool IsNull(const ::blink::mojom::blink::ExtendableMessageEventPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ExtendableMessageEventPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::ExtendableMessageEvent::message)& message(
       ::blink::mojom::blink::ExtendableMessageEventPtr& input) {
    return input->message;
  }

  static const decltype(::blink::mojom::blink::ExtendableMessageEvent::source_origin)& source_origin(
      const ::blink::mojom::blink::ExtendableMessageEventPtr& input) {
    return input->source_origin;
  }

  static const decltype(::blink::mojom::blink::ExtendableMessageEvent::source_info_for_client)& source_info_for_client(
      const ::blink::mojom::blink::ExtendableMessageEventPtr& input) {
    return input->source_info_for_client;
  }

  static  decltype(::blink::mojom::blink::ExtendableMessageEvent::source_info_for_service_worker)& source_info_for_service_worker(
       ::blink::mojom::blink::ExtendableMessageEventPtr& input) {
    return input->source_info_for_service_worker;
  }

  static bool Read(::blink::mojom::blink::ExtendableMessageEvent::DataView input, ::blink::mojom::blink::ExtendableMessageEventPtr* output);
};


template <>
struct CORE_EXPORT UnionTraits<::blink::mojom::blink::FocusResult::DataView,
                                        ::blink::mojom::blink::FocusResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::FocusResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FocusResultPtr* output) { output->reset(); }

  static ::blink::mojom::blink::FocusResult::Tag GetTag(const ::blink::mojom::blink::FocusResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::blink::ServiceWorkerClientInfoPtr& client(const ::blink::mojom::blink::FocusResultPtr& input) {
    return input->get_client();
  }

  static  ::blink::mojom::blink::FocusError error_code(const ::blink::mojom::blink::FocusResultPtr& input) {
    return input->get_error_code();
  }

  static bool Read(::blink::mojom::blink::FocusResult::DataView input, ::blink::mojom::blink::FocusResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_MOJOM_BLINK_H_