// third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_DISPATCH_FETCH_EVENT_PARAMS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_DISPATCH_FETCH_EVENT_PARAMS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT DispatchFetchEventParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DispatchFetchEventParams, T>::value>;
  using DataView = DispatchFetchEventParamsDataView;
  using Data_ = internal::DispatchFetchEventParams_Data;

  template <typename... Args>
  static DispatchFetchEventParamsPtr New(Args&&... args) {
    return DispatchFetchEventParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DispatchFetchEventParamsPtr From(const U& u) {
    return mojo::TypeConverter<DispatchFetchEventParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DispatchFetchEventParams>::Convert(*this);
  }


  DispatchFetchEventParams();

  DispatchFetchEventParams(
      ::blink::mojom::FetchAPIRequestPtr request,
      const std::string& client_id,
      const std::string& resulting_client_id,
      ::mojo::PendingReceiver<::network::mojom::URLLoaderClient> preload_url_loader_client_receiver,
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> race_network_request_loader_factory);

DispatchFetchEventParams(const DispatchFetchEventParams&) = delete;
DispatchFetchEventParams& operator=(const DispatchFetchEventParams&) = delete;

  ~DispatchFetchEventParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DispatchFetchEventParamsPtr>
  DispatchFetchEventParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DispatchFetchEventParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DispatchFetchEventParams_UnserializedMessageContext<
            UserType, DispatchFetchEventParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DispatchFetchEventParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DispatchFetchEventParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DispatchFetchEventParams_UnserializedMessageContext<
            UserType, DispatchFetchEventParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DispatchFetchEventParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::FetchAPIRequestPtr request;
  
  std::string client_id;
  
  std::string resulting_client_id;
  
  ::mojo::PendingReceiver<::network::mojom::URLLoaderClient> preload_url_loader_client_receiver;
  
  ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> race_network_request_loader_factory;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DispatchFetchEventParamsPtr DispatchFetchEventParams::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(client_id),
      mojo::Clone(resulting_client_id),
      mojo::Clone(preload_url_loader_client_receiver),
      mojo::Clone(race_network_request_loader_factory)
  );
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>*>
bool DispatchFetchEventParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  if (!mojo::Equals(this->resulting_client_id, other_struct.resulting_client_id))
    return false;
  if (!mojo::Equals(this->preload_url_loader_client_receiver, other_struct.preload_url_loader_client_receiver))
    return false;
  if (!mojo::Equals(this->race_network_request_loader_factory, other_struct.race_network_request_loader_factory))
    return false;
  return true;
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.client_id < rhs.client_id)
    return true;
  if (rhs.client_id < lhs.client_id)
    return false;
  if (lhs.resulting_client_id < rhs.resulting_client_id)
    return true;
  if (rhs.resulting_client_id < lhs.resulting_client_id)
    return false;
  if (lhs.preload_url_loader_client_receiver < rhs.preload_url_loader_client_receiver)
    return true;
  if (rhs.preload_url_loader_client_receiver < lhs.preload_url_loader_client_receiver)
    return false;
  if (lhs.race_network_request_loader_factory < rhs.race_network_request_loader_factory)
    return true;
  if (rhs.race_network_request_loader_factory < lhs.race_network_request_loader_factory)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DispatchFetchEventParams::DataView,
                                         ::blink::mojom::DispatchFetchEventParamsPtr> {
  static bool IsNull(const ::blink::mojom::DispatchFetchEventParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DispatchFetchEventParamsPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::DispatchFetchEventParams::request)& request(
       ::blink::mojom::DispatchFetchEventParamsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::DispatchFetchEventParams::client_id)& client_id(
      const ::blink::mojom::DispatchFetchEventParamsPtr& input) {
    return input->client_id;
  }

  static const decltype(::blink::mojom::DispatchFetchEventParams::resulting_client_id)& resulting_client_id(
      const ::blink::mojom::DispatchFetchEventParamsPtr& input) {
    return input->resulting_client_id;
  }

  static  decltype(::blink::mojom::DispatchFetchEventParams::preload_url_loader_client_receiver)& preload_url_loader_client_receiver(
       ::blink::mojom::DispatchFetchEventParamsPtr& input) {
    return input->preload_url_loader_client_receiver;
  }

  static  decltype(::blink::mojom::DispatchFetchEventParams::race_network_request_loader_factory)& race_network_request_loader_factory(
       ::blink::mojom::DispatchFetchEventParamsPtr& input) {
    return input->race_network_request_loader_factory;
  }

  static bool Read(::blink::mojom::DispatchFetchEventParams::DataView input, ::blink::mojom::DispatchFetchEventParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_DISPATCH_FETCH_EVENT_PARAMS_MOJOM_H_