// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ControllerServiceWorkerMode');
goog.require('blink.mojom.ServiceWorkerEmbeddedWorkerStatus');
goog.require('blink.mojom.ServiceWorkerEventStatus');
goog.require('blink.mojom.ServiceWorkerFetchHandlerBypassOption');
goog.require('blink.mojom.ServiceWorkerFetchHandlerType');
goog.require('blink.mojom.WebFeature');
goog.require('blink.mojom.CacheStorage');
goog.require('network.mojom.CrossOriginEmbedderPolicyReporter');
goog.require('network.mojom.DocumentIsolationPolicyReporter');
goog.require('blink.mojom.ServiceWorkerFetchResponseCallback');
goog.require('blink.mojom.ServiceWorkerRunningStatusCallback');
goog.require('network.mojom.CrossOriginEmbedderPolicy');
goog.require('blink.mojom.DispatchFetchEventParams');
goog.require('network.mojom.DocumentIsolationPolicy');
goog.require('blink.mojom.ServiceWorkerObjectInfo');
goog.require('blink.mojom.ServiceWorkerRouterRules');
goog.require('mojoBase.mojom.UnguessableToken');






goog.provide('blink.mojom.ControllerServiceWorker');
goog.provide('blink.mojom.ControllerServiceWorkerReceiver');
goog.provide('blink.mojom.ControllerServiceWorkerCallbackRouter');
goog.provide('blink.mojom.ControllerServiceWorkerInterface');
goog.provide('blink.mojom.ControllerServiceWorkerRemote');
goog.provide('blink.mojom.ControllerServiceWorkerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ControllerServiceWorkerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ControllerServiceWorker.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ControllerServiceWorkerInterface = class {
  
  /**
   * @param { !blink.mojom.DispatchFetchEventParams } params
   * @param { !blink.mojom.ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForSubresource(params, responseCallback) {}
  
  /**
   * @param { !blink.mojom.ControllerServiceWorkerPendingReceiver } receiver
   * @param { !network.mojom.CrossOriginEmbedderPolicy } crossOriginEmbedderPolicy
   * @param { ?network.mojom.CrossOriginEmbedderPolicyReporterRemote } coepReporter
   * @param { !network.mojom.DocumentIsolationPolicy } documentIsolationPolicy
   * @param { ?network.mojom.DocumentIsolationPolicyReporterRemote } dipReporter
   */

  clone(receiver, crossOriginEmbedderPolicy, coepReporter, documentIsolationPolicy, dipReporter) {}
};

/**
 * @export
 * @implements { blink.mojom.ControllerServiceWorkerInterface }
 */
blink.mojom.ControllerServiceWorkerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ControllerServiceWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ControllerServiceWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ControllerServiceWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DispatchFetchEventParams } params
   * @param { !blink.mojom.ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink.mojom.ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForSubresource(
      params,
      responseCallback) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
        blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
        [
          params,
          responseCallback
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ControllerServiceWorkerPendingReceiver } receiver
   * @param { !network.mojom.CrossOriginEmbedderPolicy } crossOriginEmbedderPolicy
   * @param { ?network.mojom.CrossOriginEmbedderPolicyReporterRemote } coepReporter
   * @param { !network.mojom.DocumentIsolationPolicy } documentIsolationPolicy
   * @param { ?network.mojom.DocumentIsolationPolicyReporterRemote } dipReporter
   */

  clone(
      receiver,
      crossOriginEmbedderPolicy,
      coepReporter,
      documentIsolationPolicy,
      dipReporter) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ControllerServiceWorker_Clone_ParamsSpec.$,
        null,
        [
          receiver,
          crossOriginEmbedderPolicy,
          coepReporter,
          documentIsolationPolicy,
          dipReporter
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ControllerServiceWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ControllerServiceWorkerReceiver = class {
  /**
   * @param {!blink.mojom.ControllerServiceWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ControllerServiceWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ControllerServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ControllerServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
        blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
        impl.dispatchFetchEventForSubresource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ControllerServiceWorker_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ControllerServiceWorker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ControllerServiceWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ControllerServiceWorkerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ControllerServiceWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ControllerServiceWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ControllerServiceWorkerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ControllerServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ControllerServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchFetchEventForSubresource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
        blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
        this.dispatchFetchEventForSubresource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ControllerServiceWorker_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ControllerServiceWorkerConnector');
goog.provide('blink.mojom.ControllerServiceWorkerConnectorReceiver');
goog.provide('blink.mojom.ControllerServiceWorkerConnectorCallbackRouter');
goog.provide('blink.mojom.ControllerServiceWorkerConnectorInterface');
goog.provide('blink.mojom.ControllerServiceWorkerConnectorRemote');
goog.provide('blink.mojom.ControllerServiceWorkerConnectorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ControllerServiceWorkerConnectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ControllerServiceWorkerConnector.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ControllerServiceWorkerConnectorInterface = class {
  
  /**
   * @param { ?blink.mojom.ControllerServiceWorkerRemote } controller
   */

  updateController(controller) {}
};

/**
 * @export
 * @implements { blink.mojom.ControllerServiceWorkerConnectorInterface }
 */
blink.mojom.ControllerServiceWorkerConnectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ControllerServiceWorkerConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ControllerServiceWorkerConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ControllerServiceWorkerConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?blink.mojom.ControllerServiceWorkerRemote } controller
   */

  updateController(
      controller) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
        null,
        [
          controller
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ControllerServiceWorkerConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ControllerServiceWorkerConnectorReceiver = class {
  /**
   * @param {!blink.mojom.ControllerServiceWorkerConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ControllerServiceWorkerConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ControllerServiceWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ControllerServiceWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
        null,
        impl.updateController.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ControllerServiceWorkerConnector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ControllerServiceWorkerConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ControllerServiceWorkerConnectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ControllerServiceWorkerConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ControllerServiceWorkerConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ControllerServiceWorkerConnectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ControllerServiceWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ControllerServiceWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
        null,
        this.updateController.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ServiceWorkerRouterDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerRouterDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ControllerServiceWorkerInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ControllerServiceWorkerInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ControllerServiceWorker_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ControllerServiceWorker_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ControllerServiceWorkerConnector_UpdateController_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ControllerServiceWorkerConnector_UpdateController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ServiceWorkerRouterDataSpec.$,
    'ServiceWorkerRouterData',
    [
      mojo.internal.StructField(
        'routerRules', 0,
        0,
        blink.mojom.ServiceWorkerRouterRulesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initial_running_status_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "initial_running_status_$value",
          originalFieldName: "initialRunningStatus",
        }
      ),
      mojo.internal.StructField(
        'initial_running_status_$value', 12,
        0,
        blink.mojom.ServiceWorkerEmbeddedWorkerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "initialRunningStatus",
        }
      ),
      mojo.internal.StructField(
        'runningStatusReceiver', 16,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ServiceWorkerRunningStatusCallbackPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteCacheStorage', 20,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.CacheStorageRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.ServiceWorkerRouterData');

/** @record */
blink.mojom.ServiceWorkerRouterData = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerRouterRules } */
    this.routerRules;
    /** @export { (blink.mojom.ServiceWorkerEmbeddedWorkerStatus|undefined) } */
    this.initialRunningStatus;
    /** @export { (blink.mojom.ServiceWorkerRunningStatusCallbackPendingReceiver|undefined) } */
    this.runningStatusReceiver;
    /** @export { !blink.mojom.CacheStorageRemote } */
    this.remoteCacheStorage;
  }
};



mojo.internal.Struct(
    blink.mojom.ControllerServiceWorkerInfoSpec.$,
    'ControllerServiceWorkerInfo',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.ControllerServiceWorkerModeSpec.$,
        blink.mojom.ControllerServiceWorkerMode.kNoController,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchHandlerType', 4,
        0,
        blink.mojom.ServiceWorkerFetchHandlerTypeSpec.$,
        blink.mojom.ServiceWorkerFetchHandlerType.kNoHandler,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchHandlerBypassOption', 8,
        0,
        blink.mojom.ServiceWorkerFetchHandlerBypassOptionSpec.$,
        blink.mojom.ServiceWorkerFetchHandlerBypassOption.kDefault,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sha256ScriptChecksum', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needRouterEvaluate', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'routerData', 24,
        0,
        blink.mojom.ServiceWorkerRouterDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteController', 32,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ControllerServiceWorkerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientId', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchRequestWindowId', 48,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'objectInfo', 56,
        0,
        blink.mojom.ServiceWorkerObjectInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usedFeatures', 64,
        0,
        mojo.internal.Array(blink.mojom.WebFeatureSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('blink.mojom.ControllerServiceWorkerInfo');

/** @record */
blink.mojom.ControllerServiceWorkerInfo = class {
  constructor() {
    /** @export { !blink.mojom.ControllerServiceWorkerMode } */
    this.mode;
    /** @export { !blink.mojom.ServiceWorkerFetchHandlerType } */
    this.fetchHandlerType;
    /** @export { !blink.mojom.ServiceWorkerFetchHandlerBypassOption } */
    this.fetchHandlerBypassOption;
    /** @export { (string|undefined) } */
    this.sha256ScriptChecksum;
    /** @export { !boolean } */
    this.needRouterEvaluate;
    /** @export { (blink.mojom.ServiceWorkerRouterData|undefined) } */
    this.routerData;
    /** @export { (blink.mojom.ControllerServiceWorkerRemote|undefined) } */
    this.remoteController;
    /** @export { !string } */
    this.clientId;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.fetchRequestWindowId;
    /** @export { (blink.mojom.ServiceWorkerObjectInfo|undefined) } */
    this.objectInfo;
    /** @export { !Array<!blink.mojom.WebFeature> } */
    this.usedFeatures;
  }
};



mojo.internal.Struct(
    blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
    'ControllerServiceWorker_DispatchFetchEventForSubresource_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.DispatchFetchEventParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseCallback', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ServiceWorkerFetchResponseCallbackRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_Params');

/** @record */
blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_Params = class {
  constructor() {
    /** @export { !blink.mojom.DispatchFetchEventParams } */
    this.params;
    /** @export { !blink.mojom.ServiceWorkerFetchResponseCallbackRemote } */
    this.responseCallback;
  }
};



mojo.internal.Struct(
    blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
    'ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.ServiceWorkerEventStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams');

/** @record */
blink.mojom.ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerEventStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    blink.mojom.ControllerServiceWorker_Clone_ParamsSpec.$,
    'ControllerServiceWorker_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ControllerServiceWorkerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'crossOriginEmbedderPolicy', 8,
        0,
        network.mojom.CrossOriginEmbedderPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'coepReporter', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.CrossOriginEmbedderPolicyReporterRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentIsolationPolicy', 24,
        0,
        network.mojom.DocumentIsolationPolicySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dipReporter', 32,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DocumentIsolationPolicyReporterRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.ControllerServiceWorker_Clone_Params');

/** @record */
blink.mojom.ControllerServiceWorker_Clone_Params = class {
  constructor() {
    /** @export { !blink.mojom.ControllerServiceWorkerPendingReceiver } */
    this.receiver;
    /** @export { !network.mojom.CrossOriginEmbedderPolicy } */
    this.crossOriginEmbedderPolicy;
    /** @export { (network.mojom.CrossOriginEmbedderPolicyReporterRemote|undefined) } */
    this.coepReporter;
    /** @export { !network.mojom.DocumentIsolationPolicy } */
    this.documentIsolationPolicy;
    /** @export { (network.mojom.DocumentIsolationPolicyReporterRemote|undefined) } */
    this.dipReporter;
  }
};



mojo.internal.Struct(
    blink.mojom.ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
    'ControllerServiceWorkerConnector_UpdateController_Params',
    [
      mojo.internal.StructField(
        'controller', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ControllerServiceWorkerRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ControllerServiceWorkerConnector_UpdateController_Params');

/** @record */
blink.mojom.ControllerServiceWorkerConnector_UpdateController_Params = class {
  constructor() {
    /** @export { (blink.mojom.ControllerServiceWorkerRemote|undefined) } */
    this.controller;
  }
};

