// third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SENSOR_WEB_SENSOR_PROVIDER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SENSOR_WEB_SENSOR_PROVIDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/sensor.mojom-blink-forward.h"
#include "services/device/public/mojom/sensor_provider.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class WebSensorProviderProxy;

template <typename ImplRefTraits>
class WebSensorProviderStub;

class WebSensorProviderRequestValidator;
class WebSensorProviderResponseValidator;


class PLATFORM_EXPORT WebSensorProvider
    : public WebSensorProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebSensorProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebSensorProviderInterfaceBase;
  using Proxy_ = WebSensorProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebSensorProviderStub<ImplRefTraits>;

  using RequestValidator_ = WebSensorProviderRequestValidator;
  using ResponseValidator_ = WebSensorProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSensorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebSensorProvider() = default;

  using GetSensorCallback = base::OnceCallback<void(::device::mojom::blink::SensorCreationResult, ::device::mojom::blink::SensorInitParamsPtr)>;
  using GetSensorMojoCallback = base::OnceCallback<void(::device::mojom::blink::SensorCreationResult, ::device::mojom::blink::SensorInitParamsPtr)>;

  virtual void GetSensor(::device::mojom::blink::SensorType type, GetSensorCallback callback) = 0;
};



class PLATFORM_EXPORT WebSensorProviderProxy
    : public WebSensorProvider {
 public:
  using InterfaceType = WebSensorProvider;

  explicit WebSensorProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSensor(::device::mojom::blink::SensorType type, GetSensorCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT WebSensorProviderStubDispatch {
 public:
  static bool Accept(WebSensorProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebSensorProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebSensorProvider>>
class WebSensorProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebSensorProviderStub() = default;
  ~WebSensorProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSensorProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebSensorProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT WebSensorProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT WebSensorProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SENSOR_WEB_SENSOR_PROVIDER_MOJOM_BLINK_H_