// third_party/blink/public/mojom/reporting/reporting.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/reporting/reporting.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function ReportingServiceProxy_QueueInterventionReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueueInterventionReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.id = null;
    this.message = null;
    this.sourceFile = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ReportingServiceProxy_QueueInterventionReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueueInterventionReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueInterventionReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueInterventionReport_Params.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueInterventionReport_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueInterventionReport_Params.sourceFile
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueueInterventionReport_Params.encodedSize = codec.kStructHeaderSize + 40;

  ReportingServiceProxy_QueueInterventionReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueueInterventionReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.id =
        decoder.decodeStruct(codec.String);
    val.message =
        decoder.decodeStruct(codec.String);
    val.sourceFile =
        decoder.decodeStruct(codec.String);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ReportingServiceProxy_QueueInterventionReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueueInterventionReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStruct(codec.String, val.sourceFile);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
  };
  function ReportingServiceProxy_QueueDeprecationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueueDeprecationReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.id = null;
    this.anticipatedRemoval = null;
    this.message = null;
    this.sourceFile = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ReportingServiceProxy_QueueDeprecationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueueDeprecationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDeprecationReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDeprecationReport_Params.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDeprecationReport_Params.anticipatedRemoval
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDeprecationReport_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDeprecationReport_Params.sourceFile
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueueDeprecationReport_Params.encodedSize = codec.kStructHeaderSize + 48;

  ReportingServiceProxy_QueueDeprecationReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueueDeprecationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.id =
        decoder.decodeStruct(codec.String);
    val.anticipatedRemoval =
        decoder.decodeStructPointer(time$.Time);
    val.message =
        decoder.decodeStruct(codec.String);
    val.sourceFile =
        decoder.decodeStruct(codec.String);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ReportingServiceProxy_QueueDeprecationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueueDeprecationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStructPointer(time$.Time, val.anticipatedRemoval);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStruct(codec.String, val.sourceFile);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
  };
  function ReportingServiceProxy_QueueCspViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueueCspViolationReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.group = null;
    this.documentUrl = null;
    this.referrer = null;
    this.blockedUrl = null;
    this.effectiveDirective = null;
    this.originalPolicy = null;
    this.sourceFile = null;
    this.scriptSample = null;
    this.disposition = null;
    this.statusCode = 0;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ReportingServiceProxy_QueueCspViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueueCspViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.group
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.documentUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.referrer
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.blockedUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.effectiveDirective
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.originalPolicy
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.sourceFile
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.scriptSample
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCspViolationReport_Params.disposition
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 72, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueueCspViolationReport_Params.encodedSize = codec.kStructHeaderSize + 96;

  ReportingServiceProxy_QueueCspViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueueCspViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.group =
        decoder.decodeStruct(codec.String);
    val.documentUrl =
        decoder.decodeStruct(codec.String);
    val.referrer =
        decoder.decodeStruct(codec.String);
    val.blockedUrl =
        decoder.decodeStruct(codec.String);
    val.effectiveDirective =
        decoder.decodeStruct(codec.String);
    val.originalPolicy =
        decoder.decodeStruct(codec.String);
    val.sourceFile =
        decoder.decodeStruct(codec.String);
    val.scriptSample =
        decoder.decodeStruct(codec.String);
    val.disposition =
        decoder.decodeStruct(codec.String);
    val.statusCode =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ReportingServiceProxy_QueueCspViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueueCspViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.group);
    encoder.encodeStruct(codec.String, val.documentUrl);
    encoder.encodeStruct(codec.String, val.referrer);
    encoder.encodeStruct(codec.String, val.blockedUrl);
    encoder.encodeStruct(codec.String, val.effectiveDirective);
    encoder.encodeStruct(codec.String, val.originalPolicy);
    encoder.encodeStruct(codec.String, val.sourceFile);
    encoder.encodeStruct(codec.String, val.scriptSample);
    encoder.encodeStruct(codec.String, val.disposition);
    encoder.encodeStruct(codec.Uint16, val.statusCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ReportingServiceProxy_QueueIntegrityViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueueIntegrityViolationReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.endpoint = null;
    this.documentUrl = null;
    this.blockedUrl = null;
    this.destination = null;
    this.reportOnly = false;
  };
  ReportingServiceProxy_QueueIntegrityViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueueIntegrityViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueIntegrityViolationReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueIntegrityViolationReport_Params.endpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueIntegrityViolationReport_Params.documentUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueIntegrityViolationReport_Params.blockedUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueIntegrityViolationReport_Params.destination
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueueIntegrityViolationReport_Params.encodedSize = codec.kStructHeaderSize + 48;

  ReportingServiceProxy_QueueIntegrityViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueueIntegrityViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.endpoint =
        decoder.decodeStruct(codec.String);
    val.documentUrl =
        decoder.decodeStruct(codec.String);
    val.blockedUrl =
        decoder.decodeStruct(codec.String);
    val.destination =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.reportOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ReportingServiceProxy_QueueIntegrityViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueueIntegrityViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.endpoint);
    encoder.encodeStruct(codec.String, val.documentUrl);
    encoder.encodeStruct(codec.String, val.blockedUrl);
    encoder.encodeStruct(codec.String, val.destination);
    packed = 0;
    packed |= (val.reportOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.endpoint = null;
    this.policyId = null;
    this.disposition = null;
    this.message = null;
    this.sourceFile = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.endpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.policyId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.disposition
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.sourceFile
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.encodedSize = codec.kStructHeaderSize + 56;

  ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.endpoint =
        decoder.decodeStruct(codec.String);
    val.policyId =
        decoder.decodeStruct(codec.String);
    val.disposition =
        decoder.decodeStruct(codec.String);
    val.message =
        decoder.decodeStruct(codec.String);
    val.sourceFile =
        decoder.decodeStruct(codec.String);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.endpoint);
    encoder.encodeStruct(codec.String, val.policyId);
    encoder.encodeStruct(codec.String, val.disposition);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStruct(codec.String, val.sourceFile);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
  };
  function ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.endpoint = null;
    this.policyId = null;
    this.disposition = null;
    this.message = null;
    this.allowAttribute = null;
    this.srcAttribute = null;
    this.sourceFile = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.endpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.policyId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.disposition
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.allowAttribute
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.srcAttribute
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.sourceFile
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 56, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.encodedSize = codec.kStructHeaderSize + 72;

  ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.endpoint =
        decoder.decodeStruct(codec.String);
    val.policyId =
        decoder.decodeStruct(codec.String);
    val.disposition =
        decoder.decodeStruct(codec.String);
    val.message =
        decoder.decodeStruct(codec.String);
    val.allowAttribute =
        decoder.decodeStruct(codec.String);
    val.srcAttribute =
        decoder.decodeStruct(codec.String);
    val.sourceFile =
        decoder.decodeStruct(codec.String);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.endpoint);
    encoder.encodeStruct(codec.String, val.policyId);
    encoder.encodeStruct(codec.String, val.disposition);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStruct(codec.String, val.allowAttribute);
    encoder.encodeStruct(codec.String, val.srcAttribute);
    encoder.encodeStruct(codec.String, val.sourceFile);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
  };
  function ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.group = null;
    this.policyId = null;
    this.disposition = null;
    this.message = null;
    this.sourceFile = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
  };
  ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.group
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.policyId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.disposition
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.sourceFile
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.encodedSize = codec.kStructHeaderSize + 56;

  ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.group =
        decoder.decodeStruct(codec.String);
    val.policyId =
        decoder.decodeStruct(codec.String);
    val.disposition =
        decoder.decodeStruct(codec.String);
    val.message =
        decoder.decodeStruct(codec.String);
    val.sourceFile =
        decoder.decodeStruct(codec.String);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.group);
    encoder.encodeStruct(codec.String, val.policyId);
    encoder.encodeStruct(codec.String, val.disposition);
    encoder.encodeStruct(codec.String, val.message);
    encoder.encodeStruct(codec.String, val.sourceFile);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
  };
  function ReportingServiceProxy_QueueCSPHashReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ReportingServiceProxy_QueueCSPHashReport_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.endpoint = null;
    this.subresourceUrl = null;
    this.integrityHash = null;
    this.type = null;
    this.destination = null;
  };
  ReportingServiceProxy_QueueCSPHashReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ReportingServiceProxy_QueueCSPHashReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCSPHashReport_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCSPHashReport_Params.endpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCSPHashReport_Params.subresourceUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCSPHashReport_Params.integrityHash
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCSPHashReport_Params.type
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ReportingServiceProxy_QueueCSPHashReport_Params.destination
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ReportingServiceProxy_QueueCSPHashReport_Params.encodedSize = codec.kStructHeaderSize + 48;

  ReportingServiceProxy_QueueCSPHashReport_Params.decode = function(decoder) {
    var packed;
    var val = new ReportingServiceProxy_QueueCSPHashReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.endpoint =
        decoder.decodeStruct(codec.String);
    val.subresourceUrl =
        decoder.decodeStruct(codec.String);
    val.integrityHash =
        decoder.decodeStruct(codec.String);
    val.type =
        decoder.decodeStruct(codec.String);
    val.destination =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ReportingServiceProxy_QueueCSPHashReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ReportingServiceProxy_QueueCSPHashReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.endpoint);
    encoder.encodeStruct(codec.String, val.subresourceUrl);
    encoder.encodeStruct(codec.String, val.integrityHash);
    encoder.encodeStruct(codec.String, val.type);
    encoder.encodeStruct(codec.String, val.destination);
  };
  var kReportingServiceProxy_QueueInterventionReport_Name = 0;
  var kReportingServiceProxy_QueueDeprecationReport_Name = 1;
  var kReportingServiceProxy_QueueCspViolationReport_Name = 2;
  var kReportingServiceProxy_QueueIntegrityViolationReport_Name = 3;
  var kReportingServiceProxy_QueuePermissionsPolicyViolationReport_Name = 4;
  var kReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Name = 5;
  var kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name = 6;
  var kReportingServiceProxy_QueueCSPHashReport_Name = 7;

  function ReportingServiceProxyPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ReportingServiceProxy,
                                                   handleOrPtrInfo);
  }

  function ReportingServiceProxyAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ReportingServiceProxy, associatedInterfacePtrInfo);
  }

  ReportingServiceProxyAssociatedPtr.prototype =
      Object.create(ReportingServiceProxyPtr.prototype);
  ReportingServiceProxyAssociatedPtr.prototype.constructor =
      ReportingServiceProxyAssociatedPtr;

  function ReportingServiceProxyProxy(receiver) {
    this.receiver_ = receiver;
  }
  ReportingServiceProxyPtr.prototype.queueInterventionReport = function() {
    return ReportingServiceProxyProxy.prototype.queueInterventionReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queueInterventionReport = function(url, id, message, sourceFile, lineNumber, columnNumber) {
    var params_ = new ReportingServiceProxy_QueueInterventionReport_Params();
    params_.url = url;
    params_.id = id;
    params_.message = message;
    params_.sourceFile = sourceFile;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueueInterventionReport_Name,
        codec.align(ReportingServiceProxy_QueueInterventionReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueueInterventionReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queueDeprecationReport = function() {
    return ReportingServiceProxyProxy.prototype.queueDeprecationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queueDeprecationReport = function(url, id, anticipatedRemoval, message, sourceFile, lineNumber, columnNumber) {
    var params_ = new ReportingServiceProxy_QueueDeprecationReport_Params();
    params_.url = url;
    params_.id = id;
    params_.anticipatedRemoval = anticipatedRemoval;
    params_.message = message;
    params_.sourceFile = sourceFile;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueueDeprecationReport_Name,
        codec.align(ReportingServiceProxy_QueueDeprecationReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueueDeprecationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queueCspViolationReport = function() {
    return ReportingServiceProxyProxy.prototype.queueCspViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queueCspViolationReport = function(url, group, documentUrl, referrer, blockedUrl, effectiveDirective, originalPolicy, sourceFile, scriptSample, disposition, statusCode, lineNumber, columnNumber) {
    var params_ = new ReportingServiceProxy_QueueCspViolationReport_Params();
    params_.url = url;
    params_.group = group;
    params_.documentUrl = documentUrl;
    params_.referrer = referrer;
    params_.blockedUrl = blockedUrl;
    params_.effectiveDirective = effectiveDirective;
    params_.originalPolicy = originalPolicy;
    params_.sourceFile = sourceFile;
    params_.scriptSample = scriptSample;
    params_.disposition = disposition;
    params_.statusCode = statusCode;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueueCspViolationReport_Name,
        codec.align(ReportingServiceProxy_QueueCspViolationReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueueCspViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queueIntegrityViolationReport = function() {
    return ReportingServiceProxyProxy.prototype.queueIntegrityViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queueIntegrityViolationReport = function(url, endpoint, documentUrl, blockedUrl, destination, reportOnly) {
    var params_ = new ReportingServiceProxy_QueueIntegrityViolationReport_Params();
    params_.url = url;
    params_.endpoint = endpoint;
    params_.documentUrl = documentUrl;
    params_.blockedUrl = blockedUrl;
    params_.destination = destination;
    params_.reportOnly = reportOnly;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueueIntegrityViolationReport_Name,
        codec.align(ReportingServiceProxy_QueueIntegrityViolationReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueueIntegrityViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queuePermissionsPolicyViolationReport = function() {
    return ReportingServiceProxyProxy.prototype.queuePermissionsPolicyViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queuePermissionsPolicyViolationReport = function(url, endpoint, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {
    var params_ = new ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params();
    params_.url = url;
    params_.endpoint = endpoint;
    params_.policyId = policyId;
    params_.disposition = disposition;
    params_.message = message;
    params_.sourceFile = sourceFile;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueuePermissionsPolicyViolationReport_Name,
        codec.align(ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queuePotentialPermissionsPolicyViolationReport = function() {
    return ReportingServiceProxyProxy.prototype.queuePotentialPermissionsPolicyViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queuePotentialPermissionsPolicyViolationReport = function(url, endpoint, policyId, disposition, message, allowAttribute, srcAttribute, sourceFile, lineNumber, columnNumber) {
    var params_ = new ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params();
    params_.url = url;
    params_.endpoint = endpoint;
    params_.policyId = policyId;
    params_.disposition = disposition;
    params_.message = message;
    params_.allowAttribute = allowAttribute;
    params_.srcAttribute = srcAttribute;
    params_.sourceFile = sourceFile;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Name,
        codec.align(ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queueDocumentPolicyViolationReport = function() {
    return ReportingServiceProxyProxy.prototype.queueDocumentPolicyViolationReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queueDocumentPolicyViolationReport = function(url, group, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {
    var params_ = new ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params();
    params_.url = url;
    params_.group = group;
    params_.policyId = policyId;
    params_.disposition = disposition;
    params_.message = message;
    params_.sourceFile = sourceFile;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name,
        codec.align(ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ReportingServiceProxyPtr.prototype.queueCSPHashReport = function() {
    return ReportingServiceProxyProxy.prototype.queueCSPHashReport
        .apply(this.ptr.getProxy(), arguments);
  };

  ReportingServiceProxyProxy.prototype.queueCSPHashReport = function(url, endpoint, subresourceUrl, integrityHash, type, destination) {
    var params_ = new ReportingServiceProxy_QueueCSPHashReport_Params();
    params_.url = url;
    params_.endpoint = endpoint;
    params_.subresourceUrl = subresourceUrl;
    params_.integrityHash = integrityHash;
    params_.type = type;
    params_.destination = destination;
    var builder = new codec.MessageV0Builder(
        kReportingServiceProxy_QueueCSPHashReport_Name,
        codec.align(ReportingServiceProxy_QueueCSPHashReport_Params.encodedSize));
    builder.encodeStruct(ReportingServiceProxy_QueueCSPHashReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ReportingServiceProxyStub(delegate) {
    this.delegate_ = delegate;
  }
  ReportingServiceProxyStub.prototype.queueInterventionReport = function(url, id, message, sourceFile, lineNumber, columnNumber) {
    return this.delegate_ && this.delegate_.queueInterventionReport && this.delegate_.queueInterventionReport(url, id, message, sourceFile, lineNumber, columnNumber);
  }
  ReportingServiceProxyStub.prototype.queueDeprecationReport = function(url, id, anticipatedRemoval, message, sourceFile, lineNumber, columnNumber) {
    return this.delegate_ && this.delegate_.queueDeprecationReport && this.delegate_.queueDeprecationReport(url, id, anticipatedRemoval, message, sourceFile, lineNumber, columnNumber);
  }
  ReportingServiceProxyStub.prototype.queueCspViolationReport = function(url, group, documentUrl, referrer, blockedUrl, effectiveDirective, originalPolicy, sourceFile, scriptSample, disposition, statusCode, lineNumber, columnNumber) {
    return this.delegate_ && this.delegate_.queueCspViolationReport && this.delegate_.queueCspViolationReport(url, group, documentUrl, referrer, blockedUrl, effectiveDirective, originalPolicy, sourceFile, scriptSample, disposition, statusCode, lineNumber, columnNumber);
  }
  ReportingServiceProxyStub.prototype.queueIntegrityViolationReport = function(url, endpoint, documentUrl, blockedUrl, destination, reportOnly) {
    return this.delegate_ && this.delegate_.queueIntegrityViolationReport && this.delegate_.queueIntegrityViolationReport(url, endpoint, documentUrl, blockedUrl, destination, reportOnly);
  }
  ReportingServiceProxyStub.prototype.queuePermissionsPolicyViolationReport = function(url, endpoint, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {
    return this.delegate_ && this.delegate_.queuePermissionsPolicyViolationReport && this.delegate_.queuePermissionsPolicyViolationReport(url, endpoint, policyId, disposition, message, sourceFile, lineNumber, columnNumber);
  }
  ReportingServiceProxyStub.prototype.queuePotentialPermissionsPolicyViolationReport = function(url, endpoint, policyId, disposition, message, allowAttribute, srcAttribute, sourceFile, lineNumber, columnNumber) {
    return this.delegate_ && this.delegate_.queuePotentialPermissionsPolicyViolationReport && this.delegate_.queuePotentialPermissionsPolicyViolationReport(url, endpoint, policyId, disposition, message, allowAttribute, srcAttribute, sourceFile, lineNumber, columnNumber);
  }
  ReportingServiceProxyStub.prototype.queueDocumentPolicyViolationReport = function(url, group, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {
    return this.delegate_ && this.delegate_.queueDocumentPolicyViolationReport && this.delegate_.queueDocumentPolicyViolationReport(url, group, policyId, disposition, message, sourceFile, lineNumber, columnNumber);
  }
  ReportingServiceProxyStub.prototype.queueCSPHashReport = function(url, endpoint, subresourceUrl, integrityHash, type, destination) {
    return this.delegate_ && this.delegate_.queueCSPHashReport && this.delegate_.queueCSPHashReport(url, endpoint, subresourceUrl, integrityHash, type, destination);
  }

  ReportingServiceProxyStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kReportingServiceProxy_QueueInterventionReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueueInterventionReport_Params);
      this.queueInterventionReport(params.url, params.id, params.message, params.sourceFile, params.lineNumber, params.columnNumber);
      return true;
    case kReportingServiceProxy_QueueDeprecationReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueueDeprecationReport_Params);
      this.queueDeprecationReport(params.url, params.id, params.anticipatedRemoval, params.message, params.sourceFile, params.lineNumber, params.columnNumber);
      return true;
    case kReportingServiceProxy_QueueCspViolationReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueueCspViolationReport_Params);
      this.queueCspViolationReport(params.url, params.group, params.documentUrl, params.referrer, params.blockedUrl, params.effectiveDirective, params.originalPolicy, params.sourceFile, params.scriptSample, params.disposition, params.statusCode, params.lineNumber, params.columnNumber);
      return true;
    case kReportingServiceProxy_QueueIntegrityViolationReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueueIntegrityViolationReport_Params);
      this.queueIntegrityViolationReport(params.url, params.endpoint, params.documentUrl, params.blockedUrl, params.destination, params.reportOnly);
      return true;
    case kReportingServiceProxy_QueuePermissionsPolicyViolationReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params);
      this.queuePermissionsPolicyViolationReport(params.url, params.endpoint, params.policyId, params.disposition, params.message, params.sourceFile, params.lineNumber, params.columnNumber);
      return true;
    case kReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params);
      this.queuePotentialPermissionsPolicyViolationReport(params.url, params.endpoint, params.policyId, params.disposition, params.message, params.allowAttribute, params.srcAttribute, params.sourceFile, params.lineNumber, params.columnNumber);
      return true;
    case kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params);
      this.queueDocumentPolicyViolationReport(params.url, params.group, params.policyId, params.disposition, params.message, params.sourceFile, params.lineNumber, params.columnNumber);
      return true;
    case kReportingServiceProxy_QueueCSPHashReport_Name:
      var params = reader.decodeStruct(ReportingServiceProxy_QueueCSPHashReport_Params);
      this.queueCSPHashReport(params.url, params.endpoint, params.subresourceUrl, params.integrityHash, params.type, params.destination);
      return true;
    default:
      return false;
    }
  };

  ReportingServiceProxyStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateReportingServiceProxyRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kReportingServiceProxy_QueueInterventionReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueueInterventionReport_Params;
      break;
      case kReportingServiceProxy_QueueDeprecationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueueDeprecationReport_Params;
      break;
      case kReportingServiceProxy_QueueCspViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueueCspViolationReport_Params;
      break;
      case kReportingServiceProxy_QueueIntegrityViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueueIntegrityViolationReport_Params;
      break;
      case kReportingServiceProxy_QueuePermissionsPolicyViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params;
      break;
      case kReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params;
      break;
      case kReportingServiceProxy_QueueDocumentPolicyViolationReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params;
      break;
      case kReportingServiceProxy_QueueCSPHashReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ReportingServiceProxy_QueueCSPHashReport_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateReportingServiceProxyResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ReportingServiceProxy = {
    name: 'blink.mojom.ReportingServiceProxy',
    kVersion: 0,
    ptrClass: ReportingServiceProxyPtr,
    proxyClass: ReportingServiceProxyProxy,
    stubClass: ReportingServiceProxyStub,
    validateRequest: validateReportingServiceProxyRequest,
    validateResponse: null,
  };
  ReportingServiceProxyStub.prototype.validator = validateReportingServiceProxyRequest;
  ReportingServiceProxyProxy.prototype.validator = null;
  exports.ReportingServiceProxy = ReportingServiceProxy;
  exports.ReportingServiceProxyPtr = ReportingServiceProxyPtr;
  exports.ReportingServiceProxyAssociatedPtr = ReportingServiceProxyAssociatedPtr;
})();