// third_party/blink/public/mojom/reporting/reporting.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.Time');
goog.require('url.mojom.Url');






goog.provide('blink.mojom.ReportingServiceProxy');
goog.provide('blink.mojom.ReportingServiceProxyReceiver');
goog.provide('blink.mojom.ReportingServiceProxyCallbackRouter');
goog.provide('blink.mojom.ReportingServiceProxyInterface');
goog.provide('blink.mojom.ReportingServiceProxyRemote');
goog.provide('blink.mojom.ReportingServiceProxyPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ReportingServiceProxyPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ReportingServiceProxy.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ReportingServiceProxyInterface = class {
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } id
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueInterventionReport(url, id, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } id
   * @param { ?mojoBase.mojom.Time } anticipatedRemoval
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDeprecationReport(url, id, anticipatedRemoval, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } group
   * @param { !string } documentUrl
   * @param { ?string } referrer
   * @param { ?string } blockedUrl
   * @param { !string } effectiveDirective
   * @param { !string } originalPolicy
   * @param { ?string } sourceFile
   * @param { ?string } scriptSample
   * @param { !string } disposition
   * @param { !number } statusCode
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueCspViolationReport(url, group, documentUrl, referrer, blockedUrl, effectiveDirective, originalPolicy, sourceFile, scriptSample, disposition, statusCode, lineNumber, columnNumber) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } documentUrl
   * @param { !string } blockedUrl
   * @param { !string } destination
   * @param { !boolean } reportOnly
   */

  queueIntegrityViolationReport(url, endpoint, documentUrl, blockedUrl, destination, reportOnly) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePermissionsPolicyViolationReport(url, endpoint, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } allowAttribute
   * @param { ?string } srcAttribute
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePotentialPermissionsPolicyViolationReport(url, endpoint, policyId, disposition, message, allowAttribute, srcAttribute, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } group
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDocumentPolicyViolationReport(url, group, policyId, disposition, message, sourceFile, lineNumber, columnNumber) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } subresourceUrl
   * @param { !string } integrityHash
   * @param { !string } type
   * @param { !string } destination
   */

  queueCSPHashReport(url, endpoint, subresourceUrl, integrityHash, type, destination) {}
};

/**
 * @export
 * @implements { blink.mojom.ReportingServiceProxyInterface }
 */
blink.mojom.ReportingServiceProxyRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ReportingServiceProxyPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ReportingServiceProxyPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ReportingServiceProxyPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } id
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueInterventionReport(
      url,
      id,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
        null,
        [
          url,
          id,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } id
   * @param { ?mojoBase.mojom.Time } anticipatedRemoval
   * @param { !string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDeprecationReport(
      url,
      id,
      anticipatedRemoval,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
        null,
        [
          url,
          id,
          anticipatedRemoval,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } group
   * @param { !string } documentUrl
   * @param { ?string } referrer
   * @param { ?string } blockedUrl
   * @param { !string } effectiveDirective
   * @param { !string } originalPolicy
   * @param { ?string } sourceFile
   * @param { ?string } scriptSample
   * @param { !string } disposition
   * @param { !number } statusCode
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueCspViolationReport(
      url,
      group,
      documentUrl,
      referrer,
      blockedUrl,
      effectiveDirective,
      originalPolicy,
      sourceFile,
      scriptSample,
      disposition,
      statusCode,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        2,
        blink.mojom.ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
        null,
        [
          url,
          group,
          documentUrl,
          referrer,
          blockedUrl,
          effectiveDirective,
          originalPolicy,
          sourceFile,
          scriptSample,
          disposition,
          statusCode,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } documentUrl
   * @param { !string } blockedUrl
   * @param { !string } destination
   * @param { !boolean } reportOnly
   */

  queueIntegrityViolationReport(
      url,
      endpoint,
      documentUrl,
      blockedUrl,
      destination,
      reportOnly) {
    this.proxy.sendMessage(
        3,
        blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          documentUrl,
          blockedUrl,
          destination,
          reportOnly
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePermissionsPolicyViolationReport(
      url,
      endpoint,
      policyId,
      disposition,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        4,
        blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          policyId,
          disposition,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } allowAttribute
   * @param { ?string } srcAttribute
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queuePotentialPermissionsPolicyViolationReport(
      url,
      endpoint,
      policyId,
      disposition,
      message,
      allowAttribute,
      srcAttribute,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        5,
        blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          policyId,
          disposition,
          message,
          allowAttribute,
          srcAttribute,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } group
   * @param { !string } policyId
   * @param { !string } disposition
   * @param { ?string } message
   * @param { ?string } sourceFile
   * @param { !number } lineNumber
   * @param { !number } columnNumber
   */

  queueDocumentPolicyViolationReport(
      url,
      group,
      policyId,
      disposition,
      message,
      sourceFile,
      lineNumber,
      columnNumber) {
    this.proxy.sendMessage(
        6,
        blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
        null,
        [
          url,
          group,
          policyId,
          disposition,
          message,
          sourceFile,
          lineNumber,
          columnNumber
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !string } endpoint
   * @param { !string } subresourceUrl
   * @param { !string } integrityHash
   * @param { !string } type
   * @param { !string } destination
   */

  queueCSPHashReport(
      url,
      endpoint,
      subresourceUrl,
      integrityHash,
      type,
      destination) {
    this.proxy.sendMessage(
        7,
        blink.mojom.ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
        null,
        [
          url,
          endpoint,
          subresourceUrl,
          integrityHash,
          type,
          destination
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ReportingServiceProxy
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ReportingServiceProxyReceiver = class {
  /**
   * @param {!blink.mojom.ReportingServiceProxyInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ReportingServiceProxyRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ReportingServiceProxyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ReportingServiceProxyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
        null,
        impl.queueInterventionReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
        null,
        impl.queueDeprecationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
        null,
        impl.queueCspViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
        null,
        impl.queueIntegrityViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        impl.queuePermissionsPolicyViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        impl.queuePotentialPermissionsPolicyViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
        null,
        impl.queueDocumentPolicyViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
        null,
        impl.queueCSPHashReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ReportingServiceProxy = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ReportingServiceProxy";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ReportingServiceProxyRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ReportingServiceProxyRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ReportingServiceProxy
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ReportingServiceProxyCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ReportingServiceProxyRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ReportingServiceProxyRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueInterventionReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
        null,
        this.queueInterventionReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueDeprecationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
        null,
        this.queueDeprecationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueCspViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
        null,
        this.queueCspViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueIntegrityViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
        null,
        this.queueIntegrityViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queuePermissionsPolicyViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        this.queuePermissionsPolicyViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queuePotentialPermissionsPolicyViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
        null,
        this.queuePotentialPermissionsPolicyViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueDocumentPolicyViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
        null,
        this.queueDocumentPolicyViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueCSPHashReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
        null,
        this.queueCSPHashReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ReportingServiceProxy_QueueInterventionReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueueInterventionReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueueDeprecationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueueDeprecationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueueCspViolationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueueCspViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ReportingServiceProxy_QueueCSPHashReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ReportingServiceProxy_QueueCSPHashReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueueInterventionReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueInterventionReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFile', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 36,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueueInterventionReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueueInterventionReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.message;
    /** @export { (string|undefined) } */
    this.sourceFile;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueueDeprecationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueDeprecationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'anticipatedRemoval', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFile', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 40,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 44,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueueDeprecationReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueueDeprecationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.id;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.anticipatedRemoval;
    /** @export { !string } */
    this.message;
    /** @export { (string|undefined) } */
    this.sourceFile;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueueCspViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueCspViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'referrer', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockedUrl', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'effectiveDirective', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalPolicy', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFile', 56,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptSample', 64,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disposition', 72,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'statusCode', 80,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 84,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 88,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 104],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueueCspViolationReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueueCspViolationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.group;
    /** @export { !string } */
    this.documentUrl;
    /** @export { (string|undefined) } */
    this.referrer;
    /** @export { (string|undefined) } */
    this.blockedUrl;
    /** @export { !string } */
    this.effectiveDirective;
    /** @export { !string } */
    this.originalPolicy;
    /** @export { (string|undefined) } */
    this.sourceFile;
    /** @export { (string|undefined) } */
    this.scriptSample;
    /** @export { !string } */
    this.disposition;
    /** @export { !number } */
    this.statusCode;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueIntegrityViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'documentUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockedUrl', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destination', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportOnly', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueueIntegrityViolationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.endpoint;
    /** @export { !string } */
    this.documentUrl;
    /** @export { !string } */
    this.blockedUrl;
    /** @export { !string } */
    this.destination;
    /** @export { !boolean } */
    this.reportOnly;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disposition', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFile', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 48,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 52,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueuePermissionsPolicyViolationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.endpoint;
    /** @export { !string } */
    this.policyId;
    /** @export { !string } */
    this.disposition;
    /** @export { (string|undefined) } */
    this.message;
    /** @export { (string|undefined) } */
    this.sourceFile;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disposition', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowAttribute', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'srcAttribute', 48,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFile', 56,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 64,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 68,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueuePotentialPermissionsPolicyViolationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.endpoint;
    /** @export { !string } */
    this.policyId;
    /** @export { !string } */
    this.disposition;
    /** @export { (string|undefined) } */
    this.message;
    /** @export { (string|undefined) } */
    this.allowAttribute;
    /** @export { (string|undefined) } */
    this.srcAttribute;
    /** @export { (string|undefined) } */
    this.sourceFile;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'group', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'policyId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disposition', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceFile', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lineNumber', 48,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'columnNumber', 52,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueueDocumentPolicyViolationReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.group;
    /** @export { !string } */
    this.policyId;
    /** @export { !string } */
    this.disposition;
    /** @export { (string|undefined) } */
    this.message;
    /** @export { (string|undefined) } */
    this.sourceFile;
    /** @export { !number } */
    this.lineNumber;
    /** @export { !number } */
    this.columnNumber;
  }
};



mojo.internal.Struct(
    blink.mojom.ReportingServiceProxy_QueueCSPHashReport_ParamsSpec.$,
    'ReportingServiceProxy_QueueCSPHashReport_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'integrityHash', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'destination', 40,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.ReportingServiceProxy_QueueCSPHashReport_Params');

/** @record */
blink.mojom.ReportingServiceProxy_QueueCSPHashReport_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !string } */
    this.endpoint;
    /** @export { !string } */
    this.subresourceUrl;
    /** @export { !string } */
    this.integrityHash;
    /** @export { !string } */
    this.type;
    /** @export { !string } */
    this.destination;
  }
};

