// third_party/blink/public/mojom/quota/quota_manager_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  QuotaStatusCode as blink_mojom_QuotaStatusCode,
  QuotaStatusCodeSpec as blink_mojom_QuotaStatusCodeSpec,
  UsageBreakdown as blink_mojom_UsageBreakdown,
  UsageBreakdownSpec as blink_mojom_UsageBreakdownSpec
} from './quota_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class QuotaManagerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.QuotaManagerHost', scope);
  }
}

/** @interface */
export class QuotaManagerHostInterface {
  
  /**
   * @return {!Promise<{
        error: !blink_mojom_QuotaStatusCode,
        currentUsage: !bigint,
        currentQuota: !bigint,
        usageBreakdown: !blink_mojom_UsageBreakdown,
   *  }>}
   */

  queryStorageUsageAndQuota() {}
}

/**
 * @implements { QuotaManagerHostInterface }
 */
export class QuotaManagerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!QuotaManagerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          QuotaManagerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!QuotaManagerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        error: !blink_mojom_QuotaStatusCode,
        currentUsage: !bigint,
        currentQuota: !bigint,
        usageBreakdown: !blink_mojom_UsageBreakdown,
   *  }>}
   */

  queryStorageUsageAndQuota() {
    return this.proxy.sendMessage(
        0,
        QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the QuotaManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class QuotaManagerHostReceiver {
  /**
   * @param {!QuotaManagerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!QuotaManagerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        QuotaManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!QuotaManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        impl.queryStorageUsageAndQuota.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class QuotaManagerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.QuotaManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!QuotaManagerHostRemote}
   */
  static getRemote() {
    let remote = new QuotaManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the QuotaManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class QuotaManagerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      QuotaManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!QuotaManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryStorageUsageAndQuota =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        this.queryStorageUsageAndQuota.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
    'QuotaManagerHost_QueryStorageUsageAndQuota_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class QuotaManagerHost_QueryStorageUsageAndQuota_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
    'QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_QuotaStatusCodeSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentUsage', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentQuota', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usageBreakdown', 24,
        0,
        blink_mojom_UsageBreakdownSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_QuotaStatusCode } */
    this.error;
    /** @type { !bigint } */
    this.currentUsage;
    /** @type { !bigint } */
    this.currentQuota;
    /** @type { !blink_mojom_UsageBreakdown } */
    this.usageBreakdown;
  }
}

