// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace blink::mojom {
class PushSubscriptionOptionsDataView;

class PushSubscriptionDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PushSubscriptionOptionsDataView> {
  using Data = ::blink::mojom::internal::PushSubscriptionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PushSubscriptionDataView> {
  using Data = ::blink::mojom::internal::PushSubscription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class PushErrorType : int32_t {
  
  ABORT = 0,
  
  NETWORK = 1,
  
  NONE = 2,
  
  NOT_ALLOWED = 3,
  
  NOT_FOUND = 4,
  
  NOT_SUPPORTED = 5,
  
  INVALID_STATE = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PushErrorType value);
inline bool IsKnownEnumValue(PushErrorType value) {
  return internal::PushErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PushMessagingInterfaceBase {};

using PushMessagingPtrDataView =
    mojo::InterfacePtrDataView<PushMessagingInterfaceBase>;
using PushMessagingRequestDataView =
    mojo::InterfaceRequestDataView<PushMessagingInterfaceBase>;
using PushMessagingAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PushMessagingInterfaceBase>;
using PushMessagingAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PushMessagingInterfaceBase>;


class PushSubscriptionOptionsDataView {
 public:
  PushSubscriptionOptionsDataView() = default;

  PushSubscriptionOptionsDataView(
      internal::PushSubscriptionOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool user_visible_only() const {
    return data_->user_visible_only;
  }
  inline void GetApplicationServerKeyDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApplicationServerKey(UserType* output) {
    
    auto* pointer = data_->application_server_key.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::PushSubscriptionOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PushSubscriptionDataView {
 public:
  PushSubscriptionDataView() = default;

  PushSubscriptionDataView(
      internal::PushSubscription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEndpointDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpoint(UserType* output) {
    
    auto* pointer = data_->endpoint.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpirationTime(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `expirationTime` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadExpirationTime` instead "
    "of `ReadExpirationTime if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->expirationTime.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetOptionsDataView(
      PushSubscriptionOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PushSubscriptionOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetP256dhDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadP256dh(UserType* output) {
    
    auto* pointer = data_->p256dh.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetAuthDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAuth(UserType* output) {
    
    auto* pointer = data_->auth.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::PushSubscription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_DATA_VIEW_H_