// third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AggregatableReportHistogramContribution as blink_mojom_AggregatableReportHistogramContribution,
  AggregatableReportHistogramContributionSpec as blink_mojom_AggregatableReportHistogramContributionSpec
} from '../aggregation_service/aggregatable_report.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PrivateAggregationErrorEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PrivateAggregationErrorEvent = {
  
  kReportSuccess: 0,
  kTooManyContributions: 1,
  kEmptyReportDropped: 2,
  kPendingReportLimitReached: 3,
  kInsufficientBudget: 4,
  kContributionTimeoutReached: 5,
  kAlreadyTriggeredExternalError: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PrivateAggregationHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PrivateAggregationHost', scope);
  }
}

/** @interface */
export class PrivateAggregationHostInterface {
  
  /**
   * @param { !Array<!blink_mojom_AggregatableReportHistogramContribution> } contributions
   */

  contributeToHistogram(contributions) {}
  
  /**
   * @param { !PrivateAggregationErrorEvent } errorEvent
   * @param { !Array<!blink_mojom_AggregatableReportHistogramContribution> } contributions
   */

  contributeToHistogramOnEvent(errorEvent, contributions) {}
  
  /**
   * @param { ?DebugKey } debugKey
   */

  enableDebugMode(debugKey) {}
}

/**
 * @implements { PrivateAggregationHostInterface }
 */
export class PrivateAggregationHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PrivateAggregationHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PrivateAggregationHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PrivateAggregationHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!blink_mojom_AggregatableReportHistogramContribution> } contributions
   */

  contributeToHistogram(
      contributions) {
    this.proxy.sendMessage(
        0,
        PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
        null,
        [
          contributions
        ],
        false);
  }

  
  /**
   * @param { !PrivateAggregationErrorEvent } errorEvent
   * @param { !Array<!blink_mojom_AggregatableReportHistogramContribution> } contributions
   */

  contributeToHistogramOnEvent(
      errorEvent,
      contributions) {
    this.proxy.sendMessage(
        1,
        PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
        null,
        [
          errorEvent,
          contributions
        ],
        false);
  }

  
  /**
   * @param { ?DebugKey } debugKey
   */

  enableDebugMode(
      debugKey) {
    this.proxy.sendMessage(
        2,
        PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
        null,
        [
          debugKey
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PrivateAggregationHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PrivateAggregationHostReceiver {
  /**
   * @param {!PrivateAggregationHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PrivateAggregationHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PrivateAggregationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PrivateAggregationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
        null,
        impl.contributeToHistogram.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
        null,
        impl.contributeToHistogramOnEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
        null,
        impl.enableDebugMode.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PrivateAggregationHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PrivateAggregationHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PrivateAggregationHostRemote}
   */
  static getRemote() {
    let remote = new PrivateAggregationHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PrivateAggregationHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PrivateAggregationHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PrivateAggregationHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PrivateAggregationHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contributeToHistogram =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
        null,
        this.contributeToHistogram.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.contributeToHistogramOnEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
        null,
        this.contributeToHistogramOnEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDebugMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
        null,
        this.enableDebugMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DebugKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DebugModeDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrivateAggregationHost_ContributeToHistogram_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrivateAggregationHost_EnableDebugMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DebugKeySpec.$,
    'DebugKey',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DebugKey {
  constructor() {
    /** @type { !bigint } */
    this.value;
  }
}



mojo.internal.Struct(
    DebugModeDetailsSpec.$,
    'DebugModeDetails',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'debugKey', 8,
        0,
        DebugKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DebugModeDetails {
  constructor() {
    /** @type { !boolean } */
    this.isEnabled;
    /** @type { (DebugKey|undefined) } */
    this.debugKey;
  }
}



mojo.internal.Struct(
    PrivateAggregationHost_ContributeToHistogram_ParamsSpec.$,
    'PrivateAggregationHost_ContributeToHistogram_Params',
    [
      mojo.internal.StructField(
        'contributions', 0,
        0,
        mojo.internal.Array(blink_mojom_AggregatableReportHistogramContributionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PrivateAggregationHost_ContributeToHistogram_Params {
  constructor() {
    /** @type { !Array<!blink_mojom_AggregatableReportHistogramContribution> } */
    this.contributions;
  }
}



mojo.internal.Struct(
    PrivateAggregationHost_ContributeToHistogramOnEvent_ParamsSpec.$,
    'PrivateAggregationHost_ContributeToHistogramOnEvent_Params',
    [
      mojo.internal.StructField(
        'errorEvent', 0,
        0,
        PrivateAggregationErrorEventSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contributions', 8,
        0,
        mojo.internal.Array(blink_mojom_AggregatableReportHistogramContributionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PrivateAggregationHost_ContributeToHistogramOnEvent_Params {
  constructor() {
    /** @type { !PrivateAggregationErrorEvent } */
    this.errorEvent;
    /** @type { !Array<!blink_mojom_AggregatableReportHistogramContribution> } */
    this.contributions;
  }
}



mojo.internal.Struct(
    PrivateAggregationHost_EnableDebugMode_ParamsSpec.$,
    'PrivateAggregationHost_EnableDebugMode_Params',
    [
      mojo.internal.StructField(
        'debugKey', 0,
        0,
        DebugKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PrivateAggregationHost_EnableDebugMode_Params {
  constructor() {
    /** @type { (DebugKey|undefined) } */
    this.debugKey;
  }
}

