// third_party/blink/public/mojom/printing/web_printing.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/printing/web_printing.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-params-data.h"
#include "third_party/blink/public/mojom/printing/web_printing.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/printing/web_printing.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/printing/web_printing.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
WebPrinterInfo::WebPrinterInfo()
    : printer_name(),
      printer_id(),
      printer_remote() {}

WebPrinterInfo::WebPrinterInfo(
    const ::blink::String& printer_name_in,
    const ::blink::String& printer_id_in,
    ::mojo::PendingRemote<WebPrinter> printer_remote_in)
    : printer_name(std::move(printer_name_in)),
      printer_id(std::move(printer_id_in)),
      printer_remote(std::move(printer_remote_in)) {}

WebPrinterInfo::~WebPrinterInfo() = default;

void WebPrinterInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_name"), this->printer_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_id"), this->printer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_remote"), this->printer_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<WebPrinter>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrinterInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintingRange::WebPrintingRange()
    : from(),
      to() {}

WebPrintingRange::WebPrintingRange(
    uint32_t from_in,
    uint32_t to_in)
    : from(std::move(from_in)),
      to(std::move(to_in)) {}

WebPrintingRange::~WebPrintingRange() = default;
size_t WebPrintingRange::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->from);
  seed = mojo::internal::WTFHash(seed, this->to);
  return seed;
}

void WebPrintingRange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from"), this->from,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "to"), this->to,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintingRange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintingMediaSize::WebPrintingMediaSize()
    : x_dimension(),
      y_dimension() {}

WebPrintingMediaSize::WebPrintingMediaSize(
    WebPrintingMediaSizeDimensionPtr x_dimension_in,
    WebPrintingMediaSizeDimensionPtr y_dimension_in)
    : x_dimension(std::move(x_dimension_in)),
      y_dimension(std::move(y_dimension_in)) {}

WebPrintingMediaSize::~WebPrintingMediaSize() = default;
size_t WebPrintingMediaSize::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->x_dimension);
  seed = mojo::internal::WTFHash(seed, this->y_dimension);
  return seed;
}

void WebPrintingMediaSize::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x_dimension"), this->x_dimension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingMediaSizeDimensionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y_dimension"), this->y_dimension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingMediaSizeDimensionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintingMediaSize::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintingMediaCollection::WebPrintingMediaCollection()
    : media_size(),
      media_size_name() {}

WebPrintingMediaCollection::WebPrintingMediaCollection(
    WebPrintingMediaSizePtr media_size_in,
    const ::blink::String& media_size_name_in)
    : media_size(std::move(media_size_in)),
      media_size_name(std::move(media_size_name_in)) {}

WebPrintingMediaCollection::~WebPrintingMediaCollection() = default;
size_t WebPrintingMediaCollection::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->media_size);
  seed = mojo::internal::WTFHash(seed, this->media_size_name);
  return seed;
}

void WebPrintingMediaCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_size"), this->media_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingMediaSizePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_size_name"), this->media_size_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintingMediaCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrinterAttributes::WebPrinterAttributes()
    : copies_default(),
      copies_supported(),
      media_col_default(),
      media_col_database(),
      media_source_default(),
      media_source_supported(),
      multiple_document_handling_default(),
      multiple_document_handling_supported(),
      orientation_requested_default(),
      orientation_requested_supported(),
      printer_resolution_default(),
      printer_resolution_supported(),
      print_color_mode_default(),
      print_color_mode_supported(),
      print_quality_default(),
      print_quality_supported(),
      printer_state(),
      printer_state_message(),
      printer_state_reasons(),
      sides_default(),
      sides_supported(),
      printer_id() {}

WebPrinterAttributes::WebPrinterAttributes(
    uint32_t copies_default_in,
    WebPrintingRangePtr copies_supported_in,
    WebPrintingMediaCollectionPtr media_col_default_in,
    ::blink::Vector<WebPrintingMediaCollectionPtr> media_col_database_in,
    const ::blink::String& media_source_default_in,
    ::blink::Vector<::blink::String> media_source_supported_in,
    WebPrintingMultipleDocumentHandling multiple_document_handling_default_in,
    ::blink::Vector<WebPrintingMultipleDocumentHandling> multiple_document_handling_supported_in,
    WebPrintingOrientationRequested orientation_requested_default_in,
    ::blink::Vector<WebPrintingOrientationRequested> orientation_requested_supported_in,
    const ::gfx::Size& printer_resolution_default_in,
    ::blink::Vector<::gfx::Size> printer_resolution_supported_in,
    WebPrintColorMode print_color_mode_default_in,
    ::blink::Vector<WebPrintColorMode> print_color_mode_supported_in,
    std::optional<WebPrintQuality> print_quality_default_in,
    ::blink::Vector<WebPrintQuality> print_quality_supported_in,
    WebPrinterState printer_state_in,
    const ::blink::String& printer_state_message_in,
    ::blink::Vector<WebPrinterStateReason> printer_state_reasons_in,
    std::optional<WebPrintingSides> sides_default_in,
    ::blink::Vector<WebPrintingSides> sides_supported_in,
    const ::blink::String& printer_id_in)
    : copies_default(std::move(copies_default_in)),
      copies_supported(std::move(copies_supported_in)),
      media_col_default(std::move(media_col_default_in)),
      media_col_database(std::move(media_col_database_in)),
      media_source_default(std::move(media_source_default_in)),
      media_source_supported(std::move(media_source_supported_in)),
      multiple_document_handling_default(std::move(multiple_document_handling_default_in)),
      multiple_document_handling_supported(std::move(multiple_document_handling_supported_in)),
      orientation_requested_default(std::move(orientation_requested_default_in)),
      orientation_requested_supported(std::move(orientation_requested_supported_in)),
      printer_resolution_default(std::move(printer_resolution_default_in)),
      printer_resolution_supported(std::move(printer_resolution_supported_in)),
      print_color_mode_default(std::move(print_color_mode_default_in)),
      print_color_mode_supported(std::move(print_color_mode_supported_in)),
      print_quality_default(std::move(print_quality_default_in)),
      print_quality_supported(std::move(print_quality_supported_in)),
      printer_state(std::move(printer_state_in)),
      printer_state_message(std::move(printer_state_message_in)),
      printer_state_reasons(std::move(printer_state_reasons_in)),
      sides_default(std::move(sides_default_in)),
      sides_supported(std::move(sides_supported_in)),
      printer_id(std::move(printer_id_in)) {}

WebPrinterAttributes::~WebPrinterAttributes() = default;

void WebPrinterAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies_default"), this->copies_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies_supported"), this->copies_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingRangePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_col_default"), this->media_col_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingMediaCollectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_col_database"), this->media_col_database,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<WebPrintingMediaCollectionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_source_default"), this->media_source_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_source_supported"), this->media_source_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multiple_document_handling_default"), this->multiple_document_handling_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingMultipleDocumentHandling>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multiple_document_handling_supported"), this->multiple_document_handling_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<WebPrintingMultipleDocumentHandling>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation_requested_default"), this->orientation_requested_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingOrientationRequested>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation_requested_supported"), this->orientation_requested_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<WebPrintingOrientationRequested>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_resolution_default"), this->printer_resolution_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_resolution_supported"), this->printer_resolution_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_color_mode_default"), this->print_color_mode_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintColorMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_color_mode_supported"), this->print_color_mode_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<WebPrintColorMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_quality_default"), this->print_quality_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintQuality>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_quality_supported"), this->print_quality_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<WebPrintQuality>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_state"), this->printer_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrinterState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_state_message"), this->printer_state_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_state_reasons"), this->printer_state_reasons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<WebPrinterStateReason>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sides_default"), this->sides_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintingSides>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sides_supported"), this->sides_supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<WebPrintingSides>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_id"), this->printer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrinterAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintingMediaCollectionRequested::WebPrintingMediaCollectionRequested()
    : media_size() {}

WebPrintingMediaCollectionRequested::WebPrintingMediaCollectionRequested(
    const ::gfx::Size& media_size_in)
    : media_size(std::move(media_size_in)) {}

WebPrintingMediaCollectionRequested::~WebPrintingMediaCollectionRequested() = default;

void WebPrintingMediaCollectionRequested::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_size"), this->media_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintingMediaCollectionRequested::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintJobTemplateAttributes::WebPrintJobTemplateAttributes()
    : job_name(),
      copies(),
      media_col(),
      media_source(),
      multiple_document_handling(),
      orientation_requested(),
      printer_resolution(),
      print_color_mode(),
      print_quality(),
      sides() {}

WebPrintJobTemplateAttributes::WebPrintJobTemplateAttributes(
    const ::blink::String& job_name_in,
    uint32_t copies_in,
    WebPrintingMediaCollectionRequestedPtr media_col_in,
    const ::blink::String& media_source_in,
    std::optional<WebPrintingMultipleDocumentHandling> multiple_document_handling_in,
    std::optional<WebPrintingOrientationRequested> orientation_requested_in,
    const std::optional<::gfx::Size>& printer_resolution_in,
    std::optional<WebPrintColorMode> print_color_mode_in,
    std::optional<WebPrintQuality> print_quality_in,
    std::optional<WebPrintingSides> sides_in)
    : job_name(std::move(job_name_in)),
      copies(std::move(copies_in)),
      media_col(std::move(media_col_in)),
      media_source(std::move(media_source_in)),
      multiple_document_handling(std::move(multiple_document_handling_in)),
      orientation_requested(std::move(orientation_requested_in)),
      printer_resolution(std::move(printer_resolution_in)),
      print_color_mode(std::move(print_color_mode_in)),
      print_quality(std::move(print_quality_in)),
      sides(std::move(sides_in)) {}

WebPrintJobTemplateAttributes::~WebPrintJobTemplateAttributes() = default;

void WebPrintJobTemplateAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "job_name"), this->job_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies"), this->copies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_col"), this->media_col,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintingMediaCollectionRequestedPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_source"), this->media_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multiple_document_handling"), this->multiple_document_handling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintingMultipleDocumentHandling>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "orientation_requested"), this->orientation_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintingOrientationRequested>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_resolution"), this->printer_resolution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_color_mode"), this->print_color_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintColorMode>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "print_quality"), this->print_quality,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintQuality>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sides"), this->sides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WebPrintingSides>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintJobTemplateAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintJobUpdate::WebPrintJobUpdate()
    : state(),
      pages_printed(0U) {}

WebPrintJobUpdate::WebPrintJobUpdate(
    WebPrintJobState state_in,
    uint32_t pages_printed_in)
    : state(std::move(state_in)),
      pages_printed(std::move(pages_printed_in)) {}

WebPrintJobUpdate::~WebPrintJobUpdate() = default;
size_t WebPrintJobUpdate::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->state);
  seed = mojo::internal::WTFHash(seed, this->pages_printed);
  return seed;
}

void WebPrintJobUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WebPrintJobState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pages_printed"), this->pages_printed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintJobUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintJobInfo::WebPrintJobInfo()
    : job_name(),
      job_pages(),
      observer(),
      controller() {}

WebPrintJobInfo::WebPrintJobInfo(
    const ::blink::String& job_name_in,
    uint32_t job_pages_in,
    ::mojo::PendingReceiver<WebPrintJobStateObserver> observer_in,
    ::mojo::PendingRemote<WebPrintJobController> controller_in)
    : job_name(std::move(job_name_in)),
      job_pages(std::move(job_pages_in)),
      observer(std::move(observer_in)),
      controller(std::move(controller_in)) {}

WebPrintJobInfo::~WebPrintJobInfo() = default;

void WebPrintJobInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "job_name"), this->job_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "job_pages"), this->job_pages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "observer"), this->observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<WebPrintJobStateObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "controller"), this->controller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<WebPrintJobController>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPrintJobInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebPrintingMediaSizeDimensionPtr
WebPrintingMediaSizeDimension::NewRange(
    WebPrintingRangePtr value) {
  return WebPrintingMediaSizeDimensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRange)>,
      std::move(value));
}

WebPrintingMediaSizeDimensionPtr
WebPrintingMediaSizeDimension::NewValue(
    uint32_t value) {
  return WebPrintingMediaSizeDimensionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

WebPrintingMediaSizeDimension::WebPrintingMediaSizeDimension(
    std::in_place_index_t<static_cast<size_t>(Tag::kRange)>,
    WebPrintingRangePtr value)
    : tag_(Tag::kRange),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRange)>,
            std::move(value)) {}

WebPrintingMediaSizeDimension::WebPrintingMediaSizeDimension(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    uint32_t value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
WebPrintingMediaSizeDimension::~WebPrintingMediaSizeDimension() {
  DestroyActive();
}

void WebPrintingMediaSizeDimension::set_range(WebPrintingRangePtr range) {
  if (tag_ == Tag::kRange) {
    data_.range = std::move(range);
  } else {
    DestroyActive();
    tag_ = Tag::kRange;
    new (&data_.range) WebPrintingRangePtr(
        std::move(range));
  }
}

void WebPrintingMediaSizeDimension::set_value(uint32_t value) {
  if (tag_ != Tag::kValue) {
    DestroyActive();
    tag_ = Tag::kValue;
  }
  data_.value = value;
}


WebPrintingMediaSizeDimension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRange)>,
    WebPrintingRangePtr value)
    : range(std::move(value)) {}

WebPrintingMediaSizeDimension::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    uint32_t value)
    : value(std::move(value)) {}

void WebPrintingMediaSizeDimension::DestroyActive() {
  switch (tag_) {

    case Tag::kRange:
      std::destroy_at(&data_.range);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}
size_t WebPrintingMediaSizeDimension::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kRange:
      return mojo::internal::WTFHash(seed, data_.range);
    case Tag::kValue:
      return mojo::internal::WTFHash(seed, data_.value);
    default:
      NOTREACHED();
  }
}

bool WebPrintingMediaSizeDimension::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
GetPrintersResultPtr
GetPrintersResult::NewPrinters(
    ::blink::Vector<WebPrinterInfoPtr> value) {
  return GetPrintersResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPrinters)>,
      std::move(value));
}

GetPrintersResultPtr
GetPrintersResult::NewError(
    GetPrintersError value) {
  return GetPrintersResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

GetPrintersResult::GetPrintersResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrinters)>,
    ::blink::Vector<WebPrinterInfoPtr> value)
    : tag_(Tag::kPrinters),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPrinters)>,
            std::move(value)) {}

GetPrintersResult::GetPrintersResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    GetPrintersError value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
GetPrintersResult::~GetPrintersResult() {
  DestroyActive();
}

void GetPrintersResult::set_printers(::blink::Vector<WebPrinterInfoPtr> printers) {
  if (tag_ == Tag::kPrinters) {
    data_.printers = std::move(printers);
  } else {
    DestroyActive();
    tag_ = Tag::kPrinters;
    new (&data_.printers) ::blink::Vector<WebPrinterInfoPtr>(
        std::move(printers));
  }
}

void GetPrintersResult::set_error(GetPrintersError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}


GetPrintersResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrinters)>,
    ::blink::Vector<WebPrinterInfoPtr> value)
    : printers(std::move(value)) {}

GetPrintersResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    GetPrintersError value)
    : error(std::move(value)) {}

void GetPrintersResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPrinters:
      std::destroy_at(&data_.printers);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool GetPrintersResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebPrinterFetchResultPtr
WebPrinterFetchResult::NewPrinterAttributes(
    WebPrinterAttributesPtr value) {
  return WebPrinterFetchResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPrinterAttributes)>,
      std::move(value));
}

WebPrinterFetchResultPtr
WebPrinterFetchResult::NewError(
    WebPrinterFetchError value) {
  return WebPrinterFetchResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

WebPrinterFetchResult::WebPrinterFetchResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrinterAttributes)>,
    WebPrinterAttributesPtr value)
    : tag_(Tag::kPrinterAttributes),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPrinterAttributes)>,
            std::move(value)) {}

WebPrinterFetchResult::WebPrinterFetchResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    WebPrinterFetchError value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
WebPrinterFetchResult::~WebPrinterFetchResult() {
  DestroyActive();
}

void WebPrinterFetchResult::set_printer_attributes(WebPrinterAttributesPtr printer_attributes) {
  if (tag_ == Tag::kPrinterAttributes) {
    data_.printer_attributes = std::move(printer_attributes);
  } else {
    DestroyActive();
    tag_ = Tag::kPrinterAttributes;
    new (&data_.printer_attributes) WebPrinterAttributesPtr(
        std::move(printer_attributes));
  }
}

void WebPrinterFetchResult::set_error(WebPrinterFetchError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}


WebPrinterFetchResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrinterAttributes)>,
    WebPrinterAttributesPtr value)
    : printer_attributes(std::move(value)) {}

WebPrinterFetchResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    WebPrinterFetchError value)
    : error(std::move(value)) {}

void WebPrinterFetchResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPrinterAttributes:
      std::destroy_at(&data_.printer_attributes);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool WebPrinterFetchResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebPrintResultPtr
WebPrintResult::NewPrintJobInfo(
    WebPrintJobInfoPtr value) {
  return WebPrintResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPrintJobInfo)>,
      std::move(value));
}

WebPrintResultPtr
WebPrintResult::NewError(
    WebPrintError value) {
  return WebPrintResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

WebPrintResult::WebPrintResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrintJobInfo)>,
    WebPrintJobInfoPtr value)
    : tag_(Tag::kPrintJobInfo),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPrintJobInfo)>,
            std::move(value)) {}

WebPrintResult::WebPrintResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    WebPrintError value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
WebPrintResult::~WebPrintResult() {
  DestroyActive();
}

void WebPrintResult::set_print_job_info(WebPrintJobInfoPtr print_job_info) {
  if (tag_ == Tag::kPrintJobInfo) {
    data_.print_job_info = std::move(print_job_info);
  } else {
    DestroyActive();
    tag_ = Tag::kPrintJobInfo;
    new (&data_.print_job_info) WebPrintJobInfoPtr(
        std::move(print_job_info));
  }
}

void WebPrintResult::set_error(WebPrintError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}


WebPrintResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrintJobInfo)>,
    WebPrintJobInfoPtr value)
    : print_job_info(std::move(value)) {}

WebPrintResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    WebPrintError value)
    : error(std::move(value)) {}

void WebPrintResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPrintJobInfo:
      std::destroy_at(&data_.print_job_info);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool WebPrintResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebPrintJobStateObserver::IPCStableHashFunction WebPrintJobStateObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPrintJobStateObserver>(message.name())) {
    case messages::WebPrintJobStateObserver::kOnWebPrintJobUpdate: {
      return &WebPrintJobStateObserver::OnWebPrintJobUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPrintJobStateObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPrintJobStateObserver>(message.name())) {
      case messages::WebPrintJobStateObserver::kOnWebPrintJobUpdate:
            return "Receive blink::mojom::WebPrintJobStateObserver::OnWebPrintJobUpdate";
    }
  } else {
    switch (static_cast<messages::WebPrintJobStateObserver>(message.name())) {
      case messages::WebPrintJobStateObserver::kOnWebPrintJobUpdate:
            return "Receive reply blink::mojom::WebPrintJobStateObserver::OnWebPrintJobUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPrintJobStateObserver::OnWebPrintJobUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9d2de1b;  // IPCStableHash for blink::mojom::WebPrintJobStateObserver::OnWebPrintJobUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebPrintJobStateObserverProxy::WebPrintJobStateObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPrintJobStateObserverProxy::OnWebPrintJobUpdate(
    WebPrintJobUpdatePtr in_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebPrintJobStateObserver::OnWebPrintJobUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update"), in_update,
                        "<value of type WebPrintJobUpdatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrintJobStateObserver::kOnWebPrintJobUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update)::BaseType> update_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebPrintJobUpdateDataView>(
    in_update,
    update_fragment);

  params->update.Set(
      update_fragment.is_null() ? nullptr : update_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update in WebPrintJobStateObserver.OnWebPrintJobUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrintJobStateObserver::Name_);
  message.set_method_name("OnWebPrintJobUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebPrintJobStateObserverStubDispatch::Accept(
    WebPrintJobStateObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPrintJobStateObserver>(message->header()->name)) {
    case messages::WebPrintJobStateObserver::kOnWebPrintJobUpdate: {
      DCHECK(message->is_serialized());
      internal::WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data* params =
          reinterpret_cast<internal::WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebPrintJobStateObserver.0
      bool success = true;
      WebPrintJobUpdatePtr p_update{};
      WebPrintJobStateObserver_OnWebPrintJobUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdate(&p_update))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPrintJobStateObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebPrintJobUpdate(        
        std::move(p_update));
      return true;
    }
  }
  return false;
}

// static
bool WebPrintJobStateObserverStubDispatch::AcceptWithResponder(
    WebPrintJobStateObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPrintJobStateObserver>(message->header()->name)) {
    case messages::WebPrintJobStateObserver::kOnWebPrintJobUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPrintJobStateObserverValidationInfo[] = {
    { &internal::WebPrintJobStateObserver_OnWebPrintJobUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebPrintJobStateObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebPrintJobStateObserver::Name_,
    kWebPrintJobStateObserverValidationInfo);
}

// The declaration includes the definition on other builds.

WebPrintJobController::IPCStableHashFunction WebPrintJobController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPrintJobController>(message.name())) {
    case messages::WebPrintJobController::kCancel: {
      return &WebPrintJobController::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPrintJobController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPrintJobController>(message.name())) {
      case messages::WebPrintJobController::kCancel:
            return "Receive blink::mojom::WebPrintJobController::Cancel";
    }
  } else {
    switch (static_cast<messages::WebPrintJobController>(message.name())) {
      case messages::WebPrintJobController::kCancel:
            return "Receive reply blink::mojom::WebPrintJobController::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPrintJobController::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d6dcf86;  // IPCStableHash for blink::mojom::WebPrintJobController::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebPrintJobControllerProxy::WebPrintJobControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPrintJobControllerProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebPrintJobController::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrintJobController::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrintJobController_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrintJobController::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebPrintJobControllerStubDispatch::Accept(
    WebPrintJobController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPrintJobController>(message->header()->name)) {
    case messages::WebPrintJobController::kCancel: {
      DCHECK(message->is_serialized());
      internal::WebPrintJobController_Cancel_Params_Data* params =
          reinterpret_cast<internal::WebPrintJobController_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebPrintJobController.0
      bool success = true;
      WebPrintJobController_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPrintJobController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool WebPrintJobControllerStubDispatch::AcceptWithResponder(
    WebPrintJobController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPrintJobController>(message->header()->name)) {
    case messages::WebPrintJobController::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPrintJobControllerValidationInfo[] = {
    { &internal::WebPrintJobController_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebPrintJobControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebPrintJobController::Name_,
    kWebPrintJobControllerValidationInfo);
}

// The declaration includes the definition on other builds.

WebPrinter::IPCStableHashFunction WebPrinter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPrinter>(message.name())) {
    case messages::WebPrinter::kFetchAttributes: {
      return &WebPrinter::FetchAttributes_Sym::IPCStableHash;
    }
    case messages::WebPrinter::kPrint: {
      return &WebPrinter::Print_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPrinter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPrinter>(message.name())) {
      case messages::WebPrinter::kFetchAttributes:
            return "Receive blink::mojom::WebPrinter::FetchAttributes";
      case messages::WebPrinter::kPrint:
            return "Receive blink::mojom::WebPrinter::Print";
    }
  } else {
    switch (static_cast<messages::WebPrinter>(message.name())) {
      case messages::WebPrinter::kFetchAttributes:
            return "Receive reply blink::mojom::WebPrinter::FetchAttributes";
      case messages::WebPrinter::kPrint:
            return "Receive reply blink::mojom::WebPrinter::Print";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPrinter::FetchAttributes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c5baabc;  // IPCStableHash for blink::mojom::WebPrinter::FetchAttributes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebPrinter::Print_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca10ab6d;  // IPCStableHash for blink::mojom::WebPrinter::Print
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebPrinter_FetchAttributes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebPrinter_FetchAttributes_ForwardToCallback(
      WebPrinter::FetchAttributesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebPrinter_FetchAttributes_ForwardToCallback(const WebPrinter_FetchAttributes_ForwardToCallback&) = delete;
  WebPrinter_FetchAttributes_ForwardToCallback& operator=(const WebPrinter_FetchAttributes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebPrinter::FetchAttributesCallback callback_;
};

class WebPrinter_Print_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebPrinter_Print_ForwardToCallback(
      WebPrinter::PrintCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebPrinter_Print_ForwardToCallback(const WebPrinter_Print_ForwardToCallback&) = delete;
  WebPrinter_Print_ForwardToCallback& operator=(const WebPrinter_Print_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebPrinter::PrintCallback callback_;
};

WebPrinterProxy::WebPrinterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPrinterProxy::FetchAttributes(
    FetchAttributesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebPrinter::FetchAttributes");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrinter::kFetchAttributes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrinter_FetchAttributes_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrinter::Name_);
  message.set_method_name("FetchAttributes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebPrinter_FetchAttributes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebPrinterProxy::Print(
    ::mojo::PendingRemote<::blink::mojom::blink::Blob> in_document, WebPrintJobTemplateAttributesPtr in_attributes, PrintCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebPrinter::Print", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document"), in_document,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attributes"), in_attributes,
                        "<value of type WebPrintJobTemplateAttributesPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrinter::kPrint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrinter_Print_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
    in_document,
    &params->document,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->document)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid document in WebPrinter.Print request");
  mojo::internal::MessageFragment<
      typename decltype(params->attributes)::BaseType> attributes_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::WebPrintJobTemplateAttributesDataView>(
    in_attributes,
    attributes_fragment);

  params->attributes.Set(
      attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attributes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attributes in WebPrinter.Print request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrinter::Name_);
  message.set_method_name("Print");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebPrinter_Print_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebPrinter_FetchAttributes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebPrinter::FetchAttributesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebPrinter_FetchAttributes_ProxyToResponder> proxy(
        new WebPrinter_FetchAttributes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebPrinter_FetchAttributes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebPrinter_FetchAttributes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebPrinter_FetchAttributes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebPrinter::FetchAttributesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebPrinterFetchResultPtr in_result);
};

bool WebPrinter_FetchAttributes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebPrinter_FetchAttributes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebPrinter_FetchAttributes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebPrinter.0
  bool success = true;
  WebPrinterFetchResultPtr p_result{};
  WebPrinter_FetchAttributes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebPrinter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebPrinter_FetchAttributes_ProxyToResponder::Run(
    WebPrinterFetchResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebPrinter::FetchAttributes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebPrinterFetchResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrinter::kFetchAttributes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrinter_FetchAttributes_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::WebPrinterFetchResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrinter::Name_);
  message.set_method_name("FetchAttributes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebPrinter_Print_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebPrinter::PrintCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebPrinter_Print_ProxyToResponder> proxy(
        new WebPrinter_Print_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebPrinter_Print_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebPrinter_Print_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebPrinter_Print_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebPrinter::PrintCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebPrintResultPtr in_result);
};

bool WebPrinter_Print_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebPrinter_Print_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebPrinter_Print_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebPrinter.1
  bool success = true;
  WebPrintResultPtr p_result{};
  WebPrinter_Print_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebPrinter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebPrinter_Print_ProxyToResponder::Run(
    WebPrintResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebPrinter::Print", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type WebPrintResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrinter::kPrint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrinter_Print_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::WebPrintResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrinter::Name_);
  message.set_method_name("Print");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebPrinterStubDispatch::Accept(
    WebPrinter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPrinter>(message->header()->name)) {
    case messages::WebPrinter::kFetchAttributes: {
      break;
    }
    case messages::WebPrinter::kPrint: {
      break;
    }
  }
  return false;
}

// static
bool WebPrinterStubDispatch::AcceptWithResponder(
    WebPrinter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPrinter>(message->header()->name)) {
    case messages::WebPrinter::kFetchAttributes: {
      internal::WebPrinter_FetchAttributes_Params_Data* params =
          reinterpret_cast<
              internal::WebPrinter_FetchAttributes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebPrinter.0
      bool success = true;
      WebPrinter_FetchAttributes_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPrinter::Name_, 0, false);
        return false;
      }
      auto callback =
          WebPrinter_FetchAttributes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchAttributes(std::move(callback));
      return true;
    }
    case messages::WebPrinter::kPrint: {
      internal::WebPrinter_Print_Params_Data* params =
          reinterpret_cast<
              internal::WebPrinter_Print_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebPrinter.1
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::Blob> p_document{};
      WebPrintJobTemplateAttributesPtr p_attributes{};
      WebPrinter_Print_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_document =
            input_data_view.TakeDocument<decltype(p_document)>();
      }
      if (success && !input_data_view.ReadAttributes(&p_attributes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPrinter::Name_, 1, false);
        return false;
      }
      auto callback =
          WebPrinter_Print_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Print(        
        std::move(p_document), 
        std::move(p_attributes), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPrinterValidationInfo[] = {
    { &internal::WebPrinter_FetchAttributes_Params_Data::Validate,
     &internal::WebPrinter_FetchAttributes_ResponseParams_Data::Validate},
    { &internal::WebPrinter_Print_Params_Data::Validate,
     &internal::WebPrinter_Print_ResponseParams_Data::Validate},
};

bool WebPrinterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebPrinter::Name_,
    kWebPrinterValidationInfo);
}

bool WebPrinterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebPrinter::Name_,
    kWebPrinterValidationInfo);
}
// The declaration includes the definition on other builds.

WebPrintingService::IPCStableHashFunction WebPrintingService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebPrintingService>(message.name())) {
    case messages::WebPrintingService::kGetPrinters: {
      return &WebPrintingService::GetPrinters_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebPrintingService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebPrintingService>(message.name())) {
      case messages::WebPrintingService::kGetPrinters:
            return "Receive blink::mojom::WebPrintingService::GetPrinters";
    }
  } else {
    switch (static_cast<messages::WebPrintingService>(message.name())) {
      case messages::WebPrintingService::kGetPrinters:
            return "Receive reply blink::mojom::WebPrintingService::GetPrinters";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebPrintingService::GetPrinters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b453a2b;  // IPCStableHash for blink::mojom::WebPrintingService::GetPrinters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebPrintingService_GetPrinters_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebPrintingService_GetPrinters_ForwardToCallback(
      WebPrintingService::GetPrintersCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebPrintingService_GetPrinters_ForwardToCallback(const WebPrintingService_GetPrinters_ForwardToCallback&) = delete;
  WebPrintingService_GetPrinters_ForwardToCallback& operator=(const WebPrintingService_GetPrinters_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebPrintingService::GetPrintersCallback callback_;
};

WebPrintingServiceProxy::WebPrintingServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebPrintingServiceProxy::GetPrinters(
    GetPrintersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WebPrintingService::GetPrinters");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrintingService::kGetPrinters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrintingService_GetPrinters_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrintingService::Name_);
  message.set_method_name("GetPrinters");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebPrintingService_GetPrinters_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebPrintingService_GetPrinters_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebPrintingService::GetPrintersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebPrintingService_GetPrinters_ProxyToResponder> proxy(
        new WebPrintingService_GetPrinters_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebPrintingService_GetPrinters_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebPrintingService_GetPrinters_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebPrintingService_GetPrinters_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebPrintingService::GetPrintersCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetPrintersResultPtr in_result);
};

bool WebPrintingService_GetPrinters_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebPrintingService_GetPrinters_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebPrintingService_GetPrinters_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebPrintingService.0
  bool success = true;
  GetPrintersResultPtr p_result{};
  WebPrintingService_GetPrinters_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebPrintingService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebPrintingService_GetPrinters_ProxyToResponder::Run(
    GetPrintersResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebPrintingService::GetPrinters", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetPrintersResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebPrintingService::kGetPrinters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebPrintingService_GetPrinters_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::GetPrintersResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebPrintingService::Name_);
  message.set_method_name("GetPrinters");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebPrintingServiceStubDispatch::Accept(
    WebPrintingService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebPrintingService>(message->header()->name)) {
    case messages::WebPrintingService::kGetPrinters: {
      break;
    }
  }
  return false;
}

// static
bool WebPrintingServiceStubDispatch::AcceptWithResponder(
    WebPrintingService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebPrintingService>(message->header()->name)) {
    case messages::WebPrintingService::kGetPrinters: {
      internal::WebPrintingService_GetPrinters_Params_Data* params =
          reinterpret_cast<
              internal::WebPrintingService_GetPrinters_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebPrintingService.0
      bool success = true;
      WebPrintingService_GetPrinters_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebPrintingService::Name_, 0, false);
        return false;
      }
      auto callback =
          WebPrintingService_GetPrinters_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPrinters(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebPrintingServiceValidationInfo[] = {
    { &internal::WebPrintingService_GetPrinters_Params_Data::Validate,
     &internal::WebPrintingService_GetPrinters_ResponseParams_Data::Validate},
};

bool WebPrintingServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebPrintingService::Name_,
    kWebPrintingServiceValidationInfo);
}

bool WebPrintingServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebPrintingService::Name_,
    kWebPrintingServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::WebPrinterInfo::DataView, ::blink::mojom::blink::WebPrinterInfoPtr>::Read(
    ::blink::mojom::blink::WebPrinterInfo::DataView input,
    ::blink::mojom::blink::WebPrinterInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrinterInfoPtr result(::blink::mojom::blink::WebPrinterInfo::New());
  
      if (success && !input.ReadPrinterName(&result->printer_name))
        success = false;
      if (success && !input.ReadPrinterId(&result->printer_id))
        success = false;
      if (success) {
        result->printer_remote =
            input.TakePrinterRemote<decltype(result->printer_remote)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintingRange::DataView, ::blink::mojom::blink::WebPrintingRangePtr>::Read(
    ::blink::mojom::blink::WebPrintingRange::DataView input,
    ::blink::mojom::blink::WebPrintingRangePtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintingRangePtr result(::blink::mojom::blink::WebPrintingRange::New());
  
      if (success)
        result->from = input.from();
      if (success)
        result->to = input.to();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintingMediaSize::DataView, ::blink::mojom::blink::WebPrintingMediaSizePtr>::Read(
    ::blink::mojom::blink::WebPrintingMediaSize::DataView input,
    ::blink::mojom::blink::WebPrintingMediaSizePtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintingMediaSizePtr result(::blink::mojom::blink::WebPrintingMediaSize::New());
  
      if (success && !input.ReadXDimension(&result->x_dimension))
        success = false;
      if (success && !input.ReadYDimension(&result->y_dimension))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintingMediaCollection::DataView, ::blink::mojom::blink::WebPrintingMediaCollectionPtr>::Read(
    ::blink::mojom::blink::WebPrintingMediaCollection::DataView input,
    ::blink::mojom::blink::WebPrintingMediaCollectionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintingMediaCollectionPtr result(::blink::mojom::blink::WebPrintingMediaCollection::New());
  
      if (success && !input.ReadMediaSize(&result->media_size))
        success = false;
      if (success && !input.ReadMediaSizeName(&result->media_size_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrinterAttributes::DataView, ::blink::mojom::blink::WebPrinterAttributesPtr>::Read(
    ::blink::mojom::blink::WebPrinterAttributes::DataView input,
    ::blink::mojom::blink::WebPrinterAttributesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrinterAttributesPtr result(::blink::mojom::blink::WebPrinterAttributes::New());
  
      if (success)
        result->copies_default = input.copies_default();
      if (success && !input.ReadCopiesSupported(&result->copies_supported))
        success = false;
      if (success && !input.ReadMediaColDefault(&result->media_col_default))
        success = false;
      if (success && !input.ReadMediaColDatabase(&result->media_col_database))
        success = false;
      if (success && !input.ReadMediaSourceDefault(&result->media_source_default))
        success = false;
      if (success && !input.ReadMediaSourceSupported(&result->media_source_supported))
        success = false;
      if (success && !input.ReadMultipleDocumentHandlingDefault(&result->multiple_document_handling_default))
        success = false;
      if (success && !input.ReadMultipleDocumentHandlingSupported(&result->multiple_document_handling_supported))
        success = false;
      if (success && !input.ReadOrientationRequestedDefault(&result->orientation_requested_default))
        success = false;
      if (success && !input.ReadOrientationRequestedSupported(&result->orientation_requested_supported))
        success = false;
      if (success && !input.ReadPrinterResolutionDefault(&result->printer_resolution_default))
        success = false;
      if (success && !input.ReadPrinterResolutionSupported(&result->printer_resolution_supported))
        success = false;
      if (success && !input.ReadPrintColorModeDefault(&result->print_color_mode_default))
        success = false;
      if (success && !input.ReadPrintColorModeSupported(&result->print_color_mode_supported))
        success = false;
      if (success && !input.ReadPrintQualityDefault(&result->print_quality_default)) {
        success = false;
      }
      if (success && !input.ReadPrintQualitySupported(&result->print_quality_supported))
        success = false;
      if (success && !input.ReadPrinterState(&result->printer_state))
        success = false;
      if (success && !input.ReadPrinterStateMessage(&result->printer_state_message))
        success = false;
      if (success && !input.ReadPrinterStateReasons(&result->printer_state_reasons))
        success = false;
      if (success && !input.ReadSidesDefault(&result->sides_default)) {
        success = false;
      }
      if (success && !input.ReadSidesSupported(&result->sides_supported))
        success = false;
      if (success && !input.ReadPrinterId(&result->printer_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintingMediaCollectionRequested::DataView, ::blink::mojom::blink::WebPrintingMediaCollectionRequestedPtr>::Read(
    ::blink::mojom::blink::WebPrintingMediaCollectionRequested::DataView input,
    ::blink::mojom::blink::WebPrintingMediaCollectionRequestedPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintingMediaCollectionRequestedPtr result(::blink::mojom::blink::WebPrintingMediaCollectionRequested::New());
  
      if (success && !input.ReadMediaSize(&result->media_size))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintJobTemplateAttributes::DataView, ::blink::mojom::blink::WebPrintJobTemplateAttributesPtr>::Read(
    ::blink::mojom::blink::WebPrintJobTemplateAttributes::DataView input,
    ::blink::mojom::blink::WebPrintJobTemplateAttributesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintJobTemplateAttributesPtr result(::blink::mojom::blink::WebPrintJobTemplateAttributes::New());
  
      if (success && !input.ReadJobName(&result->job_name))
        success = false;
      if (success)
        result->copies = input.copies();
      if (success && !input.ReadMediaCol(&result->media_col))
        success = false;
      if (success && !input.ReadMediaSource(&result->media_source))
        success = false;
      if (success && !input.ReadMultipleDocumentHandling(&result->multiple_document_handling)) {
        success = false;
      }
      if (success && !input.ReadOrientationRequested(&result->orientation_requested)) {
        success = false;
      }
      if (success && !input.ReadPrinterResolution(&result->printer_resolution))
        success = false;
      if (success && !input.ReadPrintColorMode(&result->print_color_mode)) {
        success = false;
      }
      if (success && !input.ReadPrintQuality(&result->print_quality)) {
        success = false;
      }
      if (success && !input.ReadSides(&result->sides)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintJobUpdate::DataView, ::blink::mojom::blink::WebPrintJobUpdatePtr>::Read(
    ::blink::mojom::blink::WebPrintJobUpdate::DataView input,
    ::blink::mojom::blink::WebPrintJobUpdatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintJobUpdatePtr result(::blink::mojom::blink::WebPrintJobUpdate::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->pages_printed = input.pages_printed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebPrintJobInfo::DataView, ::blink::mojom::blink::WebPrintJobInfoPtr>::Read(
    ::blink::mojom::blink::WebPrintJobInfo::DataView input,
    ::blink::mojom::blink::WebPrintJobInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPrintJobInfoPtr result(::blink::mojom::blink::WebPrintJobInfo::New());
  
      if (success && !input.ReadJobName(&result->job_name))
        success = false;
      if (success)
        result->job_pages = input.job_pages();
      if (success) {
        result->observer =
            input.TakeObserver<decltype(result->observer)>();
      }
      if (success) {
        result->controller =
            input.TakeController<decltype(result->controller)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::WebPrintingMediaSizeDimension::DataView, ::blink::mojom::blink::WebPrintingMediaSizeDimensionPtr>::Read(
    ::blink::mojom::blink::WebPrintingMediaSizeDimension::DataView input,
    ::blink::mojom::blink::WebPrintingMediaSizeDimensionPtr* output) {
  using UnionType = ::blink::mojom::blink::WebPrintingMediaSizeDimension;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kRange: {
      ::blink::mojom::blink::WebPrintingRangePtr result_range{};
      if (!input.ReadRange(&result_range))
        return false;

      *output = UnionType::NewRange(
          std::move(result_range));
      break;
    }
    case Tag::kValue: {
      *output = UnionType::NewValue(input.value());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::GetPrintersResult::DataView, ::blink::mojom::blink::GetPrintersResultPtr>::Read(
    ::blink::mojom::blink::GetPrintersResult::DataView input,
    ::blink::mojom::blink::GetPrintersResultPtr* output) {
  using UnionType = ::blink::mojom::blink::GetPrintersResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPrinters: {
      ::blink::Vector<::blink::mojom::blink::WebPrinterInfoPtr> result_printers{};
      if (!input.ReadPrinters(&result_printers))
        return false;

      *output = UnionType::NewPrinters(
          std::move(result_printers));
      break;
    }
    case Tag::kError: {
      ::blink::mojom::blink::GetPrintersError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::WebPrinterFetchResult::DataView, ::blink::mojom::blink::WebPrinterFetchResultPtr>::Read(
    ::blink::mojom::blink::WebPrinterFetchResult::DataView input,
    ::blink::mojom::blink::WebPrinterFetchResultPtr* output) {
  using UnionType = ::blink::mojom::blink::WebPrinterFetchResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPrinterAttributes: {
      ::blink::mojom::blink::WebPrinterAttributesPtr result_printer_attributes{};
      if (!input.ReadPrinterAttributes(&result_printer_attributes))
        return false;

      *output = UnionType::NewPrinterAttributes(
          std::move(result_printer_attributes));
      break;
    }
    case Tag::kError: {
      ::blink::mojom::blink::WebPrinterFetchError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::WebPrintResult::DataView, ::blink::mojom::blink::WebPrintResultPtr>::Read(
    ::blink::mojom::blink::WebPrintResult::DataView input,
    ::blink::mojom::blink::WebPrintResultPtr* output) {
  using UnionType = ::blink::mojom::blink::WebPrintResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPrintJobInfo: {
      ::blink::mojom::blink::WebPrintJobInfoPtr result_print_job_info{};
      if (!input.ReadPrintJobInfo(&result_print_job_info))
        return false;

      *output = UnionType::NewPrintJobInfo(
          std::move(result_print_job_info));
      break;
    }
    case Tag::kError: {
      ::blink::mojom::blink::WebPrintError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WebPrintJobStateObserverInterceptorForTesting::OnWebPrintJobUpdate(WebPrintJobUpdatePtr update) {
  GetForwardingInterface()->OnWebPrintJobUpdate(
    std::move(update)
    );
}
WebPrintJobStateObserverAsyncWaiter::WebPrintJobStateObserverAsyncWaiter(
    WebPrintJobStateObserver* proxy) : proxy_(proxy) {}

WebPrintJobStateObserverAsyncWaiter::~WebPrintJobStateObserverAsyncWaiter() = default;





void WebPrintJobControllerInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
WebPrintJobControllerAsyncWaiter::WebPrintJobControllerAsyncWaiter(
    WebPrintJobController* proxy) : proxy_(proxy) {}

WebPrintJobControllerAsyncWaiter::~WebPrintJobControllerAsyncWaiter() = default;





void WebPrinterInterceptorForTesting::FetchAttributes(FetchAttributesCallback callback) {
  GetForwardingInterface()->FetchAttributes(std::move(callback));
}
void WebPrinterInterceptorForTesting::Print(::mojo::PendingRemote<::blink::mojom::blink::Blob> document, WebPrintJobTemplateAttributesPtr attributes, PrintCallback callback) {
  GetForwardingInterface()->Print(
    std::move(document)
    , 
    std::move(attributes)
    , std::move(callback));
}
WebPrinterAsyncWaiter::WebPrinterAsyncWaiter(
    WebPrinter* proxy) : proxy_(proxy) {}

WebPrinterAsyncWaiter::~WebPrinterAsyncWaiter() = default;


void WebPrinterAsyncWaiter::FetchAttributes(
    WebPrinterFetchResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FetchAttributes(
      base::BindOnce(
          [](base::RunLoop* loop,
             WebPrinterFetchResultPtr* out_result
,
             WebPrinterFetchResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebPrinterFetchResultPtr WebPrinterAsyncWaiter::FetchAttributes(
    ) {
  WebPrinterFetchResultPtr async_wait_result;
  FetchAttributes(&async_wait_result);
  return async_wait_result;
}

void WebPrinterAsyncWaiter::Print(
    ::mojo::PendingRemote<::blink::mojom::blink::Blob> document, WebPrintJobTemplateAttributesPtr attributes, WebPrintResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Print(
      std::move(document),
      std::move(attributes),
      base::BindOnce(
          [](base::RunLoop* loop,
             WebPrintResultPtr* out_result
,
             WebPrintResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

WebPrintResultPtr WebPrinterAsyncWaiter::Print(
    ::mojo::PendingRemote<::blink::mojom::blink::Blob> document, WebPrintJobTemplateAttributesPtr attributes) {
  WebPrintResultPtr async_wait_result;
  Print(std::move(document),std::move(attributes),&async_wait_result);
  return async_wait_result;
}




void WebPrintingServiceInterceptorForTesting::GetPrinters(GetPrintersCallback callback) {
  GetForwardingInterface()->GetPrinters(std::move(callback));
}
WebPrintingServiceAsyncWaiter::WebPrintingServiceAsyncWaiter(
    WebPrintingService* proxy) : proxy_(proxy) {}

WebPrintingServiceAsyncWaiter::~WebPrintingServiceAsyncWaiter() = default;


void WebPrintingServiceAsyncWaiter::GetPrinters(
    GetPrintersResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetPrinters(
      base::BindOnce(
          [](base::RunLoop* loop,
             GetPrintersResultPtr* out_result
,
             GetPrintersResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetPrintersResultPtr WebPrintingServiceAsyncWaiter::GetPrinters(
    ) {
  GetPrintersResultPtr async_wait_result;
  GetPrinters(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif