// third_party/blink/public/mojom/prerender/prerender.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/prerender/prerender.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/prerender/prerender.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class NoStatePrefetchProcessorProxy;

template <typename ImplRefTraits>
class NoStatePrefetchProcessorStub;

class NoStatePrefetchProcessorRequestValidator;


class BLINK_COMMON_EXPORT NoStatePrefetchProcessor
    : public NoStatePrefetchProcessorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.NoStatePrefetchProcessor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NoStatePrefetchProcessorInterfaceBase;
  using Proxy_ = NoStatePrefetchProcessorProxy;

  template <typename ImplRefTraits>
  using Stub_ = NoStatePrefetchProcessorStub<ImplRefTraits>;

  using RequestValidator_ = NoStatePrefetchProcessorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kCancelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NoStatePrefetchProcessor() = default;

  virtual void Start(PrerenderAttributesPtr prerender_attribute) = 0;

  virtual void Cancel() = 0;
};



class BLINK_COMMON_EXPORT NoStatePrefetchProcessorProxy
    : public NoStatePrefetchProcessor {
 public:
  using InterfaceType = NoStatePrefetchProcessor;

  explicit NoStatePrefetchProcessorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(PrerenderAttributesPtr prerender_attribute) final;
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT NoStatePrefetchProcessorStubDispatch {
 public:
  static bool Accept(NoStatePrefetchProcessor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NoStatePrefetchProcessor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NoStatePrefetchProcessor>>
class NoStatePrefetchProcessorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NoStatePrefetchProcessorStub() = default;
  ~NoStatePrefetchProcessorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NoStatePrefetchProcessorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NoStatePrefetchProcessorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT NoStatePrefetchProcessorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT PrerenderAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrerenderAttributes, T>::value>;
  using DataView = PrerenderAttributesDataView;
  using Data_ = internal::PrerenderAttributes_Data;

  template <typename... Args>
  static PrerenderAttributesPtr New(Args&&... args) {
    return PrerenderAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrerenderAttributesPtr From(const U& u) {
    return mojo::TypeConverter<PrerenderAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrerenderAttributes>::Convert(*this);
  }


  PrerenderAttributes();

  PrerenderAttributes(
      const ::GURL& url,
      PrerenderTriggerType trigger_type,
      ::blink::mojom::ReferrerPtr referrer,
      const ::gfx::Size& view_size);

PrerenderAttributes(const PrerenderAttributes&) = delete;
PrerenderAttributes& operator=(const PrerenderAttributes&) = delete;

  ~PrerenderAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrerenderAttributesPtr>
  PrerenderAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderAttributes::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrerenderAttributes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrerenderAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrerenderAttributes_UnserializedMessageContext<
            UserType, PrerenderAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrerenderAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrerenderAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrerenderAttributes_UnserializedMessageContext<
            UserType, PrerenderAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrerenderAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  PrerenderTriggerType trigger_type;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  ::gfx::Size view_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrerenderAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrerenderAttributesPtr PrerenderAttributes::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(trigger_type),
      mojo::Clone(referrer),
      mojo::Clone(view_size)
  );
}

template <typename T, PrerenderAttributes::EnableIfSame<T>*>
bool PrerenderAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->trigger_type, other_struct.trigger_type))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->view_size, other_struct.view_size))
    return false;
  return true;
}

template <typename T, PrerenderAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.trigger_type < rhs.trigger_type)
    return true;
  if (rhs.trigger_type < lhs.trigger_type)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.view_size < rhs.view_size)
    return true;
  if (rhs.view_size < lhs.view_size)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PrerenderAttributes::DataView,
                                         ::blink::mojom::PrerenderAttributesPtr> {
  static bool IsNull(const ::blink::mojom::PrerenderAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PrerenderAttributesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PrerenderAttributes::url)& url(
      const ::blink::mojom::PrerenderAttributesPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::PrerenderAttributes::trigger_type) trigger_type(
      const ::blink::mojom::PrerenderAttributesPtr& input) {
    return input->trigger_type;
  }

  static const decltype(::blink::mojom::PrerenderAttributes::referrer)& referrer(
      const ::blink::mojom::PrerenderAttributesPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::PrerenderAttributes::view_size)& view_size(
      const ::blink::mojom::PrerenderAttributesPtr& input) {
    return input->view_size;
  }

  static bool Read(::blink::mojom::PrerenderAttributes::DataView input, ::blink::mojom::PrerenderAttributesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_H_